/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.resource.internal.ResourceDataHolder;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);

    public static void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (ResourceDataHolder.getInstance().getRegistryNotificationService() == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                ResourceDataHolder.getInstance().getRegistryNotificationService().notify(event);
            } else if (registry.getEventingServiceURL(null) == null) {
                log.error((Object)"Unable to send notification.");
            } else if (registry.getEventingServiceURL(path).equals(registry.getEventingServiceURL(null))) {
                ResourceDataHolder.getInstance().getRegistryNotificationService().notify(event);
            } else {
                ResourceDataHolder.getInstance().getRegistryNotificationService().notify(event, registry.getEventingServiceURL(path));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
        }
    }

    public static String calculatePath(String parentPath, String resourceName) {
        StringBuilder resourcePath = new StringBuilder();
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        if (parentPath.endsWith("/")) {
            resourcePath.append(parentPath).append(resourceName);
        } else {
            resourcePath.append(parentPath).append("/").append(resourceName);
        }
        return resourcePath.toString();
    }

    public static String[][] setProperties(String[][] properties, String key, String value) {
        String[][] propertyArray = new String[properties.length + 1][2];
        for (int i = 0; i <= properties.length; ++i) {
            if (i >= properties.length) {
                propertyArray[properties.length][0] = key;
                propertyArray[properties.length][1] = value;
                return propertyArray;
            }
            propertyArray[i] = (String[])properties[i].clone();
        }
        return new String[0][];
    }
}

