/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.services.utils.CommonUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class AddRolePermissionUtil {
    private static final Log log = LogFactory.getLog(AddRolePermissionUtil.class);

    public static void addRolePermission(UserRegistry userRegistry, String pathToAuthorize, String roleToAuthorize, String actionToAuthorize, String permissionType) throws Exception {
        UserRealm userRealm;
        try {
            userRealm = userRegistry.getUserRealm();
            userRealm.getAuthorizationManager();
        }
        catch (Exception e) {
            String msg = "Couldn't get access control admin for changing authorizations. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (!userRealm.getAuthorizationManager().isUserAuthorized(userRegistry.getUserName(), pathToAuthorize, "authorize")) {
            String msg = userRegistry.getUserName() + " is not allowed to authorize resource " + pathToAuthorize;
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            boolean isResource;
            String notificationResponse = "The following authorization has been added.";
            if (actionToAuthorize.equals("2")) {
                if (permissionType.equals("1")) {
                    userRealm.getAuthorizationManager().authorizeRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/get");
                    notificationResponse = notificationResponse + " READ: Allowed.";
                } else {
                    userRealm.getAuthorizationManager().denyRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/get");
                    notificationResponse = notificationResponse + " READ: Denied.";
                }
            }
            if (actionToAuthorize.equals("3")) {
                if (permissionType.equals("1")) {
                    userRealm.getAuthorizationManager().authorizeRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/add");
                    notificationResponse = notificationResponse + " WRITE: Allowed.";
                } else {
                    userRealm.getAuthorizationManager().denyRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/add");
                    notificationResponse = notificationResponse + " WRITE: Denied.";
                }
            }
            if (actionToAuthorize.equals("4")) {
                if (permissionType.equals("1")) {
                    userRealm.getAuthorizationManager().authorizeRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/delete");
                    notificationResponse = notificationResponse + " DELETE: Allowed.";
                } else {
                    userRealm.getAuthorizationManager().denyRole(roleToAuthorize, pathToAuthorize, "http://www.wso2.org/projects/registry/actions/delete");
                    notificationResponse = notificationResponse + " DELETE: Denied.";
                }
            }
            if (actionToAuthorize.equals("5")) {
                if (permissionType.equals("1")) {
                    userRealm.getAuthorizationManager().authorizeRole(roleToAuthorize, pathToAuthorize, "authorize");
                    notificationResponse = notificationResponse + " AUTHORIZE: Allowed.";
                } else {
                    userRealm.getAuthorizationManager().denyRole(roleToAuthorize, pathToAuthorize, "authorize");
                    notificationResponse = notificationResponse + " AUTHORIZE: Denied.";
                }
            }
            String message = "Permissions have been added for the role " + roleToAuthorize + " on resource " + pathToAuthorize + ". " + notificationResponse;
            try {
                isResource = !(userRegistry.get(pathToAuthorize) instanceof Collection);
            }
            catch (RegistryException e) {
                isResource = true;
            }
            RegistryEvent event = new RegistryEvent((Object)message);
            if (isResource) {
                event.setTopic("/ResourceUpdated" + pathToAuthorize);
            } else {
                event.setTopic("/CollectionUpdated" + pathToAuthorize);
            }
            event.setTenantId(userRegistry.getTenantId());
            CommonUtil.notify(event, (Registry)userRegistry, pathToAuthorize);
            AddRolePermissionUtil.addLogEntryForResourceUpdate(userRegistry, pathToAuthorize, 1, "add new role authorization of the resource");
            String msg = "Role authorization performed successfully.";
            log.debug((Object)msg);
        }
        catch (UserStoreException e) {
            String msg = "Failed to add role permissions. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLogEntryForResourceUpdate(UserRegistry userRegistry, String resourcePath, int action, String actionData) throws RegistryException {
        try {
            CurrentSession.setTenantId((int)userRegistry.getTenantId());
            CurrentSession.setUser((String)userRegistry.getUserName());
            if (userRegistry.getRegistryContext() != null) {
                userRegistry.getRegistryContext().getLogWriter().addLog(resourcePath, userRegistry.getUserName(), action, actionData);
            } else {
                Resource resource = userRegistry.get(resourcePath);
                userRegistry.put(resourcePath, resource);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("add new role authorization of the resource: " + resourcePath));
            }
        }
        finally {
            CurrentSession.removeTenantId();
            CurrentSession.removeUser();
        }
    }
}

