/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class AddResourceUtil {
    private static final Log log = LogFactory.getLog(AddResourceUtil.class);

    public static void addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation, Registry registry, String[][] properties) throws Exception {
        try {
            boolean isNew = !registry.resourceExists(path);
            ResourceImpl resourceImpl = (ResourceImpl)(isNew ? registry.newResource() : registry.get(path));
            if (resourceImpl.getProperty("registry.link") != null && ("application/wsdl+xml".equals(mediaType) || "application/xsd+xml".equals(mediaType))) {
                resourceImpl = (ResourceImpl)registry.newResource();
            }
            resourceImpl.setMediaType(mediaType);
            resourceImpl.setDescription(description);
            if (properties != null && properties.length > 0) {
                for (String[] p : properties) {
                    resourceImpl.setProperty(p[0], p[1]);
                }
            }
            if (content == null) {
                String temp = "";
                resourceImpl.setContentStream((InputStream)new ByteArrayInputStream(RegistryUtils.encodeString((String)temp)));
            } else {
                resourceImpl.setContentStream(content.getInputStream());
            }
            if (symlinkLocation != null && isNew) {
                Resource resource;
                if (!symlinkLocation.endsWith("/")) {
                    symlinkLocation = symlinkLocation + "/";
                }
                resourceImpl.setProperty("SymlinkPropertyName", symlinkLocation);
                if (registry.resourceExists(path) && (resource = registry.get(path)) != null && resource.getProperty("registry.link") != null) {
                    registry.removeLink(path);
                }
            }
            resourceImpl.setProperty("resource.source", "AdminConsole");
            registry.put(path, (Resource)resourceImpl);
            resourceImpl.discard();
        }
        catch (Exception e) {
            String msg = "Failed to add resource " + path + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

