/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.resource.download.DownloadManagerService;
import org.wso2.carbon.registry.resource.internal.ResourceDataHolder;
import org.wso2.carbon.registry.resource.services.utils.ContentUtil;
import org.wso2.carbon.registry.resource.servlets.ResourceServlet;

@Component(name="org.wso2.carbon.registry.resource", immediate=true)
public class RegistryMgtUIResourceServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUIResourceServiceComponent.class);
    private ResourceDataHolder dataHolder = ResourceDataHolder.getInstance();
    private RegistryService registryService = null;
    private HttpService httpService = null;
    private ServiceRegistration serviceRegistration = null;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            this.registerServlet(context.getBundleContext());
            log.debug((Object)"******* Registry Resources UI Management bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Registry Resources UI Management bundle ******* ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Registry Resources UI Management bundle is deactivated ******* ");
    }

    public void registerServlet(BundleContext bundleContext) throws Exception {
        if (this.registryService == null) {
            String msg = "Unable to Register Servlet. Registry Service Not Found.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Hashtable<String, String> servletParam = new Hashtable<String, String>(2);
        ((Dictionary)servletParam).put("org.apache.abdera.protocol.server.Provider", "org.wso2.carbon.registry.app.RegistryProvider");
        Hashtable<String, RegistryService> servletAttributes = new Hashtable<String, RegistryService>(2);
        ((Dictionary)servletAttributes).put("registry", this.registryService);
        Hashtable<String, Object> params = new Hashtable<String, Object>(2);
        ((Dictionary)params).put("servlet-params", servletParam);
        ((Dictionary)params).put("url-pattern", "/registry/resources");
        ((Dictionary)params).put("servlet-attributes", servletAttributes);
        ResourceServlet resourceServlet = new ResourceServlet();
        this.serviceRegistration = bundleContext.registerService(Servlet.class.getName(), (Object)resourceServlet, params);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
        this.dataHolder.setRegistryService(null);
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    @Reference(name="registry.notification.service", service=NotificationService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryNotificationService")
    protected void setRegistryNotificationService(NotificationService notificationService) {
        this.dataHolder.setRegistryNotificationService(notificationService);
    }

    protected void unsetRegistryNotificationService(NotificationService notificationService) {
        this.dataHolder.setRegistryNotificationService(null);
    }

    @Reference(name="http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Reference(name="registry.download.service", service=DownloadManagerService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetDownloadManagerService")
    protected void setDownloadManagerService(DownloadManagerService downloadManagerService) {
        ContentUtil.setDownloadManagerService(downloadManagerService);
    }

    protected void unsetDownloadManagerService(DownloadManagerService downloadManagerService) {
        ContentUtil.setDownloadManagerService(null);
    }
}

