/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.base.CarbonBaseUtils;

public class GovernanceConfiguration {
    private Map<String, Map<String, String>> discoveryAgentConfigs = new HashMap<String, Map<String, String>>();
    private List<String> comparators = new ArrayList<String>();
    private boolean endpointStateManagementEnabled = false;
    private boolean lifecycleChecklistItemsEnabled = false;
    private long defaultEndpointActiveDuration = 90L;
    private static GovernanceConfiguration instance = new GovernanceConfiguration();

    private GovernanceConfiguration() {
    }

    public static GovernanceConfiguration getInstance() {
        CarbonBaseUtils.checkSecurity();
        return instance;
    }

    public void addDiscoveryAgentConfig(String serverTypeId, Map<String, String> properties) {
        this.discoveryAgentConfigs.put(serverTypeId, properties);
    }

    public Map<String, Map<String, String>> getDiscoveryAgentConfigs() {
        return this.discoveryAgentConfigs;
    }

    public void addComparator(String comparatorClass) {
        this.comparators.add(comparatorClass);
    }

    public List<String> getComparators() {
        return this.comparators;
    }

    public void setComparators(List<String> comparators) {
        this.comparators = comparators;
    }

    public boolean isEndpointStateManagementEnabled() {
        return this.endpointStateManagementEnabled;
    }

    public void setEndpointStateManagementEnabled(boolean endpointStateManagementEnabled) {
        this.endpointStateManagementEnabled = endpointStateManagementEnabled;
    }

    public long getDefaultEndpointActiveDuration() {
        return this.defaultEndpointActiveDuration;
    }

    public void setDefaultEndpointActiveDuration(long defaultEndpointActiveDuration) {
        this.defaultEndpointActiveDuration = defaultEndpointActiveDuration;
    }

    public boolean isLifecycleChecklistItemsEnabled() {
        return this.lifecycleChecklistItemsEnabled;
    }

    public void setLifecycleChecklistItemsEnabled(boolean lifecycleChecklistItemsEnabled) {
        this.lifecycleChecklistItemsEnabled = lifecycleChecklistItemsEnabled;
    }

    public String toString() {
        return "GovernanceConfiguration{discoveryAgentConfigs=" + this.discoveryAgentConfigs + ", comparators=" + this.comparators + ", endpointStateManagementEnabled=" + this.endpointStateManagementEnabled + ", defaultEndpointActiveDuration=" + this.defaultEndpointActiveDuration + ", lifecycleChecklistItemsEnabled=" + this.lifecycleChecklistItemsEnabled + '}';
    }
}

