/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.wso2.carbon.apimgt.persistence.APIConstants;
import org.wso2.carbon.apimgt.persistence.RegistryPersistenceImpl;
import org.wso2.carbon.apimgt.persistence.dto.UserContext;
import org.wso2.carbon.apimgt.persistence.exceptions.APIPersistenceException;
import org.wso2.carbon.apimgt.persistence.utils.PersistenceUtil;
import org.wso2.carbon.registry.indexing.RegistryConfigLoader;
import org.wso2.carbon.registry.indexing.indexer.Indexer;

public class RegistrySearchUtil {
    public static final String TAG_SEARCH_TYPE_PREFIX = "tag";
    public static final String TAG_COLON_SEARCH_TYPE_PREFIX = "tag:";
    public static final String CONTENT_SEARCH_TYPE_PREFIX = "content";
    public static final String DOCUMENTATION_SEARCH_TYPE_PREFIX = "doc";
    public static final String DOCUMENTATION_SEARCH_TYPE_PREFIX_WITH_EQUALS = "doc=";
    public static final String SEARCH_AND_TAG = "&";
    public static final String TAGS_SEARCH_TYPE_PREFIX = "tags";
    public static final String NAME_TYPE_PREFIX = "name";
    public static final String API_STATUS = "STATUS";
    public static final String API_PROVIDER = "Provider";
    public static final String DOCUMENT_INDEXER = "org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer";
    public static final String STORE_VIEW_ROLES = "store_view_roles";
    public static final String PUBLISHER_ROLES = "publisher_roles";
    public static final String DOCUMENT_MEDIA_TYPE_KEY = "application/vnd.wso2-document\\+xml";
    public static final String DOCUMENT_INDEXER_INDICATOR = "document_indexed";
    public static final String DOCUMENTATION_SEARCH_MEDIA_TYPE_FIELD = "mediaType";
    public static final String DOCUMENTATION_INLINE_CONTENT_TYPE = "text/plain";
    public static final String API_RXT_MEDIA_TYPE = "application/vnd.wso2-api+xml";
    public static final String LCSTATE_SEARCH_KEY = "lcState";
    public static final String DOCUMENT_RXT_MEDIA_TYPE = "application/vnd.wso2-document+xml";
    public static final String API_OVERVIEW_STATUS = "overview_status";
    public static final String API_RELATED_CUSTOM_PROPERTIES_PREFIX = "api_meta.";
    public static final String LABEL_SEARCH_TYPE_PREFIX = "label";
    public static final String API_LABELS_GATEWAY_LABELS = "labels_labelName";
    private static final String PROVIDER_SEARCH_TYPE_PREFIX = "provider";
    private static final String VERSION_SEARCH_TYPE_PREFIX = "version";
    private static final String CONTEXT_SEARCH_TYPE_PREFIX = "context";
    public static final String API_DESCRIPTION = "Description";
    public static final String TYPE_SEARCH_TYPE_PREFIX = "type";
    public static final String CATEGORY_SEARCH_TYPE_PREFIX = "api-category";
    public static final String ENABLE_STORE = "enableStore";
    public static final String API_CATEGORIES_CATEGORY_NAME = "apiCategories_categoryName";
    public static final String NULL_USER_ROLE_LIST = "null";
    public static final String GET_API_PRODUCT_QUERY = "type=APIProduct";
    public static final String[] API_SEARCH_PREFIXES = new String[]{"doc", "tags", "name", "provider", "context", "version", "lcState".toLowerCase(), "Description".toLowerCase(), "STATUS".toLowerCase(), "content", "type", "label", "api-category", "enableStore".toLowerCase()};
    private static final Log log = LogFactory.getLog(RegistryPersistenceImpl.class);

    private static String constructQueryWithProvidedCriterias(String inputSearchQuery) throws APIPersistenceException {
        String newSearchQuery = "";
        if (!(inputSearchQuery == null || !inputSearchQuery.contains(" ") || inputSearchQuery.contains(TAG_COLON_SEARCH_TYPE_PREFIX) || inputSearchQuery.contains(CONTENT_SEARCH_TYPE_PREFIX) && inputSearchQuery.split(":").length <= 2)) {
            if (inputSearchQuery.split(" ").length > 1) {
                String[] searchCriterias = inputSearchQuery.split(" ");
                for (int i = 0; i < searchCriterias.length; ++i) {
                    if (searchCriterias[i].contains(":") && searchCriterias[i].split(":").length > 1 && DOCUMENTATION_SEARCH_TYPE_PREFIX.equalsIgnoreCase(searchCriterias[i].split(":")[0])) {
                        throw new APIPersistenceException("Invalid query. AND based search is not supported for doc prefix");
                    }
                    newSearchQuery = i == 0 ? RegistrySearchUtil.getSingleSearchCriteria(searchCriterias[i]) : newSearchQuery + SEARCH_AND_TAG + RegistrySearchUtil.getSingleSearchCriteria(searchCriterias[i]);
                }
            }
        } else {
            newSearchQuery = RegistrySearchUtil.getSingleSearchCriteria(inputSearchQuery);
        }
        return newSearchQuery;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSingleSearchCriteria(String criteria) throws APIPersistenceException {
        String searchValue = criteria = criteria.trim();
        String searchKey = NAME_TYPE_PREFIX;
        if (criteria.contains(":")) {
            if (criteria.split(":").length <= 1) throw new APIPersistenceException("Search term is missing. Try again with valid search query.");
            String[] splitValues = criteria.split(":");
            searchKey = splitValues[0].trim();
            searchValue = splitValues[1];
            if (TAG_SEARCH_TYPE_PREFIX.equals(searchKey)) {
                searchKey = TAGS_SEARCH_TYPE_PREFIX;
                searchValue = searchValue.replace(" ", "\\ ");
            }
            if (!DOCUMENTATION_SEARCH_TYPE_PREFIX.equalsIgnoreCase(searchKey) && !TAGS_SEARCH_TYPE_PREFIX.equalsIgnoreCase(searchKey)) {
                if (API_STATUS.equalsIgnoreCase(searchKey)) {
                    searchValue = searchValue.toLowerCase();
                }
                if (!searchValue.endsWith("\"") || !searchValue.startsWith("\"")) {
                    if (!searchValue.endsWith("*")) {
                        searchValue = searchValue + "*";
                    }
                    if (!searchValue.startsWith("*")) {
                        searchValue = "*" + searchValue;
                    }
                }
            }
        } else if (!searchValue.endsWith("\"") || !searchValue.startsWith("\"")) {
            if (!searchValue.endsWith("*")) {
                searchValue = searchValue + "*";
            }
            if (!searchValue.startsWith("*")) {
                searchValue = "*" + searchValue;
            }
        }
        if (!API_PROVIDER.equalsIgnoreCase(searchKey)) return searchKey + "=" + searchValue;
        searchValue = searchValue.replaceAll("@", "-AT-");
        return searchKey + "=" + searchValue;
    }

    private static Map<String, String> getSearchAttributes(String searchQuery) {
        String complexAttribute;
        String[] searchQueries = searchQuery.split(SEARCH_AND_TAG);
        String apiState = "";
        String publisherRoles = "";
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String searchCriterea : searchQueries) {
            String[] keyVal = searchCriterea.split("=");
            if (STORE_VIEW_ROLES.equals(keyVal[0])) {
                attributes.put("propertyName", keyVal[0]);
                attributes.put("rightPropertyValue", keyVal[1]);
                attributes.put("rightOp", "eq");
                continue;
            }
            if (PUBLISHER_ROLES.equals(keyVal[0])) {
                publisherRoles = keyVal[1];
                continue;
            }
            if (LCSTATE_SEARCH_KEY.equals(keyVal[0])) {
                apiState = keyVal[1];
                continue;
            }
            attributes.put(keyVal[0], keyVal[1]);
        }
        RegistryConfigLoader registryConfig = RegistryConfigLoader.getInstance();
        Map indexerMap = registryConfig.getIndexerMap();
        Indexer documentIndexer = (Indexer)indexerMap.get(DOCUMENT_MEDIA_TYPE_KEY);
        if (documentIndexer != null && DOCUMENT_INDEXER.equals(documentIndexer.getClass().getName())) {
            complexAttribute = ClientUtils.escapeQueryChars((String)API_RXT_MEDIA_TYPE) + " OR mediaType_s:(" + ClientUtils.escapeQueryChars((String)DOCUMENT_RXT_MEDIA_TYPE) + " AND document_indexed_s:true)";
            if (!StringUtils.isEmpty((CharSequence)publisherRoles)) {
                complexAttribute = "(" + ClientUtils.escapeQueryChars((String)API_RXT_MEDIA_TYPE) + " AND publisher_roles_ss:" + publisherRoles + ") OR mediaType_s:(" + ClientUtils.escapeQueryChars((String)DOCUMENT_RXT_MEDIA_TYPE) + " AND publisher_roles_s:" + publisherRoles + ")";
            }
        } else {
            complexAttribute = ClientUtils.escapeQueryChars((String)API_RXT_MEDIA_TYPE);
            if (!StringUtils.isEmpty((CharSequence)publisherRoles)) {
                complexAttribute = "(" + ClientUtils.escapeQueryChars((String)API_RXT_MEDIA_TYPE) + " AND publisher_roles_ss:" + publisherRoles + ")";
            }
        }
        attributes.put(DOCUMENTATION_SEARCH_MEDIA_TYPE_FIELD, complexAttribute);
        attributes.put(API_OVERVIEW_STATUS, apiState);
        return attributes;
    }

    private static String extractQuery(String searchQuery) {
        String[] searchQueries = searchQuery.split(SEARCH_AND_TAG);
        StringBuilder filteredQuery = new StringBuilder();
        for (String query : searchQueries) {
            if (searchQuery.startsWith(DOCUMENTATION_SEARCH_TYPE_PREFIX)) {
                filteredQuery.append(query);
                break;
            }
            if (query.contains("=")) {
                String[] searchKeys = query.split("=");
                if (searchKeys.length < 2) continue;
                if (!Arrays.asList(API_SEARCH_PREFIXES).contains(searchKeys[0].toLowerCase())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(searchKeys[0] + " does not match with any of the reserved key words. Hence appending " + API_RELATED_CUSTOM_PROPERTIES_PREFIX + " as prefix"));
                    }
                    searchKeys[0] = API_RELATED_CUSTOM_PROPERTIES_PREFIX + searchKeys[0];
                }
                if (searchKeys[0].equals(LABEL_SEARCH_TYPE_PREFIX)) {
                    searchKeys[0] = API_LABELS_GATEWAY_LABELS;
                    searchKeys[1] = searchKeys[1].replace("*", "");
                } else if (searchKeys[0].equals(CATEGORY_SEARCH_TYPE_PREFIX)) {
                    searchKeys[0] = API_CATEGORIES_CATEGORY_NAME;
                    searchKeys[1] = searchKeys[1].replace("*", "");
                }
                if (filteredQuery.length() == 0) {
                    filteredQuery.append(searchKeys[0]).append("=").append(searchKeys[1]);
                    continue;
                }
                filteredQuery.append(SEARCH_AND_TAG).append(searchKeys[0]).append("=").append(searchKeys[1]);
                continue;
            }
            filteredQuery.append(query);
        }
        return filteredQuery.toString();
    }

    private static String getPublisherRolesWrappedQuery(String query, UserContext context) {
        if (PersistenceUtil.isAdminUser(context)) {
            log.debug((Object)"Admin user. no modifications to the query");
            return query;
        }
        String criteria = "publisher_roles=" + RegistrySearchUtil.getUserRolesQuery(context.getRoles(), PersistenceUtil.getSkipRoles(context));
        if (query != null && !query.trim().isEmpty()) {
            criteria = criteria + SEARCH_AND_TAG + query;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User roles wrapped query : " + criteria));
        }
        return criteria;
    }

    private static String getDevPortalRolesWrappedQuery(String query, UserContext context) {
        if (PersistenceUtil.isAdminUser(context)) {
            log.debug((Object)"Admin user. no modifications to the query");
            return query;
        }
        String criteria = "store_view_roles=" + RegistrySearchUtil.getUserRolesQuery(context.getRoles(), PersistenceUtil.getSkipRoles(context));
        if (query != null && !query.trim().isEmpty()) {
            criteria = criteria + SEARCH_AND_TAG + query;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User roles wrapped query : " + criteria));
        }
        return criteria;
    }

    private static String getUserRolesQuery(String[] userRoles, String skippedRoles) {
        StringBuilder rolesQuery = new StringBuilder();
        rolesQuery.append('(');
        rolesQuery.append(NULL_USER_ROLE_LIST);
        String skipRolesByRegex = skippedRoles;
        if (StringUtils.isNotEmpty((CharSequence)skipRolesByRegex)) {
            ArrayList<String> filteredUserRoles = new ArrayList<String>(Arrays.asList(userRoles));
            String[] regexList = skipRolesByRegex.split(",");
            for (int i = 0; i < regexList.length; ++i) {
                Pattern p = Pattern.compile(regexList[i]);
                Iterator itr = filteredUserRoles.iterator();
                while (itr.hasNext()) {
                    String role = (String)itr.next();
                    Matcher m = p.matcher(role);
                    if (!m.matches()) continue;
                    itr.remove();
                }
            }
            userRoles = filteredUserRoles.toArray(new String[0]);
        }
        if (userRoles != null) {
            for (String userRole : userRoles) {
                rolesQuery.append(" OR ");
                rolesQuery.append(ClientUtils.escapeQueryChars((String)RegistrySearchUtil.sanitizeUserRole(userRole.toLowerCase())));
            }
        }
        rolesQuery.append(")");
        return rolesQuery.toString();
    }

    private static String sanitizeUserRole(String role) {
        if (role.contains(SEARCH_AND_TAG)) {
            return role.replaceAll(SEARCH_AND_TAG, "%26");
        }
        return role;
    }

    private static String getORBasedSearchCriteria(String[] values) {
        String criteria = "(";
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                criteria = criteria + values[i];
                criteria = i != values.length - 1 ? criteria + " OR " : criteria + ")";
            }
            return criteria;
        }
        return null;
    }

    public static String getDevPortalSearchQuery(String searchQuery, UserContext ctx, boolean displayMultipleStatus) throws APIPersistenceException {
        String modifiedQuery = RegistrySearchUtil.constructNewSearchQuery(searchQuery);
        if (!DOCUMENTATION_SEARCH_TYPE_PREFIX_WITH_EQUALS.startsWith(modifiedQuery)) {
            String[] statusList = new String[]{"PUBLISHED", "PROTOTYPED"};
            if (displayMultipleStatus) {
                statusList = new String[]{"PUBLISHED", "PROTOTYPED", "DEPRECATED"};
            }
            if ("".equals(searchQuery)) {
                String enableStoreCriteria = "enableStore=(true OR null)";
                modifiedQuery = modifiedQuery + SEARCH_AND_TAG + enableStoreCriteria;
            }
            String lcCriteria = "lcState=";
            lcCriteria = lcCriteria + RegistrySearchUtil.getORBasedSearchCriteria(statusList);
            modifiedQuery = modifiedQuery + SEARCH_AND_TAG + lcCriteria;
        }
        modifiedQuery = RegistrySearchUtil.getDevPortalRolesWrappedQuery(RegistrySearchUtil.extractQuery(modifiedQuery), ctx);
        return modifiedQuery;
    }

    public static String getPublisherSearchQuery(String searchQuery, UserContext ctx) throws APIPersistenceException {
        String newSearchQuery = RegistrySearchUtil.constructNewSearchQuery(searchQuery);
        if ("".equals(searchQuery)) {
            String typeCriteria = "type=" + RegistrySearchUtil.getORBasedSearchCriteria(APIConstants.API_SUPPORTED_TYPE_LIST);
            newSearchQuery = newSearchQuery + SEARCH_AND_TAG + typeCriteria;
        }
        newSearchQuery = RegistrySearchUtil.extractQuery(newSearchQuery);
        newSearchQuery = RegistrySearchUtil.getPublisherRolesWrappedQuery(newSearchQuery, ctx);
        return newSearchQuery;
    }

    public static String getPublisherProductSearchQuery(String searchQuery, UserContext ctx) throws APIPersistenceException {
        String newSearchQuery = StringUtils.replace((String)searchQuery, (String)":", (String)"=");
        newSearchQuery = searchQuery.equals("") ? GET_API_PRODUCT_QUERY : searchQuery + SEARCH_AND_TAG + GET_API_PRODUCT_QUERY;
        newSearchQuery = RegistrySearchUtil.getPublisherRolesWrappedQuery(newSearchQuery, ctx);
        return newSearchQuery;
    }

    private static String constructNewSearchQuery(String query) throws APIPersistenceException {
        return RegistrySearchUtil.constructQueryWithProvidedCriterias(query.trim());
    }

    public static Map<String, String> getDevPortalSearchAttributes(String searchQuery, UserContext ctx, boolean displayMultipleStatus) throws APIPersistenceException {
        String modifiedQuery = RegistrySearchUtil.constructNewSearchQuery(searchQuery);
        if (!StringUtils.containsIgnoreCase((CharSequence)modifiedQuery, (CharSequence)API_STATUS)) {
            String[] statusList = new String[]{"PUBLISHED".toLowerCase(), "PROTOTYPED".toLowerCase(), NULL_USER_ROLE_LIST};
            if (displayMultipleStatus) {
                statusList = new String[]{"PUBLISHED".toLowerCase(), "PROTOTYPED".toLowerCase(), "DEPRECATED".toLowerCase(), NULL_USER_ROLE_LIST};
            }
            String lcCriteria = "lcState=" + RegistrySearchUtil.getORBasedSearchCriteria(statusList);
            modifiedQuery = modifiedQuery + SEARCH_AND_TAG + lcCriteria;
        } else {
            String searchString = "STATUS=";
            modifiedQuery = StringUtils.replaceIgnoreCase((String)modifiedQuery, (String)searchString, (String)"lcState=");
        }
        modifiedQuery = RegistrySearchUtil.getDevPortalRolesWrappedQuery(modifiedQuery, ctx);
        Map<String, String> attributes = RegistrySearchUtil.getSearchAttributes(modifiedQuery);
        return attributes;
    }

    public static Map<String, String> getPublisherSearchAttributes(String searchQuery, UserContext ctx) throws APIPersistenceException {
        String modifiedQuery = RegistrySearchUtil.constructNewSearchQuery(searchQuery);
        modifiedQuery = RegistrySearchUtil.getPublisherRolesWrappedQuery(modifiedQuery, ctx);
        Map<String, String> attributes = RegistrySearchUtil.getSearchAttributes(modifiedQuery);
        return attributes;
    }
}

