/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.utils;

import com.google.gson.Gson;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.CORSConfiguration;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPI;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPI;
import org.wso2.carbon.apimgt.persistence.exceptions.APIPersistenceException;
import org.wso2.carbon.apimgt.persistence.internal.PersistenceManagerComponent;
import org.wso2.carbon.apimgt.persistence.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.persistence.utils.PersistenceUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryAuthorizationManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RegistryPersistenceUtil {
    private static final Log log = LogFactory.getLog(RegistryPersistenceUtil.class);

    public static String replaceEmailDomainBack(String input) {
        if (input != null && input.contains("-AT-")) {
            input = input.replace("-AT-", "@");
        }
        return input;
    }

    public static GenericArtifact createAPIArtifactContent(GenericArtifact artifact, API api) throws APIManagementException {
        try {
            String apiSecurity;
            String[] keys;
            String invalidContext;
            String apiStatus = api.getStatus();
            artifact.setAttribute("overview_name", api.getId().getApiName());
            artifact.setAttribute("overview_version", api.getId().getVersion());
            artifact.setAttribute("overview_context", api.getContext());
            artifact.setAttribute("overview_provider", api.getId().getProviderName());
            artifact.setAttribute("overview_description", api.getDescription());
            artifact.setAttribute("overview_wsdl", api.getWsdlUrl());
            artifact.setAttribute("overview_wadl", api.getWadlUrl());
            artifact.setAttribute("overview_thumbnail", api.getThumbnailUrl());
            artifact.setAttribute("overview_status", apiStatus);
            artifact.setAttribute("overview_technicalOwner", api.getTechnicalOwner());
            artifact.setAttribute("overview_technicalOwnerEmail", api.getTechnicalOwnerEmail());
            artifact.setAttribute("overview_businessOwner", api.getBusinessOwner());
            artifact.setAttribute("overview_businessOwnerEmail", api.getBusinessOwnerEmail());
            artifact.setAttribute("overview_visibility", api.getVisibility());
            artifact.setAttribute("overview_visibleRoles", api.getVisibleRoles());
            artifact.setAttribute("overview_visibleTenants", api.getVisibleTenants());
            artifact.setAttribute("overview_endpointSecured", Boolean.toString(api.isEndpointSecured()));
            artifact.setAttribute("overview_endpointAuthDigest", Boolean.toString(api.isEndpointAuthDigest()));
            artifact.setAttribute("overview_endpointUsername", api.getEndpointUTUsername());
            artifact.setAttribute("overview_endpointPpassword", api.getEndpointUTPassword());
            artifact.setAttribute("overview_transports", api.getTransports());
            artifact.setAttribute("overview_inSequence", api.getInSequence());
            artifact.setAttribute("overview_outSequence", api.getOutSequence());
            artifact.setAttribute("overview_faultSequence", api.getFaultSequence());
            artifact.setAttribute("overview_responseCaching", api.getResponseCache());
            artifact.setAttribute("overview_cacheTimeout", Integer.toString(api.getCacheTimeout()));
            artifact.setAttribute("overview_redirectURL", api.getRedirectURL());
            artifact.setAttribute("overview_vendor", api.getAdvertiseOnlyAPIVendor());
            artifact.setAttribute("overview_apiOwner", api.getApiOwner());
            artifact.setAttribute("overview_advertiseOnly", Boolean.toString(api.isAdvertiseOnly()));
            artifact.setAttribute("overview_endpointConfig", api.getEndpointConfig());
            artifact.setAttribute("overview_subscriptionAvailability", api.getSubscriptionAvailability());
            artifact.setAttribute("overview_tenants", api.getSubscriptionAvailableTenants());
            artifact.setAttribute("overview_implementation", api.getImplementation());
            artifact.setAttribute("overview_productionTps", api.getProductionMaxTps());
            artifact.setAttribute("overview_sandboxTps", api.getSandboxMaxTps());
            artifact.setAttribute("overview_authorizationHeader", api.getAuthorizationHeader());
            artifact.setAttribute("overview_apiSecurity", api.getApiSecurity());
            artifact.setAttribute("overview_enableSchemaValidation", Boolean.toString(api.isEnableSchemaValidation()));
            artifact.setAttribute("overview_enableStore", Boolean.toString(api.isEnableStore()));
            artifact.setAttribute("overview_testKey", api.getTestKey());
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if ("carbon.super".equals(tenantDomain) ? (invalidContext = File.separator + "{version}").equals(api.getContextTemplate()) : (invalidContext = "/t/" + tenantDomain + File.separator + "{version}").equals(api.getContextTemplate())) {
                throw new APIManagementException("API : " + api.getId() + " has an unsupported context : " + api.getContextTemplate());
            }
            artifact.setAttribute("overview_contextTemplate", api.getContextTemplate());
            artifact.setAttribute("overview_versionType", "context");
            artifact.setAttribute("overview_type", api.getType());
            StringBuilder policyBuilder = new StringBuilder();
            for (Tier tier : api.getAvailableTiers()) {
                policyBuilder.append(tier.getName());
                policyBuilder.append("||");
            }
            String policies = policyBuilder.toString();
            if (!"".equals(policies)) {
                policies = policies.substring(0, policies.length() - 2);
                artifact.setAttribute("overview_tier", policies);
            }
            StringBuilder tiersBuilder = new StringBuilder();
            for (Tier tier : api.getAvailableTiers()) {
                tiersBuilder.append(tier.getName());
                tiersBuilder.append("||");
            }
            String tiers = tiersBuilder.toString();
            if (!"".equals(tiers)) {
                tiers = tiers.substring(0, tiers.length() - 2);
                artifact.setAttribute("overview_tier", tiers);
            } else {
                artifact.setAttribute("overview_tier", tiers);
            }
            if ("PUBLISHED".equals(apiStatus)) {
                artifact.setAttribute("overview_isLatest", "true");
            }
            for (String key : keys = artifact.getAttributeKeys()) {
                if (!key.contains("URITemplate")) continue;
                artifact.removeAttribute(key);
            }
            Set uriTemplateSet = api.getUriTemplates();
            int i = 0;
            for (Object uriTemplate : uriTemplateSet) {
                artifact.addAttribute("URITemplate_urlPattern" + i, uriTemplate.getUriTemplate());
                artifact.addAttribute("URITemplate_httpVerb" + i, uriTemplate.getHTTPVerb());
                artifact.addAttribute("URITemplate_authType" + i, uriTemplate.getAuthType());
                ++i;
            }
            artifact.setAttribute("overview_environments", RegistryPersistenceUtil.writeEnvironmentsToArtifact(api.getEnvironments()));
            artifact.setAttribute("overview_corsConfiguration", RegistryPersistenceUtil.getCorsConfigurationJsonFromDto(api.getCorsConfiguration()));
            artifact.setAttribute("overview_websubSubscriptionConfiguration", RegistryPersistenceUtil.getWebsubSubscriptionJsonFromDto(api.getWebsubSubscriptionConfiguration()));
            artifact.setAttribute("overview_wsUriMapping", RegistryPersistenceUtil.getWsUriMappingJsonFromDto(api.getWsUriMapping()));
            List attachedApiCategories = api.getApiCategories();
            artifact.removeAttribute("apiCategories_categoryName");
            if (attachedApiCategories != null) {
                for (APICategory category : attachedApiCategories) {
                    artifact.addAttribute("apiCategories_categoryName", category.getName());
                }
            }
            artifact.setAttribute("isMonetizationEnabled", Boolean.toString(api.isMonetizationEnabled()));
            if (api.getMonetizationProperties() != null) {
                artifact.setAttribute("monetizationProperties", api.getMonetizationProperties().toJSONString());
            }
            if (api.getKeyManagers() != null) {
                artifact.setAttribute("overview_keyManagers", new Gson().toJson((Object)api.getKeyManagers()));
            }
            if ((apiSecurity = artifact.getAttribute("overview_apiSecurity")) != null && !apiSecurity.contains("oauth2") && !apiSecurity.contains("api_key")) {
                artifact.setAttribute("overview_tier", "");
            }
        }
        catch (GovernanceException e) {
            String msg = "Failed to create API for : " + api.getId().getApiName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    private static String getWsUriMappingJsonFromDto(Map<String, String> wsUriMapping) {
        return new Gson().toJson(wsUriMapping);
    }

    public static String getCorsConfigurationJsonFromDto(CORSConfiguration corsConfiguration) {
        return new Gson().toJson((Object)corsConfiguration);
    }

    public static String getWebsubSubscriptionJsonFromDto(WebsubSubscriptionConfiguration websubSubscriptionConfiguration) {
        return new Gson().toJson((Object)websubSubscriptionConfiguration);
    }

    public static String writeEnvironmentsToArtifact(Set<String> apiEnvironments) {
        StringBuilder publishedEnvironments = new StringBuilder();
        if (apiEnvironments != null) {
            for (String environmentName : apiEnvironments) {
                publishedEnvironments.append(environmentName).append(',');
            }
            if (apiEnvironments.isEmpty()) {
                publishedEnvironments.append("none,");
            }
            if (!publishedEnvironments.toString().isEmpty()) {
                publishedEnvironments.deleteCharAt(publishedEnvironments.length() - 1);
            }
        }
        return publishedEnvironments.toString();
    }

    public static GenericArtifactManager getArtifactManager(Registry registry, String key) throws APIPersistenceException {
        GenericArtifactManager artifactManager = null;
        try {
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)registry));
            if (GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)registry) != null) {
                artifactManager = new GenericArtifactManager(registry, key);
            } else {
                log.warn((Object)("Couldn't find GovernanceArtifactConfiguration of RXT: " + key + ". Tenant id set in registry : " + ((UserRegistry)registry).getTenantId() + ", Tenant domain set in PrivilegedCarbonContext: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to initialize GenericArtifactManager";
            log.error((Object)msg, (Throwable)e);
            throw new APIPersistenceException(msg, e);
        }
        return artifactManager;
    }

    public static String getAPIProviderPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + identifier.getProviderName();
    }

    public static String getAPIProviderPath(String provider) {
        return "/apimgt/applicationdata/provider/" + provider;
    }

    public static String getAPIPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(identifier.getProviderName()) + "/" + identifier.getApiName() + "/" + identifier.getVersion() + "/api";
    }

    public static String replaceEmailDomain(String input) {
        if (input != null && input.contains("@")) {
            input = input.replace("@", "-AT-");
        }
        return input;
    }

    public static String getTenantDomain(Identifier identifier) {
        return MultitenantUtils.getTenantDomain((String)RegistryPersistenceUtil.replaceEmailDomainBack(identifier.getProviderName()));
    }

    public static void loadTenantRegistry(int tenantId) throws RegistryException {
        TenantRegistryLoader tenantRegistryLoader = PersistenceManagerComponent.getTenantRegistryLoader();
        ServiceReferenceHolder.getInstance().getIndexLoaderService().loadTenantIndex(tenantId);
        tenantRegistryLoader.loadTenantRegistry(tenantId);
    }

    public static void loadloadTenantAPIRXT(String tenant, int tenantID) throws APIManagementException {
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        UserRegistry registry = null;
        try {
            registry = registryService.getGovernanceSystemRegistry(tenantID);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error when create registry instance ", (Throwable)e);
        }
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        String[] rxtFilePaths = file.list(filenameFilter);
        if (rxtFilePaths == null) {
            throw new APIManagementException("rxt files not found in directory " + rxtDir);
        }
        for (String rxtPath : rxtFilePaths) {
            String msg;
            String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            String govRelativePath = RegistryUtils.getRelativePathToOriginal((String)resourcePath, (String)RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance"));
            try {
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                resourcePath = authorizationManager.computePathOnMount(resourcePath);
                AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
                if (registry.resourceExists(govRelativePath)) {
                    authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    continue;
                }
                String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                Resource resource = registry.newResource();
                resource.setContent((Object)rxt.getBytes(Charset.defaultCharset()));
                resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
                registry.put(govRelativePath, resource);
                authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
            }
            catch (UserStoreException e) {
                throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new APIManagementException(msg, (Throwable)e);
            }
        }
    }

    public static void loadTenantAPIPolicy(String tenant, int tenantID) throws APIManagementException {
        String tierBasePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "default-tiers" + File.separator;
        String apiTierFilePath = tierBasePath + "default-tiers.xml";
        String appTierFilePath = tierBasePath + "default-app-tiers.xml";
        String resTierFilePath = tierBasePath + "default-res-tiers.xml";
        RegistryPersistenceUtil.loadTenantAPIPolicy(tenantID, "/apimgt/applicationdata/tiers.xml", apiTierFilePath);
        RegistryPersistenceUtil.loadTenantAPIPolicy(tenantID, "/apimgt/applicationdata/app-tiers.xml", appTierFilePath);
        RegistryPersistenceUtil.loadTenantAPIPolicy(tenantID, "/apimgt/applicationdata/res-tiers.xml", resTierFilePath);
    }

    private static void loadTenantAPIPolicy(int tenantID, String location, String fileName) throws APIManagementException {
        InputStream inputStream = null;
        try {
            File defaultTiers;
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists(location)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tier policies already uploaded to the tenant's registry space");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding API tier policies to the tenant's registry");
            }
            if (!(defaultTiers = new File(fileName)).exists()) {
                log.info((Object)("Default tier policies not found in : " + fileName));
                return;
            }
            inputStream = FileUtils.openInputStream((File)defaultTiers);
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            govRegistry.put(location, resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving policy information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading policy file content", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error when closing input stream", (Throwable)e);
                }
            }
        }
    }

    public static String getMountedPath(RegistryContext registryContext, String path) {
        List mounts;
        if (registryContext != null && path != null && (mounts = registryContext.getMounts()) != null) {
            for (Mount mount : mounts) {
                if (!path.equals(mount.getPath())) continue;
                return mount.getTargetPath();
            }
        }
        return path;
    }

    public static API getAPI(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        API api;
        try {
            Tag[] tag;
            int cacheTimeout;
            Resource apiResource;
            String artifactPath;
            String apiVersion;
            String apiName;
            String providerName;
            block19: {
                providerName = artifact.getAttribute("overview_provider");
                apiName = artifact.getAttribute("overview_name");
                apiVersion = artifact.getAttribute("overview_version");
                APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, apiVersion, artifact.getId());
                api = new API(apiIdentifier);
                api.setUuid(artifact.getId());
                artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
                apiResource = registry.get(artifactPath);
                api = RegistryPersistenceUtil.setResourceProperties(api, apiResource, artifactPath);
                api.setDescription(artifact.getAttribute("overview_description"));
                api.setStatus(RegistryPersistenceUtil.getLcStateFromArtifact(artifact));
                api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
                api.setWsdlUrl(artifact.getAttribute("overview_wsdl"));
                api.setWadlUrl(artifact.getAttribute("overview_wadl"));
                api.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
                api.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
                api.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
                api.setBusinessOwnerEmail(artifact.getAttribute("overview_businessOwnerEmail"));
                api.setVisibility(artifact.getAttribute("overview_visibility"));
                api.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
                api.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
                api.setEndpointSecured(Boolean.parseBoolean(artifact.getAttribute("overview_endpointSecured")));
                api.setEndpointAuthDigest(Boolean.parseBoolean(artifact.getAttribute("overview_endpointAuthDigest")));
                api.setEndpointUTUsername(artifact.getAttribute("overview_endpointUsername"));
                if (!"*****".equals(artifact.getAttribute("overview_endpointPpassword"))) {
                    api.setEndpointUTPassword(artifact.getAttribute("overview_endpointPpassword"));
                } else {
                    api.setEndpointUTPassword(apiResource.getProperty("registry.HiddenEpProperty"));
                }
                api.setTransports(artifact.getAttribute("overview_transports"));
                api.setInSequence(artifact.getAttribute("overview_inSequence"));
                api.setOutSequence(artifact.getAttribute("overview_outSequence"));
                api.setFaultSequence(artifact.getAttribute("overview_faultSequence"));
                api.setResponseCache(artifact.getAttribute("overview_responseCaching"));
                api.setImplementation(artifact.getAttribute("overview_implementation"));
                api.setType(artifact.getAttribute("overview_type"));
                api.setProductionMaxTps(artifact.getAttribute("overview_productionTps"));
                api.setSandboxMaxTps(artifact.getAttribute("overview_sandboxTps"));
                cacheTimeout = 300;
                try {
                    String strCacheTimeout = artifact.getAttribute("overview_cacheTimeout");
                    if (strCacheTimeout != null && !strCacheTimeout.isEmpty()) {
                        cacheTimeout = Integer.parseInt(strCacheTimeout);
                    }
                }
                catch (NumberFormatException e) {
                    if (!log.isWarnEnabled()) break block19;
                    log.warn((Object)("Error while retrieving cache timeout from the registry for " + apiIdentifier));
                }
            }
            api.setCacheTimeout(cacheTimeout);
            api.setEndpointConfig(artifact.getAttribute("overview_endpointConfig"));
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setAdvertiseOnlyAPIVendor(artifact.getAttribute("overview_vendor"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
            api.setType(artifact.getAttribute("overview_type"));
            api.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
            api.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
            String tenantDomainName = MultitenantUtils.getTenantDomain((String)RegistryPersistenceUtil.replaceEmailDomainBack(providerName));
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
            String tiers = artifact.getAttribute("overview_tier");
            HashSet<Tier> availableTiers = new HashSet<Tier>();
            if (tiers != null) {
                String[] tiersArray;
                for (String tierName : tiersArray = tiers.split("\\|\\|")) {
                    availableTiers.add(new Tier(tierName));
                }
            }
            api.setAvailableTiers(availableTiers);
            api.setContext(artifact.getAttribute("overview_context"));
            api.setContextTemplate(artifact.getAttribute("overview_contextTemplate"));
            api.setLatest(Boolean.parseBoolean(artifact.getAttribute("overview_isLatest")));
            api.setEnableSchemaValidation(Boolean.parseBoolean(artifact.getAttribute("overview_enableSchemaValidation")));
            api.setEnableStore(Boolean.parseBoolean(artifact.getAttribute("overview_enableStore")));
            api.setTestKey(artifact.getAttribute("overview_testKey"));
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            api.setTags(tags);
            api.setLastUpdated(apiResource.getLastModified());
            api.setCreatedTime(String.valueOf(apiResource.getCreatedTime().getTime()));
            api.setImplementation(artifact.getAttribute("overview_implementation"));
            api.setEnvironments(RegistryPersistenceUtil.getEnvironments(artifact.getAttribute("overview_environments")));
            api.setCorsConfiguration(RegistryPersistenceUtil.getCorsConfigurationFromArtifact(artifact));
            api.setWebsubSubscriptionConfiguration(RegistryPersistenceUtil.getWebsubSubscriptionConfigurationFromArtifact(artifact));
            api.setAuthorizationHeader(artifact.getAttribute("overview_authorizationHeader"));
            api.setApiSecurity(artifact.getAttribute("overview_apiSecurity"));
            api.setMonetizationEnabled(Boolean.parseBoolean(artifact.getAttribute("isMonetizationEnabled")));
            String monetizationInfo = artifact.getAttribute("monetizationProperties");
            api.setWsUriMapping(RegistryPersistenceUtil.getWsUriMappingFromArtifact(artifact));
            String deployments = artifact.getAttribute("overview_deployments");
            if (StringUtils.isNotBlank((CharSequence)monetizationInfo)) {
                JSONParser parser = new JSONParser();
                JSONObject jsonObj = (JSONObject)parser.parse(monetizationInfo);
                api.setMonetizationProperties(jsonObj);
            }
            api.setApiCategories(RegistryPersistenceUtil.getAPICategoriesFromAPIGovernanceArtifact(artifact, tenantId));
            String keyManagers = artifact.getAttribute("overview_keyManagers");
            if (StringUtils.isNotEmpty((CharSequence)keyManagers)) {
                api.setKeyManagers((List)new Gson().fromJson(keyManagers, List.class));
            } else {
                api.setKeyManagers(Arrays.asList("all"));
            }
            try {
                api.setEnvironmentList(RegistryPersistenceUtil.extractEnvironmentListForAPI(artifact.getAttribute("overview_endpointConfig")));
            }
            catch (ParseException e) {
                String msg = "Failed to parse endpoint config JSON of API: " + apiName + " " + apiVersion;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String msg = "Invalid endpoint config JSON found in API: " + apiName + " " + apiVersion;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API for artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get User Realm of API Provider";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (ParseException e) {
            String msg = "Failed to get parse monetization information.";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    private static Map<String, String> getWsUriMappingFromArtifact(GovernanceArtifact artifact) throws GovernanceException {
        Map wsUriMapping = (Map)new Gson().fromJson(artifact.getAttribute("overview_wsUriMapping"), Map.class);
        return wsUriMapping;
    }

    private static Set<String> getEnvironments(String environments) {
        if (environments != null) {
            String[] publishEnvironmentArray = environments.split(",");
            return new HashSet<String>(Arrays.asList(publishEnvironmentArray));
        }
        return null;
    }

    private static API setResourceProperties(API api, Resource apiResource, String artifactPath) throws RegistryException {
        Properties properties = apiResource.getProperties();
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API '" + api.getId().toString() + "' has the property " + propertyName));
                }
                if (!propertyName.startsWith("api_meta.")) continue;
                String property = propertyName.substring("api_meta.".length());
                api.addProperty(property, apiResource.getProperty(propertyName));
            }
        }
        api.setAccessControl(apiResource.getProperty("publisher_access_control"));
        String accessControlRoles = null;
        String displayPublisherRoles = apiResource.getProperty("display_publisher_roles");
        if (displayPublisherRoles == null) {
            String publisherRoles = apiResource.getProperty("publisher_roles");
            if (publisherRoles != null) {
                accessControlRoles = "null".equals(apiResource.getProperty("publisher_roles")) ? null : apiResource.getProperty("publisher_roles");
            }
        } else {
            accessControlRoles = "null".equals(displayPublisherRoles) ? null : displayPublisherRoles;
        }
        api.setAccessControlRoles(accessControlRoles);
        return api;
    }

    private static APIProduct setResourceProperties(APIProduct apiProduct, Registry registry, String artifactPath) throws RegistryException {
        Resource productResource = registry.get(artifactPath);
        Properties properties = productResource.getProperties();
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API Product '" + apiProduct.getId().toString() + "' has the property " + propertyName));
                }
                if (!propertyName.startsWith("api_meta.")) continue;
                apiProduct.addProperty(propertyName.substring("api_meta.".length()), productResource.getProperty(propertyName));
            }
        }
        apiProduct.setAccessControl(productResource.getProperty("publisher_access_control"));
        String accessControlRoles = null;
        String displayPublisherRoles = productResource.getProperty("display_publisher_roles");
        if (displayPublisherRoles == null) {
            String publisherRoles = productResource.getProperty("publisher_roles");
            if (publisherRoles != null) {
                accessControlRoles = "null".equals(productResource.getProperty("publisher_roles")) ? null : productResource.getProperty("publisher_roles");
            }
        } else {
            accessControlRoles = "null".equals(displayPublisherRoles) ? null : displayPublisherRoles;
        }
        apiProduct.setAccessControlRoles(accessControlRoles);
        return apiProduct;
    }

    protected GenericArtifactManager getAPIGenericArtifactManagerFromUtil(Registry registry, String keyType) throws APIPersistenceException {
        return RegistryPersistenceUtil.getArtifactManager(registry, keyType);
    }

    public static void startTenantFlow(String tenantDomain) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
    }

    public static API getApiForPublishing(Registry registry, GovernanceArtifact apiArtifact) throws APIManagementException {
        API api = RegistryPersistenceUtil.getAPI(apiArtifact, registry);
        RegistryPersistenceUtil.updateAPIProductDependencies(api, registry);
        return api;
    }

    public static void updateAPIProductDependencies(API api, Registry registry) throws APIManagementException {
        for (URITemplate uriTemplate : api.getUriTemplates()) {
            Set usedByProducts = uriTemplate.retrieveUsedByProducts();
            for (APIProductIdentifier usedByProduct : usedByProducts) {
                String apiProductPath = RegistryPersistenceUtil.getAPIProductPath(usedByProduct);
                usedByProduct.setUUID(apiProductPath);
            }
        }
    }

    public static String getAPIProductPath(APIProductIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(identifier.getProviderName()) + "/" + identifier.getName() + "/" + identifier.getVersion() + "/api";
    }

    public static void endTenantFlow() {
        PrivilegedCarbonContext.endTenantFlow();
    }

    public static void setResourcePermissions(String username, String visibility, String[] roles, String artifactPath) throws APIManagementException {
        RegistryPersistenceUtil.setResourcePermissions(username, visibility, roles, artifactPath, null);
    }

    public static void setResourcePermissions(String username, String visibility, String[] roles, String artifactPath, Registry registry) throws APIManagementException {
        try {
            String tenantDomain;
            String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + artifactPath));
            Resource registryResource = null;
            if (registry != null && registry.resourceExists(artifactPath)) {
                registryResource = registry.get(artifactPath);
            }
            StringBuilder publisherAccessRoles = new StringBuilder("null");
            if (registryResource != null) {
                String publisherRole = registryResource.getProperty("publisher_roles");
                if (publisherRole != null) {
                    publisherAccessRoles = new StringBuilder(publisherRole);
                }
                if (StringUtils.isEmpty((CharSequence)publisherAccessRoles.toString())) {
                    publisherAccessRoles = new StringBuilder("null");
                }
                if ("public".equalsIgnoreCase(visibility) || "private".equalsIgnoreCase(visibility)) {
                    registryResource.setProperty("store_view_roles", "null");
                    publisherAccessRoles = new StringBuilder("null");
                } else {
                    registryResource.setProperty("store_view_roles", publisherAccessRoles.toString());
                }
            }
            if (!"carbon.super".equals(tenantDomain = MultitenantUtils.getTenantDomain((String)PersistenceUtil.replaceEmailDomainBack(username)))) {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                resourcePath = authorizationManager.computePathOnMount(resourcePath);
                AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
                if (visibility != null && "restricted".equalsIgnoreCase(visibility)) {
                    boolean isRoleEveryOne = false;
                    if (roles != null) {
                        if (roles.length == 1 && "".equals(roles[0])) {
                            authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                            isRoleEveryOne = true;
                        } else {
                            for (String role : roles) {
                                if ("internal/everyone".equalsIgnoreCase(role.trim())) {
                                    isRoleEveryOne = true;
                                }
                                authManager.authorizeRole(role.trim(), resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                                publisherAccessRoles.append(",").append(role.trim().toLowerCase());
                            }
                        }
                    }
                    if (!isRoleEveryOne) {
                        authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && "private".equalsIgnoreCase(visibility)) {
                    authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && "OWNER_ONLY".equalsIgnoreCase(visibility)) {
                    if (roles == null) {
                        authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    } else {
                        for (String role : roles) {
                            authManager.denyRole(role.trim(), resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        }
                    }
                } else {
                    authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                }
            } else {
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                if (visibility != null && "restricted".equalsIgnoreCase(visibility)) {
                    boolean isRoleEveryOne = false;
                    if (roles != null) {
                        for (String role : roles) {
                            if ("internal/everyone".equalsIgnoreCase(role.trim())) {
                                isRoleEveryOne = true;
                            }
                            authorizationManager.authorizeRole(role.trim(), resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                            publisherAccessRoles.append(",").append(role.toLowerCase());
                        }
                    }
                    if (!isRoleEveryOne) {
                        authorizationManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && "private".equalsIgnoreCase(visibility)) {
                    authorizationManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && "OWNER_ONLY".equalsIgnoreCase(visibility)) {
                    if (roles == null) {
                        authorizationManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    } else {
                        for (String role : roles) {
                            authorizationManager.denyRole(role.trim(), resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        }
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Store view roles for " + artifactPath + " : " + publisherAccessRoles.toString()));
                    }
                    authorizationManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authorizationManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                }
            }
            if (registryResource != null) {
                registryResource.setProperty("store_view_roles", publisherAccessRoles.toString());
                registry.put(artifactPath, registryResource);
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Registry exception while adding role permissions to API", (Throwable)e);
        }
    }

    public static String prependWebContextRoot(String postfixUrl) {
        String webContext = CarbonUtils.getServerConfiguration().getFirstProperty("WebContextRoot");
        if (webContext != null && !"/".equals(webContext)) {
            postfixUrl = webContext + postfixUrl;
        }
        return postfixUrl;
    }

    public static String getLcStateFromArtifact(GovernanceArtifact artifact) throws GovernanceException {
        String lcState = artifact.getLifecycleState();
        String state = lcState != null ? lcState : artifact.getAttribute("overview_status");
        return state != null ? state.toUpperCase() : null;
    }

    private static List<APICategory> getAPICategoriesFromAPIGovernanceArtifact(GovernanceArtifact artifact, int tenantID) throws GovernanceException, APIManagementException {
        Object[] categoriesOfAPI = artifact.getAttributes("apiCategories_categoryName");
        ArrayList<APICategory> categoryList = new ArrayList<APICategory>();
        if (ArrayUtils.isNotEmpty((Object[])categoriesOfAPI)) {
            for (Object categoryName : categoriesOfAPI) {
                APICategory category = new APICategory();
                category.setName((String)categoryName);
                categoryList.add(category);
            }
        }
        return categoryList;
    }

    public static CORSConfiguration getCorsConfigurationFromArtifact(GovernanceArtifact artifact) throws GovernanceException {
        CORSConfiguration corsConfiguration = (CORSConfiguration)new Gson().fromJson(artifact.getAttribute("overview_corsConfiguration"), CORSConfiguration.class);
        return corsConfiguration;
    }

    public static WebsubSubscriptionConfiguration getWebsubSubscriptionConfigurationFromArtifact(GovernanceArtifact artifact) throws GovernanceException {
        WebsubSubscriptionConfiguration websubSubscriptionConfiguration = (WebsubSubscriptionConfiguration)new Gson().fromJson(artifact.getAttribute("overview_websubSubscriptionConfiguration"), WebsubSubscriptionConfiguration.class);
        return websubSubscriptionConfiguration;
    }

    public static Set<String> extractEnvironmentListForAPI(String endpointConfigs) throws ParseException, ClassCastException {
        HashSet<String> environmentList = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)endpointConfigs) && !"null".equals(endpointConfigs)) {
            JSONParser parser = new JSONParser();
            JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfigs);
            if (endpointConfigJson.containsKey((Object)"production_endpoints") && RegistryPersistenceUtil.isEndpointURLNonEmpty(endpointConfigJson.get((Object)"production_endpoints"))) {
                environmentList.add("PRODUCTION");
            }
            if (endpointConfigJson.containsKey((Object)"sandbox_endpoints") && RegistryPersistenceUtil.isEndpointURLNonEmpty(endpointConfigJson.get((Object)"sandbox_endpoints"))) {
                environmentList.add("SANDBOX");
            }
        }
        return environmentList;
    }

    public static boolean isEndpointURLNonEmpty(Object endpoints) {
        if (endpoints instanceof JSONObject) {
            String url;
            JSONObject endpointJson = (JSONObject)endpoints;
            if (endpointJson.containsKey((Object)"url") && endpointJson.get((Object)"url") != null && StringUtils.isNotBlank((CharSequence)(url = endpointJson.get((Object)"url").toString()))) {
                return true;
            }
        } else if (endpoints instanceof JSONArray) {
            JSONArray endpointsJson = (JSONArray)endpoints;
            for (int i = 0; i < endpointsJson.size(); ++i) {
                if (!RegistryPersistenceUtil.isEndpointURLNonEmpty(endpointsJson.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getOpenAPIDefinitionFilePath(String apiName, String apiVersion, String apiProvider) {
        return "/apimgt/applicationdata/provider/" + apiProvider + "/" + apiName + "/" + apiVersion + "/";
    }

    public static String getAPIProductOpenAPIDefinitionFilePath(String apiName, String apiVersion, String apiProvider) {
        return "/apimgt/applicationdata/provider/" + apiProvider + "/" + apiName + "/" + apiVersion + "/";
    }

    public static void loadTenantConfigBlockingMode(String tenantDomain) {
        try {
            ConfigurationContext ctx = ServiceReferenceHolder.getContextService().getServerConfigContext();
            TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating axis configuration for tenant " + tenantDomain), (Throwable)e);
        }
    }

    public static void clearResourcePermissions(String artifactPath, Identifier id, int tenantId) throws APIManagementException {
        try {
            String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + artifactPath));
            String tenantDomain = MultitenantUtils.getTenantDomain((String)RegistryPersistenceUtil.replaceEmailDomainBack(id.getProviderName()));
            if (!"carbon.super".equals(tenantDomain)) {
                AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
                authManager.clearResourceAuthorizations(resourcePath);
            } else {
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                authorizationManager.clearResourceAuthorizations(resourcePath);
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
        }
    }

    public static boolean isValidWSDLURL(String wsdlURL, boolean required) {
        if (wsdlURL != null && !"".equals(wsdlURL)) {
            if (wsdlURL.startsWith("http:") || wsdlURL.startsWith("https:") || wsdlURL.startsWith("file:") || wsdlURL.startsWith("/t") && !wsdlURL.endsWith(".zip")) {
                return true;
            }
        } else if (!required) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WSDL url validation failed. Provided wsdl url is not valid url: " + wsdlURL));
        }
        return false;
    }

    public static String getWsdlArchivePath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/wsdls/archives/" + identifier.getProviderName() + "--" + identifier.getApiName() + identifier.getVersion() + ".zip";
    }

    public static void notifyAPIStateChangeToAssociatedDocuments(GenericArtifact apiArtifact, Registry registry) throws RegistryException, APIManagementException {
        Association[] docAssociations;
        for (Association association : docAssociations = registry.getAssociations(apiArtifact.getPath(), "document")) {
            String documentResourcePath = association.getDestinationPath();
            Resource docResource = registry.get(documentResourcePath);
            String oldStateChangeIndicatorStatus = docResource.getProperty("registry.api.state.change.indicator");
            String newStateChangeIndicatorStatus = "false";
            if (oldStateChangeIndicatorStatus != null) {
                newStateChangeIndicatorStatus = String.valueOf(!Boolean.parseBoolean(oldStateChangeIndicatorStatus));
            }
            docResource.setProperty("registry.api.state.change.indicator", "false");
            registry.put(documentResourcePath, docResource);
        }
    }

    public static String getIconPath(Identifier identifier) {
        String artifactPath = "/apimgt/applicationdata/icons/" + identifier.getProviderName() + "/" + identifier.getName() + "/" + identifier.getVersion();
        return artifactPath + "/" + "icon";
    }

    public static String getAPIPath(String apiName, String apiVersion, String apiProvider) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(apiProvider) + "/" + apiName + "/" + apiVersion + "/api";
    }

    public static String getRevisionPath(String apiUUID, int revisionId) {
        return "/apimgt/applicationdata/apis/" + apiUUID + "/" + revisionId + "/";
    }

    public static String[] getAuthorizedRoles(String apiPath, String tenantDomain) throws UserStoreException {
        String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + apiPath));
        if (!"carbon.super".equals(tenantDomain)) {
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            return authManager.getAllowedRolesForResource(resourcePath, "http://www.wso2.org/projects/registry/actions/get");
        }
        RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
        return authorizationManager.getAllowedRolesForResource(resourcePath, "http://www.wso2.org/projects/registry/actions/get");
    }

    public static void setFilePermission(String filePath) throws APIManagementException {
        try {
            String filePathString = filePath.replaceFirst("/registry/resource/", "");
            AuthorizationManager accessControlAdmin = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(-1234).getAuthorizationManager();
            if (!accessControlAdmin.isRoleAuthorized("system/wso2.anonymous.role", filePathString, "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole("system/wso2.anonymous.role", filePathString, "http://www.wso2.org/projects/registry/actions/get");
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while setting up permissions for file location", (Throwable)e);
        }
    }

    public static String createWsdlFileName(String provider, String apiName, String apiVersion) {
        return provider + "--" + apiName + apiVersion + ".wsdl";
    }

    public static String getAPIBasePath(String provider, String apiName, String version) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(provider) + "/" + apiName + "/" + version;
    }

    public static PublisherAPI getAPIForSearch(GenericArtifact apiArtifact) throws APIPersistenceException {
        PublisherAPI api = new PublisherAPI();
        try {
            api.setContext(apiArtifact.getAttribute("overview_contextTemplate"));
            api.setDescription(apiArtifact.getAttribute("overview_description"));
            api.setId(apiArtifact.getId());
            api.setStatus(apiArtifact.getAttribute("overview_status"));
            api.setApiName(apiArtifact.getAttribute("overview_name"));
            api.setProviderName(apiArtifact.getAttribute("overview_provider"));
            api.setVersion(apiArtifact.getAttribute("overview_version"));
        }
        catch (GovernanceException e) {
            throw new APIPersistenceException("Error while extracting api attributes ", e);
        }
        return api;
    }

    public static DevPortalAPI getDevPortalAPIForSearch(GenericArtifact apiArtifact) throws APIPersistenceException {
        DevPortalAPI api = new DevPortalAPI();
        try {
            api.setContext(apiArtifact.getAttribute("overview_contextTemplate"));
            api.setDescription(apiArtifact.getAttribute("overview_description"));
            api.setId(apiArtifact.getId());
            api.setStatus(apiArtifact.getAttribute("overview_status"));
            api.setApiName(apiArtifact.getAttribute("overview_name"));
            api.setProviderName(apiArtifact.getAttribute("overview_provider"));
            api.setVersion(apiArtifact.getAttribute("overview_version"));
        }
        catch (GovernanceException e) {
            throw new APIPersistenceException("Error while extracting api attributes ", e);
        }
        return api;
    }

    public static GenericArtifact createAPIProductArtifactContent(GenericArtifact artifact, APIProduct apiProduct) throws APIManagementException {
        try {
            String invalidContext;
            artifact.setAttribute("overview_name", apiProduct.getId().getName());
            artifact.setAttribute("overview_version", apiProduct.getId().getVersion());
            artifact.setAttribute("overview_provider", apiProduct.getId().getProviderName());
            artifact.setAttribute("overview_context", apiProduct.getContext());
            artifact.setAttribute("overview_description", apiProduct.getDescription());
            artifact.setAttribute("overview_type", "APIProduct");
            artifact.setAttribute("overview_status", apiProduct.getState());
            artifact.setAttribute("overview_visibility", apiProduct.getVisibility());
            artifact.setAttribute("overview_visibleRoles", apiProduct.getVisibleRoles());
            artifact.setAttribute("overview_visibleTenants", apiProduct.getVisibleTenants());
            artifact.setAttribute("overview_businessOwner", apiProduct.getBusinessOwner());
            artifact.setAttribute("overview_businessOwnerEmail", apiProduct.getBusinessOwnerEmail());
            artifact.setAttribute("overview_technicalOwner", apiProduct.getTechnicalOwner());
            artifact.setAttribute("overview_technicalOwnerEmail", apiProduct.getTechnicalOwnerEmail());
            artifact.setAttribute("overview_subscriptionAvailability", apiProduct.getSubscriptionAvailability());
            artifact.setAttribute("overview_tenants", apiProduct.getSubscriptionAvailableTenants());
            artifact.setAttribute("overview_thumbnail", apiProduct.getThumbnailUrl());
            artifact.setAttribute("overview_cacheTimeout", Integer.toString(apiProduct.getCacheTimeout()));
            StringBuilder policyBuilder = new StringBuilder();
            for (Tier tier : apiProduct.getAvailableTiers()) {
                policyBuilder.append(tier.getName());
                policyBuilder.append("||");
            }
            String policies = policyBuilder.toString();
            if (!"".equals(policies)) {
                policies = policies.substring(0, policies.length() - 2);
                artifact.setAttribute("overview_tier", policies);
            } else {
                artifact.setAttribute("overview_tier", policies);
            }
            artifact.setAttribute("overview_environments", RegistryPersistenceUtil.writeEnvironmentsToArtifact(apiProduct.getEnvironments()));
            artifact.setAttribute("overview_transports", apiProduct.getTransports());
            artifact.setAttribute("overview_corsConfiguration", RegistryPersistenceUtil.getCorsConfigurationJsonFromDto(apiProduct.getCorsConfiguration()));
            artifact.setAttribute("overview_authorizationHeader", apiProduct.getAuthorizationHeader());
            artifact.setAttribute("overview_apiSecurity", apiProduct.getApiSecurity());
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if ("carbon.super".equals(tenantDomain) ? (invalidContext = File.separator + "{version}").equals(apiProduct.getContextTemplate()) : (invalidContext = "/t/" + tenantDomain + File.separator + "{version}").equals(apiProduct.getContextTemplate())) {
                throw new APIManagementException("API : " + apiProduct.getId() + " has an unsupported context : " + apiProduct.getContextTemplate());
            }
            artifact.setAttribute("overview_enableSchemaValidation", Boolean.toString(apiProduct.isEnabledSchemaValidation()));
            artifact.setAttribute("overview_enableStore", Boolean.toString(apiProduct.isEnableStore()));
            artifact.setAttribute("overview_responseCaching", apiProduct.getResponseCache());
            artifact.setAttribute("overview_contextTemplate", apiProduct.getContextTemplate());
            artifact.setAttribute("overview_versionType", "context");
            artifact.setAttribute("isMonetizationEnabled", Boolean.toString(apiProduct.getMonetizationStatus()));
            if (apiProduct.getMonetizationProperties() != null) {
                artifact.setAttribute("monetizationProperties", apiProduct.getMonetizationProperties().toJSONString());
            }
            List attachedApiCategories = apiProduct.getApiCategories();
            artifact.removeAttribute("apiCategories_categoryName");
            if (attachedApiCategories != null) {
                for (APICategory category : attachedApiCategories) {
                    artifact.addAttribute("apiCategories_categoryName", category.getName());
                }
            }
        }
        catch (GovernanceException e) {
            String msg = "Failed to create API for : " + apiProduct.getId().getName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    public static APIProduct getAPIProduct(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        APIProduct apiProduct;
        try {
            Tag[] tag;
            int cacheTimeout;
            int tenantId;
            String artifactPath;
            block11: {
                artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
                String providerName = artifact.getAttribute("overview_provider");
                String productName = artifact.getAttribute("overview_name");
                String productVersion = artifact.getAttribute("overview_version");
                APIProductIdentifier apiProductIdentifier = new APIProductIdentifier(providerName, productName, productVersion);
                apiProduct = new APIProduct(apiProductIdentifier);
                RegistryPersistenceUtil.setResourceProperties(apiProduct, registry, artifactPath);
                apiProduct.setUuid(artifact.getId());
                apiProduct.setContext(artifact.getAttribute("overview_context"));
                apiProduct.setDescription(artifact.getAttribute("overview_description"));
                apiProduct.setState(artifact.getAttribute("overview_status"));
                apiProduct.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
                apiProduct.setVisibility(artifact.getAttribute("overview_visibility"));
                apiProduct.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
                apiProduct.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
                apiProduct.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
                apiProduct.setBusinessOwnerEmail(artifact.getAttribute("overview_businessOwnerEmail"));
                apiProduct.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
                apiProduct.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
                apiProduct.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
                apiProduct.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
                apiProduct.setEnvironments(RegistryPersistenceUtil.getEnvironments(artifact.getAttribute("overview_environments")));
                apiProduct.setTransports(artifact.getAttribute("overview_transports"));
                apiProduct.setApiSecurity(artifact.getAttribute("overview_apiSecurity"));
                apiProduct.setAuthorizationHeader(artifact.getAttribute("overview_authorizationHeader"));
                apiProduct.setCorsConfiguration(RegistryPersistenceUtil.getCorsConfigurationFromArtifact(artifact));
                apiProduct.setCreatedTime(registry.get(artifactPath).getCreatedTime());
                apiProduct.setLastUpdated(registry.get(artifactPath).getLastModified());
                apiProduct.setType(artifact.getAttribute("overview_type"));
                String tenantDomainName = MultitenantUtils.getTenantDomain((String)RegistryPersistenceUtil.replaceEmailDomainBack(providerName));
                apiProduct.setTenantDomain(tenantDomainName);
                tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
                String tiers = artifact.getAttribute("overview_tier");
                HashSet<Tier> availableTiers = new HashSet<Tier>();
                if (tiers != null) {
                    String[] tiersArray;
                    for (String tierName : tiersArray = tiers.split("\\|\\|")) {
                        availableTiers.add(new Tier(tierName));
                    }
                }
                apiProduct.setAvailableTiers(availableTiers);
                apiProduct.setContextTemplate(artifact.getAttribute("overview_contextTemplate"));
                apiProduct.setEnableSchemaValidation(Boolean.parseBoolean(artifact.getAttribute("overview_enableSchemaValidation")));
                apiProduct.setEnableStore(Boolean.parseBoolean(artifact.getAttribute("overview_enableStore")));
                apiProduct.setTestKey(artifact.getAttribute("overview_testKey"));
                apiProduct.setResponseCache(artifact.getAttribute("overview_responseCaching"));
                cacheTimeout = 300;
                try {
                    cacheTimeout = Integer.parseInt(artifact.getAttribute("overview_cacheTimeout"));
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)("Error in converting cache time out due to " + e.getMessage()));
                }
            }
            apiProduct.setCacheTimeout(cacheTimeout);
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            apiProduct.addTags(tags);
            apiProduct.setMonetizationStatus(Boolean.parseBoolean(artifact.getAttribute("isMonetizationEnabled")));
            String monetizationInfo = artifact.getAttribute("monetizationProperties");
            if (StringUtils.isNotBlank((CharSequence)monetizationInfo)) {
                JSONParser parser = new JSONParser();
                JSONObject jsonObj = (JSONObject)parser.parse(monetizationInfo);
                apiProduct.setMonetizationProperties(jsonObj);
            }
            apiProduct.setApiCategories(RegistryPersistenceUtil.getAPICategoriesFromAPIGovernanceArtifact(artifact, tenantId));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API Product for artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get User Realm of API Product Provider";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (ParseException e) {
            String msg = "Failed to get parse monetization information.";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return apiProduct;
    }

    public static String getTenantAdminUserName(String tenantDomain) throws APIManagementException {
        try {
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            String adminUserName = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getRealmConfiguration().getAdminUserName();
            if (!tenantDomain.contentEquals("carbon.super")) {
                String string = adminUserName.concat("@").concat(tenantDomain);
                return string;
            }
            String string = adminUserName;
            return string;
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error in getting tenant admin username", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

