/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.persistence.dto.Documentation;
import org.wso2.carbon.apimgt.persistence.dto.DocumentationInfo;
import org.wso2.carbon.apimgt.persistence.dto.DocumentationType;
import org.wso2.carbon.apimgt.persistence.exceptions.DocumentationPersistenceException;
import org.wso2.carbon.apimgt.persistence.utils.RegistryPersistenceUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryPersistenceDocUtil {
    private static final Log log = LogFactory.getLog(RegistryPersistenceDocUtil.class);

    public static Documentation getDocumentation(GenericArtifact artifact) throws DocumentationPersistenceException {
        Documentation documentation;
        try {
            String docType = artifact.getAttribute("overview_type");
            DocumentationType type = docType.equalsIgnoreCase(DocumentationType.HOWTO.getType()) ? DocumentationType.HOWTO : (docType.equalsIgnoreCase(DocumentationType.PUBLIC_FORUM.getType()) ? DocumentationType.PUBLIC_FORUM : (docType.equalsIgnoreCase(DocumentationType.SUPPORT_FORUM.getType()) ? DocumentationType.SUPPORT_FORUM : (docType.equalsIgnoreCase(DocumentationType.API_MESSAGE_FORMAT.getType()) ? DocumentationType.API_MESSAGE_FORMAT : (docType.equalsIgnoreCase(DocumentationType.SAMPLES.getType()) ? DocumentationType.SAMPLES : DocumentationType.OTHER))));
            documentation = new Documentation(type, artifact.getAttribute("overview_name"));
            documentation.setId(artifact.getId());
            documentation.setSummary(artifact.getAttribute("overview_summary"));
            String visibilityAttr = artifact.getAttribute("overview_visibility");
            Documentation.DocumentVisibility documentVisibility = Documentation.DocumentVisibility.API_LEVEL;
            if (visibilityAttr != null) {
                if (visibilityAttr.equals(Documentation.DocumentVisibility.API_LEVEL.name())) {
                    documentVisibility = Documentation.DocumentVisibility.API_LEVEL;
                } else if (visibilityAttr.equals(Documentation.DocumentVisibility.PRIVATE.name())) {
                    documentVisibility = Documentation.DocumentVisibility.PRIVATE;
                } else if (visibilityAttr.equals(Documentation.DocumentVisibility.OWNER_ONLY.name())) {
                    documentVisibility = Documentation.DocumentVisibility.OWNER_ONLY;
                }
            }
            documentation.setVisibility(documentVisibility);
            DocumentationInfo.DocumentSourceType docSourceType = DocumentationInfo.DocumentSourceType.INLINE;
            String artifactAttribute = artifact.getAttribute("overview_sourceType");
            if (DocumentationInfo.DocumentSourceType.URL.name().equals(artifactAttribute)) {
                docSourceType = DocumentationInfo.DocumentSourceType.URL;
                documentation.setSourceUrl(artifact.getAttribute("overview_sourceURL"));
            } else if (DocumentationInfo.DocumentSourceType.FILE.name().equals(artifactAttribute)) {
                docSourceType = DocumentationInfo.DocumentSourceType.FILE;
                documentation.setFilePath(RegistryPersistenceDocUtil.prependWebContextRoot(artifact.getAttribute("overview_filePath")));
            } else if (DocumentationInfo.DocumentSourceType.MARKDOWN.name().equals(artifactAttribute)) {
                docSourceType = DocumentationInfo.DocumentSourceType.MARKDOWN;
            }
            documentation.setSourceType(docSourceType);
            if (documentation.getType() == DocumentationType.OTHER) {
                documentation.setOtherTypeName(artifact.getAttribute("overview_otherTypeName"));
            }
        }
        catch (GovernanceException e) {
            throw new DocumentationPersistenceException("Failed to get documentation from artifact", e);
        }
        return documentation;
    }

    public static String prependWebContextRoot(String postfixUrl) {
        String webContext = CarbonUtils.getServerConfiguration().getFirstProperty("WebContextRoot");
        if (webContext != null && !"/".equals(webContext)) {
            postfixUrl = webContext + postfixUrl;
        }
        return postfixUrl;
    }

    public static GenericArtifactManager getDocumentArtifactManager(Registry registry) throws DocumentationPersistenceException {
        GenericArtifactManager artifactManager = null;
        String key = "document";
        try {
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)registry));
            if (GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)registry) != null) {
                artifactManager = new GenericArtifactManager(registry, key);
            } else {
                log.warn((Object)("Couldn't find GovernanceArtifactConfiguration of RXT: " + key + ". Tenant id set in registry : " + ((UserRegistry)registry).getTenantId() + ", Tenant domain set in PrivilegedCarbonContext: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to initialize GenericArtifactManager";
            log.error((Object)msg, (Throwable)e);
            throw new DocumentationPersistenceException(msg, e);
        }
        return artifactManager;
    }

    public static String getDocumentPath(String provider, String apiName, String version) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(provider) + "/" + apiName + "/" + version + "/" + "documentation" + "/";
    }

    public static String getRevisionDocumentPath(String apiUUID, int revisionId) {
        return "/apimgt/applicationdata/apis/" + apiUUID + "/" + revisionId + "/" + "documentation" + "/";
    }

    public static String getDocumentFilePath(String provider, String apiName, String version, String fileName) {
        return RegistryPersistenceDocUtil.getDocumentPath(provider, apiName, version) + "files" + "/" + fileName;
    }

    public static String getDocumentContentPath(String provider, String apiName, String version, String fileName) {
        return RegistryPersistenceDocUtil.getDocumentPath(provider, apiName, version) + "contents" + "/" + fileName;
    }

    public static GenericArtifact createDocArtifactContent(GenericArtifact artifact, String apiName, String apiVersion, String apiProvider, Documentation documentation) throws DocumentationPersistenceException {
        try {
            artifact.setAttribute("overview_name", documentation.getName());
            artifact.setAttribute("overview_summary", documentation.getSummary());
            artifact.setAttribute("overview_type", documentation.getType().getType());
            artifact.setAttribute("overview_visibility", documentation.getVisibility().name());
            DocumentationInfo.DocumentSourceType sourceType = documentation.getSourceType();
            switch (sourceType) {
                case INLINE: {
                    sourceType = DocumentationInfo.DocumentSourceType.INLINE;
                    break;
                }
                case MARKDOWN: {
                    sourceType = DocumentationInfo.DocumentSourceType.MARKDOWN;
                    break;
                }
                case URL: {
                    sourceType = DocumentationInfo.DocumentSourceType.URL;
                    break;
                }
                case FILE: {
                    sourceType = DocumentationInfo.DocumentSourceType.FILE;
                    break;
                }
                default: {
                    throw new DocumentationPersistenceException("Unknown sourceType " + (Object)((Object)sourceType) + " provided for documentation");
                }
            }
            if (documentation.getSourceUrl() == null) {
                documentation.setSourceUrl(" ");
            }
            artifact.setAttribute("overview_sourceType", sourceType.name());
            artifact.setAttribute("overview_sourceURL", documentation.getSourceUrl());
            artifact.setAttribute("overview_filePath", documentation.getFilePath());
            artifact.setAttribute("overview_otherTypeName", documentation.getOtherTypeName());
            String basePath = RegistryPersistenceUtil.replaceEmailDomain(apiProvider) + "/" + apiName + "/" + apiVersion;
            artifact.setAttribute("overview_apiBasePath", basePath);
        }
        catch (GovernanceException e) {
            String msg = "Failed to create doc artifact content from :" + documentation.getName();
            log.error((Object)msg, (Throwable)e);
            throw new DocumentationPersistenceException(msg, e);
        }
        return artifact;
    }

    public static String getAPIDocPath(APIIdentifier id) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(id.getProviderName()) + "/" + id.getName() + "/" + id.getVersion() + "/" + "documentation" + "/";
    }

    public static String getAPIDocContentPath(APIIdentifier id, String name) {
        return RegistryPersistenceDocUtil.getAPIDocPath(id) + "/" + name;
    }

    public static String getDocumentationFilePath(Identifier id, String fileName) {
        return "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(id.getProviderName()) + "/" + id.getName() + "/" + id.getVersion() + "/" + "documentation" + "/" + "files" + "/" + fileName;
    }
}

