/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.apimgt.persistence.internal.ServiceReferenceHolder;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.xml.sax.SAXException;

public class RegistryLCManager {
    private static Log log = LogFactory.getLog(RegistryLCManager.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static final String STATE_ID_PROTOTYPED = "Prototyped";
    private static final String STATE_ID_PUBLISHED = "Published";
    private static final String TRANSITION_TARGET_PROTOTYPED = "Prototyped";
    private static final String TRANSITION_TARGET_PUBLISHED = "Published";
    private Map<String, String> stateTransitionMap = new HashMap<String, String>();
    private Map<String, StateInfo> stateInfoMap = new HashMap<String, StateInfo>();
    private HashMap<String, LifeCycleTransition> stateHashMap = new HashMap();

    public RegistryLCManager(int tenantId) throws RegistryException, XMLStreamException, ParserConfigurationException, SAXException, IOException {
        UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getConfigSystemRegistry(tenantId);
        String data = CommonUtil.getLifecycleConfiguration((String)"APILifeCycle", (Registry)registry);
        DocumentBuilderFactory factory = RegistryLCManager.getSecuredDocumentBuilder();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        Document doc = builder.parse(inputStream);
        Element root = doc.getDocumentElement();
        NodeList states = root.getElementsByTagName("state");
        int nStates = states.getLength();
        for (int i = 0; i < nStates; ++i) {
            Node node = states.item(i);
            Node id = node.getAttributes().getNamedItem("id");
            if (id == null || id.getNodeValue().isEmpty()) continue;
            LifeCycleTransition lifeCycleTransition = new LifeCycleTransition();
            ArrayList<String> actions = new ArrayList<String>();
            ArrayList<String> checklistItems = new ArrayList<String>();
            NodeList stateChiledNodes = node.getChildNodes();
            int nTransitions = stateChiledNodes.getLength();
            for (int j = 0; j < nTransitions; ++j) {
                Node transition = stateChiledNodes.item(j);
                if ("transition".equals(transition.getNodeName())) {
                    Node target = transition.getAttributes().getNamedItem("target");
                    Node action = transition.getAttributes().getNamedItem("event");
                    if (!(id.getNodeValue().equals("Prototyped") && (target.getNodeValue().equals("Prototyped") || target.getNodeValue().equals("Published")) || id.getNodeValue().equals("Published") && target.getNodeValue().equals("Published") || target == null || action == null)) {
                        lifeCycleTransition.addTransition(target.getNodeValue().toUpperCase(), action.getNodeValue());
                        this.stateTransitionMap.put(action.getNodeValue(), target.getNodeValue().toUpperCase());
                        actions.add(action.getNodeValue());
                    }
                }
                if (!"datamodel".equals(transition.getNodeName())) continue;
                NodeList datamodels = transition.getChildNodes();
                int nDatamodel = datamodels.getLength();
                for (int k = 0; k < nDatamodel; ++k) {
                    Node dataNode = datamodels.item(k);
                    if (dataNode == null || dataNode.getAttributes() == null || !"checkItems".equals(dataNode.getAttributes().getNamedItem("name").getNodeValue())) continue;
                    NodeList items = dataNode.getChildNodes();
                    for (int x = 0; x < items.getLength(); ++x) {
                        Node item = items.item(x);
                        if (item == null || item.getAttributes() == null || item.getAttributes().getNamedItem("name") == null) continue;
                        checklistItems.add(item.getAttributes().getNamedItem("name").getNodeValue());
                    }
                }
            }
            this.stateHashMap.put(id.getNodeValue().toUpperCase(), lifeCycleTransition);
            StateInfo stateInfo = new StateInfo();
            stateInfo.setCheckListItems(checklistItems);
            stateInfo.setTransitions(actions);
            this.stateInfoMap.put(id.getNodeValue().toUpperCase(), stateInfo);
        }
    }

    public String getTransitionAction(String currentState, String targetState) {
        if (this.stateHashMap.containsKey(currentState)) {
            LifeCycleTransition transition = this.stateHashMap.get(currentState);
            return transition.getAction(targetState);
        }
        return null;
    }

    public String getStateForTransition(String action) {
        return this.stateTransitionMap.get(action);
    }

    public List<String> getCheckListItemsForState(String state) {
        if (this.stateInfoMap.containsKey(state)) {
            return this.stateInfoMap.get(state).getCheckListItems();
        }
        return null;
    }

    public List<String> getAllowedActionsForState(String state) {
        if (this.stateInfoMap.containsKey(state)) {
            return this.stateInfoMap.get(state).getTransitions();
        }
        return null;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        Object Constants = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/" + "external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/" + "external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/" + "nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Failed to load XML Processor Feature " + "external-general-entities" + " or " + "external-parameter-entities" + " or " + "nonvalidating/load-external-dtd"));
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/" + "security-manager", securityManager);
        return dbf;
    }

    class StateInfo {
        private String state;
        private List<String> transitions = new ArrayList<String>();
        private List<String> checkListItems = new ArrayList<String>();

        StateInfo() {
        }

        public List<String> getCheckListItems() {
            return this.checkListItems;
        }

        public void setCheckListItems(List<String> checkListItems) {
            this.checkListItems = checkListItems;
        }

        public List<String> getTransitions() {
            return this.transitions;
        }

        public void setTransitions(List<String> transitions) {
            this.transitions = transitions;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }

    class LifeCycleTransition {
        private HashMap<String, String> transitions = new HashMap();

        public String getAction(String state) {
            if (!this.transitions.containsKey(state)) {
                return null;
            }
            return this.transitions.get(state);
        }

        public void addTransition(String targetStatus, String action) {
            this.transitions.put(targetStatus, action);
        }
    }
}

