/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.persistence.APIConstants;
import org.wso2.carbon.apimgt.persistence.dto.UserContext;
import org.wso2.carbon.apimgt.persistence.exceptions.PersistenceException;

public class PersistenceUtil {
    private static final Log log = LogFactory.getLog(PersistenceUtil.class);

    public static void handleException(String msg, Exception e) throws APIManagementException {
        throw new APIManagementException(msg, (Throwable)e);
    }

    public static void handleException(String msg) throws APIManagementException {
        throw new APIManagementException(msg);
    }

    public static String replaceEmailDomainBack(String input) {
        if (input != null && input.contains("-AT-")) {
            input = input.replace("-AT-", "@");
        }
        return input;
    }

    public static String extractPDFText(InputStream inputStream) throws IOException {
        PDFParser parser = new PDFParser(inputStream);
        parser.parse();
        COSDocument cosDoc = parser.getDocument();
        PDFTextStripper stripper = new PDFTextStripper();
        String text = stripper.getText(new PDDocument(cosDoc));
        cosDoc.close();
        return text;
    }

    public static String extractDocXText(InputStream inputStream) throws IOException {
        XWPFDocument doc = new XWPFDocument(inputStream);
        XWPFWordExtractor msWord2007Extractor = new XWPFWordExtractor(doc);
        return msWord2007Extractor.getText();
    }

    public static String extractDocText(InputStream inputStream) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(inputStream);
        WordExtractor msWord2003Extractor = new WordExtractor(fs);
        return msWord2003Extractor.getText();
    }

    public static String extractPlainText(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }

    public static File writeStream(InputStream uploadedInputStream, String fileName) throws PersistenceException {
        String randomFolderName = RandomStringUtils.randomAlphanumeric((int)10);
        String tmpFolder = System.getProperty("java.io.tmpdir") + File.separator + APIConstants.DOC_UPLOAD_TMPDIR + File.separator + randomFolderName;
        File docFile = new File(tmpFolder);
        FileOutputStream outFileStream = null;
        boolean folderCreated = docFile.mkdirs();
        if (!folderCreated) {
            throw new PersistenceException("Failed to create temporary folder for document upload ");
        }
        try {
            int read;
            outFileStream = new FileOutputStream(new File(docFile.getAbsolutePath(), fileName));
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                outFileStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            try {
                String errorMessage = "Error in transferring files.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new PersistenceException(errorMessage, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outFileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outFileStream);
        return docFile;
    }

    public static InputStream readStream(File docFile, String fileName) throws PersistenceException {
        try {
            FileInputStream newInputStream = new FileInputStream(docFile.getAbsolutePath() + File.separator + fileName);
            return newInputStream;
        }
        catch (FileNotFoundException e) {
            throw new PersistenceException("Failed to open file ");
        }
    }

    public static boolean isAdminUser(UserContext userContext) {
        boolean isAdmin = false;
        Map<String, Object> properties = userContext.getProperties();
        if (properties != null && properties.containsKey("isAdmin")) {
            isAdmin = (Boolean)properties.get("isAdmin");
        }
        return isAdmin;
    }

    public static String getSkipRoles(UserContext userContext) {
        String skipRoles = "";
        Map<String, Object> properties = userContext.getProperties();
        if (properties != null && properties.containsKey("skipRoles")) {
            skipRoles = (String)properties.get("skipRoles");
        }
        return skipRoles;
    }
}

