/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.persistence.dto.CORSConfiguration;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIProduct;
import org.wso2.carbon.apimgt.persistence.mapper.APIProductMapper;

public class APIProductMapperImpl
implements APIProductMapper {
    @Override
    public APIProduct toApiProduct(PublisherAPIProduct product) {
        if (product == null) {
            return null;
        }
        APIProduct aPIProduct = new APIProduct();
        aPIProduct.setUuid(product.getId());
        aPIProduct.setThumbnailUrl(product.getThumbnail());
        aPIProduct.setAvailableTiers(this.mapStringToSet(product.getAvailableTierNames()));
        aPIProduct.setVisibleTenants(product.getVisibleOrganizations());
        aPIProduct.setSubscriptionAvailableTenants(product.getSubscriptionAvailableOrgs());
        aPIProduct.setDescription(product.getDescription());
        aPIProduct.setVisibility(product.getVisibility());
        aPIProduct.setSubscriptionAvailability(product.getSubscriptionAvailability());
        aPIProduct.setState(product.getState());
        aPIProduct.setTechnicalOwner(product.getTechnicalOwner());
        aPIProduct.setTechnicalOwnerEmail(product.getTechnicalOwnerEmail());
        aPIProduct.setType(product.getType());
        aPIProduct.setBusinessOwner(product.getBusinessOwner());
        aPIProduct.setBusinessOwnerEmail(product.getBusinessOwnerEmail());
        aPIProduct.setMonetizationEnabled(product.isMonetizationEnabled());
        try {
            aPIProduct.setMonetizationProperties(this.mapJSONMapToJSONObject(product.getMonetizationProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPIProduct.setVisibleRoles(product.getVisibleRoles());
        aPIProduct.setDefinition(product.getDefinition());
        Set<String> set1 = product.getEnvironments();
        if (set1 != null) {
            aPIProduct.setEnvironments(new HashSet<String>(set1));
        }
        try {
            aPIProduct.setAdditionalProperties(this.mapJSONMapToJSONObject(product.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPIProduct.setContext(product.getContext());
        aPIProduct.setTransports(product.getTransports());
        aPIProduct.setCacheTimeout(product.getCacheTimeout());
        aPIProduct.setAccessControl(product.getAccessControl());
        aPIProduct.setAccessControlRoles(this.mapAccessControlRolesToString(product.getAccessControlRoles()));
        aPIProduct.setEnableSchemaValidation(product.isEnableSchemaValidation());
        aPIProduct.setApiSecurity(product.getApiSecurity());
        aPIProduct.setAuthorizationHeader(product.getAuthorizationHeader());
        aPIProduct.setCorsConfiguration(this.cORSConfigurationToCORSConfiguration(product.getCorsConfiguration()));
        aPIProduct.setCreatedTime(this.mapStringToDate(product.getCreatedTime()));
        aPIProduct.setLastUpdated(this.mapStringToDate(product.getLastUpdated()));
        aPIProduct.setContextTemplate(product.getContextTemplate());
        aPIProduct.setEnableStore(product.isEnableStore());
        Set<String> set2 = product.getTags();
        if (set2 != null) {
            aPIProduct.setTags(new HashSet<String>(set2));
        }
        aPIProduct.setApiCategories(this.mapAPICategoriesToList(product.getApiCategories()));
        return aPIProduct;
    }

    @Override
    public PublisherAPIProduct toPublisherApiProduct(APIProduct product) {
        if (product == null) {
            return null;
        }
        PublisherAPIProduct publisherAPIProduct = new PublisherAPIProduct();
        publisherAPIProduct.setThumbnail(product.getThumbnailUrl());
        publisherAPIProduct.setAvailableTierNames(this.mapTierToSet(product.getAvailableTiers()));
        publisherAPIProduct.setId(product.getUuid());
        publisherAPIProduct.setVisibleOrganizations(product.getVisibleTenants());
        publisherAPIProduct.setSubscriptionAvailableOrgs(product.getSubscriptionAvailableTenants());
        publisherAPIProduct.setContext(product.getContext());
        publisherAPIProduct.setType(product.getType());
        publisherAPIProduct.setState(product.getState());
        publisherAPIProduct.setApiSecurity(product.getApiSecurity());
        publisherAPIProduct.setDescription(product.getDescription());
        publisherAPIProduct.setVisibility(product.getVisibility());
        publisherAPIProduct.setVisibleRoles(product.getVisibleRoles());
        publisherAPIProduct.setTechnicalOwner(product.getTechnicalOwner());
        publisherAPIProduct.setTechnicalOwnerEmail(product.getTechnicalOwnerEmail());
        publisherAPIProduct.setBusinessOwner(product.getBusinessOwner());
        publisherAPIProduct.setBusinessOwnerEmail(product.getBusinessOwnerEmail());
        publisherAPIProduct.setSubscriptionAvailability(product.getSubscriptionAvailability());
        publisherAPIProduct.setCacheTimeout(product.getCacheTimeout());
        Set set1 = product.getEnvironments();
        if (set1 != null) {
            publisherAPIProduct.setEnvironments(new HashSet<String>(set1));
        }
        publisherAPIProduct.setTransports(product.getTransports());
        publisherAPIProduct.setCorsConfiguration(this.cORSConfigurationToCORSConfiguration1(product.getCorsConfiguration()));
        publisherAPIProduct.setAuthorizationHeader(product.getAuthorizationHeader());
        publisherAPIProduct.setContextTemplate(product.getContextTemplate());
        publisherAPIProduct.setEnableSchemaValidation(product.isEnableSchemaValidation());
        publisherAPIProduct.setMonetizationEnabled(product.isMonetizationEnabled());
        try {
            publisherAPIProduct.setMonetizationProperties((Map<String, String>)this.mapJSONMapToJSONObject((Map<String, String>)product.getMonetizationProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        publisherAPIProduct.setApiCategories(this.mapAPICategoriesToSet(product.getApiCategories()));
        publisherAPIProduct.setDefinition(product.getDefinition());
        publisherAPIProduct.setEnableStore(product.isEnableStore());
        publisherAPIProduct.setCreatedTime(this.mapDateToString(product.getCreatedTime()));
        publisherAPIProduct.setLastUpdated(this.mapDateToString(product.getLastUpdated()));
        Set set3 = product.getTags();
        if (set3 != null) {
            publisherAPIProduct.setTags(new HashSet<String>(set3));
        }
        publisherAPIProduct.setAccessControl(product.getAccessControl());
        publisherAPIProduct.setAccessControlRoles(this.mapAccessControlRolesToSet(product.getAccessControlRoles()));
        try {
            publisherAPIProduct.setAdditionalProperties((Map<String, String>)this.mapJSONMapToJSONObject((Map<String, String>)product.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return publisherAPIProduct;
    }

    protected org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfigurationToCORSConfiguration(CORSConfiguration cORSConfiguration) {
        List<String> list2;
        if (cORSConfiguration == null) {
            return null;
        }
        boolean corsConfigurationEnabled = false;
        ArrayList<String> accessControlAllowOrigins = null;
        boolean accessControlAllowCredentials = false;
        ArrayList<String> accessControlAllowHeaders = null;
        ArrayList<String> accessControlAllowMethods = null;
        corsConfigurationEnabled = cORSConfiguration.isCorsConfigurationEnabled();
        List<String> list = cORSConfiguration.getAccessControlAllowOrigins();
        if (list != null) {
            accessControlAllowOrigins = new ArrayList<String>(list);
        }
        accessControlAllowCredentials = cORSConfiguration.isAccessControlAllowCredentials();
        List<String> list1 = cORSConfiguration.getAccessControlAllowHeaders();
        if (list1 != null) {
            accessControlAllowHeaders = new ArrayList<String>(list1);
        }
        if ((list2 = cORSConfiguration.getAccessControlAllowMethods()) != null) {
            accessControlAllowMethods = new ArrayList<String>(list2);
        }
        org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfiguration1 = new org.wso2.carbon.apimgt.api.model.CORSConfiguration(corsConfigurationEnabled, accessControlAllowOrigins, accessControlAllowCredentials, accessControlAllowHeaders, accessControlAllowMethods);
        return cORSConfiguration1;
    }

    protected CORSConfiguration cORSConfigurationToCORSConfiguration1(org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfiguration) {
        List list2;
        if (cORSConfiguration == null) {
            return null;
        }
        CORSConfiguration cORSConfiguration1 = new CORSConfiguration();
        cORSConfiguration1.setCorsConfigurationEnabled(cORSConfiguration.isCorsConfigurationEnabled());
        List list = cORSConfiguration.getAccessControlAllowOrigins();
        if (list != null) {
            cORSConfiguration1.setAccessControlAllowOrigins(new ArrayList<String>(list));
        }
        cORSConfiguration1.setAccessControlAllowCredentials(cORSConfiguration.isAccessControlAllowCredentials());
        List list1 = cORSConfiguration.getAccessControlAllowHeaders();
        if (list1 != null) {
            cORSConfiguration1.setAccessControlAllowHeaders(new ArrayList<String>(list1));
        }
        if ((list2 = cORSConfiguration.getAccessControlAllowMethods()) != null) {
            cORSConfiguration1.setAccessControlAllowMethods(new ArrayList<String>(list2));
        }
        return cORSConfiguration1;
    }
}

