/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.mapper;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIProduct;

@Mapper
public interface APIProductMapper {
    public static final APIProductMapper INSTANCE = (APIProductMapper)Mappers.getMapper(APIProductMapper.class);

    @Mappings(value={@Mapping(source="id", target="uuid"), @Mapping(source="thumbnail", target="thumbnailUrl"), @Mapping(source="availableTierNames", target="availableTiers"), @Mapping(source="visibleOrganizations", target="visibleTenants"), @Mapping(source="subscriptionAvailableOrgs", target="subscriptionAvailableTenants")})
    public APIProduct toApiProduct(PublisherAPIProduct var1);

    @Mappings(value={@Mapping(source="thumbnailUrl", target="thumbnail"), @Mapping(source="availableTiers", target="availableTierNames"), @Mapping(source="uuid", target="id"), @Mapping(source="visibleTenants", target="visibleOrganizations"), @Mapping(source="subscriptionAvailableTenants", target="subscriptionAvailableOrgs")})
    public PublisherAPIProduct toPublisherApiProduct(APIProduct var1);

    default public JSONObject mapJSONMapToJSONObject(Map<String, String> jsonMap) throws ParseException {
        if (jsonMap != null) {
            JSONParser parser = new JSONParser();
            String jsonText = JSONValue.toJSONString(jsonMap);
            JSONObject jsonObject = (JSONObject)parser.parse(jsonText);
            return jsonObject;
        }
        return null;
    }

    default public Map<String, Object> JSONObjectToJSONMap(JSONObject jsonObject) {
        Gson gson = new Gson();
        if (jsonObject != null) {
            jsonObject.toJSONString();
            Map fromJson = (Map)gson.fromJson(jsonObject.toJSONString(), Map.class);
            return fromJson;
        }
        return null;
    }

    default public List<APICategory> mapAPICategoriesToList(Set<String> apiCategories) {
        ArrayList<APICategory> categoryList = new ArrayList<APICategory>();
        if (apiCategories != null) {
            for (String category : apiCategories) {
                APICategory apiCategory = new APICategory();
                apiCategory.setName(category);
                categoryList.add(apiCategory);
            }
        }
        return categoryList;
    }

    default public Set<String> mapAPICategoriesToSet(List<APICategory> apiCategories) {
        HashSet<String> categorySet = new HashSet<String>();
        if (apiCategories != null) {
            for (APICategory category : apiCategories) {
                categorySet.add(category.getName());
            }
        }
        return categorySet;
    }

    default public JSONObject mapJson(JSONObject json) {
        return json;
    }

    default public Date mapStringToDate(String dateString) {
        if (dateString != null) {
            return new Date(Long.parseLong(dateString));
        }
        return null;
    }

    default public String mapDateToString(Date date) {
        if (date != null) {
            return Long.toString(date.getTime());
        }
        return null;
    }

    default public Set<Tier> mapStringToSet(Set<String> tierSet) {
        HashSet<Tier> mappedTiers = new HashSet<Tier>();
        if (tierSet != null) {
            for (String tierName : tierSet) {
                mappedTiers.add(new Tier(tierName));
            }
        }
        return mappedTiers;
    }

    default public Set<String> mapTierToSet(Set<Tier> tierSet) {
        HashSet<String> mappedTiers = new HashSet<String>();
        if (tierSet != null) {
            for (Tier tier : tierSet) {
                mappedTiers.add(tier.getName());
            }
        }
        return mappedTiers;
    }

    default public String mapAccessControlRolesToString(Set<String> accessControlRoles) {
        if (accessControlRoles != null) {
            return String.join((CharSequence)",", accessControlRoles);
        }
        return null;
    }

    default public Set<String> mapAccessControlRolesToSet(String accessControlRoles) {
        if (accessControlRoles != null && !"null".equalsIgnoreCase(accessControlRoles)) {
            return new HashSet<String>(Arrays.asList(accessControlRoles.split(",")));
        }
        return null;
    }
}

