/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.SOAPToRestSequence;
import org.wso2.carbon.apimgt.persistence.dto.CORSConfiguration;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPI;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPIInfo;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPI;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIInfo;
import org.wso2.carbon.apimgt.persistence.dto.WebsubSubscriptionConfiguration;
import org.wso2.carbon.apimgt.persistence.mapper.APIMapper;

public class APIMapperImpl
implements APIMapper {
    @Override
    public API toApi(PublisherAPI api) {
        if (api == null) {
            return null;
        }
        APIIdentifier id = null;
        id = this.publisherAPIToAPIIdentifier(api);
        API aPI = new API(id);
        aPI.setUuid(api.getId());
        aPI.setThumbnailUrl(api.getThumbnail());
        aPI.setAvailableTiers(this.mapStringToSet(api.getAvailableTierNames()));
        aPI.setVisibleTenants(api.getVisibleOrganizations());
        aPI.setSubscriptionAvailableTenants(api.getSubscriptionAvailableOrgs());
        List<SOAPToRestSequence> list = api.getSoapToRestSequences();
        if (list != null) {
            aPI.setSoapToRestSequences(new ArrayList<SOAPToRestSequence>(list));
        }
        try {
            aPI.setAdditionalProperties(this.mapJSONMapToJSONObject(api.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPI.setMonetizationEnabled(api.isMonetizationEnabled());
        try {
            aPI.setMonetizationProperties(this.mapJSONMapToJSONObject(api.getMonetizationProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPI.setSwaggerDefinition(api.getSwaggerDefinition());
        Set<String> set1 = api.getEnvironments();
        if (set1 != null) {
            aPI.setEnvironments(new HashSet<String>(set1));
        }
        aPI.setImplementation(api.getImplementation());
        aPI.setProductionMaxTps(api.getProductionMaxTps());
        aPI.setSandboxMaxTps(api.getSandboxMaxTps());
        aPI.setAdvertiseOnly(api.isAdvertiseOnly());
        aPI.setApiOwner(api.getApiOwner());
        aPI.setRedirectURL(api.getRedirectURL());
        aPI.setAdvertiseOnlyAPIVendor(api.getAdvertiseOnlyAPIVendor());
        aPI.setTransports(api.getTransports());
        aPI.setTechnicalOwner(api.getTechnicalOwner());
        aPI.setTechnicalOwnerEmail(api.getTechnicalOwnerEmail());
        aPI.setBusinessOwner(api.getBusinessOwner());
        aPI.setBusinessOwnerEmail(api.getBusinessOwnerEmail());
        aPI.setDescription(api.getDescription());
        aPI.setContext(api.getContext());
        aPI.setContextTemplate(api.getContextTemplate());
        aPI.setWsdlUrl(api.getWsdlUrl());
        Set<String> set2 = api.getTags();
        if (set2 != null) {
            aPI.setTags(new HashSet<String>(set2));
        }
        aPI.setLastUpdated(this.mapStringToDate(api.getLastUpdated()));
        aPI.setStatus(api.getStatus());
        aPI.setWadlUrl(api.getWadlUrl());
        aPI.setVisibility(api.getVisibility());
        aPI.setVisibleRoles(api.getVisibleRoles());
        aPI.setEndpointUTUsername(api.getEndpointUTUsername());
        aPI.setEndpointUTPassword(api.getEndpointUTPassword());
        aPI.setEndpointSecured(api.isEndpointSecured());
        aPI.setEndpointAuthDigest(api.isEndpointAuthDigest());
        aPI.setInSequence(api.getInSequence());
        aPI.setOutSequence(api.getOutSequence());
        aPI.setSubscriptionAvailability(api.getSubscriptionAvailability());
        aPI.setEndpointConfig(api.getEndpointConfig());
        aPI.setResponseCache(api.getResponseCache());
        aPI.setCacheTimeout(api.getCacheTimeout());
        aPI.setFaultSequence(api.getFaultSequence());
        aPI.setDefaultVersion(api.isDefaultVersion());
        aPI.setCorsConfiguration(this.cORSConfigurationToCORSConfiguration(api.getCorsConfiguration()));
        aPI.setWebsubSubscriptionConfiguration(this.websubSubscriptionConfigurationToWebsubSubscriptionConfiguration(api.getWebsubSubscriptionConfiguration()));
        try {
            aPI.setWsUriMapping((Map)this.mapJSONMapToJSONObject(api.getWsUriMapping()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPI.setType(api.getType());
        aPI.setCreatedTime(api.getCreatedTime());
        aPI.setAccessControlRoles(this.mapAccessControlRolesToString(api.getAccessControlRoles()));
        aPI.setAccessControl(api.getAccessControl());
        aPI.setAuthorizationHeader(api.getAuthorizationHeader());
        aPI.setEnableSchemaValidation(api.isEnableSchemaValidation());
        aPI.setApiSecurity(api.getApiSecurity());
        aPI.setEnableStore(api.isEnableStore());
        aPI.setTestKey(api.getTestKey());
        aPI.setApiCategories(this.mapAPICategoriesToList(api.getApiCategories()));
        List<String> list2 = api.getKeyManagers();
        if (list2 != null) {
            aPI.setKeyManagers(new ArrayList<String>(list2));
        }
        return aPI;
    }

    @Override
    public PublisherAPI toPublisherApi(API api) {
        Set set3;
        if (api == null) {
            return null;
        }
        PublisherAPI publisherAPI = new PublisherAPI();
        publisherAPI.setProviderName(this.apiIdProviderName(api));
        publisherAPI.setApiName(this.apiIdApiName(api));
        publisherAPI.setVersion(this.apiIdVersion(api));
        publisherAPI.setThumbnail(api.getThumbnailUrl());
        publisherAPI.setAvailableTierNames(this.mapTierToSet(api.getAvailableTiers()));
        publisherAPI.setId(api.getUuid());
        publisherAPI.setVisibleOrganizations(api.getVisibleTenants());
        publisherAPI.setSubscriptionAvailableOrgs(api.getSubscriptionAvailableTenants());
        publisherAPI.setContext(api.getContext());
        publisherAPI.setStatus(api.getStatus());
        publisherAPI.setType(api.getType());
        List list = api.getSoapToRestSequences();
        if (list != null) {
            publisherAPI.setSoapToRestSequences(new ArrayList<SOAPToRestSequence>(list));
        }
        publisherAPI.setSwaggerDefinition(api.getSwaggerDefinition());
        publisherAPI.setDefaultVersion(api.isDefaultVersion());
        publisherAPI.setDescription(api.getDescription());
        publisherAPI.setWsdlUrl(api.getWsdlUrl());
        publisherAPI.setWadlUrl(api.getWadlUrl());
        publisherAPI.setTechnicalOwner(api.getTechnicalOwner());
        publisherAPI.setTechnicalOwnerEmail(api.getTechnicalOwnerEmail());
        publisherAPI.setBusinessOwner(api.getBusinessOwner());
        publisherAPI.setBusinessOwnerEmail(api.getBusinessOwnerEmail());
        publisherAPI.setVisibility(api.getVisibility());
        publisherAPI.setVisibleRoles(api.getVisibleRoles());
        publisherAPI.setEndpointSecured(api.isEndpointSecured());
        publisherAPI.setEndpointAuthDigest(api.isEndpointAuthDigest());
        publisherAPI.setEndpointUTUsername(api.getEndpointUTUsername());
        publisherAPI.setEndpointUTPassword(api.getEndpointUTPassword());
        publisherAPI.setTransports(api.getTransports());
        publisherAPI.setInSequence(api.getInSequence());
        publisherAPI.setOutSequence(api.getOutSequence());
        publisherAPI.setFaultSequence(api.getFaultSequence());
        publisherAPI.setResponseCache(api.getResponseCache());
        publisherAPI.setCacheTimeout(api.getCacheTimeout());
        publisherAPI.setRedirectURL(api.getRedirectURL());
        publisherAPI.setApiOwner(api.getApiOwner());
        publisherAPI.setAdvertiseOnly(api.isAdvertiseOnly());
        publisherAPI.setAdvertiseOnlyAPIVendor(api.getAdvertiseOnlyAPIVendor());
        publisherAPI.setEndpointConfig(api.getEndpointConfig());
        publisherAPI.setSubscriptionAvailability(api.getSubscriptionAvailability());
        publisherAPI.setImplementation(api.getImplementation());
        publisherAPI.setProductionMaxTps(api.getProductionMaxTps());
        publisherAPI.setSandboxMaxTps(api.getSandboxMaxTps());
        publisherAPI.setAuthorizationHeader(api.getAuthorizationHeader());
        publisherAPI.setApiSecurity(api.getApiSecurity());
        publisherAPI.setEnableSchemaValidation(api.isEnableSchemaValidation());
        publisherAPI.setEnableStore(api.isEnableStore());
        publisherAPI.setTestKey(api.getTestKey());
        publisherAPI.setContextTemplate(api.getContextTemplate());
        Set set1 = api.getEnvironments();
        if (set1 != null) {
            publisherAPI.setEnvironments(new HashSet<String>(set1));
        }
        publisherAPI.setCorsConfiguration(this.cORSConfigurationToCORSConfiguration1(api.getCorsConfiguration()));
        publisherAPI.setWebsubSubscriptionConfiguration(this.websubSubscriptionConfigurationToWebsubSubscriptionConfiguration1(api.getWebsubSubscriptionConfiguration()));
        publisherAPI.setApiCategories(this.mapAPICategoriesToSet(api.getApiCategories()));
        publisherAPI.setMonetizationEnabled(api.isMonetizationEnabled());
        try {
            publisherAPI.setMonetizationProperties((Map<String, String>)this.mapJSONMapToJSONObject((Map<String, String>)api.getMonetizationProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        List list1 = api.getKeyManagers();
        if (list1 != null) {
            publisherAPI.setKeyManagers(new ArrayList<String>(list1));
        }
        if ((set3 = api.getTags()) != null) {
            publisherAPI.setTags(new HashSet<String>(set3));
        }
        publisherAPI.setAccessControl(api.getAccessControl());
        publisherAPI.setAccessControlRoles(this.mapAccessControlRolesToSet(api.getAccessControlRoles()));
        try {
            publisherAPI.setAdditionalProperties((Map<String, String>)this.mapJSONMapToJSONObject((Map<String, String>)api.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        publisherAPI.setCreatedTime(api.getCreatedTime());
        publisherAPI.setLastUpdated(this.mapDateToString(api.getLastUpdated()));
        try {
            publisherAPI.setWsUriMapping((Map<String, String>)this.mapJSONMapToJSONObject(api.getWsUriMapping()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return publisherAPI;
    }

    @Override
    public API toApi(PublisherAPIInfo api) {
        if (api == null) {
            return null;
        }
        APIIdentifier id = null;
        id = this.publisherAPIInfoToAPIIdentifier(api);
        API aPI = new API(id);
        aPI.setUuid(api.getId());
        aPI.setThumbnailUrl(api.getThumbnail());
        aPI.setContextTemplate(api.getContext());
        aPI.setLastUpdated(api.getUpdatedTime());
        aPI.setContext(api.getContext());
        aPI.setStatus(api.getStatus());
        aPI.setType(api.getType());
        aPI.setCreatedTime(api.getCreatedTime());
        return aPI;
    }

    @Override
    public API toApi(DevPortalAPIInfo api) {
        if (api == null) {
            return null;
        }
        APIIdentifier id = null;
        id = this.devPortalAPIInfoToAPIIdentifier(api);
        API aPI = new API(id);
        aPI.setUuid(api.getId());
        aPI.setThumbnailUrl(api.getThumbnail());
        aPI.setContextTemplate(api.getContext());
        aPI.setAvailableTiers(this.mapStringToSet(api.getAvailableTierNames()));
        aPI.setSubscriptionAvailableTenants(api.getSubscriptionAvailableOrgs());
        aPI.setBusinessOwner(api.getBusinessOwner());
        aPI.setContext(api.getContext());
        aPI.setStatus(api.getStatus());
        aPI.setSubscriptionAvailability(api.getSubscriptionAvailability());
        aPI.setType(api.getType());
        return aPI;
    }

    @Override
    public API toApi(DevPortalAPI api) {
        if (api == null) {
            return null;
        }
        APIIdentifier id = null;
        id = this.devPortalAPIToAPIIdentifier(api);
        API aPI = new API(id);
        aPI.setUuid(api.getId());
        aPI.setAvailableTiers(this.mapStringToSet(api.getAvailableTierNames()));
        aPI.setSubscriptionAvailableTenants(api.getSubscriptionAvailableOrgs());
        try {
            aPI.setAdditionalProperties(this.mapJSONMapToJSONObject(api.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPI.setMonetizationEnabled(api.isMonetizationEnabled());
        aPI.setSwaggerDefinition(api.getSwaggerDefinition());
        Set<String> set1 = api.getEnvironments();
        if (set1 != null) {
            aPI.setEnvironments(new HashSet<String>(set1));
        }
        aPI.setAdvertiseOnly(api.isAdvertiseOnly());
        aPI.setApiOwner(api.getApiOwner());
        aPI.setRedirectURL(api.getRedirectURL());
        aPI.setAdvertiseOnlyAPIVendor(api.getAdvertiseOnlyAPIVendor());
        aPI.setTransports(api.getTransports());
        aPI.setTechnicalOwner(api.getTechnicalOwner());
        aPI.setTechnicalOwnerEmail(api.getTechnicalOwnerEmail());
        aPI.setBusinessOwner(api.getBusinessOwner());
        aPI.setBusinessOwnerEmail(api.getBusinessOwnerEmail());
        aPI.setDescription(api.getDescription());
        aPI.setContext(api.getContext());
        aPI.setContextTemplate(api.getContextTemplate());
        aPI.setWsdlUrl(api.getWsdlUrl());
        List<String> list = api.getTags();
        if (list != null) {
            aPI.setTags(new HashSet<String>(list));
        }
        aPI.setStatus(api.getStatus());
        aPI.setVisibility(api.getVisibility());
        aPI.setVisibleRoles(api.getVisibleRoles());
        aPI.setSubscriptionAvailability(api.getSubscriptionAvailability());
        aPI.setEndpointConfig(api.getEndpointConfig());
        if (api.getDefaultVersion() != null) {
            aPI.setDefaultVersion(api.getDefaultVersion().booleanValue());
        }
        aPI.setType(api.getType());
        aPI.setAuthorizationHeader(api.getAuthorizationHeader());
        aPI.setApiSecurity(api.getApiSecurity());
        aPI.setApiCategories(this.mapAPICategoriesToList(api.getApiCategories()));
        List<String> list2 = api.getKeyManagers();
        if (list2 != null) {
            aPI.setKeyManagers(new ArrayList<String>(list2));
        }
        return aPI;
    }

    @Override
    public DevPortalAPI toDevPortalApi(API api) {
        Set set3;
        if (api == null) {
            return null;
        }
        DevPortalAPI devPortalAPI = new DevPortalAPI();
        devPortalAPI.setProviderName(this.apiIdProviderName(api));
        devPortalAPI.setApiName(this.apiIdApiName(api));
        devPortalAPI.setVersion(this.apiIdVersion(api));
        devPortalAPI.setThumbnail(api.getThumbnailUrl());
        devPortalAPI.setAvailableTierNames(this.mapTierToSet(api.getAvailableTiers()));
        devPortalAPI.setId(api.getUuid());
        devPortalAPI.setSubscriptionAvailableOrgs(api.getSubscriptionAvailableTenants());
        devPortalAPI.setContext(api.getContext());
        devPortalAPI.setContextTemplate(api.getContextTemplate());
        devPortalAPI.setStatus(api.getStatus());
        devPortalAPI.setDefaultVersion(api.isDefaultVersion());
        devPortalAPI.setDescription(api.getDescription());
        devPortalAPI.setWsdlUrl(api.getWsdlUrl());
        devPortalAPI.setTechnicalOwner(api.getTechnicalOwner());
        devPortalAPI.setTechnicalOwnerEmail(api.getTechnicalOwnerEmail());
        devPortalAPI.setBusinessOwner(api.getBusinessOwner());
        devPortalAPI.setBusinessOwnerEmail(api.getBusinessOwnerEmail());
        devPortalAPI.setTransports(api.getTransports());
        devPortalAPI.setRedirectURL(api.getRedirectURL());
        devPortalAPI.setApiOwner(api.getApiOwner());
        devPortalAPI.setAdvertiseOnly(api.isAdvertiseOnly());
        devPortalAPI.setAdvertiseOnlyAPIVendor(api.getAdvertiseOnlyAPIVendor());
        devPortalAPI.setSubscriptionAvailability(api.getSubscriptionAvailability());
        devPortalAPI.setAuthorizationHeader(api.getAuthorizationHeader());
        Set set1 = api.getEnvironments();
        if (set1 != null) {
            devPortalAPI.setEnvironments(new HashSet<String>(set1));
        }
        devPortalAPI.setApiCategories(this.mapAPICategoriesToSet(api.getApiCategories()));
        devPortalAPI.setMonetizationEnabled(api.isMonetizationEnabled());
        List list = api.getKeyManagers();
        if (list != null) {
            devPortalAPI.setKeyManagers(new ArrayList<String>(list));
        }
        if ((set3 = api.getTags()) != null) {
            devPortalAPI.setTags(new ArrayList<String>(set3));
        }
        try {
            devPortalAPI.setAdditionalProperties((Map<String, String>)this.mapJSONMapToJSONObject((Map<String, String>)api.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        devPortalAPI.setEndpointConfig(api.getEndpointConfig());
        devPortalAPI.setType(api.getType());
        devPortalAPI.setSwaggerDefinition(api.getSwaggerDefinition());
        devPortalAPI.setApiSecurity(api.getApiSecurity());
        devPortalAPI.setVisibleRoles(api.getVisibleRoles());
        devPortalAPI.setVisibility(api.getVisibility());
        return devPortalAPI;
    }

    @Override
    public APIProduct toApiProduct(DevPortalAPI api) {
        if (api == null) {
            return null;
        }
        APIProduct aPIProduct = new APIProduct();
        aPIProduct.setUuid(api.getId());
        aPIProduct.setAvailableTiers(this.mapStringToSet(api.getAvailableTierNames()));
        aPIProduct.setSubscriptionAvailableTenants(api.getSubscriptionAvailableOrgs());
        aPIProduct.setState(api.getStatus());
        aPIProduct.setDefinition(api.getSwaggerDefinition());
        aPIProduct.setDescription(api.getDescription());
        aPIProduct.setVisibility(api.getVisibility());
        aPIProduct.setSubscriptionAvailability(api.getSubscriptionAvailability());
        aPIProduct.setTechnicalOwner(api.getTechnicalOwner());
        aPIProduct.setTechnicalOwnerEmail(api.getTechnicalOwnerEmail());
        aPIProduct.setType(api.getType());
        aPIProduct.setBusinessOwner(api.getBusinessOwner());
        aPIProduct.setBusinessOwnerEmail(api.getBusinessOwnerEmail());
        aPIProduct.setMonetizationEnabled(api.isMonetizationEnabled());
        aPIProduct.setVisibleRoles(api.getVisibleRoles());
        Set<String> set1 = api.getEnvironments();
        if (set1 != null) {
            aPIProduct.setEnvironments(new HashSet<String>(set1));
        }
        try {
            aPIProduct.setAdditionalProperties(this.mapJSONMapToJSONObject(api.getAdditionalProperties()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        aPIProduct.setContext(api.getContext());
        aPIProduct.setTransports(api.getTransports());
        aPIProduct.setApiSecurity(api.getApiSecurity());
        aPIProduct.setAuthorizationHeader(api.getAuthorizationHeader());
        aPIProduct.setContextTemplate(api.getContextTemplate());
        List<String> list = api.getTags();
        if (list != null) {
            aPIProduct.setTags(new HashSet<String>(list));
        }
        aPIProduct.setApiCategories(this.mapAPICategoriesToList(api.getApiCategories()));
        return aPIProduct;
    }

    protected APIIdentifier publisherAPIToAPIIdentifier(PublisherAPI publisherAPI) {
        if (publisherAPI == null) {
            return null;
        }
        String providerName = null;
        String apiName = null;
        String version = null;
        providerName = publisherAPI.getProviderName();
        apiName = publisherAPI.getApiName();
        version = publisherAPI.getVersion();
        APIIdentifier aPIIdentifier = new APIIdentifier(providerName, apiName, version);
        return aPIIdentifier;
    }

    protected org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfigurationToCORSConfiguration(CORSConfiguration cORSConfiguration) {
        List<String> list2;
        if (cORSConfiguration == null) {
            return null;
        }
        boolean corsConfigurationEnabled = false;
        ArrayList<String> accessControlAllowOrigins = null;
        boolean accessControlAllowCredentials = false;
        ArrayList<String> accessControlAllowHeaders = null;
        ArrayList<String> accessControlAllowMethods = null;
        corsConfigurationEnabled = cORSConfiguration.isCorsConfigurationEnabled();
        List<String> list = cORSConfiguration.getAccessControlAllowOrigins();
        if (list != null) {
            accessControlAllowOrigins = new ArrayList<String>(list);
        }
        accessControlAllowCredentials = cORSConfiguration.isAccessControlAllowCredentials();
        List<String> list1 = cORSConfiguration.getAccessControlAllowHeaders();
        if (list1 != null) {
            accessControlAllowHeaders = new ArrayList<String>(list1);
        }
        if ((list2 = cORSConfiguration.getAccessControlAllowMethods()) != null) {
            accessControlAllowMethods = new ArrayList<String>(list2);
        }
        org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfiguration1 = new org.wso2.carbon.apimgt.api.model.CORSConfiguration(corsConfigurationEnabled, accessControlAllowOrigins, accessControlAllowCredentials, accessControlAllowHeaders, accessControlAllowMethods);
        return cORSConfiguration1;
    }

    protected org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration websubSubscriptionConfigurationToWebsubSubscriptionConfiguration(WebsubSubscriptionConfiguration websubSubscriptionConfiguration) {
        if (websubSubscriptionConfiguration == null) {
            return null;
        }
        boolean enable = false;
        String secret = null;
        String signingAlgorithm = null;
        String signatureHeader = null;
        enable = websubSubscriptionConfiguration.isEnable();
        secret = websubSubscriptionConfiguration.getSecret();
        signingAlgorithm = websubSubscriptionConfiguration.getSigningAlgorithm();
        signatureHeader = websubSubscriptionConfiguration.getSignatureHeader();
        org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration websubSubscriptionConfiguration1 = new org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration(enable, secret, signingAlgorithm, signatureHeader);
        return websubSubscriptionConfiguration1;
    }

    private String apiIdProviderName(API aPI) {
        if (aPI == null) {
            return null;
        }
        APIIdentifier id = aPI.getId();
        if (id == null) {
            return null;
        }
        String providerName = id.getProviderName();
        if (providerName == null) {
            return null;
        }
        return providerName;
    }

    private String apiIdApiName(API aPI) {
        if (aPI == null) {
            return null;
        }
        APIIdentifier id = aPI.getId();
        if (id == null) {
            return null;
        }
        String apiName = id.getApiName();
        if (apiName == null) {
            return null;
        }
        return apiName;
    }

    private String apiIdVersion(API aPI) {
        if (aPI == null) {
            return null;
        }
        APIIdentifier id = aPI.getId();
        if (id == null) {
            return null;
        }
        String version = id.getVersion();
        if (version == null) {
            return null;
        }
        return version;
    }

    protected CORSConfiguration cORSConfigurationToCORSConfiguration1(org.wso2.carbon.apimgt.api.model.CORSConfiguration cORSConfiguration) {
        List list2;
        if (cORSConfiguration == null) {
            return null;
        }
        CORSConfiguration cORSConfiguration1 = new CORSConfiguration();
        cORSConfiguration1.setCorsConfigurationEnabled(cORSConfiguration.isCorsConfigurationEnabled());
        List list = cORSConfiguration.getAccessControlAllowOrigins();
        if (list != null) {
            cORSConfiguration1.setAccessControlAllowOrigins(new ArrayList<String>(list));
        }
        cORSConfiguration1.setAccessControlAllowCredentials(cORSConfiguration.isAccessControlAllowCredentials());
        List list1 = cORSConfiguration.getAccessControlAllowHeaders();
        if (list1 != null) {
            cORSConfiguration1.setAccessControlAllowHeaders(new ArrayList<String>(list1));
        }
        if ((list2 = cORSConfiguration.getAccessControlAllowMethods()) != null) {
            cORSConfiguration1.setAccessControlAllowMethods(new ArrayList<String>(list2));
        }
        return cORSConfiguration1;
    }

    protected WebsubSubscriptionConfiguration websubSubscriptionConfigurationToWebsubSubscriptionConfiguration1(org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration websubSubscriptionConfiguration) {
        if (websubSubscriptionConfiguration == null) {
            return null;
        }
        boolean enable = false;
        String secret = null;
        String signingAlgorithm = null;
        String signatureHeader = null;
        enable = websubSubscriptionConfiguration.isEnable();
        secret = websubSubscriptionConfiguration.getSecret();
        signingAlgorithm = websubSubscriptionConfiguration.getSigningAlgorithm();
        signatureHeader = websubSubscriptionConfiguration.getSignatureHeader();
        WebsubSubscriptionConfiguration websubSubscriptionConfiguration1 = new WebsubSubscriptionConfiguration(enable, secret, signingAlgorithm, signatureHeader);
        return websubSubscriptionConfiguration1;
    }

    protected APIIdentifier publisherAPIInfoToAPIIdentifier(PublisherAPIInfo publisherAPIInfo) {
        if (publisherAPIInfo == null) {
            return null;
        }
        String providerName = null;
        String apiName = null;
        String version = null;
        providerName = publisherAPIInfo.getProviderName();
        apiName = publisherAPIInfo.getApiName();
        version = publisherAPIInfo.getVersion();
        APIIdentifier aPIIdentifier = new APIIdentifier(providerName, apiName, version);
        return aPIIdentifier;
    }

    protected APIIdentifier devPortalAPIInfoToAPIIdentifier(DevPortalAPIInfo devPortalAPIInfo) {
        if (devPortalAPIInfo == null) {
            return null;
        }
        String providerName = null;
        String apiName = null;
        String version = null;
        providerName = devPortalAPIInfo.getProviderName();
        apiName = devPortalAPIInfo.getApiName();
        version = devPortalAPIInfo.getVersion();
        APIIdentifier aPIIdentifier = new APIIdentifier(providerName, apiName, version);
        return aPIIdentifier;
    }

    protected APIIdentifier devPortalAPIToAPIIdentifier(DevPortalAPI devPortalAPI) {
        if (devPortalAPI == null) {
            return null;
        }
        String providerName = null;
        String apiName = null;
        String version = null;
        providerName = devPortalAPI.getProviderName();
        apiName = devPortalAPI.getApiName();
        version = devPortalAPI.getVersion();
        APIIdentifier aPIIdentifier = new APIIdentifier(providerName, apiName, version);
        return aPIIdentifier;
    }
}

