/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.mapper;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPI;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPIInfo;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPI;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIInfo;

@Mapper
public interface APIMapper {
    public static final APIMapper INSTANCE = (APIMapper)Mappers.getMapper(APIMapper.class);

    @Mappings(value={@Mapping(source="providerName", target="id.providerName"), @Mapping(source="apiName", target="id.apiName"), @Mapping(source="version", target="id.version"), @Mapping(source="id", target="uuid"), @Mapping(source="thumbnail", target="thumbnailUrl"), @Mapping(source="availableTierNames", target="availableTiers"), @Mapping(source="visibleOrganizations", target="visibleTenants"), @Mapping(source="subscriptionAvailableOrgs", target="subscriptionAvailableTenants")})
    public API toApi(PublisherAPI var1);

    @Mappings(value={@Mapping(source="id.providerName", target="providerName"), @Mapping(source="id.apiName", target="apiName"), @Mapping(source="id.version", target="version"), @Mapping(source="thumbnailUrl", target="thumbnail"), @Mapping(source="availableTiers", target="availableTierNames"), @Mapping(source="uuid", target="id"), @Mapping(source="visibleTenants", target="visibleOrganizations"), @Mapping(source="subscriptionAvailableTenants", target="subscriptionAvailableOrgs")})
    public PublisherAPI toPublisherApi(API var1);

    @Mappings(value={@Mapping(source="providerName", target="id.providerName"), @Mapping(source="apiName", target="id.apiName"), @Mapping(source="version", target="id.version"), @Mapping(source="id", target="uuid"), @Mapping(source="thumbnail", target="thumbnailUrl"), @Mapping(source="context", target="contextTemplate"), @Mapping(source="updatedTime", target="lastUpdated")})
    public API toApi(PublisherAPIInfo var1);

    @Mappings(value={@Mapping(source="providerName", target="id.providerName"), @Mapping(source="apiName", target="id.apiName"), @Mapping(source="version", target="id.version"), @Mapping(source="id", target="uuid"), @Mapping(source="thumbnail", target="thumbnailUrl"), @Mapping(source="context", target="contextTemplate"), @Mapping(source="availableTierNames", target="availableTiers"), @Mapping(source="subscriptionAvailableOrgs", target="subscriptionAvailableTenants")})
    public API toApi(DevPortalAPIInfo var1);

    @Mappings(value={@Mapping(source="providerName", target="id.providerName"), @Mapping(source="apiName", target="id.apiName"), @Mapping(source="version", target="id.version"), @Mapping(source="id", target="uuid"), @Mapping(source="availableTierNames", target="availableTiers"), @Mapping(source="subscriptionAvailableOrgs", target="subscriptionAvailableTenants")})
    public API toApi(DevPortalAPI var1);

    @Mappings(value={@Mapping(source="id.providerName", target="providerName"), @Mapping(source="id.apiName", target="apiName"), @Mapping(source="id.version", target="version"), @Mapping(source="thumbnailUrl", target="thumbnail"), @Mapping(source="availableTiers", target="availableTierNames"), @Mapping(source="uuid", target="id"), @Mapping(source="subscriptionAvailableTenants", target="subscriptionAvailableOrgs")})
    public DevPortalAPI toDevPortalApi(API var1);

    @Mappings(value={@Mapping(source="id", target="uuid"), @Mapping(source="availableTierNames", target="availableTiers"), @Mapping(source="subscriptionAvailableOrgs", target="subscriptionAvailableTenants"), @Mapping(source="status", target="state"), @Mapping(source="swaggerDefinition", target="definition")})
    public APIProduct toApiProduct(DevPortalAPI var1);

    default public JSONObject mapJSONMapToJSONObject(Map<String, String> jsonMap) throws ParseException {
        if (jsonMap != null) {
            JSONParser parser = new JSONParser();
            String jsonText = JSONValue.toJSONString(jsonMap);
            JSONObject jsonObject = (JSONObject)parser.parse(jsonText);
            return jsonObject;
        }
        return null;
    }

    default public Map<String, Object> JSONObjectToJSONMap(JSONObject jsonObject) {
        Gson gson = new Gson();
        if (jsonObject != null) {
            jsonObject.toJSONString();
            Map fromJson = (Map)gson.fromJson(jsonObject.toJSONString(), Map.class);
            return fromJson;
        }
        return null;
    }

    default public String mapAccessControlRolesToString(Set<String> accessControlRoles) {
        if (accessControlRoles != null) {
            return String.join((CharSequence)",", accessControlRoles);
        }
        return null;
    }

    default public Set<String> mapAccessControlRolesToSet(String accessControlRoles) {
        if (accessControlRoles != null && !"null".equalsIgnoreCase(accessControlRoles)) {
            return new HashSet<String>(Arrays.asList(accessControlRoles.split(",")));
        }
        return null;
    }

    default public List<APICategory> mapAPICategoriesToList(Set<String> apiCategories) {
        ArrayList<APICategory> categoryList = new ArrayList<APICategory>();
        if (apiCategories != null) {
            for (String category : apiCategories) {
                APICategory apiCategory = new APICategory();
                apiCategory.setName(category);
                categoryList.add(apiCategory);
            }
        }
        return categoryList;
    }

    default public Set<String> mapAPICategoriesToSet(List<APICategory> apiCategories) {
        HashSet<String> categorySet = new HashSet<String>();
        if (apiCategories != null) {
            for (APICategory category : apiCategories) {
                categorySet.add(category.getName());
            }
        }
        return categorySet;
    }

    default public JSONObject mapJson(JSONObject json) {
        return json;
    }

    default public Date mapStringToDate(String dateString) {
        if (dateString != null) {
            return new Date(Long.parseLong(dateString));
        }
        return null;
    }

    default public String mapDateToString(Date date) {
        if (date != null) {
            return Long.toString(date.getTime());
        }
        return null;
    }

    default public Set<Tier> mapStringToSet(Set<String> tierSet) {
        HashSet<Tier> mappedTiers = new HashSet<Tier>();
        if (tierSet != null) {
            for (String tierName : tierSet) {
                mappedTiers.add(new Tier(tierName));
            }
        }
        return mappedTiers;
    }

    default public Set<String> mapTierToSet(Set<Tier> tierSet) {
        HashSet<String> mappedTiers = new HashSet<String>();
        if (tierSet != null) {
            for (Tier tier : tierSet) {
                mappedTiers.add(tier.getName());
            }
        }
        return mappedTiers;
    }
}

