/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence.exceptions;

import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;

public class OASPersistenceException
extends Exception {
    private ErrorHandler errorHandler;

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public OASPersistenceException(String msg) {
        super(msg);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public OASPersistenceException(String msg, Throwable e) {
        super(msg, e);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public OASPersistenceException(Throwable throwable) {
        super(throwable);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public OASPersistenceException(String message, ErrorHandler code) {
        super(message);
        this.errorHandler = code;
    }

    public OASPersistenceException(ErrorHandler code) {
        super(code.getErrorCode() + ":" + code.getErrorMessage() + "::" + code.getErrorDescription());
        this.errorHandler = code;
    }

    public OASPersistenceException(String message, Throwable cause, ErrorHandler code) {
        super(message, cause);
        this.errorHandler = code;
    }
}

