/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtResourceNotFoundException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.SOAPToRestSequence;
import org.wso2.carbon.apimgt.persistence.APIPersistence;
import org.wso2.carbon.apimgt.persistence.LCManagerFactory;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPI;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPIInfo;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalAPISearchResult;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalContentSearchResult;
import org.wso2.carbon.apimgt.persistence.dto.DevPortalSearchContent;
import org.wso2.carbon.apimgt.persistence.dto.DocumentContent;
import org.wso2.carbon.apimgt.persistence.dto.DocumentSearchContent;
import org.wso2.carbon.apimgt.persistence.dto.DocumentSearchResult;
import org.wso2.carbon.apimgt.persistence.dto.Documentation;
import org.wso2.carbon.apimgt.persistence.dto.DocumentationInfo;
import org.wso2.carbon.apimgt.persistence.dto.Mediation;
import org.wso2.carbon.apimgt.persistence.dto.MediationInfo;
import org.wso2.carbon.apimgt.persistence.dto.Organization;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPI;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIInfo;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIProduct;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIProductInfo;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPIProductSearchResult;
import org.wso2.carbon.apimgt.persistence.dto.PublisherAPISearchResult;
import org.wso2.carbon.apimgt.persistence.dto.PublisherContentSearchResult;
import org.wso2.carbon.apimgt.persistence.dto.PublisherSearchContent;
import org.wso2.carbon.apimgt.persistence.dto.ResourceFile;
import org.wso2.carbon.apimgt.persistence.dto.SearchContent;
import org.wso2.carbon.apimgt.persistence.dto.UserContext;
import org.wso2.carbon.apimgt.persistence.exceptions.APIPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.AsyncSpecPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.DocumentationPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.GraphQLPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.MediationPolicyPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.OASPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.PersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.ThumbnailPersistenceException;
import org.wso2.carbon.apimgt.persistence.exceptions.WSDLPersistenceException;
import org.wso2.carbon.apimgt.persistence.internal.PersistenceManagerComponent;
import org.wso2.carbon.apimgt.persistence.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.persistence.mapper.APIMapper;
import org.wso2.carbon.apimgt.persistence.mapper.APIProductMapper;
import org.wso2.carbon.apimgt.persistence.utils.PersistenceUtil;
import org.wso2.carbon.apimgt.persistence.utils.RegistryPersistenceDocUtil;
import org.wso2.carbon.apimgt.persistence.utils.RegistryPersistenceUtil;
import org.wso2.carbon.apimgt.persistence.utils.RegistrySearchUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifactImpl;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.ContentBasedSearchService;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RegistryPersistenceImpl
implements APIPersistence {
    private static final Log log = LogFactory.getLog(RegistryPersistenceImpl.class);
    private Properties properties;

    public RegistryPersistenceImpl() {
    }

    public RegistryPersistenceImpl(Properties properties) {
        this.properties = properties;
    }

    protected String getTenantAwareUsername(String username) {
        return MultitenantUtils.getTenantAwareUsername((String)username);
    }

    protected void loadTenantRegistry(int apiTenantId) throws RegistryException {
        TenantRegistryLoader tenantRegistryLoader = PersistenceManagerComponent.getTenantRegistryLoader();
        ServiceReferenceHolder.getInstance().getIndexLoaderService().loadTenantIndex(apiTenantId);
        tenantRegistryLoader.loadTenantRegistry(apiTenantId);
    }

    protected TenantManager getTenantManager() {
        return ServiceReferenceHolder.getInstance().getRealmService().getTenantManager();
    }

    protected RegistryService getRegistryService() {
        return ServiceReferenceHolder.getInstance().getRegistryService();
    }

    @Override
    public PublisherAPI addAPI(Organization org, PublisherAPI publisherAPI) throws APIPersistenceException {
        API api = APIMapper.INSTANCE.toApi(publisherAPI);
        boolean transactionCommitted = false;
        boolean tenantFlowStarted = false;
        Registry registry = null;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Failed to retrieve artifact manager when creating API " + api.getId().getApiName();
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifact genericArtifact = artifactManager.newGovernanceArtifact(new QName(api.getId().getApiName()));
            if (genericArtifact == null) {
                String errorMessage = "Generic artifact is null when creating API " + api.getId().getApiName();
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifact artifact = RegistryPersistenceUtil.createAPIArtifactContent(genericArtifact, api);
            artifactManager.addGenericArtifact(artifact);
            artifact.attachLifecycle("APILifeCycle");
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            String providerPath = RegistryPersistenceUtil.getAPIProviderPath(api.getId());
            registry.addAssociation(providerPath, artifactPath, "provides");
            Set tagSet = api.getTags();
            if (tagSet != null) {
                for (String tag : tagSet) {
                    registry.applyTag(artifactPath, tag);
                }
            }
            String apiStatus = api.getStatus();
            this.saveAPIStatus(registry, artifactPath, apiStatus);
            String visibleRolesList = api.getVisibleRoles();
            String[] visibleRoles = new String[]{};
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            String publisherAccessControlRoles = api.getAccessControlRoles();
            this.updateRegistryResources(registry, artifactPath, publisherAccessControlRoles, api.getAccessControl(), (Map<String, String>)api.getAdditionalProperties());
            RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, artifactPath, registry);
            if (api.getSwaggerDefinition() != null) {
                String resourcePath = RegistryPersistenceUtil.getOpenAPIDefinitionFilePath(api.getId().getName(), api.getId().getVersion(), api.getId().getProviderName());
                Resource resource = !registry.resourceExists(resourcePath = resourcePath + "swagger.json") ? registry.newResource() : registry.get(resourcePath);
                resource.setContent((Object)api.getSwaggerDefinition());
                resource.setMediaType("application/json");
                registry.put(resourcePath, resource);
                RegistryPersistenceUtil.clearResourcePermissions(resourcePath, (Identifier)api.getId(), ((UserRegistry)registry).getTenantId());
                RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, resourcePath);
            }
            String docLocation = RegistryPersistenceDocUtil.getDocumentPath(api.getId().getProviderName(), api.getId().getApiName(), api.getId().getVersion());
            RegistryPersistenceUtil.clearResourcePermissions(docLocation, (Identifier)api.getId(), ((UserRegistry)registry).getTenantId());
            RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, docLocation);
            registry.commitTransaction();
            api.setUuid(artifact.getId());
            transactionCommitted = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("API details successfully added to the registry. API Name: " + api.getId().getApiName() + ", API Version : " + api.getId().getVersion() + ", API context : " + api.getContext()));
            }
            api.setCreatedTime(String.valueOf(new Date().getTime()));
            PublisherAPI returnAPI = APIMapper.INSTANCE.toPublisherApi(api);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created API :" + returnAPI.toString()));
            }
            PublisherAPI publisherAPI2 = returnAPI;
            return publisherAPI2;
        }
        catch (RegistryException e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API: " + api.getId().getApiName()), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation", e);
        }
        catch (APIManagementException e) {
            throw new APIPersistenceException("Error while creating API", e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
            try {
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error while rolling back the transaction for API: " + api.getId().getApiName(), ex);
            }
        }
    }

    @Override
    public String addAPIRevision(Organization org, String apiUUID, int revisionId) throws APIPersistenceException {
        String revisionUUID;
        block17: {
            boolean transactionCommitted = false;
            Registry registry = null;
            boolean tenantFlowStarted = false;
            try {
                RegistryHolder holder = this.getRegistry(org.getName());
                registry = holder.getRegistry();
                tenantFlowStarted = holder.isTenantFlowStarted();
                registry.beginTransaction();
                GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
                GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiUUID);
                if (apiArtifact != null) {
                    API api = RegistryPersistenceUtil.getApiForPublishing(registry, (GovernanceArtifact)apiArtifact);
                    APIIdentifier apiId = api.getId();
                    String apiPath = RegistryPersistenceUtil.getAPIPath(apiId);
                    int prependIndex = apiPath.lastIndexOf("/api");
                    String apiSourcePath = apiPath.substring(0, prependIndex);
                    String revisionTargetPath = RegistryPersistenceUtil.getRevisionPath(apiId.getUUID(), revisionId);
                    if (registry.resourceExists(revisionTargetPath)) {
                        throw new APIManagementException("API revision already exists with id: " + revisionId, ExceptionCodes.from((ErrorHandler)ExceptionCodes.EXISTING_API_REVISION_FOUND, (String[])new String[]{String.valueOf(revisionId)}));
                    }
                    registry.copy(apiSourcePath, revisionTargetPath);
                    Resource apiRevisionArtifact = registry.get(revisionTargetPath + "api");
                    registry.commitTransaction();
                    transactionCommitted = true;
                    if (log.isDebugEnabled()) {
                        String logMessage = "Revision for API Name: " + apiId.getApiName() + ", API Version " + apiId.getVersion() + " created";
                        log.debug((Object)logMessage);
                    }
                    revisionUUID = apiRevisionArtifact.getUUID();
                    break block17;
                }
                String msg = "Failed to get API. API artifact corresponding to artifactId " + apiUUID + " does not exist";
                throw new APIMgtResourceNotFoundException(msg);
            }
            catch (RegistryException e) {
                try {
                    registry.rollbackTransaction();
                }
                catch (RegistryException re) {
                    log.error((Object)("Error while rolling back the transaction for API Revision create for API: " + apiUUID), (Throwable)re);
                }
                throw new APIPersistenceException("Error while performing registry transaction operation", e);
            }
            catch (APIManagementException e) {
                throw new APIPersistenceException("Error while creating API Revision", e);
            }
            finally {
                try {
                    if (tenantFlowStarted) {
                        RegistryPersistenceUtil.endTenantFlow();
                    }
                    if (!transactionCommitted) {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException ex) {
                    throw new APIPersistenceException("Error while rolling back the transaction for API Revision create for API: " + apiUUID, ex);
                }
            }
        }
        return revisionUUID;
    }

    @Override
    public void restoreAPIRevision(Organization org, String apiUUID, int revisionId) throws APIPersistenceException {
        boolean transactionCommitted = false;
        Registry registry = null;
        boolean tenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiUUID);
            String lcState = ((GenericArtifactImpl)apiArtifact).getLcState();
            if (apiArtifact != null) {
                String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiUUID);
                int prependIndex = apiPath.lastIndexOf("/api");
                String apiSourcePath = apiPath.substring(0, prependIndex);
                String revisionTargetPath = RegistryPersistenceUtil.getRevisionPath(apiUUID, revisionId);
                registry.delete(apiSourcePath);
                registry.copy(revisionTargetPath, apiSourcePath);
                Resource newAPIArtifact = registry.get(apiPath);
                newAPIArtifact.setUUID(apiUUID);
                newAPIArtifact.setProperty("registry.lifecycle.APILifeCycle.state", Arrays.asList(lcState));
                registry.put(apiPath, newAPIArtifact);
            }
            registry.commitTransaction();
            transactionCommitted = true;
            if (log.isDebugEnabled()) {
                String logMessage = "Revision ID" + revisionId + " for API UUID: " + apiUUID + " restored";
                log.debug((Object)logMessage);
            }
        }
        catch (RegistryException e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API Revision restore for API: " + apiUUID), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation", e);
        }
        finally {
            try {
                if (tenantFlowStarted) {
                    RegistryPersistenceUtil.endTenantFlow();
                }
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error while rolling back the transaction for API Revision restore for API: " + apiUUID, ex);
            }
        }
    }

    @Override
    public void deleteAPIRevision(Organization org, String apiUUID, int revisionId) throws APIPersistenceException {
        String revisionTargetPath = "/apimgt/applicationdata/apis/" + apiUUID + "/" + revisionId;
        boolean transactionCommitted = false;
        Registry registry = null;
        boolean tenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            registry.delete(revisionTargetPath);
            registry.commitTransaction();
            transactionCommitted = true;
            if (log.isDebugEnabled()) {
                String logMessage = "Revision ID:" + revisionId + " for API : " + apiUUID + " deleted";
                log.debug((Object)logMessage);
            }
        }
        catch (RegistryException e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API Revision delete for API: " + apiUUID), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation", e);
        }
        finally {
            try {
                if (tenantFlowStarted) {
                    RegistryPersistenceUtil.endTenantFlow();
                }
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error while rolling back the transaction for API Revision delete for API: " + apiUUID, ex);
            }
        }
    }

    @Override
    public PublisherAPI updateAPI(Organization org, PublisherAPI publisherAPI) throws APIPersistenceException {
        API api = APIMapper.INSTANCE.toApi(publisherAPI);
        boolean transactionCommitted = false;
        boolean tenantFlowStarted = false;
        Registry registry = null;
        try {
            Resource resource;
            Set tagSet;
            GenericArtifact updateApiArtifact;
            String artifactPath;
            Tag[] oldTags;
            RegistryHolder holder = this.getRegistry(org.getName());
            registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            String apiArtifactId = registry.get(RegistryPersistenceUtil.getAPIPath(api.getId())).getUUID();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Artifact manager is null when updating API artifact ID " + api.getId();
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifact artifact = this.getAPIArtifact(apiArtifactId, registry);
            boolean isSecured = Boolean.parseBoolean(artifact.getAttribute("overview_endpointSecured"));
            boolean isDigestSecured = Boolean.parseBoolean(artifact.getAttribute("overview_endpointAuthDigest"));
            String userName = artifact.getAttribute("overview_endpointUsername");
            String password = artifact.getAttribute("overview_endpointPpassword");
            if (!isSecured && !isDigestSecured && userName != null) {
                api.setEndpointUTUsername(userName);
                api.setEndpointUTPassword(password);
            }
            String oldStatus = artifact.getAttribute("overview_status");
            Resource apiResource = registry.get(artifact.getPath());
            String oldAccessControlRoles = api.getAccessControlRoles();
            if (apiResource != null) {
                oldAccessControlRoles = registry.get(artifact.getPath()).getProperty("publisher_roles");
            }
            if ((oldTags = registry.getTags(artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)(updateApiArtifact = RegistryPersistenceUtil.createAPIArtifactContent(artifact, api)).getId()))) != null) {
                for (Tag tag : oldTags) {
                    registry.removeTag(artifactPath, tag.getTagName());
                }
            }
            if ((tagSet = api.getTags()) != null) {
                for (String tag : tagSet) {
                    registry.applyTag(artifactPath, tag);
                }
            }
            artifactManager.updateGenericArtifact(updateApiArtifact);
            String[] visibleRoles = new String[]{};
            String publisherAccessControlRoles = api.getAccessControlRoles();
            this.updateRegistryResources(registry, artifactPath, publisherAccessControlRoles, api.getAccessControl(), (Map<String, String>)api.getAdditionalProperties());
            String newStatus = updateApiArtifact.getAttribute("overview_status");
            if (!StringUtils.equals((CharSequence)oldStatus, (CharSequence)newStatus) || !StringUtils.equals((CharSequence)oldAccessControlRoles, (CharSequence)publisherAccessControlRoles)) {
                RegistryPersistenceUtil.notifyAPIStateChangeToAssociatedDocuments(artifact, registry);
            }
            RegistryPersistenceUtil.clearResourcePermissions(artifactPath, (Identifier)api.getId(), ((UserRegistry)registry).getTenantId());
            String visibleRolesList = api.getVisibleRoles();
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, artifactPath, registry);
            List attachedApiCategories = api.getApiCategories();
            artifact.removeAttribute("apiCategories_categoryName");
            if (attachedApiCategories != null) {
                for (APICategory category : attachedApiCategories) {
                    artifact.addAttribute("apiCategories_categoryName", category.getName());
                }
            }
            if (api.getSwaggerDefinition() != null) {
                String resourcePath = RegistryPersistenceUtil.getOpenAPIDefinitionFilePath(api.getId().getName(), api.getId().getVersion(), api.getId().getProviderName());
                Resource resource2 = !registry.resourceExists(resourcePath = resourcePath + "swagger.json") ? registry.newResource() : registry.get(resourcePath);
                resource2.setContent((Object)api.getSwaggerDefinition());
                resource2.setMediaType("application/json");
                registry.put(resourcePath, resource2);
                RegistryPersistenceUtil.clearResourcePermissions(resourcePath, (Identifier)api.getId(), ((UserRegistry)registry).getTenantId());
                RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, resourcePath);
            }
            String apiOrAPIProductDocPath = RegistryPersistenceDocUtil.getDocumentPath(api.getId().getProviderName(), api.getId().getApiName(), api.getId().getVersion());
            String pathToContent = apiOrAPIProductDocPath + "contents";
            String pathToDocFile = apiOrAPIProductDocPath + "files";
            if (registry.resourceExists(apiOrAPIProductDocPath) && (resource = registry.get(apiOrAPIProductDocPath)) instanceof Collection) {
                String[] docsPaths;
                for (String docPath : docsPaths = ((Collection)resource).getChildren()) {
                    if (docPath.equalsIgnoreCase(pathToContent) || docPath.equalsIgnoreCase(pathToDocFile)) continue;
                    Resource docResource = registry.get(docPath);
                    GenericArtifactManager docArtifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registry);
                    GenericArtifact docArtifact = docArtifactManager.getGenericArtifact(docResource.getUUID());
                    Documentation doc = RegistryPersistenceDocUtil.getDocumentation(docArtifact);
                    if (!"API_LEVEL".equalsIgnoreCase(doc.getVisibility().name())) continue;
                    String documentationPath = RegistryPersistenceDocUtil.getAPIDocPath(api.getId()) + doc.getName();
                    RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, documentationPath, registry);
                    if (DocumentationInfo.DocumentSourceType.INLINE.equals((Object)doc.getSourceType()) || DocumentationInfo.DocumentSourceType.MARKDOWN.equals((Object)doc.getSourceType())) {
                        String contentPath = RegistryPersistenceDocUtil.getAPIDocPath(api.getId()) + "contents" + "/" + doc.getName();
                        RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, contentPath, registry);
                        continue;
                    }
                    if (!DocumentationInfo.DocumentSourceType.FILE.equals((Object)doc.getSourceType()) || doc.getFilePath() == null) continue;
                    String filePath = RegistryPersistenceDocUtil.getDocumentationFilePath((Identifier)api.getId(), doc.getFilePath().split("files/")[1]);
                    RegistryPersistenceUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, filePath, registry);
                }
            }
            this.setSoapToRestSequences(publisherAPI, registry);
            registry.commitTransaction();
            transactionCommitted = true;
            PublisherAPI publisherAPI2 = APIMapper.INSTANCE.toPublisherApi(api);
            return publisherAPI2;
        }
        catch (Exception e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API: " + api.getId().getApiName()), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation ", e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
            try {
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error occurred while rolling back the transaction. ", ex);
            }
        }
    }

    @Override
    public PublisherAPI getPublisherAPI(Organization org, String apiId) throws APIPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String msg;
            RegistryHolder holder = this.getRegistry(org.getName());
            tenantFlowStarted = holder.isTenantFlowStarted();
            Registry registry = holder.getRegistry();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registry);
            if (apiArtifact != null) {
                int prependIndex;
                API api = RegistryPersistenceUtil.getApiForPublishing(registry, (GovernanceArtifact)apiArtifact);
                String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
                String apiSourcePath = apiPath.substring(0, prependIndex = apiPath.lastIndexOf("/api"));
                String definitionPath = apiSourcePath + "/" + "swagger.json";
                if (registry.resourceExists(definitionPath)) {
                    Resource apiDocResource = registry.get(definitionPath);
                    String apiDocContent = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                    api.setSwaggerDefinition(apiDocContent);
                }
                if ("SOAPTOREST".equals(api.getType())) {
                    List<SOAPToRestSequence> list = this.getSoapToRestSequences(registry, api, SOAPToRestSequence.Direction.IN);
                    list.addAll(this.getSoapToRestSequences(registry, api, SOAPToRestSequence.Direction.OUT));
                    api.setSoapToRestSequences(list);
                }
                PublisherAPI pubApi = APIMapper.INSTANCE.toPublisherApi(api);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API for id " + apiId + " : " + pubApi.toString()));
                }
                PublisherAPI publisherAPI = pubApi;
                return publisherAPI;
            }
            try {
                String msg2 = "Failed to get API. API artifact corresponding to artifactId " + apiId + " does not exist";
                throw new APIMgtResourceNotFoundException(msg2);
            }
            catch (RegistryException e) {
                msg = "Failed to get API";
                throw new APIPersistenceException(msg, e);
            }
            catch (APIManagementException e) {
                msg = "Failed to get API";
                throw new APIPersistenceException(msg, e);
            }
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public DevPortalAPI getDevPortalAPI(Organization org, String apiId) throws APIPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registry);
            if (apiArtifact != null) {
                DevPortalAPI devPortalAPI;
                API api = RegistryPersistenceUtil.getApiForPublishing(registry, (GovernanceArtifact)apiArtifact);
                String definitionPath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(api.getId().getProviderName()) + "/" + api.getId().getName() + "/" + api.getId().getVersion() + "/" + "swagger.json";
                if (registry.resourceExists(definitionPath)) {
                    Resource apiDocResource = registry.get(definitionPath);
                    String apiDocContent = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                    api.setSwaggerDefinition(apiDocContent);
                }
                String apiTenantDomain = MultitenantUtils.getTenantDomain((String)RegistryPersistenceUtil.replaceEmailDomainBack(api.getId().getProviderName()));
                if ("public".equals(api.getVisibility())) {
                    devPortalAPI = APIMapper.INSTANCE.toDevPortalApi(api);
                    return devPortalAPI;
                }
                if (tenantDomain == null || !tenantDomain.equals(apiTenantDomain)) {
                    throw new APIPersistenceException("User does not have permission to view API : " + api.getId().getApiName());
                }
                devPortalAPI = APIMapper.INSTANCE.toDevPortalApi(api);
                return devPortalAPI;
            }
            DevPortalAPI devPortalAPI = null;
            return devPortalAPI;
        }
        catch (APIManagementException | RegistryException e) {
            String msg = "Failed to get API";
            throw new APIPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public void deleteAPI(Organization org, String apiId) throws APIPersistenceException {
        boolean transactionCommitted = false;
        boolean tenantFlowStarted = false;
        Registry registry = null;
        try {
            Resource providerCollection;
            CollectionImpl collection;
            String apiProviderPath;
            Resource apiCollection;
            CollectionImpl collection2;
            String apiCollectionPath;
            String apiDefinitionFilePath;
            String wsdlArchivePath;
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)registry));
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Failed to retrieve artifact manager when deleting API " + apiId;
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiId);
            APIIdentifier identifier = new APIIdentifier(apiArtifact.getAttribute("overview_provider"), apiArtifact.getAttribute("overview_name"), apiArtifact.getAttribute("overview_version"));
            GovernanceArtifact[] dependenciesArray = apiArtifact.getDependencies();
            if (dependenciesArray.length > 0) {
                for (GovernanceArtifact artifact : dependenciesArray) {
                    registry.delete(artifact.getPath());
                }
            }
            artifactManager.removeGenericArtifact(apiArtifact);
            String path = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
            Resource apiResource = registry.get(path);
            String artifactId = apiResource.getUUID();
            artifactManager.removeGenericArtifact(artifactId);
            String thumbPath = RegistryPersistenceUtil.getIconPath((Identifier)identifier);
            if (registry.resourceExists(thumbPath)) {
                registry.delete(thumbPath);
            }
            if (registry.resourceExists(wsdlArchivePath = RegistryPersistenceUtil.getWsdlArchivePath(identifier))) {
                registry.delete(wsdlArchivePath);
            }
            if (registry.resourceExists(apiDefinitionFilePath = "/apimgt/applicationdata/api-docs/" + identifier.getApiName() + '-' + identifier.getVersion() + '-' + identifier.getProviderName())) {
                registry.delete(apiDefinitionFilePath);
            }
            if (registry.resourceExists(apiCollectionPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName()) && (collection2 = (CollectionImpl)(apiCollection = registry.get(apiCollectionPath))).getChildCount() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No more versions of the API found, removing API collection from registry");
                }
                registry.delete(apiCollectionPath);
            }
            if (registry.resourceExists(apiProviderPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName()) && (collection = (CollectionImpl)(providerCollection = registry.get(apiProviderPath))).getChildCount() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No more APIs from the provider " + identifier.getProviderName() + " found. Removing provider collection from registry"));
                }
                registry.delete(apiProviderPath);
            }
            registry.commitTransaction();
            transactionCommitted = true;
        }
        catch (RegistryException e) {
            throw new APIPersistenceException("Failed to remove the API : " + apiId, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
            try {
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error occurred while rolling back the transaction. ", ex);
            }
        }
    }

    @Override
    public PublisherAPISearchResult searchAPIsForPublisher(Organization org, String searchQuery, int start, int offset, UserContext ctx) throws APIPersistenceException {
        String requestedTenantDomain = org.getName();
        boolean isTenantFlowStarted = false;
        PublisherAPISearchResult result = null;
        try {
            RegistryHolder holder = this.getRegistry(requestedTenantDomain);
            Registry sysRegistry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            int tenantIDLocal = holder.getTenantId();
            log.debug((Object)("Requested query for publisher search: " + searchQuery));
            String modifiedQuery = RegistrySearchUtil.getPublisherSearchQuery(searchQuery, ctx);
            log.debug((Object)("Modified query for publisher search: " + modifiedQuery));
            String tenantAdminUsername = this.getTenantAwareUsername(RegistryPersistenceUtil.getTenantAdminUserName(requestedTenantDomain));
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(tenantAdminUsername);
            result = searchQuery != null && searchQuery.startsWith("doc") ? this.searchPaginatedPublisherAPIsByDoc(sysRegistry, tenantIDLocal, searchQuery.split(":")[1], tenantAdminUsername, start, offset) : this.searchPaginatedPublisherAPIs(sysRegistry, tenantIDLocal, modifiedQuery, start, offset);
        }
        catch (APIManagementException e) {
            throw new APIPersistenceException("Error while searching APIs ", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    private PublisherAPISearchResult searchPaginatedPublisherAPIs(Registry userRegistry, int tenantIDLocal, String searchQuery, int start, int offset) throws APIManagementException {
        int totalLength = 0;
        PublisherAPISearchResult searchResults = new PublisherAPISearchResult();
        try {
            int maxPaginationLimit = this.getMaxPaginationLimit();
            PaginationContext.init((int)start, (int)offset, (String)"ASC", (String)"overview_name", (int)maxPaginationLimit);
            List governanceArtifacts = GovernanceUtils.findGovernanceArtifacts((String)searchQuery, (Registry)userRegistry, (String)"application/vnd.wso2-api+xml", (boolean)true);
            totalLength = PaginationContext.getInstance().getLength();
            boolean isFound = true;
            if (governanceArtifacts == null || governanceArtifacts.size() == 0) {
                if (searchQuery.contains("overview_provider")) {
                    governanceArtifacts = GovernanceUtils.findGovernanceArtifacts((String)(searchQuery = searchQuery.replaceAll("overview_provider", "overview_apiOwner")), (Registry)userRegistry, (String)"application/vnd.wso2-api+xml", (boolean)true);
                    if (governanceArtifacts == null || governanceArtifacts.size() == 0) {
                        isFound = false;
                    }
                } else {
                    isFound = false;
                }
            }
            if (!isFound) {
                PublisherAPISearchResult publisherAPISearchResult = searchResults;
                return publisherAPISearchResult;
            }
            if (maxPaginationLimit == totalLength) {
                --totalLength;
            }
            ArrayList<PublisherAPIInfo> publisherAPIInfoList = new ArrayList<PublisherAPIInfo>();
            int tempLength = 0;
            for (GovernanceArtifact artifact : governanceArtifacts) {
                PublisherAPIInfo apiInfo = new PublisherAPIInfo();
                String artifactPath = GovernanceUtils.getArtifactPath((Registry)userRegistry, (String)artifact.getId());
                Resource apiResource = userRegistry.get(artifactPath);
                apiInfo.setType(artifact.getAttribute("overview_type"));
                apiInfo.setId(artifact.getId());
                apiInfo.setApiName(artifact.getAttribute("overview_name"));
                apiInfo.setContext(artifact.getAttribute("overview_contextTemplate"));
                apiInfo.setProviderName(artifact.getAttribute("overview_provider"));
                apiInfo.setStatus(artifact.getAttribute("overview_status"));
                apiInfo.setThumbnail(artifact.getAttribute("overview_thumbnail"));
                apiInfo.setVersion(artifact.getAttribute("overview_version"));
                apiInfo.setCreatedTime(String.valueOf(apiResource.getCreatedTime().getTime()));
                apiInfo.setUpdatedTime(apiResource.getLastModified());
                publisherAPIInfoList.add(apiInfo);
                if (++tempLength < totalLength) continue;
                break;
            }
            searchResults.setPublisherAPIInfoList(publisherAPIInfoList);
            searchResults.setReturnedAPIsCount(publisherAPIInfoList.size());
            searchResults.setTotalAPIsCount(totalLength);
        }
        catch (RegistryException e) {
            String msg = "Failed to search APIs with type";
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            PaginationContext.destroy();
        }
        return searchResults;
    }

    @Override
    public DevPortalAPISearchResult searchAPIsForDevPortal(Organization org, String searchQuery, int start, int offset, UserContext ctx) throws APIPersistenceException {
        String requestedTenantDomain = org.getName();
        boolean isTenantFlowStarted = false;
        DevPortalAPISearchResult result = null;
        try {
            RegistryHolder holder = this.getRegistry(ctx.getUserame(), requestedTenantDomain);
            Registry userRegistry = holder.getRegistry();
            int tenantIDLocal = holder.getTenantId();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            log.debug((Object)("Requested query for devportal search: " + searchQuery));
            String modifiedQuery = RegistrySearchUtil.getDevPortalSearchQuery(searchQuery, ctx, this.isAllowDisplayAPIsWithMultipleStatus());
            log.debug((Object)("Modified query for devportal search: " + modifiedQuery));
            String userNameLocal = holder.isAnonymousMode() ? "wso2.anonymous.user" : this.getTenantAwareUsername(ctx.getUserame());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(userNameLocal);
            result = searchQuery != null && searchQuery.startsWith("doc") ? this.searchPaginatedDevPortalAPIsByDoc(userRegistry, tenantIDLocal, searchQuery.split(":")[1], userNameLocal, start, offset) : this.searchPaginatedDevPortalAPIs(userRegistry, tenantIDLocal, modifiedQuery, start, offset);
        }
        catch (APIManagementException e) {
            throw new APIPersistenceException("Error while searching APIs ", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    private DevPortalAPISearchResult searchPaginatedDevPortalAPIs(Registry userRegistry, int tenantIDLocal, String searchQuery, int start, int offset) throws APIManagementException {
        int totalLength = 0;
        DevPortalAPISearchResult searchResults = new DevPortalAPISearchResult();
        try {
            int maxPaginationLimit = this.getMaxPaginationLimit();
            PaginationContext.init((int)start, (int)offset, (String)"ASC", (String)"overview_name", (int)maxPaginationLimit);
            log.debug((Object)("Dev portal list apis query " + searchQuery));
            List governanceArtifacts = GovernanceUtils.findGovernanceArtifacts((String)searchQuery, (Registry)userRegistry, (String)"application/vnd.wso2-api+xml", (boolean)true);
            totalLength = PaginationContext.getInstance().getLength();
            boolean isFound = true;
            if (governanceArtifacts == null || governanceArtifacts.size() == 0) {
                if (searchQuery.contains("overview_provider")) {
                    governanceArtifacts = GovernanceUtils.findGovernanceArtifacts((String)(searchQuery = searchQuery.replaceAll("overview_provider", "overview_apiOwner")), (Registry)userRegistry, (String)"application/vnd.wso2-api+xml", (boolean)true);
                    if (governanceArtifacts == null || governanceArtifacts.size() == 0) {
                        isFound = false;
                    }
                } else {
                    isFound = false;
                }
            }
            if (!isFound) {
                DevPortalAPISearchResult devPortalAPISearchResult = searchResults;
                return devPortalAPISearchResult;
            }
            if (maxPaginationLimit == totalLength) {
                --totalLength;
            }
            ArrayList<DevPortalAPIInfo> devPortalAPIInfoList = new ArrayList<DevPortalAPIInfo>();
            int tempLength = 0;
            for (GovernanceArtifact artifact : governanceArtifacts) {
                DevPortalAPIInfo apiInfo = new DevPortalAPIInfo();
                apiInfo.setType(artifact.getAttribute("overview_type"));
                apiInfo.setId(artifact.getId());
                apiInfo.setApiName(artifact.getAttribute("overview_name"));
                apiInfo.setContext(artifact.getAttribute("overview_contextTemplate"));
                apiInfo.setProviderName(artifact.getAttribute("overview_provider"));
                apiInfo.setStatus(artifact.getAttribute("overview_status"));
                apiInfo.setThumbnail(artifact.getAttribute("overview_thumbnail"));
                apiInfo.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
                apiInfo.setVersion(artifact.getAttribute("overview_version"));
                String tiers = artifact.getAttribute("overview_tier");
                HashSet<String> availableTiers = new HashSet<String>();
                if (tiers != null) {
                    String[] tiersArray;
                    for (String tierName : tiersArray = tiers.split("\\|\\|")) {
                        availableTiers.add(tierName);
                    }
                }
                apiInfo.setAvailableTierNames(availableTiers);
                apiInfo.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
                apiInfo.setSubscriptionAvailableOrgs(artifact.getAttribute("overview_tenants"));
                devPortalAPIInfoList.add(apiInfo);
                if (++tempLength < totalLength) continue;
                break;
            }
            searchResults.setDevPortalAPIInfoList(devPortalAPIInfoList);
            searchResults.setReturnedAPIsCount(devPortalAPIInfoList.size());
            searchResults.setTotalAPIsCount(totalLength);
        }
        catch (RegistryException e) {
            String msg = "Failed to search APIs with type";
            throw new APIManagementException(msg, (Throwable)e);
        }
        finally {
            PaginationContext.destroy();
        }
        return searchResults;
    }

    private DevPortalAPISearchResult searchPaginatedDevPortalAPIsByDoc(Registry registry, int tenantID, String searchQuery, String username, int start, int offset) throws APIPersistenceException {
        DevPortalAPISearchResult searchResults = new DevPortalAPISearchResult();
        try {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(username);
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Artifact manager is null when searching APIs by docs in tenant ID " + tenantID;
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifactManager docArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "document");
            if (docArtifactManager == null) {
                String errorMessage = "Doc artifact manager is null when searching APIs by docs in tenant ID " + tenantID;
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            SolrClient client = SolrClient.getInstance();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("path", "*/apimgt/applicationdata/provider*");
            fields.put("mediaType", "*");
            if (tenantID == -1) {
                tenantID = -1234;
            }
            SolrDocumentList documentList = client.query(searchQuery, tenantID, fields);
            AuthorizationManager manager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            ArrayList<DevPortalAPIInfo> devPortalAPIInfoList = new ArrayList<DevPortalAPIInfo>();
            for (SolrDocument document : documentList) {
                DevPortalAPIInfo apiInfo = new DevPortalAPIInfo();
                String filePath = (String)document.getFieldValue("path_s");
                String fileName = (String)document.getFieldValue("resourceName_s");
                int index = filePath.indexOf("/apimgt");
                filePath = filePath.substring(index);
                int indexOfContents = filePath.indexOf("contents");
                String documentationPath = filePath.substring(0, indexOfContents) + fileName;
                String path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + documentationPath));
                boolean isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                if (!isAuthorized) continue;
                int indexOfDocumentation = filePath.indexOf("document");
                String apiPath = documentationPath.substring(0, indexOfDocumentation) + "api";
                path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + apiPath));
                isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                if (!isAuthorized) continue;
                Resource resource = registry.get(apiPath);
                String apiArtifactId = resource.getUUID();
                if (apiArtifactId != null) {
                    GenericArtifact artifact = artifactManager.getGenericArtifact(apiArtifactId);
                    String status = artifact.getAttribute("overview_status");
                    if (!"PUBLISHED".equals(status) && !"PROTOTYPED".equals(status)) continue;
                    apiInfo.setType(artifact.getAttribute("overview_type"));
                    apiInfo.setId(artifact.getId());
                    apiInfo.setApiName(artifact.getAttribute("overview_name"));
                    apiInfo.setContext(artifact.getAttribute("overview_contextTemplate"));
                    apiInfo.setProviderName(artifact.getAttribute("overview_provider"));
                    apiInfo.setStatus(status);
                    apiInfo.setThumbnail(artifact.getAttribute("overview_thumbnail"));
                    apiInfo.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
                    apiInfo.setVersion(artifact.getAttribute("overview_version"));
                    apiInfo.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
                    apiInfo.setSubscriptionAvailableOrgs(artifact.getAttribute("overview_tenants"));
                    devPortalAPIInfoList.add(apiInfo);
                    continue;
                }
                throw new GovernanceException("artifact id is null of " + apiPath);
            }
            searchResults.setDevPortalAPIInfoList(devPortalAPIInfoList);
            searchResults.setTotalAPIsCount(devPortalAPIInfoList.size());
            searchResults.setReturnedAPIsCount(devPortalAPIInfoList.size());
        }
        catch (APIPersistenceException | RegistryException | IndexerException | UserStoreException e) {
            String msg = "Failed to search APIs with type";
            throw new APIPersistenceException(msg, e);
        }
        finally {
            PaginationContext.destroy();
        }
        return searchResults;
    }

    private PublisherAPISearchResult searchPaginatedPublisherAPIsByDoc(Registry registry, int tenantID, String searchQuery, String username, int start, int offset) throws APIPersistenceException {
        PublisherAPISearchResult searchResults = new PublisherAPISearchResult();
        try {
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Artifact manager is null when searching APIs by docs in tenant ID " + tenantID;
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            GenericArtifactManager docArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "document");
            if (docArtifactManager == null) {
                String errorMessage = "Doc artifact manager is null when searching APIs by docs in tenant ID " + tenantID;
                log.error((Object)errorMessage);
                throw new APIPersistenceException(errorMessage);
            }
            SolrClient client = SolrClient.getInstance();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("path", "*/apimgt/applicationdata/provider*");
            fields.put("mediaType", "*");
            if (tenantID == -1) {
                tenantID = -1234;
            }
            SolrDocumentList documentList = client.query(searchQuery, tenantID, fields);
            AuthorizationManager manager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            ArrayList<PublisherAPIInfo> publisherAPIInfoList = new ArrayList<PublisherAPIInfo>();
            for (SolrDocument document : documentList) {
                PublisherAPIInfo apiInfo = new PublisherAPIInfo();
                String filePath = (String)document.getFieldValue("path_s");
                String fileName = (String)document.getFieldValue("resourceName_s");
                int index = filePath.indexOf("/apimgt");
                filePath = filePath.substring(index);
                int indexOfContents = filePath.indexOf("contents");
                String documentationPath = filePath.substring(0, indexOfContents) + fileName;
                String path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + documentationPath));
                boolean isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                if (!isAuthorized) continue;
                int indexOfDocumentation = filePath.indexOf("document");
                String apiPath = documentationPath.substring(0, indexOfDocumentation) + "api";
                path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(RegistryPersistenceUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + apiPath));
                isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                if (!isAuthorized) continue;
                Resource resource = registry.get(apiPath);
                String apiArtifactId = resource.getUUID();
                if (apiArtifactId != null) {
                    GenericArtifact artifact = artifactManager.getGenericArtifact(apiArtifactId);
                    String status = artifact.getAttribute("overview_status");
                    if (!"PUBLISHED".equals(status) && !"PROTOTYPED".equals(status)) continue;
                    apiInfo.setType(artifact.getAttribute("overview_type"));
                    apiInfo.setId(artifact.getId());
                    apiInfo.setApiName(artifact.getAttribute("overview_name"));
                    apiInfo.setContext(artifact.getAttribute("overview_contextTemplate"));
                    apiInfo.setProviderName(artifact.getAttribute("overview_provider"));
                    apiInfo.setStatus(status);
                    apiInfo.setThumbnail(artifact.getAttribute("overview_thumbnail"));
                    apiInfo.setCreatedTime(String.valueOf(resource.getCreatedTime().getTime()));
                    apiInfo.setUpdatedTime(resource.getLastModified());
                    apiInfo.setVersion(artifact.getAttribute("overview_version"));
                    publisherAPIInfoList.add(apiInfo);
                    continue;
                }
                throw new GovernanceException("artifact id is null of " + apiPath);
            }
            searchResults.setPublisherAPIInfoList(publisherAPIInfoList);
            searchResults.setTotalAPIsCount(publisherAPIInfoList.size());
            searchResults.setReturnedAPIsCount(publisherAPIInfoList.size());
        }
        catch (APIPersistenceException | RegistryException | IndexerException | UserStoreException e) {
            String msg = "Failed to search APIs with type";
            throw new APIPersistenceException(msg, e);
        }
        finally {
            PaginationContext.destroy();
        }
        return searchResults;
    }

    private boolean isAllowDisplayAPIsWithMultipleStatus() {
        if (this.properties != null) {
            return (Boolean)this.properties.get("allowMultipleStatus");
        }
        return false;
    }

    @Override
    public PublisherContentSearchResult searchContentForPublisher(Organization org, String searchQuery, int start, int offset, UserContext ctx) throws APIPersistenceException {
        log.debug((Object)("Requested query for publisher content search: " + searchQuery));
        Map<String, String> attributes = RegistrySearchUtil.getPublisherSearchAttributes(searchQuery, ctx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Search attributes : " + attributes));
        }
        boolean isTenantFlowStarted = false;
        PublisherContentSearchResult result = null;
        try {
            UserRegistry systemUserRegistry;
            ContentBasedSearchService contentBasedSearchService;
            SearchResultsBean resultsBean;
            String errorMsg;
            RegistryHolder holder = this.getRegistry(org.getName());
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            String requestedTenantDomain = org.getName();
            String tenantAwareUsername = this.getTenantAwareUsername(RegistryPersistenceUtil.getTenantAdminUserName(requestedTenantDomain));
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(tenantAwareUsername);
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifactManager docArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "document");
            int maxPaginationLimit = this.getMaxPaginationLimit();
            PaginationContext.init((int)start, (int)offset, (String)"ASC", (String)"overview_name", (int)maxPaginationLimit);
            int tenantId = holder.getTenantId();
            if (tenantId == -1) {
                tenantId = -1234;
            }
            if ((errorMsg = (resultsBean = (contentBasedSearchService = new ContentBasedSearchService()).searchByAttribute(attributes, systemUserRegistry = ServiceReferenceHolder.getInstance().getRegistryService().getRegistry("wso2.system.user", tenantId))).getErrorMessage()) != null) {
                throw new APIPersistenceException("Error while searching " + errorMsg);
            }
            ResourceData[] resourceData = resultsBean.getResourceDataList();
            int totalLength = PaginationContext.getInstance().getLength();
            if (resourceData != null) {
                result = new PublisherContentSearchResult();
                ArrayList<SearchContent> contentData = new ArrayList<SearchContent>();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of records Found: " + resourceData.length));
                }
                for (ResourceData data : resourceData) {
                    String resourcePath = data.getResourcePath();
                    if (!resourcePath.contains("/apimgt")) continue;
                    int index = resourcePath.indexOf("/apimgt");
                    Resource resource = registry.get(resourcePath = resourcePath.substring(index));
                    if ("application/vnd.wso2-document+xml".equals(resource.getMediaType()) || "text/plain".equals(resource.getMediaType())) {
                        if (resourcePath.contains("contents")) {
                            int indexOfContents = resourcePath.indexOf("contents");
                            resourcePath = resourcePath.substring(0, indexOfContents) + data.getName();
                        }
                        DocumentSearchContent docSearch = new DocumentSearchContent();
                        Resource docResource = registry.get(resourcePath);
                        String docArtifactId = docResource.getUUID();
                        GenericArtifact docArtifact = docArtifactManager.getGenericArtifact(docArtifactId);
                        Documentation doc = RegistryPersistenceDocUtil.getDocumentation(docArtifact);
                        int indexOfDocumentation = resourcePath.indexOf("document");
                        String apiPath = resourcePath.substring(0, indexOfDocumentation) + "api";
                        Resource apiResource = registry.get(apiPath);
                        String apiArtifactId = apiResource.getUUID();
                        if (apiArtifactId != null) {
                            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiArtifactId);
                            String accociatedType = apiArtifact.getAttribute("overview_type").equals("APIProduct") ? "APIProduct" : "API";
                            PublisherAPI pubAPI = RegistryPersistenceUtil.getAPIForSearch(apiArtifact);
                            docSearch.setApiName(pubAPI.getApiName());
                            docSearch.setApiProvider(pubAPI.getProviderName());
                            docSearch.setApiVersion(pubAPI.getVersion());
                            docSearch.setApiUUID(pubAPI.getId());
                            docSearch.setAssociatedType(accociatedType);
                            docSearch.setDocType(doc.getType());
                            docSearch.setId(doc.getId());
                            docSearch.setSourceType(doc.getSourceType());
                            docSearch.setVisibility(doc.getVisibility());
                            docSearch.setName(doc.getName());
                            contentData.add(docSearch);
                            continue;
                        }
                        throw new GovernanceException("artifact id is null of " + apiPath);
                    }
                    String apiArtifactId = resource.getUUID();
                    if (apiArtifactId != null) {
                        GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiArtifactId);
                        String type = apiArtifact.getAttribute("overview_type").equals("APIProduct") ? "APIProduct" : "API";
                        PublisherAPI pubAPI = RegistryPersistenceUtil.getAPIForSearch(apiArtifact);
                        PublisherSearchContent content = new PublisherSearchContent();
                        content.setContext(pubAPI.getContext());
                        content.setDescription(pubAPI.getDescription());
                        content.setId(pubAPI.getId());
                        content.setName(pubAPI.getApiName());
                        content.setProvider(RegistryPersistenceUtil.replaceEmailDomainBack(pubAPI.getProviderName()));
                        content.setType(type);
                        content.setVersion(pubAPI.getVersion());
                        content.setStatus(pubAPI.getStatus());
                        contentData.add(content);
                        continue;
                    }
                    throw new GovernanceException("artifact id is null for " + resourcePath);
                }
                result.setTotalCount(totalLength);
                result.setReturnedCount(contentData.size());
                result.setResults(contentData);
            }
        }
        catch (APIManagementException | DocumentationPersistenceException | RegistryException | IndexerException e) {
            throw new APIPersistenceException("Error while searching for content ", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    @Override
    public DevPortalContentSearchResult searchContentForDevPortal(Organization org, String searchQuery, int start, int offset, UserContext ctx) throws APIPersistenceException {
        log.debug((Object)("Requested query for devportal content search: " + searchQuery));
        Map<String, String> attributes = RegistrySearchUtil.getDevPortalSearchAttributes(searchQuery, ctx, this.isAllowDisplayAPIsWithMultipleStatus());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Search attributes : " + attributes));
        }
        DevPortalContentSearchResult result = null;
        boolean isTenantFlowStarted = false;
        try {
            UserRegistry systemUserRegistry;
            ContentBasedSearchService contentBasedSearchService;
            SearchResultsBean resultsBean;
            String errorMsg;
            RegistryHolder holder = this.getRegistry(ctx.getUserame(), org.getName());
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            String tenantAwareUsername = this.getTenantAwareUsername(ctx.getUserame());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(tenantAwareUsername);
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifactManager docArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "document");
            int maxPaginationLimit = this.getMaxPaginationLimit();
            PaginationContext.init((int)start, (int)offset, (String)"ASC", (String)"overview_name", (int)maxPaginationLimit);
            int tenantId = holder.getTenantId();
            if (tenantId == -1) {
                tenantId = -1234;
            }
            if ((errorMsg = (resultsBean = (contentBasedSearchService = new ContentBasedSearchService()).searchByAttribute(attributes, systemUserRegistry = ServiceReferenceHolder.getInstance().getRegistryService().getRegistry("wso2.system.user", tenantId))).getErrorMessage()) != null) {
                throw new APIPersistenceException("Error while searching " + errorMsg);
            }
            ResourceData[] resourceData = resultsBean.getResourceDataList();
            int totalLength = PaginationContext.getInstance().getLength();
            if (resourceData != null) {
                result = new DevPortalContentSearchResult();
                ArrayList<SearchContent> contentData = new ArrayList<SearchContent>();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of records Found: " + resourceData.length));
                }
                for (ResourceData data : resourceData) {
                    String resourcePath = data.getResourcePath();
                    if (!resourcePath.contains("/apimgt")) continue;
                    int index = resourcePath.indexOf("/apimgt");
                    Resource resource = registry.get(resourcePath = resourcePath.substring(index));
                    if ("application/vnd.wso2-document+xml".equals(resource.getMediaType()) || "text/plain".equals(resource.getMediaType())) {
                        if (resourcePath.contains("contents")) {
                            int indexOfContents = resourcePath.indexOf("contents");
                            resourcePath = resourcePath.substring(0, indexOfContents) + data.getName();
                        }
                        DocumentSearchContent docSearch = new DocumentSearchContent();
                        Resource docResource = registry.get(resourcePath);
                        String docArtifactId = docResource.getUUID();
                        GenericArtifact docArtifact = docArtifactManager.getGenericArtifact(docArtifactId);
                        Documentation doc = RegistryPersistenceDocUtil.getDocumentation(docArtifact);
                        int indexOfDocumentation = resourcePath.indexOf("document");
                        String apiPath = resourcePath.substring(0, indexOfDocumentation) + "api";
                        Resource apiResource = registry.get(apiPath);
                        String apiArtifactId = apiResource.getUUID();
                        if (apiArtifactId != null) {
                            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiArtifactId);
                            DevPortalAPI devAPI = RegistryPersistenceUtil.getDevPortalAPIForSearch(apiArtifact);
                            docSearch.setApiName(devAPI.getApiName());
                            docSearch.setApiProvider(devAPI.getProviderName());
                            docSearch.setApiVersion(devAPI.getVersion());
                            docSearch.setApiUUID(devAPI.getId());
                            docSearch.setDocType(doc.getType());
                            docSearch.setId(doc.getId());
                            docSearch.setSourceType(doc.getSourceType());
                            docSearch.setVisibility(doc.getVisibility());
                            docSearch.setName(doc.getName());
                            contentData.add(docSearch);
                            continue;
                        }
                        throw new GovernanceException("artifact id is null of " + apiPath);
                    }
                    String apiArtifactId = resource.getUUID();
                    if (apiArtifactId != null) {
                        GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiArtifactId);
                        DevPortalAPI devAPI = RegistryPersistenceUtil.getDevPortalAPIForSearch(apiArtifact);
                        DevPortalSearchContent content = new DevPortalSearchContent();
                        content.setContext(devAPI.getContext());
                        content.setDescription(devAPI.getDescription());
                        content.setId(devAPI.getId());
                        content.setName(devAPI.getApiName());
                        content.setProvider(RegistryPersistenceUtil.replaceEmailDomainBack(devAPI.getProviderName()));
                        content.setVersion(devAPI.getVersion());
                        content.setStatus(devAPI.getStatus());
                        content.setBusinessOwner(devAPI.getBusinessOwner());
                        content.setBusinessOwnerEmail(devAPI.getBusinessOwnerEmail());
                        contentData.add(content);
                        continue;
                    }
                    throw new GovernanceException("artifact id is null for " + resourcePath);
                }
                result.setTotalCount(totalLength);
                result.setReturnedCount(contentData.size());
                result.setResults(contentData);
            }
        }
        catch (DocumentationPersistenceException | RegistryException | IndexerException e) {
            throw new APIPersistenceException("Error while searching for content ", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    @Override
    public void changeAPILifeCycle(Organization org, String apiId, String status) throws APIPersistenceException {
        GenericArtifactManager artifactManager = null;
        boolean isTenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            if (GovernanceUtils.findGovernanceArtifactConfiguration((String)"api", (Registry)registry) != null) {
                artifactManager = new GenericArtifactManager(registry, "api");
                GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiId);
                String action = LCManagerFactory.getInstance().getLCManager().getTransitionAction(apiArtifact.getLifecycleState().toUpperCase(), status.toUpperCase());
                apiArtifact.invokeAction(action, "APILifeCycle");
            } else {
                log.warn((Object)("Couldn't find GovernanceArtifactConfiguration of RXT: api. Tenant id set in registry : " + ((UserRegistry)registry).getTenantId() + ", Tenant domain set in PrivilegedCarbonContext: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
            }
        }
        catch (GovernanceException e) {
            throw new APIPersistenceException("Error while changing the lifecycle. ", e);
        }
        catch (RegistryException e) {
            throw new APIPersistenceException("Error while accessing the registry. ", e);
        }
        catch (PersistenceException e) {
            throw new APIPersistenceException("Error while accessing the lifecycle. ", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public void saveWSDL(Organization org, String apiId, ResourceFile wsdlResourceFile) throws WSDLPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String apiSourcePath = RegistryPersistenceUtil.getAPIBasePath(apiProviderName, apiName, apiVersion);
            String wsdlResourcePath = null;
            boolean isZip = false;
            String wsdlResourcePathArchive = apiSourcePath + "/" + "archives/" + apiProviderName + "--" + apiName + apiVersion + ".zip";
            String wsdlResourcePathFile = apiSourcePath + "/" + RegistryPersistenceUtil.createWsdlFileName(apiProviderName, apiName, apiVersion);
            if ("application/zip".equals(wsdlResourceFile.getContentType())) {
                wsdlResourcePath = wsdlResourcePathArchive;
                isZip = true;
            } else {
                wsdlResourcePath = wsdlResourcePathFile;
            }
            String visibility = apiArtifact.getAttribute("overview_visibility");
            String visibleRolesList = apiArtifact.getAttribute("overview_visibleRoles");
            Resource wsdlResource = registry.newResource();
            wsdlResource.setContentStream(wsdlResourceFile.getContent());
            if (wsdlResourceFile.getContentType() != null) {
                wsdlResource.setMediaType(wsdlResourceFile.getContentType());
            }
            registry.put(wsdlResourcePath, wsdlResource);
            String[] visibleRoles = null;
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, visibleRoles, wsdlResourcePath);
            if (isZip) {
                if (registry.resourceExists(wsdlResourcePathFile)) {
                    registry.delete(wsdlResourcePathFile);
                }
            } else if (registry.resourceExists(wsdlResourcePathArchive)) {
                registry.delete(wsdlResourcePathArchive);
            }
            String absoluteWSDLResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)"/_system/governance") + wsdlResourcePath;
            String wsdlRegistryPath = "carbon.super".equalsIgnoreCase(tenantDomain) ? "/registry/resource" + absoluteWSDLResourcePath : "/t/" + tenantDomain + "/" + "registry" + "/" + "resource" + absoluteWSDLResourcePath;
            apiArtifact.setAttribute("overview_wsdl", wsdlRegistryPath);
            apiArtifactManager.updateGenericArtifact(apiArtifact);
        }
        catch (APIManagementException | APIPersistenceException | RegistryException e) {
            throw new WSDLPersistenceException("Error while saving the wsdl for api " + apiId, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public ResourceFile getWSDL(Organization org, String apiId) throws WSDLPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registry);
            if (apiArtifact == null) {
                ResourceFile resourceFile = null;
                return resourceFile;
            }
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
            int prependIndex = apiPath.lastIndexOf("/api");
            String apiSourcePath = apiPath.substring(0, prependIndex);
            String wsdlResourcePath = apiSourcePath + "/" + RegistryPersistenceUtil.createWsdlFileName(apiProviderName, apiName, apiVersion);
            String wsdlResourcePathOld = "/apimgt/applicationdata/wsdls/" + RegistryPersistenceUtil.createWsdlFileName(apiProviderName, apiName, apiVersion);
            String resourceFileName = apiProviderName + "-" + apiName + "-" + apiVersion;
            if (registry.resourceExists(wsdlResourcePath)) {
                Resource resource = registry.get(wsdlResourcePath);
                ResourceFile returnResource = new ResourceFile(resource.getContentStream(), resource.getMediaType());
                returnResource.setName(resourceFileName);
                ResourceFile resourceFile = returnResource;
                return resourceFile;
            }
            if (registry.resourceExists(wsdlResourcePathOld)) {
                Resource resource = registry.get(wsdlResourcePathOld);
                ResourceFile returnResource = new ResourceFile(resource.getContentStream(), resource.getMediaType());
                returnResource.setName(resourceFileName);
                ResourceFile resourceFile = returnResource;
                return resourceFile;
            }
            wsdlResourcePath = apiSourcePath + "/" + "archives/" + apiProviderName + "--" + apiName + apiVersion + ".zip";
            wsdlResourcePathOld = "/apimgt/applicationdata/wsdls/archives/" + apiProviderName + "--" + apiName + apiVersion + ".zip";
            if (registry.resourceExists(wsdlResourcePath)) {
                Resource resource = registry.get(wsdlResourcePath);
                ResourceFile returnResource = new ResourceFile(resource.getContentStream(), resource.getMediaType());
                returnResource.setName(resourceFileName);
                ResourceFile resourceFile = returnResource;
                return resourceFile;
            }
            if (registry.resourceExists(wsdlResourcePathOld)) {
                Resource resource = registry.get(wsdlResourcePathOld);
                ResourceFile returnResource = new ResourceFile(resource.getContentStream(), resource.getMediaType());
                returnResource.setName(resourceFileName);
                ResourceFile resourceFile = returnResource;
                return resourceFile;
            }
            try {
                throw new WSDLPersistenceException("No WSDL found for the API: " + apiId, ExceptionCodes.from((ErrorHandler)ExceptionCodes.NO_WSDL_AVAILABLE_FOR_API, (String[])new String[]{apiName, apiVersion}));
            }
            catch (APIPersistenceException | RegistryException e) {
                String msg = "Error while getting wsdl file from the registry for API: " + apiId.toString();
                throw new WSDLPersistenceException(msg, e);
            }
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public void saveOASDefinition(Organization org, String apiId, String apiDefinition) throws OASPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Failed to retrieve artifact manager when deleting API " + apiId;
                log.error((Object)errorMessage);
                throw new OASPersistenceException(errorMessage);
            }
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String visibleRoles = apiArtifact.getAttribute("overview_visibleRoles");
            String visibility = apiArtifact.getAttribute("overview_visibility");
            String resourcePath = RegistryPersistenceUtil.getOpenAPIDefinitionFilePath(apiName, apiVersion, apiProviderName);
            Resource resource = !registry.resourceExists(resourcePath = resourcePath + "swagger.json") ? registry.newResource() : registry.get(resourcePath);
            resource.setContent((Object)apiDefinition);
            resource.setMediaType("application/json");
            registry.put(resourcePath, resource);
            String[] visibleRolesArr = null;
            if (visibleRoles != null) {
                visibleRolesArr = visibleRoles.split(",");
            }
            RegistryPersistenceUtil.clearResourcePermissions(resourcePath, (Identifier)new APIIdentifier(apiProviderName, apiName, apiVersion), ((UserRegistry)registry).getTenantId());
            RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, visibleRolesArr, resourcePath);
        }
        catch (APIManagementException | APIPersistenceException | RegistryException e) {
            throw new OASPersistenceException("Error while adding OSA Definition for " + apiId, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public String getOASDefinition(Organization org, String apiId) throws OASPersistenceException {
        String apiTenantDomain = org.getName();
        String definition = null;
        boolean tenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(apiTenantDomain);
            Registry registryType = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted;
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registryType);
            if (apiArtifact != null) {
                int prependIndex;
                String apiProviderName = apiArtifact.getAttribute("overview_provider");
                String apiName = apiArtifact.getAttribute("overview_name");
                String apiVersion = apiArtifact.getAttribute("overview_version");
                String apiPath = GovernanceUtils.getArtifactPath((Registry)registryType, (String)apiId);
                String apiSourcePath = apiPath.substring(0, prependIndex = apiPath.lastIndexOf("/api"));
                String definitionPath = apiSourcePath + "/" + "swagger.json";
                if (registryType.resourceExists(definitionPath)) {
                    Resource apiDocResource = registryType.get(definitionPath);
                    String string = definition = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                    return string;
                }
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Failed to get swagger documentation of API : " + apiId;
            throw new OASPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
        return definition;
    }

    @Override
    public String getAsyncDefinition(Organization org, String apiId) throws AsyncSpecPersistenceException {
        String apiTenantDomain = org.getName();
        String definition = null;
        boolean tenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(apiTenantDomain);
            Registry registryType = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted;
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registryType, "api");
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiId);
            if (apiArtifact != null) {
                String apiProviderName = apiArtifact.getAttribute("overview_provider");
                String apiName = apiArtifact.getAttribute("overview_name");
                String apiVersion = apiArtifact.getAttribute("overview_version");
                String definitionPath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(apiProviderName) + "/" + apiName + "/" + apiVersion + "/" + "asyncapi.json";
                if (registryType.resourceExists(definitionPath)) {
                    Resource apiDocResource = registryType.get(definitionPath);
                    String string = definition = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                    return string;
                }
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Failed to get specification of API : " + apiId;
            throw new AsyncSpecPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
        return definition;
    }

    @Override
    public void saveGraphQLSchemaDefinition(Organization org, String apiId, String schemaDefinition) throws GraphQLPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new GraphQLPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String path = "/apimgt/applicationdata/provider/" + api.apiProvider + "/" + api.apiName + "/" + api.apiVersion + "/";
            String saveResourcePath = path + api.apiProvider + "--" + api.apiName + api.apiVersion + ".graphql";
            Resource resource = !registry.resourceExists(saveResourcePath) ? registry.newResource() : registry.get(saveResourcePath);
            resource.setContent((Object)schemaDefinition);
            resource.setMediaType(String.valueOf(ContentType.TEXT_PLAIN));
            registry.put(saveResourcePath, resource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully imported the schema: " + schemaDefinition));
            }
            RegistryPersistenceUtil.clearResourcePermissions(saveResourcePath, (Identifier)new APIIdentifier(api.apiProvider, api.apiName, api.apiVersion), ((UserRegistry)registry).getTenantId());
            RegistryPersistenceUtil.setResourcePermissions(api.apiProvider, api.visibility, api.visibleRoles, saveResourcePath);
        }
        catch (APIManagementException | APIPersistenceException | RegistryException e) {
            throw new GraphQLPersistenceException("Error while adding Graphql Definition for api " + apiId, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public String getGraphQLSchema(Organization org, String apiId) throws GraphQLPersistenceException {
        boolean tenantFlowStarted = false;
        String schemaDoc = null;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new GraphQLPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
            int prependIndex = apiPath.lastIndexOf("/api");
            String apiSourcePath = apiPath.substring(0, prependIndex);
            String schemaName = api.apiProvider + "--" + api.apiName + api.apiVersion + ".graphql";
            String schemaResourcePath = apiSourcePath + "/" + schemaName;
            if (registry.resourceExists(schemaResourcePath)) {
                Resource schemaResource = registry.get(schemaResourcePath);
                schemaDoc = IOUtils.toString((InputStream)schemaResource.getContentStream(), (String)"utf-8");
            }
        }
        catch (IOException | APIPersistenceException | RegistryException e) {
            throw new GraphQLPersistenceException("Error while accessing graphql schema definition ", e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
        return schemaDoc;
    }

    @Override
    public Documentation addDocumentation(Organization org, String apiId, Documentation documentation) throws DocumentationPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            GenericArtifactManager docArtifactManager = new GenericArtifactManager(registry, "document");
            GenericArtifact docArtifact = docArtifactManager.newGovernanceArtifact(new QName(documentation.getName()));
            docArtifactManager.addGenericArtifact(RegistryPersistenceDocUtil.createDocArtifactContent(docArtifact, apiName, apiVersion, apiProviderName, documentation));
            String apiPath = RegistryPersistenceUtil.getAPIPath(apiName, apiVersion, apiProviderName);
            String docVisibility = documentation.getVisibility().name();
            String[] authorizedRoles = RegistryPersistenceUtil.getAuthorizedRoles(apiPath, tenantDomain);
            String visibility = apiArtifact.getAttribute("overview_visibility");
            if (docVisibility != null) {
                if ("PRIVATE".equalsIgnoreCase(docVisibility)) {
                    authorizedRoles = null;
                    visibility = "PRIVATE";
                } else if ("OWNER_ONLY".equalsIgnoreCase(docVisibility)) {
                    authorizedRoles = null;
                    visibility = "OWNER_ONLY";
                }
            }
            RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, authorizedRoles, docArtifact.getPath(), registry);
            String docFilePath = docArtifact.getAttribute("overview_filePath");
            if (docFilePath != null && !"".equals(docFilePath)) {
                int startIndex = docFilePath.indexOf("governance") + "governance".length();
                String filePath = docFilePath.substring(startIndex, docFilePath.length());
                RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, authorizedRoles, filePath, registry);
            }
            documentation.setId(docArtifact.getId());
            Documentation documentation2 = documentation;
            return documentation2;
        }
        catch (APIManagementException | APIPersistenceException | RegistryException | UserStoreException e) {
            throw new DocumentationPersistenceException("Failed to add documentation", e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public Documentation updateDocumentation(Organization org, String apiId, Documentation documentation) throws DocumentationPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            GenericArtifactManager artifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registry);
            GenericArtifact artifact = artifactManager.getGenericArtifact(documentation.getId());
            String docVisibility = documentation.getVisibility().name();
            String[] authorizedRoles = new String[]{};
            String visibleRolesList = apiArtifact.getAttribute("overview_visibleRoles");
            if (visibleRolesList != null) {
                authorizedRoles = visibleRolesList.split(",");
            }
            String visibility = apiArtifact.getAttribute("overview_visibility");
            if (docVisibility != null) {
                if ("PRIVATE".equalsIgnoreCase(docVisibility)) {
                    authorizedRoles = null;
                    visibility = "PRIVATE";
                } else if ("OWNER_ONLY".equalsIgnoreCase(docVisibility)) {
                    authorizedRoles = null;
                    visibility = "OWNER_ONLY";
                }
            }
            GenericArtifact updateApiArtifact = RegistryPersistenceDocUtil.createDocArtifactContent(artifact, apiProviderName, apiName, apiVersion, documentation);
            artifactManager.updateGenericArtifact(updateApiArtifact);
            RegistryPersistenceUtil.clearResourcePermissions(updateApiArtifact.getPath(), (Identifier)new APIIdentifier(apiProviderName, apiName, apiVersion), ((UserRegistry)registry).getTenantId());
            RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, authorizedRoles, artifact.getPath(), registry);
            String docFilePath = artifact.getAttribute("overview_filePath");
            if (docFilePath != null && !"".equals(docFilePath)) {
                int startIndex = docFilePath.indexOf("governance") + "governance".length();
                String filePath = docFilePath.substring(startIndex, docFilePath.length());
                RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, authorizedRoles, filePath, registry);
            }
            Documentation documentation2 = documentation;
            return documentation2;
        }
        catch (APIManagementException | APIPersistenceException | RegistryException e) {
            throw new DocumentationPersistenceException("Failed to update documentation", e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public Documentation getDocumentation(Organization org, String apiId, String docId) throws DocumentationPersistenceException {
        Documentation documentation = null;
        boolean tenantFlowStarted = false;
        try {
            String requestedTenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(requestedTenantDomain);
            Registry registryType = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager artifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registryType);
            GenericArtifact artifact = artifactManager.getGenericArtifact(docId);
            if (artifact == null) {
                Documentation documentation2 = documentation;
                return documentation2;
            }
            if (null != artifact) {
                documentation = RegistryPersistenceDocUtil.getDocumentation(artifact);
                documentation.setCreatedDate(registryType.get(artifact.getPath()).getCreatedTime());
                Date lastModified = registryType.get(artifact.getPath()).getLastModified();
                if (lastModified != null) {
                    documentation.setLastUpdated(registryType.get(artifact.getPath()).getLastModified());
                }
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Failed to get documentation details";
            throw new DocumentationPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
        return documentation;
    }

    @Override
    public DocumentContent getDocumentationContent(Organization org, String apiId, String docId) throws DocumentationPersistenceException {
        DocumentContent documentContent = null;
        boolean tenantFlowStarted = false;
        try {
            String requestedTenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(requestedTenantDomain);
            Registry registryType = holder.getRegistry();
            tenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager artifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registryType);
            GenericArtifact artifact = artifactManager.getGenericArtifact(docId);
            if (artifact == null) {
                DocumentContent documentContent2 = null;
                return documentContent2;
            }
            if (artifact != null) {
                Documentation documentation = RegistryPersistenceDocUtil.getDocumentation(artifact);
                if (documentation.getSourceType().equals((Object)DocumentationInfo.DocumentSourceType.FILE)) {
                    String resource = documentation.getFilePath();
                    if (resource == null) {
                        DocumentContent documentContent3 = null;
                        return documentContent3;
                    }
                    String[] resourceSplitPath = resource.split("/_system/governance");
                    if (resourceSplitPath.length != 2) {
                        throw new DocumentationPersistenceException("Invalid resource Path " + resource);
                    }
                    resource = resourceSplitPath[1];
                    if (registryType.resourceExists(resource)) {
                        documentContent = new DocumentContent();
                        Resource apiDocResource = registryType.get(resource);
                        String[] content = apiDocResource.getPath().split("/");
                        String name = content[content.length - 1];
                        documentContent.setSourceType(DocumentContent.ContentSourceType.FILE);
                        ResourceFile resourceFile = new ResourceFile(apiDocResource.getContentStream(), apiDocResource.getMediaType());
                        resourceFile.setName(name);
                        documentContent.setResourceFile(resourceFile);
                    }
                } else if (documentation.getSourceType().equals((Object)DocumentationInfo.DocumentSourceType.INLINE) || documentation.getSourceType().equals((Object)DocumentationInfo.DocumentSourceType.MARKDOWN)) {
                    String contentPath = artifact.getPath().replace("/" + documentation.getName(), "") + "/" + "contents" + "/" + documentation.getName();
                    if (registryType.resourceExists(contentPath)) {
                        documentContent = new DocumentContent();
                        Resource docContent = registryType.get(contentPath);
                        Object content = docContent.getContent();
                        if (content != null) {
                            String contentStr = new String((byte[])docContent.getContent(), Charset.defaultCharset());
                            documentContent.setTextContent(contentStr);
                            documentContent.setSourceType(DocumentContent.ContentSourceType.valueOf(documentation.getSourceType().toString()));
                        }
                    }
                } else if (documentation.getSourceType().equals((Object)DocumentationInfo.DocumentSourceType.URL)) {
                    documentContent = new DocumentContent();
                    String sourceUrl = documentation.getSourceUrl();
                    documentContent.setTextContent(sourceUrl);
                    documentContent.setSourceType(DocumentContent.ContentSourceType.valueOf(documentation.getSourceType().toString()));
                }
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Failed to get documentation details";
            throw new DocumentationPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
        return documentContent;
    }

    @Override
    public DocumentContent addDocumentationContent(Organization org, String apiId, String docId, DocumentContent content) throws DocumentationPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            GenericArtifactManager docArtifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registry);
            GenericArtifact docArtifact = docArtifactManager.getGenericArtifact(docId);
            Documentation doc = RegistryPersistenceDocUtil.getDocumentation(docArtifact);
            if (DocumentContent.ContentSourceType.FILE.equals((Object)content.getSourceType())) {
                ResourceFile resource = content.getResourceFile();
                String filePath = RegistryPersistenceDocUtil.getDocumentFilePath(apiProviderName, apiName, apiVersion, resource.getName());
                String visibility = apiArtifact.getAttribute("overview_visibility");
                String visibleRolesList = apiArtifact.getAttribute("overview_visibleRoles");
                String[] visibleRoles = new String[]{};
                if (visibleRolesList != null) {
                    visibleRoles = visibleRolesList.split(",");
                }
                RegistryPersistenceUtil.setResourcePermissions(RegistryPersistenceUtil.replaceEmailDomain(apiProviderName), visibility, visibleRoles, filePath, registry);
                String savedFilePath = this.addResourceFile(filePath, resource, registry, tenantDomain);
                docArtifact.setAttribute("overview_filePath", savedFilePath);
                docArtifactManager.updateGenericArtifact(docArtifact);
                RegistryPersistenceUtil.setFilePermission(filePath);
            } else {
                String contentPath = RegistryPersistenceDocUtil.getDocumentContentPath(apiProviderName, apiName, apiVersion, doc.getName());
                Resource docContent = !registry.resourceExists(contentPath) ? registry.newResource() : registry.get(contentPath);
                String text = content.getTextContent();
                if (!"no_content_update".equals(text)) {
                    docContent.setContent((Object)text);
                }
                docContent.setMediaType("text/plain");
                registry.put(contentPath, docContent);
                String apiPath = RegistryPersistenceUtil.getAPIPath(apiName, apiVersion, apiProviderName);
                String docVisibility = doc.getVisibility().name();
                String[] authorizedRoles = RegistryPersistenceUtil.getAuthorizedRoles(apiPath, tenantDomain);
                String visibility = apiArtifact.getAttribute("overview_visibility");
                if (docVisibility != null) {
                    if ("PRIVATE".equalsIgnoreCase(docVisibility)) {
                        authorizedRoles = null;
                        visibility = "PRIVATE";
                    } else if ("OWNER_ONLY".equalsIgnoreCase(docVisibility)) {
                        authorizedRoles = null;
                        visibility = "OWNER_ONLY";
                    }
                }
                RegistryPersistenceUtil.setResourcePermissions(apiProviderName, visibility, authorizedRoles, contentPath, registry);
                GenericArtifact updateDocArtifact = RegistryPersistenceDocUtil.createDocArtifactContent(docArtifact, apiProviderName, apiName, apiVersion, doc);
                Boolean toggle = Boolean.parseBoolean(updateDocArtifact.getAttribute("toggle"));
                updateDocArtifact.setAttribute("toggle", Boolean.toString(toggle == false));
                docArtifactManager.updateGenericArtifact(updateDocArtifact);
            }
        }
        catch (APIManagementException | APIPersistenceException | PersistenceException | RegistryException | UserStoreException e) {
            throw new DocumentationPersistenceException("Error while adding document content", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return null;
    }

    @Override
    public DocumentSearchResult searchDocumentation(Organization org, String apiId, int start, int offset, String searchQuery, UserContext ctx) throws DocumentationPersistenceException {
        DocumentSearchResult result = null;
        String requestedTenantDomain = org.getName();
        boolean isTenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(requestedTenantDomain);
            Registry registryType = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registryType, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registryType, (String)apiId);
            int prependIndex = apiPath.lastIndexOf("/api");
            String apiSourcePath = apiPath.substring(0, prependIndex);
            String apiOrAPIProductDocPath = apiSourcePath + "/" + "documentation" + "/";
            String pathToContent = apiOrAPIProductDocPath + "contents";
            String pathToDocFile = apiOrAPIProductDocPath + "files";
            if (registryType.resourceExists(apiOrAPIProductDocPath)) {
                ArrayList<Documentation> documentationList = new ArrayList<Documentation>();
                Resource resource = registryType.get(apiOrAPIProductDocPath);
                if (resource instanceof Collection) {
                    String[] docsPaths;
                    for (String docPath : docsPaths = ((Collection)resource).getChildren()) {
                        if (docPath.equalsIgnoreCase(pathToContent) || docPath.equalsIgnoreCase(pathToDocFile)) continue;
                        Resource docResource = registryType.get(docPath);
                        GenericArtifactManager artifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registryType);
                        GenericArtifact docArtifact = artifactManager.getGenericArtifact(docResource.getUUID());
                        Documentation doc = RegistryPersistenceDocUtil.getDocumentation(docArtifact);
                        if (searchQuery != null) {
                            if (searchQuery.toLowerCase().startsWith("name:")) {
                                String requestedDocName = searchQuery.split(":")[1];
                                if (!doc.getName().equalsIgnoreCase(requestedDocName)) continue;
                                documentationList.add(doc);
                                continue;
                            }
                            log.warn((Object)("Document search not implemented for the query " + searchQuery));
                            continue;
                        }
                        documentationList.add(doc);
                    }
                }
                result = new DocumentSearchResult();
                result.setDocumentationList(documentationList);
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Failed to get documentations for api/product " + apiId;
            throw new DocumentationPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    @Override
    public void deleteDocumentation(Organization org, String apiId, String docId) throws DocumentationPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            RegistryHolder holder = this.getRegistry(org.getName());
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager artifactManager = RegistryPersistenceDocUtil.getDocumentArtifactManager(registry);
            if (artifactManager == null) {
                String errorMessage = "Failed to retrieve artifact manager when removing documentation of " + apiId + " Document ID " + docId;
                log.error((Object)errorMessage);
                throw new DocumentationPersistenceException(errorMessage);
            }
            GenericArtifact artifact = artifactManager.getGenericArtifact(docId);
            String docPath = artifact.getPath();
            if (docPath != null && registry.resourceExists(docPath)) {
                registry.delete(docPath);
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            throw new DocumentationPersistenceException("Failed to delete documentation", e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public Mediation addMediationPolicy(Organization org, String apiId, Mediation mediation) throws MediationPolicyPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new MediationPolicyPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String resourcePath = "/apimgt/applicationdata/provider/" + api.apiProvider + "/" + api.apiName + "/" + api.apiVersion + "/" + mediation.getType() + "/" + mediation.getName();
            if (registry.resourceExists(resourcePath)) {
                throw new MediationPolicyPersistenceException("Mediation policy already exists for the given name " + mediation.getName(), (ErrorHandler)ExceptionCodes.MEDIATION_POLICY_API_ALREADY_EXISTS);
            }
            Resource policy = registry.newResource();
            policy.setContent((Object)mediation.getConfig());
            policy.setMediaType("application/xml");
            registry.put(resourcePath, policy);
            mediation.setId(policy.getUUID());
            Mediation mediation2 = mediation;
            return mediation2;
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error while adding the mediation to the registry";
            throw new MediationPolicyPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public Mediation updateMediationPolicy(Organization org, String apiId, Mediation mediation) throws MediationPolicyPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new MediationPolicyPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String resourcePath = "/apimgt/applicationdata/provider/" + api.apiProvider + "/" + api.apiName + "/" + api.apiVersion + "/" + mediation.getType() + "/" + mediation.getName();
            Resource policy = registry.get(resourcePath);
            policy.setContent((Object)mediation.getConfig());
            registry.put(resourcePath, policy);
            Mediation mediation2 = mediation;
            return mediation2;
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error while adding the mediation to the registry";
            throw new MediationPolicyPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public Mediation getMediationPolicy(Organization org, String apiId, String mediationPolicyId) throws MediationPolicyPersistenceException {
        boolean isTenantFlowStarted = false;
        Mediation mediation = null;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new MediationPolicyPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
            int prependIndex = apiPath.lastIndexOf("/api");
            String apiResourcePath = apiPath.substring(0, prependIndex);
            String policyPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)mediationPolicyId);
            if (!policyPath.startsWith(apiResourcePath)) {
                throw new MediationPolicyPersistenceException("Policy not foud ", (ErrorHandler)ExceptionCodes.POLICY_NOT_FOUND);
            }
            Resource mediationResource = registry.get(policyPath);
            if (mediationResource != null) {
                String contentString = IOUtils.toString((InputStream)mediationResource.getContentStream(), (String)"utf-8");
                OMElement omElement = AXIOMUtil.stringToOM((String)contentString);
                OMAttribute attribute = omElement.getAttribute(new QName("name"));
                String mediationPolicyName = attribute.getAttributeValue();
                String[] path = policyPath.split("/");
                String resourceType = path[path.length - 2];
                mediation = new Mediation();
                mediation.setConfig(contentString);
                mediation.setType(resourceType);
                mediation.setId(mediationResource.getUUID());
                mediation.setName(mediationPolicyName);
            }
        }
        catch (IOException | XMLStreamException | APIPersistenceException | RegistryException e) {
            String msg = "Error occurred  while getting Api Specific mediation policies ";
            throw new MediationPolicyPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return mediation;
    }

    @Override
    public List<MediationInfo> getAllMediationPolicies(Organization org, String apiId) throws MediationPolicyPersistenceException {
        boolean isTenantFlowStarted = false;
        ArrayList<MediationInfo> mediationList = new ArrayList<MediationInfo>();
        try {
            int prependIndex;
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new MediationPolicyPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
            String apiResourcePath = apiPath.substring(0, prependIndex = apiPath.lastIndexOf("/api"));
            Resource resource = registry.get(apiResourcePath);
            if (resource instanceof Collection) {
                String[] typeArray;
                Collection typeCollection = (Collection)resource;
                for (String type : typeArray = typeCollection.getChildren()) {
                    String[] mediationPolicyArr;
                    Resource typeResource;
                    if (!type.equalsIgnoreCase(apiResourcePath + "/" + "in") && !type.equalsIgnoreCase(apiResourcePath + "/" + "out") && !type.equalsIgnoreCase(apiResourcePath + "/" + "fault") || !((typeResource = registry.get(type)) instanceof Collection) || (mediationPolicyArr = ((Collection)typeResource).getChildren()).length <= 0) continue;
                    for (String mediationPolicy : mediationPolicyArr) {
                        Resource policyResource = registry.get(mediationPolicy);
                        String resourceId = policyResource.getUUID();
                        try {
                            String contentString = IOUtils.toString((InputStream)policyResource.getContentStream(), (String)"utf-8");
                            OMElement omElement = AXIOMUtil.stringToOM((String)contentString);
                            OMAttribute attribute = omElement.getAttribute(new QName("name"));
                            String mediationPolicyName = attribute.getAttributeValue();
                            MediationInfo mediation = new MediationInfo();
                            mediation.setId(resourceId);
                            mediation.setName(mediationPolicyName);
                            String resourceType = type.substring(type.lastIndexOf("/") + 1);
                            mediation.setType(resourceType);
                            mediationList.add(mediation);
                        }
                        catch (XMLStreamException e) {
                            log.error((Object)"Error occurred while getting omElement out of mediation content", (Throwable)e);
                        }
                        catch (IOException e) {
                            log.error((Object)("Error occurred while converting the content stream of mediation " + mediationPolicy + " to string"), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error occurred  while getting Api Specific mediation policies ";
            throw new MediationPolicyPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return mediationList;
    }

    @Override
    public void deleteMediationPolicy(Organization org, String apiId, String mediationPolicyId) throws MediationPolicyPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            BasicAPI api = this.getbasicAPIInfo(apiId, registry);
            if (api == null) {
                throw new MediationPolicyPersistenceException("API not foud ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiResourcePath = "/apimgt/applicationdata/provider/" + api.apiProvider + "/" + api.apiName + "/" + api.apiVersion;
            String policyPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)mediationPolicyId);
            if (!policyPath.startsWith(apiResourcePath)) {
                throw new MediationPolicyPersistenceException("Policy not foud ", (ErrorHandler)ExceptionCodes.POLICY_NOT_FOUND);
            }
            if (registry.resourceExists(policyPath)) {
                registry.delete(policyPath);
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error occurred  while getting Api Specific mediation policies ";
            throw new MediationPolicyPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public void saveThumbnail(Organization org, String apiId, ResourceFile resourceFile) throws ThumbnailPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifactManager apiArtifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiId);
            if (apiArtifact == null) {
                throw new ThumbnailPersistenceException("API not found. ", (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String artifactPath = "/apimgt/applicationdata/provider/" + apiProviderName + "/" + apiName + "/" + apiVersion;
            String filePath = artifactPath + "/" + "icon";
            String savedFilePath = this.addResourceFile(filePath, resourceFile, registry, tenantDomain);
            RegistryPersistenceUtil.setResourcePermissions(apiProviderName, null, null, filePath);
            apiArtifact.setAttribute("overview_thumbnail", savedFilePath);
            apiArtifactManager.updateGenericArtifact(apiArtifact);
        }
        catch (APIManagementException | APIPersistenceException | PersistenceException | GovernanceException e) {
            throw new ThumbnailPersistenceException("Error while saving thumbnail for api " + apiId, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public ResourceFile getThumbnail(Organization org, String apiId) throws ThumbnailPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registry);
            if (apiArtifact == null) {
                ResourceFile resourceFile = null;
                return resourceFile;
            }
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String artifactOldPath = "/apimgt/applicationdata/icons/" + apiProviderName + "/" + apiName + "/" + apiVersion;
            String apiPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)apiId);
            int prependIndex = apiPath.lastIndexOf("/api");
            String artifactPath = apiPath.substring(0, prependIndex);
            String oldThumbPath = artifactOldPath + "/" + "icon";
            String thumbPath = artifactPath + "/" + "icon";
            if (registry.resourceExists(thumbPath)) {
                Resource res = registry.get(thumbPath);
                ResourceFile resourceFile = new ResourceFile(res.getContentStream(), res.getMediaType());
                return resourceFile;
            }
            if (registry.resourceExists(oldThumbPath)) {
                Resource res = registry.get(oldThumbPath);
                ResourceFile resourceFile = new ResourceFile(res.getContentStream(), res.getMediaType());
                return resourceFile;
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error while loading API icon of API " + apiId + " from the registry";
            throw new ThumbnailPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return null;
    }

    @Override
    public void deleteThumbnail(Organization org, String apiId) throws ThumbnailPersistenceException {
        boolean isTenantFlowStarted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            Registry registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiId, registry);
            if (apiArtifact == null) {
                throw new ThumbnailPersistenceException("API not found for id " + apiId, (ErrorHandler)ExceptionCodes.API_NOT_FOUND);
            }
            String apiProviderName = apiArtifact.getAttribute("overview_provider");
            apiProviderName = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
            String apiName = apiArtifact.getAttribute("overview_name");
            String apiVersion = apiArtifact.getAttribute("overview_version");
            String artifactOldPath = "/apimgt/applicationdata/icons/" + apiProviderName + "/" + apiName + "/" + apiVersion;
            String artifactPath = "/apimgt/applicationdata/provider/" + apiProviderName + "/" + apiName + "/" + apiVersion;
            String oldThumbPath = artifactOldPath + "/" + "icon";
            String thumbPath = artifactPath + "/" + "icon";
            if (registry.resourceExists(thumbPath)) {
                registry.delete(thumbPath);
            }
            if (registry.resourceExists(oldThumbPath)) {
                registry.delete(oldThumbPath);
            }
        }
        catch (APIPersistenceException | RegistryException e) {
            String msg = "Error while loading API icon of API " + apiId + " from the registry";
            throw new ThumbnailPersistenceException(msg, e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void saveAPIStatus(Registry registry, String artifactId, String apiStatus) throws APIManagementException {
        try {
            Resource resource = registry.get(artifactId);
            if (resource != null) {
                String propValue = resource.getProperty("STATUS");
                if (propValue == null) {
                    resource.addProperty("STATUS", apiStatus);
                } else {
                    resource.setProperty("STATUS", apiStatus);
                }
                registry.put(artifactId, resource);
            }
        }
        catch (RegistryException e) {
            PersistenceUtil.handleException("Error while adding API", (Exception)((Object)e));
        }
    }

    private void updateRegistryResources(Registry registry, String artifactPath, String publisherAccessControlRoles, String publisherAccessControl, Map<String, String> additionalProperties) throws RegistryException {
        String string = publisherAccessControlRoles = publisherAccessControlRoles == null || publisherAccessControlRoles.trim().isEmpty() ? "null" : publisherAccessControlRoles;
        if (publisherAccessControlRoles.equalsIgnoreCase("null")) {
            publisherAccessControl = "all";
        }
        if (!registry.resourceExists(artifactPath)) {
            return;
        }
        Resource apiResource = registry.get(artifactPath);
        if (apiResource != null) {
            Properties properties;
            if (additionalProperties != null && (properties = apiResource.getProperties()) != null) {
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    if (!propertyName.startsWith("api_meta.")) continue;
                    apiResource.removeProperty(propertyName);
                }
            }
            apiResource.setProperty("publisher_roles", publisherAccessControlRoles.toLowerCase());
            apiResource.setProperty("display_publisher_roles", publisherAccessControlRoles);
            apiResource.setProperty("publisher_access_control", publisherAccessControl);
            apiResource.removeProperty("registry.customIndexer");
            if (additionalProperties != null && additionalProperties.size() != 0) {
                for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
                    apiResource.setProperty("api_meta." + entry.getKey(), entry.getValue());
                }
            }
            registry.put(artifactPath, apiResource);
        }
    }

    protected int getMaxPaginationLimit() {
        return Integer.MAX_VALUE;
    }

    protected String addResourceFile(String resourcePath, ResourceFile resourceFile, Registry registry, String tenantDomain) throws PersistenceException {
        try {
            Resource thumb = registry.newResource();
            thumb.setContentStream(resourceFile.getContent());
            thumb.setMediaType(resourceFile.getContentType());
            registry.put(resourcePath, thumb);
            if ("carbon.super".equalsIgnoreCase(tenantDomain)) {
                return "/registry/resource/_system/governance" + resourcePath;
            }
            return "/t/" + tenantDomain + "/" + "registry" + "/" + "resource" + "/" + "_system" + "/" + "governance" + resourcePath;
        }
        catch (RegistryException e) {
            String msg = "Error while adding the resource to the registry";
            throw new PersistenceException(msg, e);
        }
    }

    protected RegistryHolder getRegistry(String requestedTenantDomain) throws APIPersistenceException {
        UserRegistry registry;
        String userTenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        log.debug((Object)("Accessing system registry in tenant domain " + userTenantDomain + ". Requested tenant domain: " + requestedTenantDomain));
        boolean tenantFlowStarted = false;
        RegistryHolder holder = new RegistryHolder();
        try {
            if (requestedTenantDomain != null) {
                int id = this.getTenantManager().getTenantId(requestedTenantDomain);
                RegistryPersistenceUtil.startTenantFlow(requestedTenantDomain);
                tenantFlowStarted = true;
                if (userTenantDomain != null && !userTenantDomain.equals(requestedTenantDomain)) {
                    log.debug((Object)("Cross tenant user from tenant " + userTenantDomain + " accessing " + requestedTenantDomain + " registry"));
                    this.loadTenantRegistry(id);
                    registry = this.getRegistryService().getGovernanceSystemRegistry(id);
                    holder.setTenantId(id);
                    ServiceReferenceHolder.setUserRealm(ServiceReferenceHolder.getInstance().getRealmService().getBootstrapRealm());
                } else {
                    log.debug((Object)("Same tenant accessing registry of tenant " + userTenantDomain + ":" + tenantId));
                    this.loadTenantRegistry(tenantId);
                    registry = this.getRegistryService().getGovernanceSystemRegistry(tenantId);
                    RegistryPersistenceUtil.loadloadTenantAPIRXT(null, tenantId);
                    RegistryPersistenceUtil.loadTenantAPIPolicy(null, tenantId);
                    holder.setTenantId(tenantId);
                    ServiceReferenceHolder.setUserRealm((UserRealm)ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId));
                }
            } else {
                log.debug((Object)("Same tenant user accessing registry of tenant " + userTenantDomain + ":" + tenantId));
                this.loadTenantRegistry(tenantId);
                registry = this.getRegistryService().getGovernanceSystemRegistry(tenantId);
                RegistryPersistenceUtil.loadloadTenantAPIRXT(null, tenantId);
                RegistryPersistenceUtil.loadTenantAPIPolicy(null, tenantId);
                ServiceReferenceHolder.setUserRealm((UserRealm)ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId));
                holder.setTenantId(tenantId);
            }
        }
        catch (APIManagementException | RegistryException | UserStoreException e) {
            String msg = "Failed to get API";
            throw new APIPersistenceException(msg, e);
        }
        holder.setRegistry((Registry)registry);
        holder.setTenantFlowStarted(tenantFlowStarted);
        return holder;
    }

    protected RegistryHolder getRegistry(String username, String requestedTenantDomain) throws APIPersistenceException {
        UserRegistry registry;
        String tenantAwareUserName = this.getTenantAwareUsername(username);
        String userTenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        log.debug((Object)("Accessing registry for user:" + tenantAwareUserName + " in tenant domain " + userTenantDomain + ". Requested tenant domain: " + requestedTenantDomain));
        boolean tenantFlowStarted = false;
        RegistryHolder holder = new RegistryHolder();
        try {
            if (requestedTenantDomain != null) {
                int id = this.getTenantManager().getTenantId(requestedTenantDomain);
                RegistryPersistenceUtil.startTenantFlow(requestedTenantDomain);
                tenantFlowStarted = true;
                if ("wso2.anonymous.user".equals(tenantAwareUserName)) {
                    log.debug((Object)("Annonymous user from tenant " + userTenantDomain + " accessing the registry"));
                    this.loadTenantRegistry(id);
                    registry = this.getRegistryService().getGovernanceUserRegistry(tenantAwareUserName, id);
                    holder.setTenantId(id);
                } else if (userTenantDomain != null && !userTenantDomain.equals(requestedTenantDomain)) {
                    holder.setAnonymousMode(true);
                    log.debug((Object)("Cross tenant user from tenant " + userTenantDomain + " accessing " + requestedTenantDomain + " registry"));
                    this.loadTenantRegistry(id);
                    registry = this.getRegistryService().getGovernanceSystemRegistry(id);
                    holder.setTenantId(id);
                    ServiceReferenceHolder.setUserRealm(ServiceReferenceHolder.getInstance().getRealmService().getBootstrapRealm());
                } else {
                    log.debug((Object)("Same tenant user : " + tenantAwareUserName + " accessing registry of tenant " + userTenantDomain + ":" + tenantId));
                    this.loadTenantRegistry(tenantId);
                    registry = this.getRegistryService().getGovernanceUserRegistry(tenantAwareUserName, tenantId);
                    RegistryPersistenceUtil.loadloadTenantAPIRXT(tenantAwareUserName, tenantId);
                    RegistryPersistenceUtil.loadTenantAPIPolicy(tenantAwareUserName, tenantId);
                    holder.setTenantId(tenantId);
                    ServiceReferenceHolder.setUserRealm((UserRealm)ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId));
                }
            } else {
                log.debug((Object)("Same tenant user : " + tenantAwareUserName + " accessing registry of tenant " + userTenantDomain + ":" + tenantId));
                this.loadTenantRegistry(tenantId);
                registry = this.getRegistryService().getGovernanceUserRegistry(tenantAwareUserName, tenantId);
                RegistryPersistenceUtil.loadloadTenantAPIRXT(tenantAwareUserName, tenantId);
                RegistryPersistenceUtil.loadTenantAPIPolicy(tenantAwareUserName, tenantId);
                ServiceReferenceHolder.setUserRealm((UserRealm)ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId));
                holder.setTenantId(tenantId);
            }
        }
        catch (APIManagementException | RegistryException | UserStoreException e) {
            String msg = "Failed to get API";
            throw new APIPersistenceException(msg, e);
        }
        holder.setRegistry((Registry)registry);
        holder.setTenantFlowStarted(tenantFlowStarted);
        return holder;
    }

    private BasicAPI getbasicAPIInfo(String uuid, Registry registry) throws APIPersistenceException, GovernanceException {
        BasicAPI api = new BasicAPI();
        GenericArtifact apiArtifact = this.getAPIArtifact(uuid, registry);
        if (apiArtifact == null) {
            return null;
        }
        String apiProviderName = apiArtifact.getAttribute("overview_provider");
        api.apiProvider = RegistryPersistenceUtil.replaceEmailDomain(apiProviderName);
        api.apiName = apiArtifact.getAttribute("overview_name");
        api.apiVersion = apiArtifact.getAttribute("overview_version");
        String visibleRolesList = apiArtifact.getAttribute("overview_visibleRoles");
        if (visibleRolesList != null) {
            api.visibleRoles = visibleRolesList.split(",");
        }
        api.visibility = apiArtifact.getAttribute("overview_visibility");
        return api;
    }

    @Override
    public PublisherAPIProduct addAPIProduct(Organization org, PublisherAPIProduct publisherAPIProduct) throws APIPersistenceException {
        Registry registry = null;
        boolean isTenantFlowStarted = false;
        boolean transactionCommitted = false;
        try {
            String tenantDomain = org.getName();
            RegistryHolder holder = this.getRegistry(tenantDomain);
            registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            GenericArtifact genericArtifact = artifactManager.newGovernanceArtifact(new QName(publisherAPIProduct.getApiProductName()));
            APIProduct apiProduct = APIProductMapper.INSTANCE.toApiProduct(publisherAPIProduct);
            APIProductIdentifier id = new APIProductIdentifier(publisherAPIProduct.getProviderName(), publisherAPIProduct.getApiProductName(), publisherAPIProduct.getVersion());
            apiProduct.setID(id);
            if (genericArtifact == null) {
                String errorMessage = "Generic artifact is null when creating API Product" + apiProduct.getId().getName();
                log.error((Object)errorMessage);
                throw new APIManagementException(errorMessage);
            }
            GenericArtifact artifact = RegistryPersistenceUtil.createAPIProductArtifactContent(genericArtifact, apiProduct);
            artifactManager.addGenericArtifact(artifact);
            artifact.attachLifecycle("APILifeCycle");
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            String providerPath = "/apimgt/applicationdata/provider/" + id.getProviderName();
            registry.addAssociation(providerPath, artifactPath, "provides");
            this.saveAPIStatus(registry, artifactPath, "PUBLISHED");
            Set tagSet = apiProduct.getTags();
            if (tagSet != null) {
                for (String tag : tagSet) {
                    registry.applyTag(artifactPath, tag);
                }
            }
            String visibleRolesList = apiProduct.getVisibleRoles();
            String[] visibleRoles = new String[]{};
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            String publisherAccessControlRoles = apiProduct.getAccessControlRoles();
            this.updateRegistryResources(registry, artifactPath, publisherAccessControlRoles, apiProduct.getAccessControl(), (Map<String, String>)apiProduct.getAdditionalProperties());
            RegistryPersistenceUtil.setResourcePermissions(apiProduct.getId().getProviderName(), apiProduct.getVisibility(), visibleRoles, artifactPath, registry);
            registry.commitTransaction();
            transactionCommitted = true;
            if (log.isDebugEnabled()) {
                String logMessage = "API Product Name: " + apiProduct.getId().getName() + ", API Product Version " + apiProduct.getId().getVersion() + " created";
                log.debug((Object)logMessage);
            }
            GenericArtifact apiArtifact = artifactManager.getGenericArtifact(artifact.getId());
            apiArtifact.invokeAction("Publish", "APILifeCycle");
            publisherAPIProduct.setCreatedTime(String.valueOf(new Date().getTime()));
            publisherAPIProduct.setId(artifact.getId());
            PublisherAPIProduct publisherAPIProduct2 = publisherAPIProduct;
            return publisherAPIProduct2;
        }
        catch (RegistryException e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API Product : " + publisherAPIProduct.getApiProductName()), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation", e);
        }
        catch (APIManagementException e) {
            throw new APIPersistenceException("Error while creating API Product", e);
        }
        finally {
            try {
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error while rolling back the transaction for API Product : " + publisherAPIProduct.getApiProductName(), ex);
            }
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public PublisherAPIProduct getPublisherAPIProduct(Organization org, String apiProductId) throws APIPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            String msg;
            RegistryHolder holder = this.getRegistry(org.getName());
            tenantFlowStarted = holder.isTenantFlowStarted();
            Registry registry = holder.getRegistry();
            GenericArtifact apiArtifact = this.getAPIArtifact(apiProductId, registry);
            if (apiArtifact != null) {
                APIProduct apiProduct = RegistryPersistenceUtil.getAPIProduct((GovernanceArtifact)apiArtifact, registry);
                String definitionPath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(apiProduct.getId().getProviderName()) + "/" + apiProduct.getId().getName() + "/" + apiProduct.getId().getVersion() + "/" + "swagger.json";
                if (registry.resourceExists(definitionPath)) {
                    Resource apiDocResource = registry.get(definitionPath);
                    String apiDocContent = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                    apiProduct.setDefinition(apiDocContent);
                }
                PublisherAPIProduct pubApi = APIProductMapper.INSTANCE.toPublisherApiProduct(apiProduct);
                pubApi.setApiProductName(apiProduct.getId().getName());
                pubApi.setProviderName(apiProduct.getId().getProviderName());
                pubApi.setVersion(apiProduct.getId().getVersion());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API Product for id " + apiProductId + " : " + pubApi.toString()));
                }
                PublisherAPIProduct publisherAPIProduct = pubApi;
                return publisherAPIProduct;
            }
            try {
                String msg2 = "Failed to get API. API artifact corresponding to artifactId " + apiProductId + " does not exist";
                throw new APIMgtResourceNotFoundException(msg2);
            }
            catch (RegistryException e) {
                msg = "Failed to get API";
                throw new APIPersistenceException(msg, e);
            }
            catch (APIManagementException e) {
                msg = "Failed to get API";
                throw new APIPersistenceException(msg, e);
            }
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    @Override
    public PublisherAPIProductSearchResult searchAPIProductsForPublisher(Organization org, String searchQuery, int start, int offset, UserContext ctx) throws APIPersistenceException {
        String requestedTenantDomain = org.getName();
        boolean isTenantFlowStarted = false;
        PublisherAPIProductSearchResult result = new PublisherAPIProductSearchResult();
        try {
            RegistryHolder holder = this.getRegistry(ctx.getUserame(), requestedTenantDomain);
            Registry userRegistry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            log.debug((Object)("Requested query for publisher product search: " + searchQuery));
            String modifiedQuery = RegistrySearchUtil.getPublisherProductSearchQuery(searchQuery, ctx);
            log.debug((Object)("Modified query for publisher product search: " + modifiedQuery));
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(ctx.getUserame());
            int maxPaginationLimit = this.getMaxPaginationLimit();
            PaginationContext.init((int)start, (int)offset, (String)"ASC", (String)"overview_name", (int)maxPaginationLimit);
            List governanceArtifacts = GovernanceUtils.findGovernanceArtifacts((String)modifiedQuery, (Registry)userRegistry, (String)"application/vnd.wso2-api+xml", (boolean)true);
            int totalLength = PaginationContext.getInstance().getLength();
            if (maxPaginationLimit == totalLength) {
                --totalLength;
            }
            int tempLength = 0;
            ArrayList<PublisherAPIProductInfo> publisherAPIProductInfoList = new ArrayList<PublisherAPIProductInfo>();
            for (GovernanceArtifact artifact : governanceArtifacts) {
                PublisherAPIProductInfo info = new PublisherAPIProductInfo();
                info.setProviderName(artifact.getAttribute("overview_provider"));
                info.setContext(artifact.getAttribute("overview_context"));
                info.setId(artifact.getId());
                info.setApiProductName(artifact.getAttribute("overview_name"));
                info.setState(artifact.getAttribute("overview_status"));
                info.setType(artifact.getAttribute("overview_type"));
                info.setVersion(artifact.getAttribute("overview_version"));
                info.setApiSecurity(artifact.getAttribute("overview_apiSecurity"));
                publisherAPIProductInfoList.add(info);
                if (++tempLength < totalLength) continue;
                break;
            }
            result.setPublisherAPIProductInfoList(publisherAPIProductInfoList);
            result.setReturnedAPIsCount(publisherAPIProductInfoList.size());
            result.setTotalAPIsCount(totalLength);
        }
        catch (GovernanceException e) {
            throw new APIPersistenceException("Error while searching APIs ", e);
        }
        finally {
            PaginationContext.destroy();
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return result;
    }

    @Override
    public PublisherAPIProduct updateAPIProduct(Organization org, PublisherAPIProduct publisherAPIProduct) throws APIPersistenceException {
        String requestedTenantDomain = org.getName();
        boolean isTenantFlowStarted = false;
        boolean transactionCommitted = false;
        Registry registry = null;
        try {
            Set tagSet;
            Tag[] oldTags;
            RegistryHolder holder = this.getRegistry(requestedTenantDomain);
            registry = holder.getRegistry();
            isTenantFlowStarted = holder.isTenantFlowStarted();
            registry.beginTransaction();
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Artifact manager is null when updating API Product with artifact ID " + publisherAPIProduct.getId();
                log.error((Object)errorMessage);
                throw new APIManagementException(errorMessage);
            }
            GenericArtifact artifact = artifactManager.getGenericArtifact(publisherAPIProduct.getId());
            APIProduct apiProduct = APIProductMapper.INSTANCE.toApiProduct(publisherAPIProduct);
            APIProductIdentifier id = new APIProductIdentifier(publisherAPIProduct.getProviderName(), publisherAPIProduct.getApiProductName(), publisherAPIProduct.getVersion());
            apiProduct.setID(id);
            GenericArtifact updateApiProductArtifact = RegistryPersistenceUtil.createAPIProductArtifactContent(artifact, apiProduct);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)updateApiProductArtifact.getId());
            artifactManager.updateGenericArtifact(updateApiProductArtifact);
            String visibleRolesList = apiProduct.getVisibleRoles();
            String[] visibleRoles = new String[]{};
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            if ((oldTags = registry.getTags(artifactPath)) != null) {
                for (Tag tag : oldTags) {
                    registry.removeTag(artifactPath, tag.getTagName());
                }
            }
            if ((tagSet = apiProduct.getTags()) != null) {
                for (String tag : tagSet) {
                    registry.applyTag(artifactPath, tag);
                }
            }
            String publisherAccessControlRoles = apiProduct.getAccessControlRoles();
            this.updateRegistryResources(registry, artifactPath, publisherAccessControlRoles, apiProduct.getAccessControl(), (Map<String, String>)apiProduct.getAdditionalProperties());
            RegistryPersistenceUtil.setResourcePermissions(apiProduct.getId().getProviderName(), apiProduct.getVisibility(), visibleRoles, artifactPath, registry);
            registry.commitTransaction();
            transactionCommitted = true;
            PublisherAPIProduct publisherAPIProduct2 = publisherAPIProduct;
            return publisherAPIProduct2;
        }
        catch (Exception e) {
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)("Error while rolling back the transaction for API Product: " + publisherAPIProduct.getApiProductName()), (Throwable)re);
            }
            throw new APIPersistenceException("Error while performing registry transaction operation", e);
        }
        finally {
            try {
                if (!transactionCommitted) {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException ex) {
                throw new APIPersistenceException("Error occurred while rolling back the transaction.", ex);
            }
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public void deleteAPIProduct(Organization org, String apiId) throws APIPersistenceException {
        boolean tenantFlowStarted = false;
        try {
            Resource providerCollection;
            CollectionImpl collection;
            String productProviderPath;
            RegistryHolder holder = this.getRegistry(org.getName());
            tenantFlowStarted = holder.isTenantFlowStarted();
            Registry registry = holder.getRegistry();
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)registry));
            GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
            if (artifactManager == null) {
                String errorMessage = "Failed to retrieve artifact manager when deleting API Product" + apiId;
                log.error((Object)errorMessage);
                throw new APIManagementException(errorMessage);
            }
            GenericArtifact apiProductArtifact = artifactManager.getGenericArtifact(apiId);
            APIProductIdentifier identifier = new APIProductIdentifier(apiProductArtifact.getAttribute("overview_provider"), apiProductArtifact.getAttribute("overview_name"), apiProductArtifact.getAttribute("overview_version"));
            String productResourcePath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(identifier.getProviderName()) + "/" + identifier.getName() + "/" + identifier.getVersion();
            String apiProductArtifactPath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(identifier.getProviderName()) + "/" + identifier.getName() + "/" + identifier.getVersion() + "/api";
            Resource apiProductResource = registry.get(productResourcePath);
            String productResourceUUID = apiProductResource.getUUID();
            if (productResourceUUID == null) {
                throw new APIManagementException("artifact id is null for : " + productResourcePath);
            }
            Resource apiArtifactResource = registry.get(apiProductArtifactPath);
            String apiArtifactResourceUUID = apiArtifactResource.getUUID();
            if (apiArtifactResourceUUID == null) {
                throw new APIManagementException("artifact id is null for : " + apiProductArtifactPath);
            }
            GovernanceArtifact[] dependenciesArray = apiProductArtifact.getDependencies();
            if (dependenciesArray.length > 0) {
                for (GovernanceArtifact artifact : dependenciesArray) {
                    registry.delete(artifact.getPath());
                }
            }
            artifactManager.removeGenericArtifact(apiProductArtifact);
            artifactManager.removeGenericArtifact(productResourceUUID);
            String apiProductCollectionPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getName();
            if (registry.resourceExists(apiProductCollectionPath)) {
                registry.delete(apiProductCollectionPath);
            }
            if (registry.resourceExists(productProviderPath = "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getName()) && (collection = (CollectionImpl)(providerCollection = registry.get(productProviderPath))).getChildCount() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No more API Products from the provider " + identifier.getProviderName() + " found. Removing provider collection from registry"));
                }
                registry.delete(productProviderPath);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to get API";
            throw new APIPersistenceException(msg, e);
        }
        catch (APIManagementException e) {
            String msg = "Failed to get API";
            throw new APIPersistenceException(msg, e);
        }
        finally {
            if (tenantFlowStarted) {
                RegistryPersistenceUtil.endTenantFlow();
            }
        }
    }

    protected GenericArtifact getAPIArtifact(String apiId, Registry registry) throws APIPersistenceException, GovernanceException {
        GenericArtifactManager artifactManager = RegistryPersistenceUtil.getArtifactManager(registry, "api");
        GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiId);
        return apiArtifact;
    }

    protected List<SOAPToRestSequence> getSoapToRestSequences(Registry registry, API api, SOAPToRestSequence.Direction direction) throws RegistryException, APIPersistenceException {
        String resourcePath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(api.getId().getProviderName()) + "/" + api.getId().getName() + "/" + api.getId().getVersion() + "/" + "soap_to_rest" + "/";
        if (direction == SOAPToRestSequence.Direction.IN) {
            resourcePath = resourcePath + "in";
        } else if (direction == SOAPToRestSequence.Direction.OUT) {
            resourcePath = resourcePath + "out";
        } else {
            throw new APIPersistenceException("Invalid sequence type");
        }
        ArrayList<SOAPToRestSequence> sequences = new ArrayList<SOAPToRestSequence>();
        if (registry.resourceExists(resourcePath)) {
            String[] resources;
            Collection collection = (Collection)registry.get(resourcePath);
            for (String path : resources = collection.getChildren()) {
                Resource resource = registry.get(path);
                String content = new String((byte[])resource.getContent(), Charset.defaultCharset());
                String resourceName = resource.getProperty("resourcePath") != null ? resource.getProperty("resourcePath") : ((ResourceImpl)resource).getName();
                resourceName = resourceName.replaceAll("\\.xml", "");
                resourceName = resourceName.split("_")[0];
                String httpMethod = resource.getProperty("method");
                SOAPToRestSequence seq = new SOAPToRestSequence(httpMethod, resourceName, content, direction);
                seq.setUuid(resource.getUUID());
                sequences.add(seq);
            }
        }
        return sequences;
    }

    protected void setSoapToRestSequences(PublisherAPI publisherAPI, Registry registry) throws RegistryException {
        if (publisherAPI.getSoapToRestSequences() != null && !publisherAPI.getSoapToRestSequences().isEmpty()) {
            List<SOAPToRestSequence> sequence = publisherAPI.getSoapToRestSequences();
            for (SOAPToRestSequence soapToRestSequence : sequence) {
                String apiResourceName = soapToRestSequence.getPath();
                if (apiResourceName.startsWith("/")) {
                    apiResourceName = apiResourceName.substring(1);
                }
                String resourcePath = "/apimgt/applicationdata/provider/" + RegistryPersistenceUtil.replaceEmailDomain(publisherAPI.getProviderName()) + "/" + publisherAPI.getApiName() + "/" + publisherAPI.getVersion() + "/";
                resourcePath = soapToRestSequence.getDirection() == SOAPToRestSequence.Direction.OUT ? resourcePath + "soap_to_rest" + "/" + "out" + "/" : resourcePath + "soap_to_rest" + "/" + "in" + "/";
                if (registry.resourceExists(resourcePath = resourcePath + apiResourceName + "_" + soapToRestSequence.getMethod() + ".xml")) continue;
                Resource regResource = registry.newResource();
                regResource.setContent((Object)soapToRestSequence.getContent());
                regResource.addProperty("method", soapToRestSequence.getMethod());
                if (regResource.getProperty("resourcePath") != null) {
                    regResource.removeProperty("resourcePath");
                }
                regResource.addProperty("resourcePath", apiResourceName);
                regResource.setMediaType("text/xml");
                registry.put(resourcePath, regResource);
            }
        }
    }

    private class BasicAPI {
        String apiName;
        String apiVersion;
        String apiProvider;
        String visibility;
        String[] visibleRoles;

        private BasicAPI() {
        }
    }

    class RegistryHolder {
        private Registry registry;
        private boolean isTenantFlowStarted;
        private int tenantId;
        private boolean isAnonymousMode;

        RegistryHolder() {
        }

        public boolean isAnonymousMode() {
            return this.isAnonymousMode;
        }

        public void setAnonymousMode(boolean anonymousMode) {
            this.isAnonymousMode = anonymousMode;
        }

        public Registry getRegistry() {
            return this.registry;
        }

        public void setRegistry(Registry registry) {
            this.registry = registry;
        }

        public boolean isTenantFlowStarted() {
            return this.isTenantFlowStarted;
        }

        public void setTenantFlowStarted(boolean isTenantFlowStarted) {
            this.isTenantFlowStarted = isTenantFlowStarted;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }
    }
}

