/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.persistence;

import java.io.IOException;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.persistence.exceptions.PersistenceException;
import org.wso2.carbon.apimgt.persistence.utils.RegistryLCManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.xml.sax.SAXException;

public class LCManagerFactory {
    private static final Log log = LogFactory.getLog(LCManagerFactory.class);
    private static LCManagerFactory instance;

    private LCManagerFactory() {
    }

    public static LCManagerFactory getInstance() {
        if (instance == null) {
            instance = new LCManagerFactory();
        }
        return instance;
    }

    public RegistryLCManager getLCManager() throws PersistenceException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String cacheName = tenantDomain + "_" + "lcCache";
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Cache lcCache = Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache("lcCache");
        RegistryLCManager lcManager = (RegistryLCManager)lcCache.get((Object)cacheName);
        if (lcManager != null) {
            log.debug((Object)"Lifecycle info servered from Cache.");
            return lcManager;
        }
        try {
            log.debug((Object)"Lifecycle info not found in Cache.");
            lcManager = new RegistryLCManager(tenantId);
            lcCache.put((Object)cacheName, (Object)lcManager);
            return lcManager;
        }
        catch (IOException | ParserConfigurationException | XMLStreamException | RegistryException | SAXException e) {
            throw new PersistenceException("Error while accessing the lifecycle resource ", e);
        }
    }
}

