/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.mgt.ui.fileupload.CarbonAppUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class CarbonAppUploadExecutor
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        return this.uploadArtifacts(request, response, "dropins", new String[]{"jar"}, "Axis2");
    }

    protected boolean uploadArtifacts(HttpServletRequest request, HttpServletResponse response, String uploadDirName, String[] extensions, String utilityString) throws IOException {
        String msg;
        response.setContentType("text/html; charset=utf-8");
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/carbonapps/app_upload.jsp"));
        }
        CarbonAppUploaderClient uploaderClient = new CarbonAppUploaderClient(this.configurationContext, serverURL + "CarbonAppUploader", cookie);
        try {
            for (Object o : fileItemsMap.keySet()) {
                String fieldName = (String)o;
                FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                String fileName = this.getFileName(fileItemData.getFileItem().getName());
                uploaderClient.addUploadedFileItem(fileItemData.getDataHandler(), fileName, "jar");
            }
            uploaderClient.uploadFileItems();
            msg = "Your Application has been uploaded successfully. Please refresh this page in a while to see the status of the new Application.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/carbonapps/index.jsp"));
            return true;
        }
        catch (Exception e) {
            msg = "File upload failed.";
            log.error((Object)msg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/carbonapps/app_upload.jsp"));
            return false;
        }
    }
}

