/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TenantRegistryDataDeletionUtil {
    public static final Log log = LogFactory.getLog(TenantRegistryDataDeletionUtil.class);

    public static void deleteTenantRegistryData(int tenantId, Connection conn) throws Exception {
        try {
            conn.setAutoCommit(false);
            String deleteClusterLockSql = "DELETE FROM REG_CLUSTER_LOCK WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteClusterLockSql, tenantId);
            String deleteLogSql = "DELETE FROM REG_LOG WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteLogSql, tenantId);
            String deleteAssociationSql = "DELETE FROM REG_ASSOCIATION WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteAssociationSql, tenantId);
            String deleteSnapshotSql = "DELETE FROM REG_SNAPSHOT WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteSnapshotSql, tenantId);
            String deleteResourceCommentSql = "DELETE FROM REG_RESOURCE_COMMENT WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourceCommentSql, tenantId);
            String deleteCommentSql = "DELETE FROM REG_COMMENT WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteCommentSql, tenantId);
            String deleteResourceRatingSql = "DELETE FROM REG_RESOURCE_RATING WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourceRatingSql, tenantId);
            String deleteRatingSql = "DELETE FROM REG_RATING WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteRatingSql, tenantId);
            String deleteResourceTagSql = "DELETE FROM REG_RESOURCE_TAG WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourceTagSql, tenantId);
            String deleteTagSql = "DELETE FROM REG_TAG WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteTagSql, tenantId);
            String deleteResourcePropertySql = "DELETE FROM REG_RESOURCE_PROPERTY WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourcePropertySql, tenantId);
            String deletePropertySql = "DELETE FROM REG_PROPERTY WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deletePropertySql, tenantId);
            String deleteResourceHistorySql = "DELETE FROM REG_RESOURCE_HISTORY WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourceHistorySql, tenantId);
            String deleteContentHistorySql = "DELETE FROM REG_CONTENT_HISTORY WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteContentHistorySql, tenantId);
            String deleteResourceSql = "DELETE FROM REG_RESOURCE WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteResourceSql, tenantId);
            String deleteContentSql = "DELETE FROM REG_CONTENT WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deleteContentSql, tenantId);
            String deletePathSql = "DELETE FROM REG_PATH WHERE REG_TENANT_ID = ?";
            TenantRegistryDataDeletionUtil.executeDeleteQuery(conn, deletePathSql, tenantId);
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            String errorMsg = "An error occurred while deleting registry data for tenant: " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            conn.close();
        }
    }

    private static void executeDeleteQuery(Connection conn, String query, int tenantId) throws Exception {
        try (PreparedStatement ps = null;){
            ps = conn.prepareStatement(query);
            ps.setInt(1, tenantId);
            ps.executeUpdate();
        }
    }
}

