/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.util;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.constants.TenantConstants;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.exception.TenantManagementClientException;
import org.wso2.carbon.stratos.common.exception.TenantManagementServerException;
import org.wso2.carbon.stratos.common.exception.TenantMgtException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.message.TenantDeleteClusterMessage;
import org.wso2.carbon.tenant.mgt.util.TenantDataDeletionUtil;
import org.wso2.carbon.tenant.mgt.util.TenantRegistryDataDeletionUtil;
import org.wso2.carbon.tenant.mgt.util.TenantUMDataDeletionUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class TenantMgtUtil {
    private static final Log log = LogFactory.getLog(TenantMgtUtil.class);
    private static final String ILLEGAL_CHARACTERS_FOR_TENANT_DOMAIN = ".*[^a-z0-9\\._\\-].*";
    private static final String DOT = ".";
    private static ThreadLocal<Boolean> isTenantAdminCreationOperation = new ThreadLocal();
    private static final int DEFAULT_ITEMS_PER_PAGE = 15;
    private static final int DEFAULT_MAXIMUM_ITEMS_PER_PAGE = 100;

    public static void prepareStringToShowThemeMgtPage(int tenantId, String resourceId) throws TenantMgtException {
        try {
            UserRegistry systemRegistry = TenantMgtServiceComponent.getRegistryService().getGovernanceSystemRegistry();
            Resource resource = systemRegistry.newResource();
            String tenantIdStr = Integer.toString(tenantId);
            resource.setProperty("tenantId", tenantIdStr);
            String uuidPath = "/repository/components/org.wso2.carbon.theme-page-token/" + resourceId;
            systemRegistry.put(uuidPath, resource);
            CommonUtil.denyAnonAuthorization((String)uuidPath, (UserRealm)systemRegistry.getUserRealm());
        }
        catch (RegistryException e) {
            throw new TenantManagementServerException("Error while creating the path for theme page.", (Exception)((Object)e));
        }
    }

    public static String prepareStringToShowThemeMgtPage(int tenantId) throws RegistryException {
        UserRegistry systemRegistry = TenantMgtServiceComponent.getRegistryService().getGovernanceSystemRegistry();
        String uuid = UUIDGenerator.generateUUID();
        Resource resource = systemRegistry.newResource();
        String tenantIdStr = Integer.toString(tenantId);
        resource.setProperty("tenantId", tenantIdStr);
        String uuidPath = "/repository/components/org.wso2.carbon.theme-page-token/" + uuid;
        systemRegistry.put(uuidPath, resource);
        CommonUtil.denyAnonAuthorization((String)uuidPath, (UserRealm)systemRegistry.getUserRealm());
        return uuid;
    }

    public static void triggerAddTenant(TenantInfoBean tenantInfo) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantCreate(tenantInfo);
        }
    }

    public static void triggerPreTenantDelete(int tenantId) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            log.debug((Object)("Executing OnPreDelete on Listener Impl Class Name : " + tenantMgtListener.getClass().getName()));
            tenantMgtListener.onPreDelete(tenantId);
        }
    }

    public static void triggerUpdateTenant(TenantInfoBean tenantInfoBean) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantUpdate(tenantInfoBean);
        }
    }

    public static void triggerTenantInitialActivation(TenantInfoBean tenantInfoBean) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantInitialActivation(tenantInfoBean.getTenantId());
        }
    }

    public static void triggerTenantActivation(int tenantId) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantActivation(tenantId);
        }
    }

    public static void triggerTenantDeactivation(int tenantId) throws StratosException {
        for (TenantMgtListener tenantMgtListener : TenantMgtServiceComponent.getTenantMgtListeners()) {
            tenantMgtListener.onTenantDeactivation(tenantId);
        }
    }

    public static void validateDomain(String domainName) throws Exception {
        int lastIndexOfDot;
        if (StringUtils.isBlank((String)domainName)) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_EMPTY_DOMAIN_NAME);
        }
        if (CommonUtil.isPublicCloudSetup() && (lastIndexOfDot = domainName.lastIndexOf(DOT)) <= 0) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTENSION);
        }
        int indexOfDot = domainName.indexOf(DOT);
        if (indexOfDot == 0) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_INVALID_DOMAIN);
        }
        if (domainName.matches(ILLEGAL_CHARACTERS_FOR_TENANT_DOMAIN)) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_ILLEGAL_CHARACTERS_IN_DOMAIN.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_ILLEGAL_CHARACTERS_IN_DOMAIN.getMessage(), domainName));
        }
    }

    public static UserStoreManager getUserStoreManager(Tenant tenant, int tenantId) throws Exception {
        UserRealm userRealm;
        RealmConfiguration realmConfig = TenantMgtServiceComponent.getBootstrapRealmConfiguration();
        TenantMgtConfiguration tenantMgtConfiguration = TenantMgtServiceComponent.getRealmService().getTenantMgtConfiguration();
        try {
            MultiTenantRealmConfigBuilder builder = TenantMgtServiceComponent.getRealmService().getMultiTenantRealmConfigBuilder();
            RealmConfiguration realmConfigToPersist = builder.getRealmConfigForTenantToPersist(realmConfig, tenantMgtConfiguration, tenant, tenantId);
            RealmConfiguration realmConfigToCreate = builder.getRealmConfigForTenantToCreateRealmOnTenantCreation(realmConfig, realmConfigToPersist, tenantId);
            userRealm = TenantMgtServiceComponent.getRealmService().getUserRealm(realmConfigToCreate);
        }
        catch (UserStoreException e) {
            String msg = "Error in creating Realm for tenant, tenant domain: " + tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            return userStoreManager;
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the userstore/authorization manager for tenant: " + tenant.getDomain();
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public static Tenant initializeTenant(TenantInfoBean tenantInfoBean) {
        Tenant tenant = new Tenant();
        tenant.setDomain(tenantInfoBean.getTenantDomain());
        tenant.setEmail(tenantInfoBean.getEmail());
        tenant.setAdminName(tenantInfoBean.getAdmin());
        tenant.setId(tenantInfoBean.getTenantId());
        tenant.setAdminFirstName(tenantInfoBean.getFirstname());
        tenant.setAdminLastName(tenantInfoBean.getLastname());
        tenant.setAdminPassword(tenantInfoBean.getAdminPassword());
        Calendar createdDateCal = tenantInfoBean.getCreatedDate();
        long createdDate = createdDateCal != null ? createdDateCal.getTimeInMillis() : System.currentTimeMillis();
        tenant.setCreatedDate(new Date(createdDate));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant object Initialized from the TenantInfoBean");
        }
        return tenant;
    }

    public static void deleteTenant(String tenantDomain) throws Exception {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        if (tenantManager != null) {
            int tenantId = tenantManager.getTenantId(tenantDomain);
            ServerConfigurationService serverConfigurationService = TenantMgtServiceComponent.getServerConfigurationService();
            if (Boolean.parseBoolean(serverConfigurationService.getFirstProperty("Tenant.ListenerInvocationPolicy.InvokeOnDelete"))) {
                TenantMgtUtil.triggerPreTenantDelete(tenantId);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant.ListenerInvocationPolicy.InvokeOnDelete flag is not set to true in carbon.xml. Listener invocation ignored.");
            }
            TenantMgtUtil.deleteWorkernodesTenant(tenantId);
            if (TenantMgtServiceComponent.getBillingService() != null) {
                TenantMgtServiceComponent.getBillingService().deleteBillingData(tenantId);
            }
            TenantMgtUtil.unloadTenantConfigurations(tenantDomain, tenantId);
            TenantMgtUtil.deleteTenantRegistryData(tenantId);
            TenantMgtUtil.deleteTenantDir(tenantId);
            tenantManager.deleteTenant(tenantId);
            log.info((Object)String.format("Deleted tenant with domain: %s and tenant id: %d from the system.", tenantDomain, tenantId));
        }
    }

    public static TenantInfoBean initializeTenantInfoBean(int tenantId, Tenant tenant) throws Exception {
        TenantInfoBean bean = TenantMgtUtil.getTenantInfoBeanfromTenant(tenantId, tenant);
        if (tenant != null) {
            try {
                bean.setAdmin(ClaimsMgtUtil.getAdminUserNameFromTenantId((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
            }
            catch (Exception e) {
                throw new TenantManagementServerException("Error while getting admin username from tenant id.", e);
            }
        }
        return bean;
    }

    public static TenantInfoBean getTenantInfoBeanfromTenant(int tenantId, Tenant tenant) {
        TenantInfoBean bean = new TenantInfoBean();
        if (tenant != null) {
            bean.setTenantId(tenantId);
            bean.setTenantDomain(tenant.getDomain());
            bean.setEmail(tenant.getEmail());
            Calendar createdDate = Calendar.getInstance();
            createdDate.setTimeInMillis(tenant.getCreatedDate().getTime());
            bean.setCreatedDate(createdDate);
            bean.setActive(tenant.isActive());
            if (log.isDebugEnabled()) {
                log.debug((Object)"The TenantInfoBean object has been created from the tenant.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The tenant is null.");
        }
        return bean;
    }

    public static void addClaimsToUserStoreManager(Tenant tenant) throws Exception {
        try {
            UserStoreManager userStoreManager;
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((String)tenant.getAdminFirstName())) {
                claimsMap.put("http://wso2.org/claims/givenname", tenant.getAdminFirstName());
            }
            if (StringUtils.isNotEmpty((String)tenant.getAdminLastName())) {
                claimsMap.put("http://wso2.org/claims/lastname", tenant.getAdminLastName());
            }
            if (StringUtils.isNotEmpty((String)tenant.getEmail())) {
                claimsMap.put("http://wso2.org/claims/emailaddress", tenant.getEmail());
            }
            if (!(userStoreManager = (UserStoreManager)TenantMgtServiceComponent.getRealmService().getTenantUserRealm(tenant.getId()).getUserStoreManager()).isReadOnly()) {
                userStoreManager.setUserClaimValues(tenant.getAdminName(), claimsMap, "default");
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Error in adding claims to the user.";
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
    }

    public static void addAdditionalClaimsToUserStoreManager(Tenant tenant) throws Exception {
        try {
            UserStoreManager userStoreManager;
            HashMap claimsMap = new HashMap();
            if (tenant.getClaimsMap() != null) {
                for (Map.Entry entry : tenant.getClaimsMap().entrySet()) {
                    claimsMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (!(userStoreManager = (UserStoreManager)TenantMgtServiceComponent.getRealmService().getTenantUserRealm(tenant.getId()).getUserStoreManager()).isReadOnly()) {
                userStoreManager.setUserClaimValues(tenant.getAdminName(), claimsMap, "default");
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Error in adding claims to the user.";
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
    }

    public static void activateTenantInitially(TenantInfoBean tenantInfoBean, int tenantId) throws Exception {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        String tenantDomain = tenantInfoBean.getTenantDomain();
        try {
            TenantMgtUtil.activateTenant(tenantDomain, tenantManager, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Activated the tenant " + tenantDomain + " at the time of tenant creation"));
            }
            TenantMgtUtil.triggerTenantInitialActivation(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant initial activation.";
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Error while activating the tenant.";
            throw new TenantManagementServerException(msg, e);
        }
    }

    public static void activateTenant(String tenantDomain, TenantManager tenantManager, int tenantId) throws Exception {
        try {
            tenantManager.activateTenant(tenantId);
        }
        catch (UserStoreException e) {
            throw new TenantManagementServerException("Error in activating the tenant for tenant domain: " + tenantDomain + DOT, (Exception)((Object)e));
        }
    }

    public static void deactivateTenant(String tenantDomain, TenantManager tenantManager, int tenantId) throws Exception {
        try {
            tenantManager.deactivateTenant(tenantId);
            TenantMgtUtil.unloadTenantConfigurations(tenantDomain, tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in deactivating tenant for tenant domain: " + tenantDomain + DOT;
            log.error((Object)msg, (Throwable)e);
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadTenantConfigurations(String tenantDomain, int tenantId) {
        Map tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)TenantMgtServiceComponent.getConfigurationContext());
        ConfigurationContext tenantConfigurationContext = (ConfigurationContext)tenantConfigContexts.get(tenantDomain);
        if (tenantConfigurationContext != null && tenantConfigurationContext.getAxisConfiguration() != null) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setTenantId(tenantId);
                TenantAxisUtils.terminateTenantConfigContext((ConfigurationContext)tenantConfigurationContext);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            tenantConfigContexts.remove(tenantDomain);
        }
    }

    public static void deleteTenantRegistryData(int tenantId) throws Exception {
        JDBCDataAccessManager configMgr = (JDBCDataAccessManager)TenantMgtServiceComponent.getRegistryService().getConfigUserRegistry().getRegistryContext().getDataAccessManager();
        TenantRegistryDataDeletionUtil.deleteTenantRegistryData(tenantId, configMgr.getDataSource().getConnection());
        JDBCDataAccessManager govMgr = (JDBCDataAccessManager)TenantMgtServiceComponent.getRegistryService().getGovernanceUserRegistry().getRegistryContext().getDataAccessManager();
        TenantRegistryDataDeletionUtil.deleteTenantRegistryData(tenantId, govMgr.getDataSource().getConnection());
    }

    public static void deleteTenantUMData(int tenantId) throws Exception {
        RealmConfiguration realmConfig = TenantMgtServiceComponent.getRealmService().getBootstrapRealmConfiguration();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(realmConfig.getRealmProperty("driverName"));
        dataSource.setUrl(realmConfig.getRealmProperty("url"));
        dataSource.setUsername(realmConfig.getRealmProperty("userName"));
        dataSource.setPassword(realmConfig.getRealmProperty("password"));
        dataSource.setMaxActive(Integer.parseInt(realmConfig.getRealmProperty("maxActive")));
        dataSource.setMinIdle(Integer.parseInt(realmConfig.getRealmProperty("minIdle")));
        dataSource.setMaxWait((long)Integer.parseInt(realmConfig.getRealmProperty("maxWait")));
        TenantUMDataDeletionUtil.deleteTenantUMData(tenantId, dataSource.getConnection());
    }

    public static void deleteWorkernodesTenant(int tenantId) throws Exception {
        AxisConfiguration axisConfiguration;
        ClusteringAgent agent;
        TenantDeleteClusterMessage clustermessage = new TenantDeleteClusterMessage(tenantId);
        ConfigurationContext configContext = TenantMgtServiceComponent.getConfigurationContext();
        if (configContext != null && (agent = (axisConfiguration = configContext.getAxisConfiguration()).getClusteringAgent()) != null) {
            try {
                agent.sendMessage((ClusteringMessage)clustermessage, true);
            }
            catch (ClusteringFault e) {
                log.error((Object)("Error occurred while broadcasting TenantDeleteClusterMessage : " + e.getMessage()));
            }
        }
    }

    public static void deleteProductSpecificTenantData(String dataSourceName, String tableName, int tenantId) {
        try {
            TenantDataDeletionUtil.deleteProductSpecificTenantData(((DataSource)InitialContext.doLookup(dataSourceName)).getConnection(), tableName, tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in looking up data source: " + e.getMessage(), e);
        }
    }

    public static void deleteTenantDir(int tenantId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting tenant directory of tenant: " + tenantId));
        }
        String tenantDirPath = CarbonUtils.getCarbonTenantsDirPath() + File.separator + tenantId;
        File tenantDir = new File(tenantDirPath);
        try {
            FileUtils.deleteDirectory((File)tenantDir);
        }
        catch (IOException e) {
            log.error((Object)("Error in deleting tenant directory: " + tenantDirPath), (Throwable)e);
        }
    }

    public static boolean isTenantAdminCreationOperation() {
        if (isTenantAdminCreationOperation == null) {
            return false;
        }
        if (isTenantAdminCreationOperation.get() == null) {
            return false;
        }
        return isTenantAdminCreationOperation.get();
    }

    public static void setTenantAdminCreationOperation(boolean isAdminCreationOperation) {
        isTenantAdminCreationOperation.set(isAdminCreationOperation);
    }

    public static void clearTenantAdminCreationOperation() {
        isTenantAdminCreationOperation.remove();
    }

    public static int getDefaultItemsPerPage() {
        int defaultItemsPerPage = 15;
        try {
            int defaultItemsPerPageConfig;
            String defaultItemsPerPageProperty = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
            if (StringUtils.isNotBlank((String)defaultItemsPerPageProperty) && (defaultItemsPerPageConfig = Integer.parseInt(defaultItemsPerPageProperty)) > 0) {
                defaultItemsPerPage = defaultItemsPerPageConfig;
            }
        }
        catch (NumberFormatException e) {
            defaultItemsPerPage = 15;
            log.warn((Object)"Error occurred while parsing the 'ItemsPerPage' property value in carbon.xml.", (Throwable)e);
        }
        return defaultItemsPerPage;
    }

    public static int getMaximumItemPerPage() {
        int maximumItemsPerPage = 100;
        String maximumItemsPerPagePropertyValue = ServerConfiguration.getInstance().getFirstProperty("MaximumItemsPerPage");
        if (StringUtils.isNotBlank((String)maximumItemsPerPagePropertyValue)) {
            try {
                maximumItemsPerPage = Integer.parseInt(maximumItemsPerPagePropertyValue);
            }
            catch (NumberFormatException e) {
                maximumItemsPerPage = 100;
                log.warn((Object)"Error occurred while parsing the 'MaximumItemsPerPage' property value in carbon.xml.", (Throwable)e);
            }
        }
        return maximumItemsPerPage;
    }
}

