/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.services;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.constants.TenantConstants;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.exception.TenantManagementClientException;
import org.wso2.carbon.stratos.common.exception.TenantManagementServerException;
import org.wso2.carbon.stratos.common.exception.TenantMgtException;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.core.TenantPersistor;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.services.TenantMgtService;
import org.wso2.carbon.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.tenant.TenantSearchResult;

public class TenantMgtImpl
implements TenantMgtService {
    private static final Log log = LogFactory.getLog(TenantMgtImpl.class);
    private static final String DEFAULT_SORT_BY = "UM_DOMAIN_NAME";
    private static final String DESC_SORT_ORDER = "DESC";
    private static final String ASC_SORT_ORDER = "ASC";
    public static final String DOMAIN_NAME = "domainName";
    public static final String TENANT_ADMIN_ASK_PASSWORD_CLAIM = "http://wso2.org/claims/identity/tenantAdminAskPassword";
    public static final String INVITE_VIA_EMAIL = "invite-via-email";

    @Override
    public String addTenant(Tenant tenant) throws TenantMgtException {
        int tenantId;
        String tenantDomain = tenant.getDomain();
        this.validateInputs(tenant);
        try {
            TenantMgtUtil.setTenantAdminCreationOperation(true);
            this.addAttributeValues(tenant);
            this.createTenant(tenant);
            this.addTenantAdminUser(tenant);
            tenantId = tenant.getId();
            this.addClaimsToUserStore(tenant);
            TenantInfoBean tenantInfoBean = TenantMgtUtil.initializeTenantInfoBean(tenantId, tenant);
            this.notifyTenantAddition(tenantInfoBean);
            TenantMgtUtil.activateTenantInitially(tenantInfoBean, tenantId);
            if (INVITE_VIA_EMAIL.equalsIgnoreCase(tenant.getProvisioningMethod())) {
                tenant.getClaimsMap().put(TENANT_ADMIN_ASK_PASSWORD_CLAIM, "true");
            }
            this.addAdditionalClaimsToUserStore(tenant);
        }
        catch (Exception e) {
            if (e instanceof TenantMgtException) {
                throw (TenantMgtException)e;
            }
            throw new TenantManagementServerException(e.getMessage(), e);
        }
        log.info((Object)("Added the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
        TenantMgtUtil.prepareStringToShowThemeMgtPage(tenant.getId(), tenant.getTenantUniqueID());
        return tenant.getTenantUniqueID();
    }

    @Override
    public TenantSearchResult listTenants(Integer limit, Integer offset, String sortOrder, String sortBy, String filter) throws TenantMgtException {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            TenantSearchResult tenantSearchResult = new TenantSearchResult();
            this.setParameters(limit, offset, sortOrder, sortBy, filter, tenantSearchResult);
            tenantSearchResult = tenantManager.listTenants(Integer.valueOf(tenantSearchResult.getLimit()), Integer.valueOf(tenantSearchResult.getOffSet()), tenantSearchResult.getSortOrder(), tenantSearchResult.getSortBy(), tenantSearchResult.getFilter());
            return tenantSearchResult;
        }
        catch (UserStoreException e) {
            throw new TenantManagementServerException("Error in retrieving the tenant information.", (Exception)((Object)e));
        }
    }

    @Override
    public Tenant getTenant(String tenantUniqueID) throws TenantMgtException {
        Tenant tenant;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenant = tenantManager.getTenant(tenantUniqueID);
            if (tenant == null) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getMessage(), tenantUniqueID));
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error while getting the tenant - " + tenantUniqueID, (Exception)((Object)e));
        }
        return tenant;
    }

    @Override
    public Tenant getTenantByDomain(String domain) throws TenantMgtException {
        Tenant tenant;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            int tenantID = tenantManager.getTenantId(domain);
            tenant = (Tenant)tenantManager.getTenant(tenantID);
            if (tenant == null) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_DOMAIN_NOT_FOUND.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_DOMAIN_NOT_FOUND.getMessage(), domain));
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error while getting the tenant - " + domain, (Exception)((Object)e));
        }
        return tenant;
    }

    @Override
    public boolean isDomainAvailable(String domain) throws TenantMgtException {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            int tenantID = tenantManager.getTenantId(domain);
            if (tenantID == -1) {
                return true;
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error while getting the tenant - " + domain, (Exception)((Object)e));
        }
        return false;
    }

    @Override
    public void activateTenant(String tenantUniqueID) throws TenantMgtException {
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        String tenantDomain = null;
        try {
            Tenant tenant = tenantManager.getTenant(tenantUniqueID);
            if (tenant == null) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getMessage(), tenantUniqueID));
            }
            tenantManager.activateTenant(tenantUniqueID);
            tenantId = tenant.getId();
            tenantDomain = tenant.getDomain();
            TenantMgtUtil.triggerTenantActivation(tenantId);
        }
        catch (UserStoreException e) {
            throw new TenantManagementServerException("Error in activating or getting the tenant using tenant unique id: " + tenantUniqueID + " .", (Exception)((Object)e));
        }
        catch (StratosException e) {
            throw new TenantManagementServerException("Error in notifying tenant activation of tenant: " + tenantDomain + " .", (Exception)((Object)e));
        }
        log.info((Object)("Activated the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
    }

    @Override
    public void deactivateTenant(String tenantUniqueID) throws TenantMgtException {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        String tenantDomain = null;
        try {
            Tenant tenant = tenantManager.getTenant(tenantUniqueID);
            if (tenant == null) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getMessage(), tenantUniqueID));
            }
            int tenantId = tenant.getId();
            tenantDomain = tenant.getDomain();
            TenantMgtUtil.triggerTenantDeactivation(tenantId);
            tenantManager.deactivateTenant(tenantUniqueID);
            TenantMgtUtil.unloadTenantConfigurations(tenantDomain, tenantId);
            log.info((Object)("Deactivated the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error in retrieving or deactivating the tenant using tenant unique id: " + tenantUniqueID + " .", (Exception)((Object)e));
        }
        catch (StratosException e) {
            throw new TenantManagementServerException("Error while triggering tenant deactivation for the tenant: " + tenantDomain + " .", (Exception)((Object)e));
        }
    }

    @Override
    public void deleteTenantMetaData(String tenantUniqueIdentifier) throws TenantMgtException {
        ServerConfigurationService serverConfigurationService = TenantMgtServiceComponent.getServerConfigurationService();
        if (!Boolean.parseBoolean(serverConfigurationService.getFirstProperty("Tenant.TenantDelete"))) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_TENANT_DELETION_NOT_ENABLED.getCode(), TenantConstants.ErrorMessage.ERROR_CODE_TENANT_DELETION_NOT_ENABLED.getMessage());
        }
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        if (tenantManager != null) {
            Tenant tenant;
            try {
                tenant = tenantManager.getTenant(tenantUniqueIdentifier);
            }
            catch (UserStoreException e) {
                throw new TenantManagementServerException("Error while getting the tenant with the tenant unique id :" + tenantUniqueIdentifier + " .", (Exception)((Object)e));
            }
            if (tenant != null) {
                int tenantId = tenant.getId();
                String tenantDomain = tenant.getDomain();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Starting tenant deletion for domain: %s and tenant id: %d from the system.", tenantDomain, tenantId));
                    }
                    TenantMgtUtil.deleteTenant(tenantDomain);
                }
                catch (Exception e) {
                    if (e instanceof TenantMgtException) {
                        throw (TenantMgtException)e;
                    }
                    throw new TenantManagementServerException(e.getMessage(), e);
                }
            } else if (log.isDebugEnabled()) {
                String msg = "Trying to delete a non-existing tenant with tenant unique id : %s .";
                log.debug((Object)String.format(msg, tenantUniqueIdentifier));
            }
        }
    }

    @Override
    public User getOwner(String tenantUniqueID) throws TenantMgtException {
        Tenant tenant = this.getTenantFromTenantManager(tenantUniqueID);
        if (tenant != null) {
            return this.createOwner(tenant);
        }
        throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_RESOURCE_NOT_FOUND.getMessage(), tenantUniqueID));
    }

    private void createTenant(Tenant tenant) throws Exception {
        TenantPersistor persistor = new TenantPersistor();
        persistor.persistTenant(tenant);
    }

    private void addClaimsToUserStore(Tenant tenant) throws Exception {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenant.getDomain());
            carbonContext.setTenantId(tenant.getId());
            TenantMgtUtil.addClaimsToUserStoreManager(tenant);
        }
        finally {
            TenantMgtUtil.clearTenantAdminCreationOperation();
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void addAdditionalClaimsToUserStore(Tenant tenant) throws Exception {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenant.getDomain());
            carbonContext.setTenantId(tenant.getId());
            TenantMgtUtil.addAdditionalClaimsToUserStoreManager(tenant);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void validateInputs(Tenant tenant) throws TenantMgtException {
        try {
            CommonUtil.validateEmail((String)tenant.getEmail());
            TenantMgtUtil.validateDomain(tenant.getDomain());
            this.checkIsSuperTenantInvoking();
        }
        catch (Exception e) {
            if (e instanceof TenantMgtException) {
                throw (TenantMgtException)e;
            }
            throw new TenantManagementServerException(e.getMessage(), e);
        }
    }

    private void addAttributeValues(Tenant tenant) throws TenantMgtException {
        tenant.setCreatedDate(this.createDate());
        tenant.setTenantUniqueID(UUIDGenerator.generateUUID());
        RealmConfiguration realmConfiguration = this.getRealmConfigForTenant(tenant);
        tenant.setRealmConfig(realmConfiguration);
    }

    private RealmConfiguration getRealmConfigForTenant(Tenant tenant) throws TenantMgtException {
        RealmService realmService = TenantMgtServiceComponent.getRealmService();
        RealmConfiguration realmConfig = realmService.getBootstrapRealmConfiguration();
        TenantMgtConfiguration tenantMgtConfiguration = realmService.getTenantMgtConfiguration();
        try {
            MultiTenantRealmConfigBuilder builder = TenantMgtServiceComponent.getRealmService().getMultiTenantRealmConfigBuilder();
            RealmConfiguration realmConfigToPersist = builder.getRealmConfigForTenantToPersist(realmConfig, tenantMgtConfiguration, tenant, -1);
            realmService.getBootstrapRealm().getRealmConfiguration().setAddAdmin("true");
            return realmConfigToPersist;
        }
        catch (UserStoreException e) {
            throw new TenantMgtException("Error while getting the realm config.", (Exception)((Object)e));
        }
    }

    private void addTenantAdminUser(Tenant tenant) throws TenantManagementServerException {
        RealmService realmService = TenantMgtServiceComponent.getRealmService();
        try {
            realmService.getTenantUserRealm(tenant.getId());
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error while adding tenant admin user.", (Exception)((Object)e));
        }
    }

    private Date createDate() {
        long createdDate = System.currentTimeMillis();
        return new Date(createdDate);
    }

    private void notifyTenantAddition(TenantInfoBean tenantInfoBean) throws TenantMgtException {
        try {
            TenantMgtUtil.triggerAddTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant addition.";
            throw new TenantMgtException(msg, (Exception)((Object)e));
        }
    }

    private void checkIsSuperTenantInvoking() throws TenantManagementServerException {
        UserRegistry userRegistry = (UserRegistry)CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        if (userRegistry == null) {
            throw new TenantManagementServerException("Invalid data. Security Alert! User registry is null. A user is trying create a tenant without an authenticated session.");
        }
        if (userRegistry.getTenantId() != -1234) {
            throw new TenantManagementServerException("Invalid data. Security Alert! Non super tenant trying to create a tenant.");
        }
    }

    private void setParameters(Integer limit, Integer offset, String sortOrder, String sortBy, String filter, TenantSearchResult result) throws TenantManagementClientException {
        result.setLimit(this.validateLimit(limit));
        result.setOffSet(this.validateOffset(offset));
        result.setSortOrder(this.validateSortOrder(sortOrder));
        result.setSortBy(this.validateSortBy(sortBy));
        result.setFilter(filter);
    }

    private String validateSortBy(String sortBy) {
        if (StringUtils.isBlank((String)sortBy)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"sortBy attribute is empty. Therefore we set the default sortBy attribute: UM_DOMAIN_NAME");
            }
            return DEFAULT_SORT_BY;
        }
        switch (sortBy) {
            case "domainName": {
                sortBy = DEFAULT_SORT_BY;
                break;
            }
            default: {
                sortBy = DEFAULT_SORT_BY;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"sortBy attribute is incorrect. Therefore we set the default sortBy attribute. sortBy: UM_DOMAIN_NAME");
            }
        }
        return sortBy;
    }

    private String validateSortOrder(String sortOrder) {
        if (StringUtils.isBlank((String)sortOrder)) {
            sortOrder = ASC_SORT_ORDER;
            if (log.isDebugEnabled()) {
                log.debug((Object)"sortOrder is empty. Therefore we set the default sortOrder value as: ASC");
            }
        } else if (!sortOrder.equals(DESC_SORT_ORDER) && !sortOrder.equals(ASC_SORT_ORDER)) {
            sortOrder = ASC_SORT_ORDER;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sortOrder is incorrect. Therefore we set the default sortOrder value as: ASC. SortOrder: " + sortOrder));
            }
        }
        return sortOrder;
    }

    private int validateLimit(Integer limit) throws TenantManagementClientException {
        if (limit == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given limit is null. Therefore we get the default limit from carbon.xml.");
            }
            limit = TenantMgtUtil.getDefaultItemsPerPage();
        }
        if (limit < 0) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_INVALID_LIMIT);
        }
        int maxLimit = TenantMgtUtil.getMaximumItemPerPage();
        if (limit > maxLimit) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Given limit exceed the maximum limit. Therefore we get the default max limit: " + maxLimit + " from carbon.xml."));
            }
            limit = maxLimit;
        }
        return limit;
    }

    private int validateOffset(Integer offset) throws TenantManagementClientException {
        if (offset == null) {
            offset = 0;
        }
        if (offset < 0) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_INVALID_OFFSET);
        }
        return offset;
    }

    private User createOwner(Tenant tenant) throws TenantManagementServerException {
        User owner = new User();
        owner.setUsername(tenant.getAdminName());
        owner.setUserID(tenant.getAdminUserId());
        return owner;
    }

    private Tenant getTenantFromTenantManager(String tenantUniqueID) throws TenantManagementServerException {
        Tenant tenant;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenant = tenantManager.getTenant(tenantUniqueID);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new TenantManagementServerException("Error while getting the tenant: " + tenantUniqueID + " .", (Exception)((Object)e));
        }
        return tenant;
    }
}

