/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.beans.PaginatedTenantInfoBean;
import org.wso2.carbon.tenant.mgt.core.TenantPersistor;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

public class TenantMgtAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(TenantMgtAdminService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addTenant(TenantInfoBean tenantInfoBean) throws Exception {
        try {
            CommonUtil.validateEmail((String)tenantInfoBean.getEmail());
        }
        catch (Exception e) {
            String msg = "Invalid email is provided.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String tenantDomain = tenantInfoBean.getTenantDomain();
        TenantMgtUtil.validateDomain(tenantDomain);
        this.checkIsSuperTenantInvoking();
        TenantMgtUtil.setTenantAdminCreationOperation(true);
        org.wso2.carbon.user.core.tenant.Tenant tenant = TenantMgtUtil.initializeTenant(tenantInfoBean);
        tenant.setTenantUniqueID(UUIDGenerator.generateUUID());
        TenantPersistor persistor = new TenantPersistor();
        int tenantId = persistor.persistTenant(tenant, false, tenantInfoBean.getSuccessKey(), tenantInfoBean.getOriginatedService(), false);
        tenantInfoBean.setTenantId(tenantId);
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenantDomain);
            carbonContext.setTenantId(tenantId);
            TenantMgtUtil.addClaimsToUserStoreManager(tenant);
        }
        finally {
            TenantMgtUtil.clearTenantAdminCreationOperation();
            PrivilegedCarbonContext.endTenantFlow();
        }
        this.notifyTenantAddition(tenantInfoBean);
        TenantMgtUtil.activateTenantInitially(tenantInfoBean, tenantId);
        log.info((Object)("Added the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
        TenantMgtUtil.prepareStringToShowThemeMgtPage(tenant.getId(), tenant.getTenantUniqueID());
        return tenant.getTenantUniqueID();
    }

    public boolean checkDomainAvailability(String domainName) throws Exception {
        if ("carbon.super".equals(domainName)) {
            return false;
        }
        TenantMgtUtil.validateDomain(domainName);
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        int tenantId = tenantManager.getTenantId(domainName);
        if (tenantId == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant Domain " + domainName + " is available to register."));
            }
            return true;
        }
        return false;
    }

    private void notifyTenantAddition(TenantInfoBean tenantInfoBean) throws Exception {
        try {
            TenantMgtUtil.triggerAddTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant addition.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private void checkIsSuperTenantInvoking() throws Exception {
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceRegistry();
        if (userRegistry == null) {
            log.error((Object)"Security Alert! User registry is null. A user is trying create a tenant  without an authenticated session.");
            throw new Exception("Invalid data.");
        }
        if (userRegistry.getTenantId() != -1234) {
            log.error((Object)"Security Alert! Non super tenant trying to create a tenant.");
            throw new Exception("Invalid data.");
        }
    }

    public String addSkeletonTenant(TenantInfoBean tenantInfoBean) throws Exception {
        int tenantId;
        this.checkIsSuperTenantInvoking();
        try {
            tenantId = TenantMgtServiceComponent.getTenantManager().getTenantId(tenantInfoBean.getTenantDomain());
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Error in getting tenant id";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        if (tenantId < 0) {
            String msg = "Tenant is not added in user store. Tenant domain: " + tenantInfoBean.getTenantDomain();
            log.error((Object)msg);
            throw new Exception(msg);
        }
        org.wso2.carbon.user.core.tenant.Tenant tenant = TenantMgtUtil.initializeTenant(tenantInfoBean);
        tenant.setId(tenantId);
        TenantPersistor persistor = new TenantPersistor();
        persistor.persistTenant(tenant, false, tenantInfoBean.getSuccessKey(), tenantInfoBean.getOriginatedService(), true);
        tenantInfoBean.setTenantId(tenantId);
        this.notifyTenantAddition(tenantInfoBean);
        return TenantMgtUtil.prepareStringToShowThemeMgtPage(tenantId);
    }

    private List<TenantInfoBean> getAllTenants() throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant[] tenants;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenants = (org.wso2.carbon.user.core.tenant.Tenant[])tenantManager.getAllTenants();
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        ArrayList<TenantInfoBean> tenantList = new ArrayList<TenantInfoBean>();
        for (org.wso2.carbon.user.core.tenant.Tenant tenant : tenants) {
            TenantInfoBean bean = TenantMgtUtil.getTenantInfoBeanfromTenant(tenant.getId(), tenant);
            tenantList.add(bean);
        }
        return tenantList;
    }

    private List<TenantInfoBean> searchPartialTenantsDomains(String domain) throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant[] tenants;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            domain = domain.trim();
            tenants = (org.wso2.carbon.user.core.tenant.Tenant[])tenantManager.getAllTenantsForTenantDomainStr(domain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        ArrayList<TenantInfoBean> tenantList = new ArrayList<TenantInfoBean>();
        for (org.wso2.carbon.user.core.tenant.Tenant tenant : tenants) {
            TenantInfoBean bean = TenantMgtUtil.getTenantInfoBeanfromTenant(tenant.getId(), tenant);
            tenantList.add(bean);
        }
        return tenantList;
    }

    public TenantInfoBean[] retrieveTenants() throws Exception {
        List<TenantInfoBean> tenantList = this.getAllTenants();
        return tenantList.toArray(new TenantInfoBean[tenantList.size()]);
    }

    public TenantInfoBean[] retrievePartialSearchTenants(String domain) throws Exception {
        List<TenantInfoBean> tenantList = this.searchPartialTenantsDomains(domain);
        return tenantList.toArray(new TenantInfoBean[tenantList.size()]);
    }

    public PaginatedTenantInfoBean retrievePaginatedPartialSearchTenants(String domain, int pageNumber) throws Exception {
        List<TenantInfoBean> tenantList = this.searchPartialTenantsDomains(domain);
        PaginatedTenantInfoBean paginatedTenantInfoBean = new PaginatedTenantInfoBean();
        DataPaginator.doPaging((int)pageNumber, tenantList, (Pageable)paginatedTenantInfoBean);
        return paginatedTenantInfoBean;
    }

    public PaginatedTenantInfoBean retrievePaginatedTenants(int pageNumber) throws Exception {
        List<TenantInfoBean> tenantList = this.getAllTenants();
        PaginatedTenantInfoBean paginatedTenantInfoBean = new PaginatedTenantInfoBean();
        DataPaginator.doPaging((int)pageNumber, tenantList, (Pageable)paginatedTenantInfoBean);
        return paginatedTenantInfoBean;
    }

    public TenantInfoBean getTenant(String tenantDomain) throws Exception {
        org.wso2.carbon.user.core.tenant.Tenant tenant;
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
        try {
            tenant = (org.wso2.carbon.user.core.tenant.Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant from the tenant manager.";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
        TenantInfoBean bean = TenantMgtUtil.initializeTenantInfoBean(tenantId, tenant);
        bean.setFirstname(ClaimsMgtUtil.getFirstNamefromUserStoreManager((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
        bean.setLastname(ClaimsMgtUtil.getLastNamefromUserStoreManager((RealmService)TenantMgtServiceComponent.getRealmService(), (int)tenantId));
        String activePlan = "";
        if (TenantMgtServiceComponent.getBillingService() != null) {
            activePlan = TenantMgtServiceComponent.getBillingService().getActiveUsagePlan(tenantDomain);
        }
        if (activePlan != null && activePlan.trim().length() > 0) {
            bean.setUsagePlan(activePlan);
        } else {
            bean.setUsagePlan("");
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenant(TenantInfoBean tenantInfoBean) throws Exception {
        String msg;
        org.wso2.carbon.user.core.tenant.Tenant tenant;
        int tenantId;
        String tenantDomain;
        TenantManager tenantManager;
        block26: {
            tenantManager = TenantMgtServiceComponent.getTenantManager();
            UserRegistry configSystemRegistry = TenantMgtServiceComponent.getConfigSystemRegistry(tenantInfoBean.getTenantId());
            tenantDomain = tenantInfoBean.getTenantDomain();
            try {
                tenantId = tenantManager.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                String msg2 = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
                log.error((Object)msg2, (Throwable)e);
                throw new Exception(msg2, e);
            }
            try {
                tenant = (org.wso2.carbon.user.core.tenant.Tenant)tenantManager.getTenant(tenantId);
            }
            catch (UserStoreException e) {
                String msg3 = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
                log.error((Object)msg3, (Throwable)e);
                throw new Exception(msg3, e);
            }
            if (tenantInfoBean.getFirstname() != null && !tenantInfoBean.getFirstname().trim().equals("")) {
                try {
                    CommonUtil.validateName((String)tenantInfoBean.getFirstname(), (String)"First Name");
                }
                catch (Exception e) {
                    String msg4 = "Invalid first name is provided.";
                    log.error((Object)msg4, (Throwable)e);
                    throw new Exception(msg4, e);
                }
            }
            if (tenantInfoBean.getLastname() != null && !tenantInfoBean.getLastname().trim().equals("")) {
                try {
                    CommonUtil.validateName((String)tenantInfoBean.getLastname(), (String)"Last Name");
                }
                catch (Exception e) {
                    String msg5 = "Invalid last name is provided.";
                    log.error((Object)msg5, (Throwable)e);
                    throw new Exception(msg5, e);
                }
            }
            tenant.setAdminFirstName(tenantInfoBean.getFirstname());
            tenant.setAdminLastName(tenantInfoBean.getLastname());
            try {
                UserStoreManager userStoreManager;
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setTenantId(tenantId);
                TenantMgtUtil.addClaimsToUserStoreManager(tenant);
                if (StringUtils.isNotBlank((String)tenantInfoBean.getEmail())) {
                    try {
                        CommonUtil.validateEmail((String)tenantInfoBean.getEmail());
                    }
                    catch (Exception e) {
                        String msg6 = "Invalid email is provided.";
                        log.error((Object)msg6, (Throwable)e);
                        throw new Exception(msg6, e);
                    }
                    tenant.setEmail(tenantInfoBean.getEmail());
                }
                UserRealm userRealm = configSystemRegistry.getUserRealm();
                try {
                    userStoreManager = userRealm.getUserStoreManager();
                }
                catch (UserStoreException e) {
                    String msg7 = "Error in getting the user store manager for tenant, tenant domain: " + tenantDomain + ".";
                    log.error((Object)msg7, (Throwable)e);
                    throw new Exception(msg7, e);
                }
                boolean updatePassword = false;
                if (StringUtils.isNotBlank((String)tenantInfoBean.getAdminPassword())) {
                    updatePassword = true;
                }
                if (!userStoreManager.isReadOnly() && updatePassword) {
                    try {
                        userStoreManager.updateCredentialByAdmin(tenantInfoBean.getAdmin(), (Object)tenantInfoBean.getAdminPassword());
                        break block26;
                    }
                    catch (UserStoreException e) {
                        String msg8 = "Error in changing the tenant admin password, tenant domain: " + tenantInfoBean.getTenantDomain() + ". " + e.getMessage() + " for: " + tenantInfoBean.getAdmin();
                        log.error((Object)msg8, (Throwable)e);
                        throw new Exception(msg8, e);
                    }
                }
                tenantInfoBean.setAdminPassword("");
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        try {
            tenantManager.updateTenant((Tenant)tenant);
        }
        catch (UserStoreException e) {
            msg = "Error in updating the tenant for tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            TenantMgtUtil.triggerUpdateTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            msg = "Error in notifying tenant update.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        log.info((Object)("Updated the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
    }

    public void activateTenant(String tenantDomain) throws Exception {
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        TenantMgtUtil.activateTenant(tenantDomain, tenantManager, tenantId);
        try {
            TenantMgtUtil.triggerTenantActivation(tenantId);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant activate.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        log.info((Object)("Activated the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
    }

    public void deactivateTenant(String tenantDomain) throws Exception {
        int tenantId;
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant id for the tenant domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        TenantMgtUtil.deactivateTenant(tenantDomain, tenantManager, tenantId);
        try {
            TenantMgtUtil.triggerTenantDeactivation(tenantId);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant deactivate.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        log.info((Object)("Deactivated the tenant '" + tenantDomain + " [" + tenantId + "]' by '" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "'"));
    }

    public void deleteTenant(String tenantDomain) throws StratosException, org.wso2.carbon.user.api.UserStoreException {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        if (tenantManager != null) {
            int tenantId = tenantManager.getTenantId(tenantDomain);
            try {
                ServerConfigurationService serverConfigurationService;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Starting tenant deletion for domain: %s and tenant id: %d from the system", tenantDomain, tenantId));
                }
                if (Boolean.parseBoolean((serverConfigurationService = TenantMgtServiceComponent.getServerConfigurationService()).getFirstProperty("Tenant.TenantDelete"))) {
                    TenantMgtUtil.deleteTenant(tenantDomain);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant.TenantDelete flag is set to false in carbon.xml. Hence the tenant will not be deleted.");
                }
            }
            catch (Exception e) {
                String msg = String.format("Deleted tenant with domain: %s and tenant id: %d from the system.", tenantDomain, tenantId);
                log.error((Object)msg, (Throwable)e);
                throw new StratosException(msg, (Throwable)e);
            }
        }
    }
}

