/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.realm;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tenant.mgt.realm.CloudWSRealmConfigBuilder;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;

public class IdaasWSRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static final Log log = LogFactory.getLog(CloudWSRealmConfigBuilder.class);

    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        RealmConfiguration realmConfig;
        try {
            realmConfig = persistedConfig;
            Map realmProps = realmConfig.getRealmProperties();
            Map bootStrapProps = bootStrapConfig.getRealmProperties();
            realmProps.put("url", bootStrapProps.get("url"));
            realmProps.put("driverName", bootStrapProps.get("driverName"));
            realmProps.put("userName", bootStrapProps.get("userName"));
            realmProps.put("password", bootStrapProps.get("password"));
            realmConfig.setTenantId(tenantId);
            if (log.isDebugEnabled()) {
                OMElement omElement = RealmConfigXMLProcessor.serialize((RealmConfiguration)realmConfig);
                log.debug((Object)("Creating realm from **** " + omElement.toString()));
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UserStoreException(msg);
        }
        return realmConfig;
    }

    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return null;
    }

    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        return null;
    }
}

