/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.TenantBillingService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.tenant.mgt", immediate=true)
public class TenantMgtServiceComponent {
    private static Log log = LogFactory.getLog(TenantMgtServiceComponent.class);
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ConfigurationContextService configurationContextService;
    private static ServerConfigurationService serverConfigurationService;
    private static List<TenantMgtListener> tenantMgtListeners;
    private static TenantBillingService billingService;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            if (CommonUtil.getStratosConfig() == null) {
                StratosConfiguration stratosConfig = CommonUtil.loadStratosConfiguration();
                CommonUtil.setStratosConfig((StratosConfiguration)stratosConfig);
            }
            if (CommonUtil.getEula() == null) {
                String eula = CommonUtil.loadTermsOfUsage();
                CommonUtil.setEula((String)eula);
            }
            log.debug((Object)"******* Tenant Config bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Tenant Config bundle failed activating ****", (Throwable)e);
        }
    }

    @Reference(name="org.wso2.carbon.tenant.mgt.listener.service", service=TenantMgtListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantMgtListenerService")
    protected void setTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        TenantMgtServiceComponent.addTenantMgtListener(tenantMgtListener);
    }

    protected void unsetTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        TenantMgtServiceComponent.removeTenantMgtListener(tenantMgtListener);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Governance Tenant Config bundle is deactivated ******* ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        TenantMgtServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        TenantMgtServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        TenantMgtServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        this.setConfigurationContextService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        log.debug((Object)"Receiving ServerConfiguration Service");
        TenantMgtServiceComponent.serverConfigurationService = serverConfigurationService;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        log.debug((Object)"Unsetting ServerConfiguration Service");
        this.setServerConfigurationService(null);
    }

    public static void addTenantMgtListener(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.add(tenantMgtListener);
        TenantMgtServiceComponent.sortTenantMgtListeners();
    }

    public static void removeTenantMgtListener(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.remove(tenantMgtListener);
        TenantMgtServiceComponent.sortTenantMgtListeners();
    }

    public static void sortTenantMgtListeners() {
        Collections.sort(tenantMgtListeners, new Comparator<TenantMgtListener>(){

            @Override
            public int compare(TenantMgtListener o1, TenantMgtListener o2) {
                return o1.getListenerOrder() - o2.getListenerOrder();
            }
        });
    }

    public static List<TenantMgtListener> getTenantMgtListeners() {
        return tenantMgtListeners;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    public static UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getGovernanceSystemRegistry(tenantId);
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    @Reference(name="default.tenant.billing.service", service=TenantBillingService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantBillingService")
    protected void setTenantBillingService(TenantBillingService tenantBillingService) {
        billingService = tenantBillingService;
    }

    protected void unsetTenantBillingService(TenantBillingService tenantBilling) {
        this.setTenantBillingService(null);
    }

    public static TenantBillingService getBillingService() {
        return billingService;
    }

    static {
        tenantMgtListeners = new ArrayList<TenantMgtListener>();
        billingService = null;
    }
}

