/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.logger;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public final class LoggerEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(LoggerEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;

    public LoggerEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String uniqueIdentification = dynamicProperties.get("uniqueId");
        if (uniqueIdentification == null || uniqueIdentification.trim().isEmpty()) {
            uniqueIdentification = this.eventAdapterConfiguration.getName();
        }
        if (message instanceof Object[]) {
            log.info((Object)("Unique ID: " + uniqueIdentification + ",\n Event: " + Arrays.deepToString((Object[])message)));
        } else {
            log.info((Object)("Unique ID: " + uniqueIdentification + ",\n Event: " + message));
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }
}

