/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.util.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterSchema;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.publisher.core.internal.type.json.JSONOutputMapperConfigurationBuilder;
import org.wso2.carbon.event.publisher.core.internal.type.map.MapOutputMapperConfigurationBuilder;
import org.wso2.carbon.event.publisher.core.internal.type.text.TextOutputMapperConfigurationBuilder;
import org.wso2.carbon.event.publisher.core.internal.type.wso2event.WSO2EventOutputMapperConfigurationBuilder;
import org.wso2.carbon.event.publisher.core.internal.type.xml.XMLOutputMapperConfigurationBuilder;

public class EventPublisherConfigurationHelper {
    private static final Log log = LogFactory.getLog(EventPublisherConfigurationHelper.class);

    public static void validateEventPublisherConfiguration(OMElement eventPublisherOMElement) throws EventPublisherConfigurationException, EventPublisherValidationException {
        if (!eventPublisherOMElement.getLocalName().equals("eventPublisher")) {
            throw new EventPublisherConfigurationException("Invalid event publisher configuration.");
        }
        if (eventPublisherOMElement.getAttributeValue(new QName("name")) == null || eventPublisherOMElement.getAttributeValue(new QName("name")).trim().isEmpty()) {
            throw new EventPublisherConfigurationException("Need to have an eventPublisher name");
        }
        String eventPublisherName = eventPublisherOMElement.getAttributeValue(new QName("name"));
        Iterator childElements = eventPublisherOMElement.getChildElements();
        int count = 0;
        while (childElements.hasNext()) {
            ++count;
            childElements.next();
        }
        if (count != 3) {
            throw new EventPublisherConfigurationException("Not a valid configuration, Event Publisher Configuration can only contains 3 child tags (From,Mapping & To), for " + eventPublisherName);
        }
        OMElement fromElement = eventPublisherOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "from"));
        OMElement mappingElement = eventPublisherOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "mapping"));
        OMElement toElement = eventPublisherOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
        if (fromElement == null || mappingElement == null || toElement == null) {
            throw new EventPublisherConfigurationException("Invalid event publisher configuration for event publisher: " + eventPublisherName);
        }
        Iterator fromPropertyIter = eventPublisherOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "from"));
        OMElement fromPropertyOMElement = null;
        count = 0;
        while (fromPropertyIter.hasNext()) {
            fromPropertyOMElement = (OMElement)fromPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventPublisherConfigurationException("There can be only one 'From' element in Event Publisher configuration " + eventPublisherName);
        }
        String fromStreamName = fromPropertyOMElement.getAttributeValue(new QName("streamName"));
        String fromStreamVersion = fromPropertyOMElement.getAttributeValue(new QName("version"));
        if (fromStreamName == null || fromStreamName.isEmpty() || fromStreamVersion == null || fromStreamName.isEmpty()) {
            throw new EventPublisherConfigurationException("There should be stream name and version in the 'From' element, of " + eventPublisherName);
        }
        Iterator mappingPropertyIter = eventPublisherOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "mapping"));
        OMElement mappingPropertyOMElement = null;
        count = 0;
        while (mappingPropertyIter.hasNext()) {
            mappingPropertyOMElement = (OMElement)mappingPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventPublisherConfigurationException("There can be only one 'Mapping' element in Event Publisher configuration " + eventPublisherName);
        }
        String mappingType = mappingPropertyOMElement.getAttributeValue(new QName("type"));
        if (mappingType == null || mappingType.isEmpty()) {
            throw new EventPublisherConfigurationException("There should be proper mapping type in Event Publisher configuration " + eventPublisherName);
        }
        EventPublisherConfigurationHelper.validateMappingProperties(mappingElement, mappingType);
        Iterator toPropertyIter = eventPublisherOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
        OMElement toPropertyOMElement = null;
        count = 0;
        while (toPropertyIter.hasNext()) {
            toPropertyOMElement = (OMElement)toPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventPublisherConfigurationException("There can be only one 'To' element in Event Publisher configuration file.");
        }
        String toEventAdapterType = toPropertyOMElement.getAttributeValue(new QName("eventAdapterType"));
        if (toEventAdapterType == null || toEventAdapterType.isEmpty()) {
            throw new EventPublisherConfigurationException("There should be a event adapter type in Publisher configuration file.");
        }
        if (!EventPublisherConfigurationHelper.validateToPropertyConfiguration(toPropertyOMElement, toEventAdapterType)) {
            throw new EventPublisherConfigurationException("To property does not contains all the required values for event adapter type " + toEventAdapterType);
        }
    }

    public static void validateMappingProperties(OMElement mappingElement, String mappingType) throws EventPublisherConfigurationException {
        if (mappingType.equalsIgnoreCase("wso2event")) {
            WSO2EventOutputMapperConfigurationBuilder.validateWso2EventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("text")) {
            TextOutputMapperConfigurationBuilder.validateTextMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("map")) {
            MapOutputMapperConfigurationBuilder.validateMapEventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("xml")) {
            XMLOutputMapperConfigurationBuilder.validateXMLEventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("json")) {
            JSONOutputMapperConfigurationBuilder.validateJsonEventMapping(mappingElement);
        } else {
            log.info((Object)("No validations available for output mapping type :" + mappingType));
        }
    }

    private static boolean validateToPropertyConfiguration(OMElement toElement, String eventAdapterType) throws EventPublisherConfigurationException {
        ArrayList<String> requiredProperties = new ArrayList<String>();
        ArrayList<String> propertiesInConfig = new ArrayList<String>();
        Iterator toElementPropertyIterator = toElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        OutputEventAdapterSchema adapterSchema = eventAdapterService.getOutputEventAdapterSchema(eventAdapterType);
        if (adapterSchema == null) {
            throw new EventPublisherValidationException("Event Adapter with type: " + eventAdapterType + " does not exist", eventAdapterType);
        }
        ArrayList propertyList = new ArrayList();
        if (adapterSchema.getDynamicPropertyList() != null) {
            propertyList.addAll(adapterSchema.getDynamicPropertyList());
        }
        if (adapterSchema.getDynamicPropertyList() != null) {
            propertyList.addAll(adapterSchema.getDynamicPropertyList());
        }
        if (propertyList.size() > 0) {
            for (Property property : propertyList) {
                if (!property.isRequired()) continue;
                requiredProperties.add(property.getPropertyName());
            }
            while (toElementPropertyIterator.hasNext()) {
                OMElement toElementProperty = (OMElement)toElementPropertyIterator.next();
                String propertyName = toElementProperty.getAttributeValue(new QName("name"));
                propertiesInConfig.add(propertyName);
            }
            if (!propertiesInConfig.containsAll(requiredProperties)) {
                return false;
            }
        }
        return true;
    }

    public static OutputEventAdapterConfiguration getOutputEventAdapterConfiguration(String eventAdapterType, String publisherName, String messageFormat) {
        OutputEventAdapterSchema schema = EventPublisherServiceValueHolder.getOutputEventAdapterService().getOutputEventAdapterSchema(eventAdapterType);
        OutputEventAdapterConfiguration outputEventAdapterConfiguration = new OutputEventAdapterConfiguration();
        outputEventAdapterConfiguration.setName(publisherName);
        outputEventAdapterConfiguration.setMessageFormat(messageFormat);
        outputEventAdapterConfiguration.setType(eventAdapterType);
        HashMap<String, String> staticProperties = new HashMap<String, String>();
        if (schema != null && schema.getStaticPropertyList() != null) {
            for (Property property : schema.getStaticPropertyList()) {
                staticProperties.put(property.getPropertyName(), property.getDefaultValue());
            }
        }
        outputEventAdapterConfiguration.setStaticProperties(staticProperties);
        return outputEventAdapterConfiguration;
    }

    public static Map<String, String> getDynamicProperties(String eventAdapterType) {
        HashMap<String, String> dynamicProperties = new HashMap<String, String>();
        OutputEventAdapterSchema schema = EventPublisherServiceValueHolder.getOutputEventAdapterService().getOutputEventAdapterSchema(eventAdapterType);
        if (schema != null && schema.getDynamicPropertyList() != null) {
            for (Property property : schema.getDynamicPropertyList()) {
                dynamicProperties.put(property.getPropertyName(), property.getDefaultValue());
            }
        }
        return dynamicProperties;
    }

    public static String getOutputMappingType(OMElement eventPublisherOMElement) {
        OMElement mappingPropertyOMElement = eventPublisherOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "mapping"));
        return mappingPropertyOMElement.getAttributeValue(new QName("type"));
    }

    public static String getEventPublisherName(OMElement eventPublisherOMElement) {
        return eventPublisherOMElement.getAttributeValue(new QName("name"));
    }

    public static boolean validateEncryptedProperties(OMElement eventAdapterConfigOMElement) {
        String adaptorType = eventAdapterConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to")).getAttributeValue(new QName("eventAdapterType"));
        List<String> encryptedProperties = EventPublisherServiceValueHolder.getCarbonEventPublisherService().getEncryptedProperties(adaptorType);
        Iterator propertyIter = eventAdapterConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to")).getChildrenWithName(new QName("property"));
        while (propertyIter.hasNext()) {
            OMElement propertyOMElement = (OMElement)propertyIter.next();
            String name = propertyOMElement.getAttributeValue(new QName("name"));
            String value = propertyOMElement.getText();
            if (!encryptedProperties.contains(name.trim())) continue;
            OMAttribute encryptedAttribute = propertyOMElement.getAttribute(new QName("encrypted"));
            if (value == null || value.length() <= 0 || encryptedAttribute != null && "true".equals(encryptedAttribute.getAttributeValue())) continue;
            return false;
        }
        return true;
    }
}

