/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.util.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.publisher.core.EventPublisherDeployer;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.publisher.core.internal.util.helper.XmlFormatter;

public class EventPublisherConfigurationFilesystemInvoker {
    private static final Log log = LogFactory.getLog(EventPublisherConfigurationFilesystemInvoker.class);

    public static void encryptAndSave(OMElement eventAdaptorElement, String fileName) throws EventPublisherConfigurationException {
        String adaptorType = eventAdaptorElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to")).getAttributeValue(new QName("eventAdapterType"));
        List<String> encryptedProperties = EventPublisherServiceValueHolder.getCarbonEventPublisherService().getEncryptedProperties(adaptorType);
        Iterator propertyIter = eventAdaptorElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to")).getChildrenWithName(new QName("property"));
        if (propertyIter.hasNext()) {
            while (propertyIter.hasNext()) {
                OMAttribute encryptedAttribute;
                OMElement propertyOMElement = (OMElement)propertyIter.next();
                String name = propertyOMElement.getAttributeValue(new QName("name"));
                if (!encryptedProperties.contains(name.trim()) || (encryptedAttribute = propertyOMElement.getAttribute(new QName("encrypted"))) != null && "true".equals(encryptedAttribute.getAttributeValue())) continue;
                String value = propertyOMElement.getText();
                try {
                    value = new String(CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(value.getBytes()));
                    propertyOMElement.setText(value);
                    propertyOMElement.addAttribute("encrypted", "true", null);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to decrypt the encrypted field: " + name + " for adaptor type: " + adaptorType));
                    propertyOMElement.setText("");
                }
            }
        }
        EventPublisherConfigurationFilesystemInvoker.save(eventAdaptorElement, fileName);
    }

    public static void save(OMElement eventPublisherOMElement, String fileName) throws EventPublisherConfigurationException {
        EventPublisherConfigurationFilesystemInvoker.save(eventPublisherOMElement.toString(), fileName);
    }

    public static void save(String eventPublisher, String fileName) throws EventPublisherConfigurationException {
        AxisConfiguration axisConfiguration = EventPublisherUtil.getAxisConfiguration();
        EventPublisherDeployer eventPublisherDeployer = (EventPublisherDeployer)EventPublisherConfigurationFilesystemInvoker.getDeployer(axisConfiguration, "eventpublishers");
        EventPublisherUtil.validateFilePath(fileName);
        String filePath = EventPublisherConfigurationFilesystemInvoker.getFilePathFromFilename(fileName, axisConfiguration);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
            new XmlFormatter();
            String xmlContent = XmlFormatter.format(eventPublisher);
            eventPublisherDeployer.getDeployedEventPublisherFilePaths().add(filePath);
            out.write(xmlContent);
            out.close();
            log.info((Object)("Event Publisher configuration saved in the filesystem : " + new File(filePath).getName()));
            eventPublisherDeployer.executeManualDeployment(filePath);
        }
        catch (IOException e) {
            eventPublisherDeployer.getDeployedEventPublisherFilePaths().remove(filePath);
            log.error((Object)("Could not save Event Publisher configuration : " + fileName), (Throwable)e);
            throw new EventPublisherConfigurationException("Error while saving ", e);
        }
    }

    public static void delete(String fileName) throws EventPublisherConfigurationException {
        try {
            AxisConfiguration axisConfiguration = EventPublisherUtil.getAxisConfiguration();
            EventPublisherUtil.validateFilePath(fileName);
            String filePath = EventPublisherConfigurationFilesystemInvoker.getFilePathFromFilename(fileName, axisConfiguration);
            File file = new File(filePath);
            if (file.exists()) {
                EventPublisherDeployer deployer = (EventPublisherDeployer)EventPublisherConfigurationFilesystemInvoker.getDeployer(axisConfiguration, "eventpublishers");
                deployer.getUndeployedEventPublisherFilePaths().add(filePath);
                boolean fileDeleted = file.delete();
                if (!fileDeleted) {
                    log.error((Object)("Could not delete Event Publisher configuration : " + fileName));
                    deployer.getUndeployedEventPublisherFilePaths().remove(filePath);
                } else {
                    log.info((Object)("Event Publisher configuration deleted from the file system : " + fileName));
                    deployer.executeManualUndeployment(filePath);
                }
            }
        }
        catch (Exception e) {
            throw new EventPublisherConfigurationException("Error while deleting the Event Publisher : " + e.getMessage(), e);
        }
    }

    public static boolean isEventPublisherConfigurationFileExists(String fileName, AxisConfiguration axisConfiguration) throws EventPublisherConfigurationException {
        EventPublisherUtil.validateFilePath(fileName);
        String filePath = EventPublisherConfigurationFilesystemInvoker.getFilePathFromFilename(fileName, axisConfiguration);
        File file = new File(filePath);
        return file.exists();
    }

    public static void reload(String filePath, Map<Integer, EventPublisherDeployer> tenantSpecificDeployerMap) throws EventPublisherConfigurationException {
        EventPublisherDeployer deployer = tenantSpecificDeployerMap.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true));
        try {
            deployer.processUndeployment(filePath);
            deployer.processDeployment(new DeploymentFileData(new File(filePath)));
        }
        catch (DeploymentException e) {
            throw new EventPublisherConfigurationException(e);
        }
    }

    public static String readEventPublisherConfigurationFile(String fileName) throws EventPublisherConfigurationException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            AxisConfiguration axisConfiguration = EventPublisherUtil.getAxisConfiguration();
            EventPublisherUtil.validateFilePath(fileName);
            String filePath = EventPublisherConfigurationFilesystemInvoker.getFilePathFromFilename(fileName, axisConfiguration);
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new EventPublisherConfigurationException("Event publisher file not found : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EventPublisherConfigurationException("Cannot read the Event Publisher file : " + e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
            }
        }
        return stringBuilder.toString().trim();
    }

    private static Deployer getDeployer(AxisConfiguration axisConfig, String endpointDirPath) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        return deploymentEngine.getDeployer(endpointDirPath, "xml");
    }

    private static String getFilePathFromFilename(String filename, AxisConfiguration axisConfiguration) {
        return new File(EventAdapterUtil.getAxisConfiguration().getRepository().getPath()).getAbsolutePath() + File.separator + "eventpublishers" + File.separator + filename;
    }
}

