/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;

public class RuntimeResourceLoader {
    private static final long DEFAULT_TIMEOUT_DURATION = 15L;
    private final LoadingCache<String, String> cache;
    private Map<String, Integer> propertyPositionMap = null;

    public RuntimeResourceLoader(long cacheTimeoutDuration, Map<String, Integer> propertyPositionMap) {
        this.propertyPositionMap = propertyPositionMap;
        if (cacheTimeoutDuration < 0L) {
            cacheTimeoutDuration = 15L;
        }
        CacheLoader<String, String> loader = new CacheLoader<String, String>(){

            public String load(String path) throws EventPublisherConfigurationException {
                return EventPublisherServiceValueHolder.getCarbonEventPublisherService().getRegistryResourceContent(path);
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeoutDuration, TimeUnit.MINUTES).build((CacheLoader)loader);
    }

    public String getResourceContent(String path) throws EventPublisherConfigurationException {
        try {
            return (String)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new EventPublisherConfigurationException("Error in getting cached resource", e);
        }
    }
}

