/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherStreamValidationException;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;

public class EventPublisherUtil {
    private static final String JVM_BIT_ARCH_SYSTEM_PROPERTY = "sun.arch.data.model";
    private static int referenceSize;
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static final Log log;

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateFilePath(String eventPublisherName, String repositoryPath) throws EventPublisherConfigurationException {
        String path;
        File subDir;
        File repoDir = new File(repositoryPath);
        if (!repoDir.exists()) {
            String string = repositoryPath.intern();
            synchronized (string) {
                if (!repoDir.exists() && !repoDir.mkdir()) {
                    throw new EventPublisherConfigurationException("Cannot create directory to add tenant specific event publisher :" + eventPublisherName);
                }
            }
        }
        if (!(subDir = new File(path = repoDir.getAbsolutePath() + File.separator + "eventpublishers")).exists()) {
            String string = path.intern();
            synchronized (string) {
                if (!subDir.exists() && !subDir.mkdir()) {
                    throw new EventPublisherConfigurationException("Cannot create directory eventpublishers to add tenant specific event publisher :" + eventPublisherName);
                }
            }
        }
        return subDir.getAbsolutePath() + File.separator + eventPublisherName + ".xml";
    }

    public static String getImportedStreamIdFrom(EventPublisherConfiguration eventPublisherConfiguration) {
        String streamId = null;
        if (eventPublisherConfiguration != null && eventPublisherConfiguration.getFromStreamName() != null && !eventPublisherConfiguration.getFromStreamName().isEmpty()) {
            streamId = eventPublisherConfiguration.getFromStreamName() + ":" + (eventPublisherConfiguration.getFromStreamVersion() != null && !eventPublisherConfiguration.getFromStreamVersion().isEmpty() ? eventPublisherConfiguration.getFromStreamVersion() : "1.0.0");
        }
        return streamId;
    }

    public static AxisConfiguration getAxisConfiguration() {
        AxisConfiguration axisConfiguration = null;
        axisConfiguration = CarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234 ? EventPublisherServiceValueHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration() : TenantAxisUtils.getTenantAxisConfiguration((String)CarbonContext.getThreadLocalCarbonContext().getTenantDomain(), (ConfigurationContext)EventPublisherServiceValueHolder.getConfigurationContextService().getServerConfigContext());
        return axisConfiguration;
    }

    public static int getSize(org.wso2.siddhi.core.event.Event event) {
        int size = 8;
        size += EventPublisherUtil.getSize(event.getData());
        return ++size;
    }

    public static int getSize(Event event) {
        int size = 8;
        size += EventPublisherUtil.getSize(event.getStreamId());
        if (event.getMetaData() != null) {
            size += EventPublisherUtil.getSize(event.getMetaData());
        }
        if (event.getCorrelationData() != null) {
            size += EventPublisherUtil.getSize(event.getCorrelationData());
        }
        if (event.getPayloadData() != null) {
            size += EventPublisherUtil.getSize(event.getPayloadData());
        }
        size += referenceSize;
        if (event.getArbitraryDataMap() != null) {
            size += EventPublisherUtil.getSize(event.getArbitraryDataMap());
        }
        return size;
    }

    private static int getSize(Map<String, String> arbitraryDataMap) {
        int size = 0;
        if (arbitraryDataMap != null) {
            for (Map.Entry<String, String> entry : arbitraryDataMap.entrySet()) {
                size += EventPublisherUtil.getSize(entry.getKey());
                size += EventPublisherUtil.getSize(entry.getValue());
                size += referenceSize * 2;
            }
        }
        return size;
    }

    private static int getSize(Object[] objects) {
        int size = 0;
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof Integer) {
                size += 4;
                continue;
            }
            if (object instanceof Long) {
                size += 8;
                continue;
            }
            if (object instanceof Boolean) {
                ++size;
                continue;
            }
            if (object instanceof Double) {
                size += 8;
                continue;
            }
            if (object instanceof Float) {
                size += 4;
                continue;
            }
            if (!(object instanceof String)) continue;
            size += EventPublisherUtil.getSize(object.toString());
        }
        return size += referenceSize * objects.length;
    }

    public static int getSize(String value) {
        int size = 0;
        if (value != null) {
            try {
                size = value.getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                size = value.getBytes().length;
            }
        }
        return size;
    }

    public static org.wso2.siddhi.core.event.Event convertToSiddhiEvent(Event inputEvent, int inputStreamSize) {
        Object[] data = new Object[inputStreamSize];
        int dataArrayCount = 0;
        if (inputEvent.getMetaData() != null) {
            for (Object attribute : inputEvent.getMetaData()) {
                data[dataArrayCount++] = attribute;
            }
        }
        if (inputEvent.getCorrelationData() != null) {
            for (Object attribute : inputEvent.getCorrelationData()) {
                data[dataArrayCount++] = attribute;
            }
        }
        if (inputEvent.getPayloadData() != null) {
            for (Object attribute : inputEvent.getPayloadData()) {
                data[dataArrayCount++] = attribute;
            }
        }
        org.wso2.siddhi.core.event.Event event = new org.wso2.siddhi.core.event.Event(inputEvent.getTimeStamp(), data);
        Map map = inputEvent.getArbitraryDataMap();
        event.setArbitraryDataMap(map);
        return event;
    }

    public static void validateStreamDefinitionWithOutputProperties(String actualMappingText, Map<String, Integer> propertyPositionMap, Map<String, Object> arbitraryDataMap) throws EventPublisherConfigurationException {
        List<String> mappingProperties = EventPublisherUtil.getOutputMappingPropertyList(actualMappingText);
        for (String property : mappingProperties) {
            if (propertyPositionMap.containsKey(property) || arbitraryDataMap != null && arbitraryDataMap.containsKey(property)) continue;
            throw new EventPublisherStreamValidationException("Property " + property + " is neither in the input stream attributes nor in runtime arbitrary data map.");
        }
    }

    public static List<String> getOutputMappingPropertyList(String mappingText) throws EventPublisherConfigurationException {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        int prefixIndex = text.indexOf("{{");
        while (prefixIndex > 0) {
            int postFixIndex = text.indexOf("}}");
            if (postFixIndex <= prefixIndex) {
                throw new EventPublisherConfigurationException("Found template attribute prefix {{ without corresponding postfix }}. Please verify your template.");
            }
            mappingTextList.add(text.substring(prefixIndex + 2, postFixIndex));
            text = text.substring(postFixIndex + 2);
            prefixIndex = text.indexOf("{{");
        }
        return mappingTextList;
    }

    public static void validateFilePath(String fileName) throws EventPublisherConfigurationException {
        if (fileName.contains("../") || fileName.contains("..\\")) {
            throw new EventPublisherConfigurationException("File name contains restricted path elements. " + fileName);
        }
    }

    static {
        log = LogFactory.getLog(EventPublisherUtil.class);
        String arch = System.getProperty(JVM_BIT_ARCH_SYSTEM_PROPERTY);
        referenceSize = arch.equals("32") ? 4 : 8;
    }
}

