/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterSchema;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.OutputMapperFactory;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherStreamValidationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.publisher.core.internal.util.helper.EventPublisherConfigurationHelper;
import org.wso2.carbon.event.publisher.core.internal.util.helper.XmlFormatter;
import org.wso2.carbon.event.stream.core.EventStreamService;

public class EventPublisherConfigurationBuilder {
    private static final Log log = LogFactory.getLog(EventPublisherConfigurationBuilder.class);

    public static OMElement eventPublisherConfigurationToOM(EventPublisherConfiguration eventPublisherConfiguration) throws EventPublisherConfigurationException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement eventPublisherConfigElement = factory.createOMElement(new QName("eventPublisher"));
        eventPublisherConfigElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        eventPublisherConfigElement.addAttribute("name", eventPublisherConfiguration.getEventPublisherName(), null);
        if (eventPublisherConfiguration.isStatisticsEnabled()) {
            eventPublisherConfigElement.addAttribute("statistics", "enable", null);
        } else {
            eventPublisherConfigElement.addAttribute("statistics", "disable", null);
        }
        if (eventPublisherConfiguration.isTracingEnabled()) {
            eventPublisherConfigElement.addAttribute("trace", "enable", null);
        } else {
            eventPublisherConfigElement.addAttribute("trace", "disable", null);
        }
        if (eventPublisherConfiguration.isProcessingEnabled()) {
            eventPublisherConfigElement.addAttribute("processing", "enable", null);
        } else {
            eventPublisherConfigElement.addAttribute("processing", "disable", null);
        }
        OMElement fromOMElement = factory.createOMElement(new QName("from"));
        fromOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        fromOMElement.addAttribute("streamName", eventPublisherConfiguration.getFromStreamName(), null);
        fromOMElement.addAttribute("version", eventPublisherConfiguration.getFromStreamVersion(), null);
        eventPublisherConfigElement.addChild((OMNode)fromOMElement);
        OMElement mappingOMElement = EventPublisherServiceValueHolder.getMappingFactoryMap().get(eventPublisherConfiguration.getOutputMapping().getMappingType()).constructOMFromOutputMapping(eventPublisherConfiguration.getOutputMapping(), factory);
        eventPublisherConfigElement.addChild((OMNode)mappingOMElement);
        OMElement toOMElement = factory.createOMElement(new QName("to"));
        toOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        OutputEventAdapterConfiguration outputEventAdapterConfiguration = eventPublisherConfiguration.getToAdapterConfiguration();
        toOMElement.addAttribute("eventAdapterType", outputEventAdapterConfiguration.getType(), null);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (outputEventAdapterConfiguration.getStaticProperties() != null) {
            properties.putAll(outputEventAdapterConfiguration.getStaticProperties());
        }
        if (eventPublisherConfiguration.getToAdapterDynamicProperties() != null) {
            properties.putAll(eventPublisherConfiguration.getToAdapterDynamicProperties());
        }
        for (Map.Entry propertyEntry : properties.entrySet()) {
            if (propertyEntry.getValue() == null) continue;
            OMElement propertyElement = factory.createOMElement(new QName("property"));
            propertyElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
            propertyElement.addAttribute("name", (String)propertyEntry.getKey(), null);
            propertyElement.setText((String)propertyEntry.getValue());
            toOMElement.addChild((OMNode)propertyElement);
        }
        eventPublisherConfigElement.addChild((OMNode)toOMElement);
        try {
            String formattedXml = XmlFormatter.format(eventPublisherConfigElement.toString());
            eventPublisherConfigElement = AXIOMUtil.stringToOM((String)formattedXml);
        }
        catch (XMLStreamException e) {
            log.warn((Object)("Could not format OMElement properly." + eventPublisherConfigElement.toString()));
        }
        return eventPublisherConfigElement;
    }

    public static EventPublisherConfiguration getEventPublisherConfiguration(OMElement eventPublisherConfigOMElement, String mappingType, boolean isEditable, int tenantId) throws EventPublisherConfigurationException, EventPublisherValidationException {
        String fromStreamVersion;
        String processingEnabledAttribute;
        String statisticsEnabledAttribute;
        if (!eventPublisherConfigOMElement.getLocalName().equals("eventPublisher")) {
            throw new EventPublisherConfigurationException("Root element is not an event publisher.");
        }
        String publisherName = eventPublisherConfigOMElement.getAttributeValue(new QName("name"));
        boolean traceEnabled = false;
        boolean statisticsEnabled = false;
        boolean processingEnabled = true;
        String traceEnabledAttribute = eventPublisherConfigOMElement.getAttributeValue(new QName("trace"));
        if (traceEnabledAttribute != null && traceEnabledAttribute.equalsIgnoreCase("enable")) {
            traceEnabled = true;
        }
        if ((statisticsEnabledAttribute = eventPublisherConfigOMElement.getAttributeValue(new QName("statistics"))) != null && statisticsEnabledAttribute.equalsIgnoreCase("enable")) {
            statisticsEnabled = true;
        }
        if ((processingEnabledAttribute = eventPublisherConfigOMElement.getAttributeValue(new QName("processing"))) != null && processingEnabledAttribute.equalsIgnoreCase("disable")) {
            processingEnabled = false;
        }
        EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
        OMElement fromElement = eventPublisherConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "from"));
        OMElement mappingElement = eventPublisherConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "mapping"));
        OMElement toElement = eventPublisherConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
        String fromStreamName = fromElement.getAttributeValue(new QName("streamName"));
        if (!EventPublisherConfigurationBuilder.validateStreamDetails(fromStreamName, fromStreamVersion = fromElement.getAttributeValue(new QName("version")), tenantId)) {
            throw new EventPublisherStreamValidationException("Stream " + fromStreamName + ":" + fromStreamVersion + " does not exist", fromStreamName + ":" + fromStreamVersion);
        }
        String toEventAdapterType = toElement.getAttributeValue(new QName("eventAdapterType"));
        if (!EventPublisherConfigurationBuilder.validateEventAdapter(toEventAdapterType)) {
            throw new EventPublisherValidationException("Event Adapter with type: " + toEventAdapterType + " does not exist", toEventAdapterType);
        }
        Iterator toElementPropertyIterator = toElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
        OutputEventAdapterConfiguration outputEventAdapterConfiguration = EventPublisherConfigurationHelper.getOutputEventAdapterConfiguration(toEventAdapterType, publisherName, mappingType);
        Map<String, String> dynamicProperties = EventPublisherConfigurationHelper.getDynamicProperties(toEventAdapterType);
        while (toElementPropertyIterator.hasNext()) {
            OMElement toElementProperty = (OMElement)toElementPropertyIterator.next();
            String propertyName = toElementProperty.getAttributeValue(new QName("name"));
            String propertyValue = toElementProperty.getText();
            OMAttribute encryptedAttribute = toElementProperty.getAttribute(new QName("encrypted"));
            if (encryptedAttribute != null && "true".equals(encryptedAttribute.getAttributeValue())) {
                try {
                    propertyValue = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(propertyValue));
                }
                catch (CryptoException e) {
                    log.error((Object)("Unable to decrypt the encrypted field: " + propertyName + " in adaptor: " + outputEventAdapterConfiguration.getName()));
                    propertyValue = "";
                }
            }
            if (outputEventAdapterConfiguration.getStaticProperties().containsKey(propertyName)) {
                outputEventAdapterConfiguration.getStaticProperties().put(propertyName, propertyValue);
                continue;
            }
            if (dynamicProperties.containsKey(propertyName)) {
                dynamicProperties.put(propertyName, propertyValue);
                continue;
            }
            log.warn((Object)("To property " + propertyName + " with value " + propertyValue + " is dropped as its irrelevant of output adapter type:" + toEventAdapterType));
        }
        String toStreamName = "";
        String toStreamVersion = "";
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (mappingType.equalsIgnoreCase("wso2event") && customMappingEnabledAttribute != null && customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            OMElement toOMElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
            toStreamName = toOMElement.getAttributeValue(new QName("streamName"));
            toStreamVersion = toOMElement.getAttributeValue(new QName("version"));
        }
        if (toStreamName == null || toStreamName.isEmpty() || toStreamVersion == null || toStreamVersion.isEmpty()) {
            outputEventAdapterConfiguration.setOutputStreamIdOfWso2eventMessageFormat(fromStreamName + ":" + fromStreamVersion);
        } else {
            outputEventAdapterConfiguration.setOutputStreamIdOfWso2eventMessageFormat(toStreamName + ":" + toStreamVersion);
        }
        if (mappingType.equalsIgnoreCase("wso2event")) {
            if (!EventPublisherConfigurationBuilder.validateSupportedMapping(toEventAdapterType, "wso2event")) {
                throw new EventPublisherConfigurationException("WSO2Event Mapping is not supported by event adapter type " + toEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("text")) {
            if (!EventPublisherConfigurationBuilder.validateSupportedMapping(toEventAdapterType, "text")) {
                throw new EventPublisherConfigurationException("Text Mapping is not supported by event adapter type " + toEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("map")) {
            if (!EventPublisherConfigurationBuilder.validateSupportedMapping(toEventAdapterType, "map")) {
                throw new EventPublisherConfigurationException("Map Mapping is not supported by event adapter type " + toEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("xml")) {
            if (!EventPublisherConfigurationBuilder.validateSupportedMapping(toEventAdapterType, "xml")) {
                throw new EventPublisherConfigurationException("XML Mapping is not supported by event adapter type " + toEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("json")) {
            if (!EventPublisherConfigurationBuilder.validateSupportedMapping(toEventAdapterType, "json")) {
                throw new EventPublisherConfigurationException("JSON Mapping is not supported by event adapter type " + toEventAdapterType);
            }
        } else {
            String factoryClassName = EventPublisherConfigurationBuilder.getMappingTypeFactoryClass(mappingElement);
            if (factoryClassName == null) {
                throw new EventPublisherConfigurationException("Corresponding mappingType " + mappingType + " is not valid");
            }
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                OutputMapperFactory outputMapperFactory = (OutputMapperFactory)factoryClass.newInstance();
                EventPublisherServiceValueHolder.getMappingFactoryMap().putIfAbsent(mappingType, outputMapperFactory);
            }
            catch (ClassNotFoundException e) {
                throw new EventPublisherConfigurationException("Class not found exception occurred ", e);
            }
            catch (InstantiationException e) {
                throw new EventPublisherConfigurationException("Instantiation exception occurred ", e);
            }
            catch (IllegalAccessException e) {
                throw new EventPublisherConfigurationException("Illegal exception occurred ", e);
            }
        }
        eventPublisherConfiguration.setEventPublisherName(publisherName);
        eventPublisherConfiguration.setStatisticsEnabled(statisticsEnabled);
        eventPublisherConfiguration.setTraceEnabled(traceEnabled);
        eventPublisherConfiguration.setFromStreamName(fromStreamName);
        eventPublisherConfiguration.setFromStreamVersion(fromStreamVersion);
        eventPublisherConfiguration.setOutputMapping(EventPublisherServiceValueHolder.getMappingFactoryMap().get(mappingType).constructOutputMapping(mappingElement));
        eventPublisherConfiguration.setToAdapterConfiguration(outputEventAdapterConfiguration);
        eventPublisherConfiguration.setToAdapterDynamicProperties(dynamicProperties);
        eventPublisherConfiguration.setEditable(isEditable);
        eventPublisherConfiguration.setProcessEnabled(processingEnabled);
        return eventPublisherConfiguration;
    }

    public static String getMappingTypeFactoryClass(OMElement omElement) {
        return omElement.getAttributeValue(new QName("factoryClass"));
    }

    private static boolean validateStreamDetails(String streamName, String streamVersion, int tenantId) throws EventPublisherConfigurationException {
        EventStreamService eventStreamService = EventPublisherServiceValueHolder.getEventStreamService();
        try {
            StreamDefinition streamDefinition = eventStreamService.getStreamDefinition(streamName, streamVersion);
            if (streamDefinition != null) {
                return true;
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error while retrieving stream definition from Event Stream Service : " + e.getMessage()), e);
        }
        return false;
    }

    private static boolean validateEventAdapter(String eventAdapterType) {
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        List eventAdapterTypes = eventAdapterService.getOutputEventAdapterTypes();
        if (eventAdapterTypes == null || eventAdapterTypes.size() == 0) {
            throw new EventPublisherValidationException("Event adapter with type: " + eventAdapterType + " does not exist", eventAdapterType);
        }
        for (String adapterType : eventAdapterTypes) {
            if (!adapterType.equals(eventAdapterType)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateSupportedMapping(String eventAdapterType, String messageType) {
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        OutputEventAdapterSchema eventAdapterSchema = eventAdapterService.getOutputEventAdapterSchema(eventAdapterType);
        if (eventAdapterSchema == null) {
            throw new EventPublisherValidationException("Event Adapter with type: " + eventAdapterType + " does not exist", eventAdapterType);
        }
        List supportedOutputMessageFormats = eventAdapterSchema.getSupportedMessageFormats();
        return supportedOutputMessageFormats.contains(messageType);
    }
}

