/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.XMLOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;

public class XMLOutputMapperConfigurationBuilder {
    private XMLOutputMapperConfigurationBuilder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OutputMapping fromOM(OMElement mappingElement) throws EventPublisherValidationException, EventPublisherConfigurationException {
        XMLOutputMapping xmlOutputMapping = new XMLOutputMapping();
        String customMappingEnabled = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabled == null || customMappingEnabled.equals("enable")) {
            xmlOutputMapping.setCustomMappingEnabled(true);
            if (!XMLOutputMapperConfigurationBuilder.validateXMLEventMapping(mappingElement)) {
                throw new EventPublisherConfigurationException("XML Mapping is not valid, check the output mapping");
            }
            OMElement innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "inline"));
            if (innerMappingElement != null) {
                xmlOutputMapping.setRegistryResource(false);
            } else {
                innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "registry"));
                if (innerMappingElement == null) throw new EventPublisherConfigurationException("XML Mapping is not valid, Mapping should be inline or from registry");
                xmlOutputMapping.setRegistryResource(true);
                try {
                    AXIOMUtil.stringToOM((String)innerMappingElement.toString());
                }
                catch (XMLStreamException e) {
                    throw new EventPublisherConfigurationException("XML Mapping that provided is not valid : " + e.getMessage(), e);
                }
                String cacheTimeoutDurationValue = innerMappingElement.getAttributeValue(QName.valueOf("cacheTimeoutDuration"));
                if (cacheTimeoutDurationValue == null || cacheTimeoutDurationValue.isEmpty()) {
                    xmlOutputMapping.setCacheTimeoutDuration(0L);
                } else {
                    xmlOutputMapping.setCacheTimeoutDuration(Long.parseLong(cacheTimeoutDurationValue));
                }
            }
            String xmlMappingText = innerMappingElement.toString();
            if (xmlOutputMapping.isRegistryResource() && innerMappingElement.getText() != null && !innerMappingElement.getText().trim().isEmpty()) {
                xmlOutputMapping.setMappingXMLText(innerMappingElement.getText());
                return xmlOutputMapping;
            } else {
                if (!innerMappingElement.getChildElements().hasNext()) throw new EventPublisherConfigurationException("No valid xml content available");
                int index1 = xmlMappingText.indexOf(">");
                int index2 = xmlMappingText.lastIndexOf("<");
                xmlMappingText = xmlMappingText.substring(index1 + 1, index2);
                xmlOutputMapping.setMappingXMLText(xmlMappingText);
            }
            return xmlOutputMapping;
        }
        xmlOutputMapping.setCustomMappingEnabled(false);
        return xmlOutputMapping;
    }

    public static boolean validateXMLEventMapping(OMElement omElement) {
        int count = 0;
        Iterator mappingIterator = omElement.getChildElements();
        while (mappingIterator.hasNext()) {
            ++count;
            mappingIterator.next();
        }
        return count != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OMElement outputMappingToOM(OutputMapping outputMapping, OMFactory factory) throws EventPublisherConfigurationException {
        XMLOutputMapping xmlOutputMapping = (XMLOutputMapping)outputMapping;
        String xmlText = xmlOutputMapping.getMappingXMLText();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        mappingOMElement.addAttribute("type", "xml", null);
        if (xmlOutputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
            if (xmlOutputMapping.isRegistryResource()) {
                OMElement innerMappingElement = factory.createOMElement(new QName("registry"));
                innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                mappingOMElement.addChild((OMNode)innerMappingElement);
                innerMappingElement.setText(xmlText);
                innerMappingElement.addAttribute("cacheTimeoutDuration", Long.toString(xmlOutputMapping.getCacheTimeoutDuration()), null);
                return mappingOMElement;
            }
            OMElement innerMappingElement = factory.createOMElement(new QName("inline"));
            innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
            try {
                AXIOMUtil.stringToOM((String)xmlText);
            }
            catch (XMLStreamException e) {
                throw new EventPublisherConfigurationException("XML Mapping that provided is not valid : " + e.getMessage(), e);
            }
            mappingOMElement.addChild((OMNode)innerMappingElement);
            try {
                innerMappingElement.addChild((OMNode)AXIOMUtil.stringToOM((String)xmlText));
                return mappingOMElement;
            }
            catch (XMLStreamException e) {
                throw new EventPublisherConfigurationException("XML mapping is not in XML format :" + xmlText, e);
            }
        }
        mappingOMElement.addAttribute("customMapping", "disable", null);
        return mappingOMElement;
    }
}

