/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.mapping.XMLOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.publisher.core.internal.util.RuntimeResourceLoader;
import org.wso2.siddhi.core.event.Event;

public class XMLOutputMapper
implements OutputMapper {
    private static final Log log = LogFactory.getLog(XMLOutputMapper.class);
    private EventPublisherConfiguration eventPublisherConfiguration = null;
    private Map<String, Integer> propertyPositionMap = null;
    private List<String> mappingTextList;
    private boolean isCustomRegistryPath;
    private final RuntimeResourceLoader runtimeResourceLoader;
    private final boolean isCustomMappingEnabled;
    private String mappingText;

    public XMLOutputMapper(EventPublisherConfiguration eventPublisherConfiguration, Map<String, Integer> propertyPositionMap, int tenantId, StreamDefinition streamDefinition) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.propertyPositionMap = propertyPositionMap;
        XMLOutputMapping outputMapping = (XMLOutputMapping)eventPublisherConfiguration.getOutputMapping();
        this.runtimeResourceLoader = new RuntimeResourceLoader(outputMapping.getCacheTimeoutDuration(), propertyPositionMap);
        this.isCustomMappingEnabled = outputMapping.isCustomMappingEnabled();
        this.mappingText = this.isCustomMappingEnabled ? this.getCustomMappingText() : this.generateTemplateXMLEvent(streamDefinition);
        if (!outputMapping.isRegistryResource()) {
            this.mappingText = this.validateXML(this.mappingText);
            this.mappingTextList = this.generateMappingTextList(this.mappingText);
        }
    }

    private String validateXML(String text) throws EventPublisherConfigurationException {
        try {
            OMElement mappingOMElement = AXIOMUtil.stringToOM((String)text);
            return mappingOMElement.toString();
        }
        catch (XMLStreamException e) {
            throw new EventPublisherConfigurationException("Could not parse the mapping text:" + e.getMessage(), e);
        }
    }

    private List<String> getOutputMappingPropertyList(String mappingText) throws EventPublisherConfigurationException {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        int prefixIndex = text.indexOf("{{");
        while (prefixIndex > 0) {
            int postfixIndex = text.indexOf("}}");
            if (postfixIndex <= prefixIndex) {
                throw new EventPublisherConfigurationException("Found template attribute prefix {{ without corresponding postfix }}. Please verify your XML template.");
            }
            mappingTextList.add(text.substring(prefixIndex + 2, postfixIndex));
            text = text.substring(postfixIndex + 2);
            prefixIndex = text.indexOf("{{");
        }
        return mappingTextList;
    }

    private List<String> generateMappingTextList(String mappingText) throws EventPublisherConfigurationException {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        int prefixIndex = text.indexOf("{{");
        while (prefixIndex > 0) {
            int postfixIndex = text.indexOf("}}");
            if (postfixIndex <= prefixIndex) {
                throw new EventPublisherConfigurationException("Found template attribute prefix {{ without corresponding postfix }}. Please verify your XML template.");
            }
            mappingTextList.add(text.substring(0, prefixIndex));
            mappingTextList.add(text.substring(prefixIndex + 2, postfixIndex));
            text = text.substring(postfixIndex + 2);
            prefixIndex = text.indexOf("{{");
        }
        mappingTextList.add(text);
        return mappingTextList;
    }

    private String getCustomMappingText() throws EventPublisherConfigurationException {
        XMLOutputMapping textOutputMapping = (XMLOutputMapping)this.eventPublisherConfiguration.getOutputMapping();
        String actualMappingText = textOutputMapping.getMappingXMLText();
        if (textOutputMapping.isRegistryResource()) {
            boolean bl = this.isCustomRegistryPath = actualMappingText.contains("{{") && actualMappingText.indexOf("}}") > 0;
            if (!this.isCustomRegistryPath) {
                actualMappingText = this.runtimeResourceLoader.getResourceContent(textOutputMapping.getMappingXMLText());
            }
        }
        return actualMappingText;
    }

    private String getPropertyValue(Event event, String mappingProperty) {
        Object[] eventData = event.getData();
        Map arbitraryMap = event.getArbitraryDataMap();
        Integer position = this.propertyPositionMap.get(mappingProperty);
        Object data = null;
        if (position != null && eventData.length != 0) {
            data = eventData[position];
        } else if (mappingProperty != null && arbitraryMap != null && arbitraryMap.containsKey(mappingProperty)) {
            data = arbitraryMap.get(mappingProperty);
        }
        if (data != null) {
            return data.toString();
        }
        return "";
    }

    @Override
    public Object convertToMappedInputEvent(Event event) throws EventPublisherConfigurationException {
        Map arbitraryDataMap;
        XMLOutputMapping outputMapping;
        if (this.isCustomMappingEnabled) {
            EventPublisherUtil.validateStreamDefinitionWithOutputProperties(this.mappingText, this.propertyPositionMap, event.getArbitraryDataMap());
        }
        if ((outputMapping = (XMLOutputMapping)this.eventPublisherConfiguration.getOutputMapping()).isRegistryResource()) {
            String path = outputMapping.getMappingXMLText();
            if (this.isCustomRegistryPath) {
                List<String> pathMappingTextList = this.generateMappingTextList(path);
                StringBuilder pathBuilder = new StringBuilder(pathMappingTextList.get(0));
                for (int i = 1; i < pathMappingTextList.size(); ++i) {
                    if (i % 2 == 0) {
                        pathBuilder.append(pathMappingTextList.get(i));
                        continue;
                    }
                    pathBuilder.append(this.getPropertyValue(event, pathMappingTextList.get(i)));
                }
                path = pathBuilder.toString();
            }
            String actualMappingText = this.runtimeResourceLoader.getResourceContent(path);
            actualMappingText = this.validateXML(actualMappingText);
            this.mappingTextList = this.generateMappingTextList(actualMappingText);
        }
        StringBuilder eventText = new StringBuilder(this.mappingTextList.get(0));
        int size = this.mappingTextList.size();
        for (int i = 1; i < size; ++i) {
            if (i % 2 == 0) {
                eventText.append(this.mappingTextList.get(i));
                continue;
            }
            eventText.append(this.getPropertyValue(event, this.mappingTextList.get(i)));
        }
        String text = eventText.toString();
        if (!this.isCustomMappingEnabled && (arbitraryDataMap = event.getArbitraryDataMap()) != null && !arbitraryDataMap.isEmpty()) {
            try {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                OMElement compositeEventElement = AXIOMUtil.stringToOM((String)text);
                OMElement parentPropertyElement = factory.createOMElement(new QName("arbitraryDataMap"));
                for (Map.Entry entry : arbitraryDataMap.entrySet()) {
                    OMElement propertyElement = factory.createOMElement(new QName((String)entry.getKey()));
                    propertyElement.setText(entry.getValue().toString());
                    parentPropertyElement.addChild((OMNode)propertyElement);
                }
                compositeEventElement.getFirstElement().addChild((OMNode)parentPropertyElement);
                text = compositeEventElement.toString();
            }
            catch (XMLStreamException e) {
                log.warn((Object)"Error in parsing event XML text", (Throwable)e);
            }
        }
        return text;
    }

    @Override
    public Object convertToTypedInputEvent(Event event) throws EventPublisherConfigurationException {
        return this.convertToMappedInputEvent(event);
    }

    private String generateTemplateXMLEvent(StreamDefinition streamDefinition) {
        List payloadAttributes;
        List correlationAttributes;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement compositeEventElement = factory.createOMElement(new QName("events"));
        OMElement templateEventElement = factory.createOMElement(new QName("event"));
        compositeEventElement.addChild((OMNode)templateEventElement);
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            templateEventElement.addChild((OMNode)XMLOutputMapper.createPropertyElement(factory, "meta_", metaDatAttributes, "metaData"));
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            templateEventElement.addChild((OMNode)XMLOutputMapper.createPropertyElement(factory, "correlation_", correlationAttributes, "correlationData"));
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            templateEventElement.addChild((OMNode)XMLOutputMapper.createPropertyElement(factory, "", payloadAttributes, "payloadData"));
        }
        return compositeEventElement.toString();
    }

    private static OMElement createPropertyElement(OMFactory factory, String dataPrefix, List<Attribute> attributeList, String propertyTag) {
        OMElement parentPropertyElement = factory.createOMElement(new QName(propertyTag));
        for (Attribute attribute : attributeList) {
            OMElement propertyElement = factory.createOMElement(new QName(attribute.getName()));
            propertyElement.setText("{{" + dataPrefix + attribute.getName() + "}}");
            parentPropertyElement.addChild((OMNode)propertyElement);
        }
        return parentPropertyElement;
    }
}

