/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.wso2event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.publisher.core.config.EventOutputProperty;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConstants;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.WSO2EventOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;

public class WSO2EventOutputMapperConfigurationBuilder {
    private WSO2EventOutputMapperConfigurationBuilder() {
    }

    public static OutputMapping fromOM(OMElement mappingElement) throws EventPublisherValidationException, EventPublisherConfigurationException {
        WSO2EventOutputMapping wso2EventOutputMapping = new WSO2EventOutputMapping();
        String customMappingEnabled = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabled == null || customMappingEnabled.equals("enable")) {
            OMElement payloadMappingElement;
            OMElement correlationMappingElement;
            wso2EventOutputMapping.setCustomMappingEnabled(true);
            if (!WSO2EventOutputMapperConfigurationBuilder.validateWso2EventMapping(mappingElement)) {
                throw new EventPublisherConfigurationException("WS02Event Mapping is not valid, check the output mapping");
            }
            wso2EventOutputMapping.setCustomMappingEnabled(true);
            OMElement toOMElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
            wso2EventOutputMapping.setToEventName(toOMElement.getAttributeValue(new QName("streamName")));
            wso2EventOutputMapping.setToEventVersion(toOMElement.getAttributeValue(new QName("version")));
            OMElement metaMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "metaData"));
            if (metaMappingElement != null) {
                Iterator metaPropertyIterator = metaMappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
                while (metaPropertyIterator.hasNext()) {
                    OMElement propertyOMElement = (OMElement)metaPropertyIterator.next();
                    EventOutputProperty eventOutputProperty = WSO2EventOutputMapperConfigurationBuilder.getWSO2EventOutputPropertyFromOM(propertyOMElement);
                    wso2EventOutputMapping.addMetaWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                }
            }
            if ((correlationMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "correlationData"))) != null) {
                Iterator correlationPropertyIterator = correlationMappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
                while (correlationPropertyIterator.hasNext()) {
                    OMElement propertyOMElement = (OMElement)correlationPropertyIterator.next();
                    EventOutputProperty eventOutputProperty = WSO2EventOutputMapperConfigurationBuilder.getWSO2EventOutputPropertyFromOM(propertyOMElement);
                    wso2EventOutputMapping.addCorrelationWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                }
            }
            if ((payloadMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "payloadData"))) != null) {
                Iterator payloadPropertyIterator = payloadMappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
                while (payloadPropertyIterator.hasNext()) {
                    OMElement propertyOMElement = (OMElement)payloadPropertyIterator.next();
                    EventOutputProperty eventOutputProperty = WSO2EventOutputMapperConfigurationBuilder.getWSO2EventOutputPropertyFromOM(propertyOMElement);
                    wso2EventOutputMapping.addPayloadWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                }
            }
        } else {
            wso2EventOutputMapping.setCustomMappingEnabled(false);
        }
        return wso2EventOutputMapping;
    }

    private static EventOutputProperty getWSO2EventOutputPropertyFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
        String name = propertyToElement.getAttributeValue(new QName("name"));
        String valueOf = propertyFromElement.getAttributeValue(new QName("name"));
        AttributeType type = EventPublisherConstants.STRING_ATTRIBUTE_TYPE_MAP.get(propertyToElement.getAttributeValue(new QName("type")));
        return new EventOutputProperty(name, valueOf, type);
    }

    public static boolean validateWso2EventMapping(OMElement omElement) {
        ArrayList<String> supportedChildTags = new ArrayList<String>();
        supportedChildTags.add("metaData");
        supportedChildTags.add("correlationData");
        supportedChildTags.add("payloadData");
        supportedChildTags.add("payloadData");
        supportedChildTags.add("to");
        int count = 0;
        Iterator mappingIterator = omElement.getChildElements();
        while (mappingIterator.hasNext()) {
            OMElement childElement = (OMElement)mappingIterator.next();
            String childTag = childElement.getLocalName();
            if (!supportedChildTags.contains(childTag)) {
                return false;
            }
            ++count;
        }
        return count != 0;
    }

    public static OMElement outputMappingToOM(OutputMapping outputMapping, OMFactory factory) {
        WSO2EventOutputMapping wso2EventOutputMapping = (WSO2EventOutputMapping)outputMapping;
        List<EventOutputProperty> metaWSO2EventPropertyConfiguration = wso2EventOutputMapping.getMetaWSO2EventOutputPropertyConfiguration();
        List<EventOutputProperty> correlationWSO2EventPropertyConfiguration = wso2EventOutputMapping.getCorrelationWSO2EventOutputPropertyConfiguration();
        List<EventOutputProperty> payloadWSO2EventPropertyConfiguration = wso2EventOutputMapping.getPayloadWSO2EventOutputPropertyConfiguration();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        mappingOMElement.addAttribute("type", "wso2event", null);
        if (wso2EventOutputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
            OMElement toOMElement = factory.createOMElement(new QName("to"));
            toOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
            toOMElement.addAttribute("streamName", wso2EventOutputMapping.getToEventName(), null);
            toOMElement.addAttribute("version", wso2EventOutputMapping.getToEventVersion(), null);
            mappingOMElement.addChild((OMNode)toOMElement);
            if (metaWSO2EventPropertyConfiguration.size() > 0) {
                OMElement metaOMElement = factory.createOMElement(new QName("metaData"));
                metaOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                for (EventOutputProperty eventOutputProperty : metaWSO2EventPropertyConfiguration) {
                    metaOMElement.addChild((OMNode)WSO2EventOutputMapperConfigurationBuilder.getPropertyOmElement(factory, eventOutputProperty));
                }
                mappingOMElement.addChild((OMNode)metaOMElement);
            }
            if (correlationWSO2EventPropertyConfiguration.size() > 0) {
                OMElement correlationOMElement = factory.createOMElement(new QName("correlationData"));
                correlationOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                for (EventOutputProperty eventOutputProperty : correlationWSO2EventPropertyConfiguration) {
                    correlationOMElement.addChild((OMNode)WSO2EventOutputMapperConfigurationBuilder.getPropertyOmElement(factory, eventOutputProperty));
                }
                mappingOMElement.addChild((OMNode)correlationOMElement);
            }
            if (payloadWSO2EventPropertyConfiguration.size() > 0) {
                OMElement payloadOMElement = factory.createOMElement(new QName("payloadData"));
                payloadOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                for (EventOutputProperty eventOutputProperty : payloadWSO2EventPropertyConfiguration) {
                    payloadOMElement.addChild((OMNode)WSO2EventOutputMapperConfigurationBuilder.getPropertyOmElement(factory, eventOutputProperty));
                }
                mappingOMElement.addChild((OMNode)payloadOMElement);
            }
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        return mappingOMElement;
    }

    private static OMElement getPropertyOmElement(OMFactory factory, EventOutputProperty eventOutputProperty) {
        OMElement propertyOMElement = factory.createOMElement(new QName("property"));
        propertyOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        fromElement.addAttribute("name", eventOutputProperty.getValueOf(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        toElement.addAttribute("name", eventOutputProperty.getName(), null);
        toElement.addAttribute("type", WSO2EventOutputMapperConfigurationBuilder.getAttributeType(eventOutputProperty.getType()), null);
        propertyOMElement.addChild((OMNode)fromElement);
        propertyOMElement.addChild((OMNode)toElement);
        return propertyOMElement;
    }

    private static String getAttributeType(AttributeType attributeType) {
        Map<String, AttributeType> attributeMap = EventPublisherConstants.STRING_ATTRIBUTE_TYPE_MAP;
        for (Map.Entry<String, AttributeType> entry : attributeMap.entrySet()) {
            if (!entry.getValue().equals((Object)attributeType)) continue;
            return entry.getKey();
        }
        return null;
    }
}

