/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.wso2event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.publisher.core.config.EventOutputProperty;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.mapping.WSO2EventOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherStreamValidationException;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;

public class WSO2EventOutputMapper
implements OutputMapper {
    private WSO2EventOutputMapping wso2EventOutputMapping;
    private EventPublisherConfiguration eventPublisherConfiguration = null;
    private Map<String, Integer> propertyPositionMap = null;
    private final int tenantId;
    private final StreamDefinition inputStreamDefinition;
    private int noOfMetaData = 0;
    private int noOfCorrelationData = 0;
    private int noOfPayloadData = 0;

    public WSO2EventOutputMapper(EventPublisherConfiguration eventPublisherConfiguration, Map<String, Integer> propertyPositionMap, int tenantId, StreamDefinition inputStreamDefinition) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.propertyPositionMap = propertyPositionMap;
        this.tenantId = tenantId;
        this.inputStreamDefinition = inputStreamDefinition;
        this.wso2EventOutputMapping = (WSO2EventOutputMapping)eventPublisherConfiguration.getOutputMapping();
        if (this.wso2EventOutputMapping.getToEventName() == null || this.wso2EventOutputMapping.getToEventName().isEmpty() || this.wso2EventOutputMapping.getToEventVersion() == null || this.wso2EventOutputMapping.getToEventVersion().isEmpty()) {
            this.wso2EventOutputMapping.setToEventName(inputStreamDefinition.getName());
            this.wso2EventOutputMapping.setToEventVersion(inputStreamDefinition.getVersion());
        }
        if (!this.wso2EventOutputMapping.isCustomMappingEnabled()) {
            this.noOfMetaData = inputStreamDefinition.getMetaData() != null ? inputStreamDefinition.getMetaData().size() : 0;
            this.noOfCorrelationData = inputStreamDefinition.getCorrelationData() != null ? inputStreamDefinition.getCorrelationData().size() : 0;
            this.noOfPayloadData = inputStreamDefinition.getPayloadData() != null ? inputStreamDefinition.getPayloadData().size() : 0;
        } else {
            this.validateStreamDefinitionWithOutputProperties();
        }
    }

    private void validateStreamDefinitionWithOutputProperties() throws EventPublisherConfigurationException {
        WSO2EventOutputMapping wso2EventOutputMapping = (WSO2EventOutputMapping)this.eventPublisherConfiguration.getOutputMapping();
        List<EventOutputProperty> metaWSO2EventOutputPropertyConfiguration = wso2EventOutputMapping.getMetaWSO2EventOutputPropertyConfiguration();
        List<EventOutputProperty> correlationWSO2EventOutputPropertyConfiguration = wso2EventOutputMapping.getCorrelationWSO2EventOutputPropertyConfiguration();
        List<EventOutputProperty> payloadWSO2EventOutputPropertyConfiguration = wso2EventOutputMapping.getPayloadWSO2EventOutputPropertyConfiguration();
        for (EventOutputProperty wso2EventOutputProperty : metaWSO2EventOutputPropertyConfiguration) {
            if (this.propertyPositionMap.containsKey(wso2EventOutputProperty.getValueOf())) continue;
            throw new EventPublisherStreamValidationException("Property " + wso2EventOutputProperty.getValueOf() + " is not in the input stream definition. ", this.inputStreamDefinition.getStreamId());
        }
        for (EventOutputProperty wso2EventOutputProperty : correlationWSO2EventOutputPropertyConfiguration) {
            if (this.propertyPositionMap.containsKey(wso2EventOutputProperty.getValueOf())) continue;
            throw new EventPublisherStreamValidationException("Property " + wso2EventOutputProperty.getValueOf() + " is not in the input stream definition. ", this.inputStreamDefinition.getStreamId());
        }
        for (EventOutputProperty wso2EventOutputProperty : payloadWSO2EventOutputPropertyConfiguration) {
            if (this.propertyPositionMap.containsKey(wso2EventOutputProperty.getValueOf())) continue;
            throw new EventPublisherStreamValidationException("Property " + wso2EventOutputProperty.getValueOf() + " is not in the input stream definition. ", this.inputStreamDefinition.getStreamId());
        }
    }

    private void addAttributeToStreamDefinition(StreamDefinition streamDefinition, List<EventOutputProperty> wso2EventOutputPropertyList, String propertyType) {
        block4: {
            block5: {
                block3: {
                    if (!propertyType.equals("meta")) break block3;
                    for (EventOutputProperty wso2EventOutputProperty : wso2EventOutputPropertyList) {
                        streamDefinition.addMetaData(wso2EventOutputProperty.getName(), wso2EventOutputProperty.getType());
                    }
                    break block4;
                }
                if (!propertyType.equals("correlation")) break block5;
                for (EventOutputProperty wso2EventOutputProperty : wso2EventOutputPropertyList) {
                    streamDefinition.addCorrelationData(wso2EventOutputProperty.getName(), wso2EventOutputProperty.getType());
                }
                break block4;
            }
            if (!propertyType.equals("payload")) break block4;
            for (EventOutputProperty wso2EventOutputProperty : wso2EventOutputPropertyList) {
                streamDefinition.addPayloadData(wso2EventOutputProperty.getName(), wso2EventOutputProperty.getType());
            }
        }
    }

    @Override
    public Object convertToMappedInputEvent(org.wso2.siddhi.core.event.Event event) throws EventPublisherConfigurationException {
        Map map;
        Event eventObject = new Event();
        eventObject.setTimeStamp(event.getTimestamp());
        Object[] eventData = event.getData();
        if (eventData.length > 0) {
            int position;
            eventObject.setStreamId(this.wso2EventOutputMapping.getToEventName() + ":" + this.wso2EventOutputMapping.getToEventVersion());
            List<EventOutputProperty> metaWSO2EventOutputPropertyConfiguration = this.wso2EventOutputMapping.getMetaWSO2EventOutputPropertyConfiguration();
            List<EventOutputProperty> correlationWSO2EventOutputPropertyConfiguration = this.wso2EventOutputMapping.getCorrelationWSO2EventOutputPropertyConfiguration();
            List<EventOutputProperty> payloadWSO2EventOutputPropertyConfiguration = this.wso2EventOutputMapping.getPayloadWSO2EventOutputPropertyConfiguration();
            if (metaWSO2EventOutputPropertyConfiguration.size() != 0) {
                ArrayList<Object> metaData = new ArrayList<Object>();
                for (EventOutputProperty eventOutputProperty : metaWSO2EventOutputPropertyConfiguration) {
                    position = this.propertyPositionMap.get(eventOutputProperty.getValueOf());
                    metaData.add(eventData[position]);
                }
                eventObject.setMetaData(metaData.toArray());
            }
            if (correlationWSO2EventOutputPropertyConfiguration.size() != 0) {
                ArrayList<Object> correlationData = new ArrayList<Object>();
                for (EventOutputProperty eventOutputProperty : correlationWSO2EventOutputPropertyConfiguration) {
                    position = this.propertyPositionMap.get(eventOutputProperty.getValueOf());
                    correlationData.add(eventData[position]);
                }
                eventObject.setCorrelationData(correlationData.toArray());
            }
            if (payloadWSO2EventOutputPropertyConfiguration.size() != 0) {
                ArrayList<Object> payloadData = new ArrayList<Object>();
                for (EventOutputProperty eventOutputProperty : payloadWSO2EventOutputPropertyConfiguration) {
                    position = this.propertyPositionMap.get(eventOutputProperty.getValueOf());
                    payloadData.add(eventData[position]);
                }
                eventObject.setPayloadData(payloadData.toArray());
            }
        }
        if ((map = event.getArbitraryDataMap()) != null) {
            eventObject.setArbitraryDataMap(map);
        }
        return eventObject;
    }

    @Override
    public Object convertToTypedInputEvent(org.wso2.siddhi.core.event.Event event) throws EventPublisherConfigurationException {
        Map map;
        Event eventObject = new Event();
        eventObject.setStreamId(this.wso2EventOutputMapping.getToEventName() + ":" + this.wso2EventOutputMapping.getToEventVersion());
        eventObject.setTimeStamp(event.getTimestamp());
        Object[] eventData = event.getData();
        if (this.noOfMetaData > 0) {
            ArrayList<Object> metaData = new ArrayList<Object>();
            metaData.addAll(Arrays.asList(eventData).subList(0, this.noOfMetaData));
            eventObject.setMetaData(metaData.toArray());
        }
        if (this.noOfCorrelationData > 0) {
            ArrayList<Object> correlationData = new ArrayList<Object>();
            correlationData.addAll(Arrays.asList(eventData).subList(this.noOfMetaData, this.noOfMetaData + this.noOfCorrelationData));
            eventObject.setCorrelationData(correlationData.toArray());
        }
        if (this.noOfPayloadData > 0) {
            ArrayList<Object> payloadData = new ArrayList<Object>();
            payloadData.addAll(Arrays.asList(eventData).subList(this.noOfCorrelationData + this.noOfMetaData, this.noOfPayloadData + this.noOfCorrelationData + this.noOfMetaData));
            eventObject.setPayloadData(payloadData.toArray());
        }
        if ((map = event.getArbitraryDataMap()) != null) {
            eventObject.setArbitraryDataMap(map);
        }
        return eventObject;
    }
}

