/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.text;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.TextOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;

public class TextOutputMapperConfigurationBuilder {
    private TextOutputMapperConfigurationBuilder() {
    }

    public static OutputMapping fromOM(OMElement mappingElement) throws EventPublisherValidationException, EventPublisherConfigurationException {
        TextOutputMapping textOutputMapping = new TextOutputMapping();
        String customMappingEnabled = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabled == null || customMappingEnabled.equals("enable")) {
            textOutputMapping.setCustomMappingEnabled(true);
            if (!TextOutputMapperConfigurationBuilder.validateTextMapping(mappingElement)) {
                throw new EventPublisherConfigurationException("Text Mapping is not valid, check the output mapping");
            }
            OMElement innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "inline"));
            if (innerMappingElement != null) {
                textOutputMapping.setRegistryResource(false);
            } else {
                innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "registry"));
                if (innerMappingElement != null) {
                    textOutputMapping.setRegistryResource(true);
                    String cacheTimeoutDurationValue = innerMappingElement.getAttributeValue(QName.valueOf("cacheTimeoutDuration"));
                    if (cacheTimeoutDurationValue == null || cacheTimeoutDurationValue.isEmpty()) {
                        textOutputMapping.setCacheTimeoutDuration(0L);
                    } else {
                        textOutputMapping.setCacheTimeoutDuration(Long.parseLong(cacheTimeoutDurationValue));
                    }
                } else {
                    throw new EventPublisherConfigurationException("Text Mapping is not valid, Mapping should be inline or from registry");
                }
            }
            if (innerMappingElement.getText() == null || innerMappingElement.getText().trim().isEmpty()) {
                throw new EventPublisherConfigurationException("No mapping content available");
            }
            textOutputMapping.setMappingText(innerMappingElement.getText());
        } else {
            textOutputMapping.setCustomMappingEnabled(false);
        }
        return textOutputMapping;
    }

    public static boolean validateTextMapping(OMElement omElement) {
        int count = 0;
        Iterator mappingIterator = omElement.getChildElements();
        while (mappingIterator.hasNext()) {
            ++count;
            mappingIterator.next();
        }
        return count != 0;
    }

    public static OMElement outputMappingToOM(OutputMapping outputMapping, OMFactory factory) {
        TextOutputMapping textOutputMapping = (TextOutputMapping)outputMapping;
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        mappingOMElement.addAttribute("type", "text", null);
        if (textOutputMapping.isCustomMappingEnabled()) {
            OMElement innerMappingElement;
            mappingOMElement.addAttribute("customMapping", "enable", null);
            if (textOutputMapping.isRegistryResource()) {
                innerMappingElement = factory.createOMElement(new QName("registry"));
                innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                innerMappingElement.addAttribute("cacheTimeoutDuration", Long.toString(textOutputMapping.getCacheTimeoutDuration()), null);
            } else {
                innerMappingElement = factory.createOMElement(new QName("inline"));
                innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
            }
            mappingOMElement.addChild((OMNode)innerMappingElement);
            innerMappingElement.setText(textOutputMapping.getMappingText());
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        return mappingOMElement;
    }
}

