/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.mapping.TextOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.publisher.core.internal.util.RuntimeResourceLoader;
import org.wso2.siddhi.core.event.Event;

public class TextOutputMapper
implements OutputMapper {
    private List<String> mappingTextList;
    private EventPublisherConfiguration eventPublisherConfiguration = null;
    private Map<String, Integer> propertyPositionMap = null;
    private final StreamDefinition streamDefinition;
    private boolean isCustomRegistryPath;
    private final RuntimeResourceLoader runtimeResourceLoader;
    private final boolean isCustomMappingEnabled;
    private String mappingText;

    public TextOutputMapper(EventPublisherConfiguration eventPublisherConfiguration, Map<String, Integer> propertyPositionMap, int tenantId, StreamDefinition streamDefinition) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.propertyPositionMap = propertyPositionMap;
        this.streamDefinition = streamDefinition;
        TextOutputMapping outputMapping = (TextOutputMapping)eventPublisherConfiguration.getOutputMapping();
        this.runtimeResourceLoader = new RuntimeResourceLoader(outputMapping.getCacheTimeoutDuration(), propertyPositionMap);
        this.isCustomMappingEnabled = outputMapping.isCustomMappingEnabled();
        if (this.isCustomMappingEnabled) {
            this.mappingText = outputMapping.getMappingText();
            if (outputMapping.isRegistryResource()) {
                boolean bl = this.isCustomRegistryPath = this.mappingText.contains("{{") && this.mappingText.indexOf("}}") > 0;
                if (!this.isCustomRegistryPath) {
                    this.mappingText = this.runtimeResourceLoader.getResourceContent(outputMapping.getMappingText());
                }
            }
        } else {
            this.mappingText = this.generateTemplateTextEvent(streamDefinition);
        }
        if (!outputMapping.isRegistryResource()) {
            this.mappingTextList = this.generateMappingTextList(this.mappingText);
        }
    }

    private List<String> getOutputMappingPropertyList(String mappingText) {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        mappingTextList.clear();
        while (text.contains("{{") && text.indexOf("}}") > 0) {
            mappingTextList.add(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")));
            text = text.substring(text.indexOf("}}") + 2);
        }
        return mappingTextList;
    }

    private List<String> generateMappingTextList(String mappingText) {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        mappingTextList.clear();
        while (text.contains("{{") && text.indexOf("}}") > 0) {
            mappingTextList.add(text.substring(0, text.indexOf("{{")));
            mappingTextList.add(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")));
            text = text.substring(text.indexOf("}}") + 2);
        }
        mappingTextList.add(text);
        return mappingTextList;
    }

    @Override
    public Object convertToMappedInputEvent(Event event) throws EventPublisherConfigurationException {
        Map arbitraryDataMap;
        TextOutputMapping outputMapping;
        if (this.isCustomMappingEnabled) {
            EventPublisherUtil.validateStreamDefinitionWithOutputProperties(this.mappingText, this.propertyPositionMap, event.getArbitraryDataMap());
        }
        if ((outputMapping = (TextOutputMapping)this.eventPublisherConfiguration.getOutputMapping()).isRegistryResource()) {
            String path = outputMapping.getMappingText();
            if (this.isCustomRegistryPath) {
                List<String> pathMappingTextList = this.generateMappingTextList(path);
                StringBuilder pathBuilder = new StringBuilder(pathMappingTextList.get(0));
                for (int i = 1; i < pathMappingTextList.size(); ++i) {
                    if (i % 2 == 0) {
                        pathBuilder.append(pathMappingTextList.get(i));
                        continue;
                    }
                    pathBuilder.append(this.getPropertyValue(event, pathMappingTextList.get(i)));
                }
                path = pathBuilder.toString();
            }
            String actualMappingText = this.runtimeResourceLoader.getResourceContent(path);
            this.mappingTextList = this.generateMappingTextList(actualMappingText);
        }
        StringBuilder eventText = new StringBuilder(this.mappingTextList.get(0));
        for (int i = 1; i < this.mappingTextList.size(); ++i) {
            if (i % 2 == 0) {
                eventText.append(this.mappingTextList.get(i));
                continue;
            }
            eventText.append(this.getPropertyValue(event, this.mappingTextList.get(i)));
        }
        if (!this.isCustomMappingEnabled && (arbitraryDataMap = event.getArbitraryDataMap()) != null && !arbitraryDataMap.isEmpty()) {
            eventText.append(",");
            for (Map.Entry entry : arbitraryDataMap.entrySet()) {
                eventText.append("\n" + (String)entry.getKey() + ":" + entry.getValue() + ",");
            }
            eventText.deleteCharAt(eventText.lastIndexOf(","));
        }
        return eventText.toString();
    }

    @Override
    public Object convertToTypedInputEvent(Event event) throws EventPublisherConfigurationException {
        return this.convertToMappedInputEvent(event);
    }

    private String getPropertyValue(Event event, String mappingProperty) {
        Object[] eventData = event.getData();
        Map arbitraryMap = event.getArbitraryDataMap();
        Integer position = this.propertyPositionMap.get(mappingProperty);
        Object data = null;
        if (position != null && eventData.length != 0) {
            data = eventData[position];
        } else if (mappingProperty != null && arbitraryMap != null && arbitraryMap.containsKey(mappingProperty)) {
            data = arbitraryMap.get(mappingProperty);
        }
        if (data != null) {
            return data.toString();
        }
        return "";
    }

    private String generateTemplateTextEvent(StreamDefinition streamDefinition) {
        List payloadAttributes;
        List correlationAttributes;
        String templateTextEvent = "";
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            for (Attribute attribute : metaDatAttributes) {
                templateTextEvent = templateTextEvent + "\nmeta_" + attribute.getName() + ":" + "{{" + "meta_" + attribute.getName() + "}}" + ",";
            }
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            for (Attribute attribute : correlationAttributes) {
                templateTextEvent = templateTextEvent + "\ncorrelation_" + attribute.getName() + ":" + "{{" + "correlation_" + attribute.getName() + "}}" + ",";
            }
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            for (Attribute attribute : payloadAttributes) {
                templateTextEvent = templateTextEvent + "\n" + attribute.getName() + ":" + "{{" + attribute.getName() + "}}" + ",";
            }
        }
        if (templateTextEvent.trim().endsWith(",")) {
            templateTextEvent = templateTextEvent.substring(0, templateTextEvent.length() - 1).trim();
        }
        return templateTextEvent;
    }
}

