/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.map;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.event.publisher.core.config.EventOutputProperty;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.MapOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherValidationException;

public class MapOutputMapperConfigurationBuilder {
    private MapOutputMapperConfigurationBuilder() {
    }

    public static OutputMapping fromOM(OMElement mappingElement) throws EventPublisherValidationException, EventPublisherConfigurationException {
        MapOutputMapping mapOutputMapping = new MapOutputMapping();
        String customMappingEnabled = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabled == null || customMappingEnabled.equals("enable")) {
            mapOutputMapping.setCustomMappingEnabled(true);
            if (!MapOutputMapperConfigurationBuilder.validateMapEventMapping(mappingElement)) {
                throw new EventPublisherConfigurationException("Map Mapping is not valid, check the output mapping");
            }
            if (mappingElement != null) {
                Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventpublisher", "property"));
                while (propertyIterator.hasNext()) {
                    OMElement propertyOMElement = (OMElement)propertyIterator.next();
                    EventOutputProperty eventOutputProperty = MapOutputMapperConfigurationBuilder.getOutputPropertyFromOM(propertyOMElement);
                    mapOutputMapping.addOutputPropertyConfiguration(eventOutputProperty);
                }
            }
        } else {
            mapOutputMapping.setCustomMappingEnabled(false);
        }
        return mapOutputMapping;
    }

    private static EventOutputProperty getOutputPropertyFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "to"));
        String name = propertyToElement.getAttributeValue(new QName("name"));
        String valueOf = propertyFromElement.getAttributeValue(new QName("name"));
        return new EventOutputProperty(name, valueOf);
    }

    public static boolean validateMapEventMapping(OMElement omElement) {
        int count = 0;
        Iterator mappingIterator = omElement.getChildElements();
        while (mappingIterator.hasNext()) {
            OMElement childElement = (OMElement)mappingIterator.next();
            String childTag = childElement.getLocalName();
            if (!childTag.equals("property")) {
                return false;
            }
            ++count;
        }
        return count != 0;
    }

    public static OMElement outputMappingToOM(OutputMapping outputMapping, OMFactory factory) {
        MapOutputMapping mapOutputMapping = (MapOutputMapping)outputMapping;
        List<EventOutputProperty> outputPropertyConfiguration = mapOutputMapping.getOutputPropertyConfiguration();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        mappingOMElement.addAttribute("type", "map", null);
        if (mapOutputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
            if (outputPropertyConfiguration.size() > 0) {
                for (EventOutputProperty eventOutputProperty : outputPropertyConfiguration) {
                    mappingOMElement.addChild((OMNode)MapOutputMapperConfigurationBuilder.getPropertyOmElement(factory, eventOutputProperty));
                }
            }
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        return mappingOMElement;
    }

    private static OMElement getPropertyOmElement(OMFactory factory, EventOutputProperty eventOutputProperty) {
        OMElement propertyOMElement = factory.createOMElement(new QName("property"));
        propertyOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        fromElement.addAttribute("name", eventOutputProperty.getValueOf(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        toElement.addAttribute("name", eventOutputProperty.getName(), null);
        propertyOMElement.addChild((OMNode)fromElement);
        propertyOMElement.addChild((OMNode)toElement);
        return propertyOMElement;
    }
}

