/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.map;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.publisher.core.config.EventOutputProperty;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.mapping.MapOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherStreamValidationException;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;
import org.wso2.siddhi.core.event.Event;

public class MapOutputMapper
implements OutputMapper {
    EventPublisherConfiguration eventPublisherConfiguration = null;
    Map<String, Integer> propertyPositionMap = null;
    private int noOfMetaData = 0;
    private int noOfCorrelationData = 0;
    private int noOfPayloadData = 0;
    private StreamDefinition streamDefinition;

    public MapOutputMapper(EventPublisherConfiguration eventPublisherConfiguration, Map<String, Integer> propertyPositionMap, int tenantId, StreamDefinition streamDefinition) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.propertyPositionMap = propertyPositionMap;
        if (!eventPublisherConfiguration.getOutputMapping().isCustomMappingEnabled()) {
            this.streamDefinition = streamDefinition;
            this.noOfMetaData = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
            this.noOfCorrelationData = streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
            this.noOfPayloadData = streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
        }
    }

    private void validateStreamDefinitionWithOutputProperties(Map<String, Object> arbitraryDataMap) throws EventPublisherConfigurationException {
        MapOutputMapping mapOutputMapping = (MapOutputMapping)this.eventPublisherConfiguration.getOutputMapping();
        if (!mapOutputMapping.isCustomMappingEnabled()) {
            return;
        }
        List<EventOutputProperty> outputPropertyConfiguration = mapOutputMapping.getOutputPropertyConfiguration();
        for (EventOutputProperty outputProperty : outputPropertyConfiguration) {
            String valueOf = outputProperty.getValueOf();
            if (this.propertyPositionMap.containsKey(valueOf) || arbitraryDataMap != null && arbitraryDataMap.containsKey(valueOf)) continue;
            throw new EventPublisherStreamValidationException("Property " + valueOf + " is neither in the input stream attributes nor in runtime arbitrary data map of ", this.streamDefinition.getStreamId());
        }
    }

    @Override
    public Object convertToMappedInputEvent(Event event) throws EventPublisherConfigurationException {
        this.validateStreamDefinitionWithOutputProperties(event.getArbitraryDataMap());
        TreeMap<String, Object> eventMapObject = new TreeMap<String, Object>();
        Object[] eventData = event.getData();
        Map arbitraryDataMap = event.getArbitraryDataMap();
        MapOutputMapping mapOutputMapping = (MapOutputMapping)this.eventPublisherConfiguration.getOutputMapping();
        List<EventOutputProperty> outputPropertyConfiguration = mapOutputMapping.getOutputPropertyConfiguration();
        if (outputPropertyConfiguration.size() != 0 && eventData.length > 0) {
            for (EventOutputProperty eventOutputProperty : outputPropertyConfiguration) {
                String valueOf = eventOutputProperty.getValueOf();
                Integer position = this.propertyPositionMap.get(valueOf);
                if (position != null) {
                    eventMapObject.put(eventOutputProperty.getName(), eventData[position]);
                    continue;
                }
                if (valueOf == null || arbitraryDataMap == null || !arbitraryDataMap.containsKey(valueOf)) continue;
                eventMapObject.put(eventOutputProperty.getName(), arbitraryDataMap.get(valueOf));
            }
        }
        return eventMapObject;
    }

    @Override
    public Object convertToTypedInputEvent(Event event) throws EventPublisherConfigurationException {
        Map arbitraryDataMap;
        this.validateStreamDefinitionWithOutputProperties(event.getArbitraryDataMap());
        TreeMap<String, Object> eventMapObject = new TreeMap<String, Object>();
        int counter = 0;
        Object[] eventData = event.getData();
        if (this.noOfMetaData > 0) {
            for (Attribute metaData : this.streamDefinition.getMetaData()) {
                eventMapObject.put("meta_" + metaData.getName(), eventData[counter]);
                ++counter;
            }
        }
        if (this.noOfCorrelationData > 0) {
            for (Attribute correlationData : this.streamDefinition.getCorrelationData()) {
                eventMapObject.put("correlation_" + correlationData.getName(), eventData[counter]);
                ++counter;
            }
        }
        if (this.noOfPayloadData > 0) {
            for (Attribute payloadData : this.streamDefinition.getPayloadData()) {
                eventMapObject.put(payloadData.getName(), eventData[counter]);
                ++counter;
            }
        }
        if ((arbitraryDataMap = event.getArbitraryDataMap()) != null) {
            for (Map.Entry entry : arbitraryDataMap.entrySet()) {
                eventMapObject.put((String)entry.getKey(), entry.getValue());
            }
        }
        return eventMapObject;
    }
}

