/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.json;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.JSONOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;

public class JSONOutputMapperConfigurationBuilder {
    private JSONOutputMapperConfigurationBuilder() {
    }

    public static OutputMapping fromOM(OMElement mappingElement) throws EventPublisherConfigurationException {
        JSONOutputMapping jsonOutputMapping = new JSONOutputMapping();
        String customMappingEnabled = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabled == null || customMappingEnabled.equals("enable")) {
            jsonOutputMapping.setCustomMappingEnabled(true);
            if (!JSONOutputMapperConfigurationBuilder.validateJsonEventMapping(mappingElement)) {
                throw new EventPublisherConfigurationException("JSON Mapping is not valid, check the output mapping");
            }
            OMElement innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "inline"));
            if (innerMappingElement != null) {
                jsonOutputMapping.setRegistryResource(false);
            } else {
                innerMappingElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventpublisher", "registry"));
                if (innerMappingElement != null) {
                    jsonOutputMapping.setRegistryResource(true);
                    String cacheTimeoutDurationValue = innerMappingElement.getAttributeValue(QName.valueOf("cacheTimeoutDuration"));
                    if (cacheTimeoutDurationValue == null || cacheTimeoutDurationValue.isEmpty()) {
                        jsonOutputMapping.setCacheTimeoutDuration(0L);
                    } else {
                        jsonOutputMapping.setCacheTimeoutDuration(Long.parseLong(cacheTimeoutDurationValue));
                    }
                } else {
                    throw new EventPublisherConfigurationException("XML Mapping is not valid, Mapping should be inline or from registry");
                }
            }
            if (innerMappingElement.getText() == null || innerMappingElement.getText().trim().isEmpty()) {
                throw new EventPublisherConfigurationException("No mapping content available");
            }
            jsonOutputMapping.setMappingText(innerMappingElement.getText());
        } else {
            jsonOutputMapping.setCustomMappingEnabled(false);
        }
        return jsonOutputMapping;
    }

    public static boolean validateJsonEventMapping(OMElement omElement) {
        int count = 0;
        Iterator mappingIterator = omElement.getChildElements();
        while (mappingIterator.hasNext()) {
            ++count;
            mappingIterator.next();
        }
        return count != 0;
    }

    public static OMElement outputMappingToOM(OutputMapping outputMapping, OMFactory factory) {
        JSONOutputMapping jsonOutputMapping = (JSONOutputMapping)outputMapping;
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
        mappingOMElement.addAttribute("type", "json", null);
        if (jsonOutputMapping.isCustomMappingEnabled()) {
            OMElement innerMappingElement;
            mappingOMElement.addAttribute("customMapping", "enable", null);
            if (jsonOutputMapping.isRegistryResource()) {
                innerMappingElement = factory.createOMElement(new QName("registry"));
                innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
                innerMappingElement.addAttribute("cacheTimeoutDuration", Long.toString(jsonOutputMapping.getCacheTimeoutDuration()), null);
            } else {
                innerMappingElement = factory.createOMElement(new QName("inline"));
                innerMappingElement.declareDefaultNamespace("http://wso2.org/carbon/eventpublisher");
            }
            mappingOMElement.addChild((OMNode)innerMappingElement);
            innerMappingElement.setText(jsonOutputMapping.getMappingText());
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        return mappingOMElement;
    }
}

