/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.type.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.mapping.JSONOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.publisher.core.internal.util.RuntimeResourceLoader;
import org.wso2.siddhi.core.event.Event;

public class JSONOutputMapper
implements OutputMapper {
    private List<String> mappingTextList;
    private EventPublisherConfiguration eventPublisherConfiguration = null;
    private Map<String, Integer> propertyPositionMap = null;
    private final StreamDefinition streamDefinition;
    private boolean isCustomRegistryPath;
    private final RuntimeResourceLoader runtimeResourceLoader;
    private final boolean isCustomMappingEnabled;
    private final String mappingText;

    public JSONOutputMapper(EventPublisherConfiguration eventPublisherConfiguration, Map<String, Integer> propertyPositionMap, int tenantId, StreamDefinition streamDefinition) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.propertyPositionMap = propertyPositionMap;
        this.streamDefinition = streamDefinition;
        JSONOutputMapping outputMapping = (JSONOutputMapping)eventPublisherConfiguration.getOutputMapping();
        this.runtimeResourceLoader = new RuntimeResourceLoader(outputMapping.getCacheTimeoutDuration(), propertyPositionMap);
        this.isCustomMappingEnabled = outputMapping.isCustomMappingEnabled();
        this.mappingText = this.isCustomMappingEnabled ? this.getCustomMappingText() : this.generateJsonEventTemplate(streamDefinition);
        if (!outputMapping.isRegistryResource()) {
            this.mappingTextList = this.generateMappingTextList(this.mappingText);
        }
    }

    private List<String> generateMappingTextList(String mappingText) throws EventPublisherConfigurationException {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        int prefixIndex = text.indexOf("{{");
        while (prefixIndex > 0) {
            int postFixIndex = text.indexOf("}}");
            if (postFixIndex <= prefixIndex) {
                throw new EventPublisherConfigurationException("Found template attribute prefix {{ without corresponding postfix }}. Please verify your JSON template.");
            }
            mappingTextList.add(text.substring(0, prefixIndex));
            mappingTextList.add(text.substring(prefixIndex + 2, postFixIndex));
            text = text.substring(postFixIndex + 2);
            prefixIndex = text.indexOf("{{");
        }
        mappingTextList.add(text);
        return mappingTextList;
    }

    @Override
    public Object convertToMappedInputEvent(Event event) throws EventPublisherConfigurationException {
        Map arbitraryDataMap;
        JSONOutputMapping outputMapping;
        if (this.isCustomMappingEnabled) {
            EventPublisherUtil.validateStreamDefinitionWithOutputProperties(this.mappingText, this.propertyPositionMap, event.getArbitraryDataMap());
        }
        if ((outputMapping = (JSONOutputMapping)this.eventPublisherConfiguration.getOutputMapping()).isRegistryResource()) {
            String path = outputMapping.getMappingText();
            if (this.isCustomRegistryPath) {
                List<String> pathMappingTextList = this.generateMappingTextList(path);
                StringBuilder pathBuilder = new StringBuilder(pathMappingTextList.get(0));
                for (int i = 1; i < pathMappingTextList.size(); ++i) {
                    if (i % 2 == 0) {
                        pathBuilder.append(pathMappingTextList.get(i));
                        continue;
                    }
                    pathBuilder.append(this.getPropertyValue(event, pathMappingTextList.get(i)));
                }
                path = pathBuilder.toString();
            }
            String actualMappingText = this.runtimeResourceLoader.getResourceContent(path);
            this.mappingTextList = this.generateMappingTextList(actualMappingText);
        }
        StringBuilder eventText = new StringBuilder(this.mappingTextList.get(0));
        int size = this.mappingTextList.size();
        for (int i = 1; i < size; ++i) {
            if (i % 2 == 0) {
                eventText.append(this.mappingTextList.get(i));
                continue;
            }
            Object propertyValue = this.getPropertyValue(event, this.mappingTextList.get(i));
            if (propertyValue != null && propertyValue instanceof String) {
                eventText.append("\"").append(propertyValue).append("\"");
                continue;
            }
            eventText.append(propertyValue);
        }
        String text = eventText.toString();
        if (!this.isCustomMappingEnabled && (arbitraryDataMap = event.getArbitraryDataMap()) != null && !arbitraryDataMap.isEmpty()) {
            Gson gson = new Gson();
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(text).getAsJsonObject();
            jsonObject.getAsJsonObject("event").add("arbitraryDataMap", gson.toJsonTree((Object)arbitraryDataMap));
            text = gson.toJson((JsonElement)jsonObject);
        }
        return text;
    }

    @Override
    public Object convertToTypedInputEvent(Event event) throws EventPublisherConfigurationException {
        return this.convertToMappedInputEvent(event);
    }

    private String getCustomMappingText() throws EventPublisherConfigurationException {
        JSONOutputMapping jsonOutputMapping = (JSONOutputMapping)this.eventPublisherConfiguration.getOutputMapping();
        String actualMappingText = jsonOutputMapping.getMappingText();
        if (actualMappingText == null) {
            throw new EventPublisherConfigurationException("Json mapping text is empty!");
        }
        if (jsonOutputMapping.isRegistryResource()) {
            boolean bl = this.isCustomRegistryPath = actualMappingText.contains("{{") && actualMappingText.indexOf("}}") > 0;
            if (!this.isCustomRegistryPath) {
                actualMappingText = this.runtimeResourceLoader.getResourceContent(jsonOutputMapping.getMappingText());
            }
        }
        return actualMappingText;
    }

    private Object getPropertyValue(Event event, String mappingProperty) {
        Object[] eventData = event.getData();
        Map arbitraryMap = event.getArbitraryDataMap();
        Integer position = this.propertyPositionMap.get(mappingProperty);
        Object data = null;
        if (position != null && eventData.length != 0) {
            data = eventData[position];
        } else if (mappingProperty != null && arbitraryMap != null && arbitraryMap.containsKey(mappingProperty)) {
            data = arbitraryMap.get(mappingProperty);
        }
        return data;
    }

    private String generateJsonEventTemplate(StreamDefinition streamDefinition) {
        List payloadAttributes;
        List correlationAttributes;
        JsonObject jsonEventObject = new JsonObject();
        JsonObject innerParentObject = new JsonObject();
        List metaDatAttributes = streamDefinition.getMetaData();
        if (metaDatAttributes != null && metaDatAttributes.size() > 0) {
            innerParentObject.add("metaData", (JsonElement)JSONOutputMapper.createPropertyElement("meta_", metaDatAttributes));
        }
        if ((correlationAttributes = streamDefinition.getCorrelationData()) != null && correlationAttributes.size() > 0) {
            innerParentObject.add("correlationData", (JsonElement)JSONOutputMapper.createPropertyElement("correlation_", correlationAttributes));
        }
        if ((payloadAttributes = streamDefinition.getPayloadData()) != null && payloadAttributes.size() > 0) {
            innerParentObject.add("payloadData", (JsonElement)JSONOutputMapper.createPropertyElement("", payloadAttributes));
        }
        jsonEventObject.add("event", (JsonElement)innerParentObject);
        String defaultMapping = jsonEventObject.toString();
        defaultMapping = defaultMapping.replaceAll("\"\\{\\{", "{{");
        defaultMapping = defaultMapping.replaceAll("\\}\\}\"", "}}");
        return defaultMapping;
    }

    private static JsonObject createPropertyElement(String dataPrefix, List<Attribute> attributeList) {
        JsonObject innerObject = new JsonObject();
        for (Attribute attribute : attributeList) {
            innerObject.addProperty(attribute.getName(), "{{" + dataPrefix + attribute.getName() + "}}");
        }
        return innerObject;
    }
}

