/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal.ds;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.publisher.core.config.OutputMapperFactory;
import org.wso2.carbon.event.publisher.core.internal.CarbonEventPublisherManagementService;
import org.wso2.carbon.event.publisher.core.internal.CarbonEventPublisherService;
import org.wso2.carbon.event.publisher.core.internal.type.json.JSONOutputMapperFactory;
import org.wso2.carbon.event.publisher.core.internal.type.map.MapOutputMapperFactory;
import org.wso2.carbon.event.publisher.core.internal.type.text.TextOutputMapperFactory;
import org.wso2.carbon.event.publisher.core.internal.type.wso2event.WSO2EventOutputMapperFactory;
import org.wso2.carbon.event.publisher.core.internal.type.xml.XMLOutputMapperFactory;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class EventPublisherServiceValueHolder {
    private static OutputEventAdapterService outputEventAdapterService;
    private static CarbonEventPublisherService carbonEventPublisherService;
    private static EventStreamService eventStreamService;
    private static RegistryService registryService;
    private static CarbonEventPublisherManagementService carbonEventPublisherManagementService;
    private static EventManagementService eventManagementService;
    private static ConcurrentHashMap<String, OutputMapperFactory> mappingFactoryMap;
    public static Set<String> outputEventAdapterTypes;
    private static ConfigurationContextService configurationContextService;
    private static boolean globalStatisticsEnabled;

    private EventPublisherServiceValueHolder() {
    }

    public static CarbonEventPublisherService getCarbonEventPublisherService() {
        return carbonEventPublisherService;
    }

    public static void registerPublisherService(EventPublisherService eventPublisherService) {
        carbonEventPublisherService = (CarbonEventPublisherService)eventPublisherService;
    }

    public static void registerEventAdapterService(OutputEventAdapterService eventAdapterService) {
        outputEventAdapterService = eventAdapterService;
    }

    public static OutputEventAdapterService getOutputEventAdapterService() {
        return outputEventAdapterService;
    }

    public static void setRegistryService(RegistryService registryService) {
        EventPublisherServiceValueHolder.registryService = registryService;
    }

    public static CarbonEventPublisherManagementService getCarbonEventPublisherManagementService() {
        return carbonEventPublisherManagementService;
    }

    public static void registerPublisherManagementService(CarbonEventPublisherManagementService eventPublisherManagementService) {
        carbonEventPublisherManagementService = eventPublisherManagementService;
    }

    public static void registerEventManagementService(EventManagementService eventManagementService) {
        EventPublisherServiceValueHolder.eventManagementService = eventManagementService;
    }

    public static void unSetRegistryService() {
        registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static Registry getRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static ConcurrentHashMap<String, OutputMapperFactory> getMappingFactoryMap() {
        return mappingFactoryMap;
    }

    public static EventManagementService getEventManagementService() {
        return eventManagementService;
    }

    public static void registerEventStreamService(EventStreamService eventStreamService) {
        EventPublisherServiceValueHolder.eventStreamService = eventStreamService;
    }

    public static EventStreamService getEventStreamService() {
        return eventStreamService;
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        EventPublisherServiceValueHolder.configurationContextService = configurationContextService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static Set<String> getOutputEventAdapterTypes() {
        return outputEventAdapterTypes;
    }

    public static void addOutputEventAdapterType(String outputEventAdapterType) {
        outputEventAdapterTypes.add(outputEventAdapterType);
    }

    public static void removeOutputEventAdapterType(String outputEventAdapterType) {
        outputEventAdapterTypes.remove(outputEventAdapterType);
    }

    public static void setGlobalStatisticsEnabled(boolean globalStatisticsEnabled) {
        EventPublisherServiceValueHolder.globalStatisticsEnabled = globalStatisticsEnabled;
    }

    public static boolean isGlobalStatisticsEnabled() {
        return globalStatisticsEnabled;
    }

    static {
        mappingFactoryMap = new ConcurrentHashMap();
        outputEventAdapterTypes = Collections.newSetFromMap(new ConcurrentHashMap());
        globalStatisticsEnabled = false;
        mappingFactoryMap.put("map", new MapOutputMapperFactory());
        mappingFactoryMap.put("text", new TextOutputMapperFactory());
        mappingFactoryMap.put("wso2event", new WSO2EventOutputMapperFactory());
        mappingFactoryMap.put("xml", new XMLOutputMapperFactory());
        mappingFactoryMap.put("json", new JSONOutputMapperFactory());
    }
}

