/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.processor.manager.core.EventManagementUtil;
import org.wso2.carbon.event.processor.manager.core.EventSync;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.processor.manager.core.config.HAConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.ManagementModeInfo;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherStreamValidationException;
import org.wso2.carbon.event.publisher.core.internal.BlockingEventQueue;
import org.wso2.carbon.event.publisher.core.internal.OutputMapper;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.stream.core.WSO2EventConsumer;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class EventPublisher
implements WSO2EventConsumer,
EventSync {
    private static final Log log = LogFactory.getLog(EventPublisher.class);
    private final boolean traceEnabled;
    private final boolean statisticsEnabled;
    private final boolean processingEnabled;
    private List<String> dynamicMessagePropertyList = new ArrayList<String>();
    private Log trace = LogFactory.getLog((String)"EVENT_TRACE_LOGGER");
    private EventPublisherConfiguration eventPublisherConfiguration = null;
    private int tenantId;
    private Map<String, Integer> propertyPositionMap = new TreeMap<String, Integer>();
    private OutputMapper outputMapper = null;
    private String streamId = null;
    private String beforeTracerPrefix;
    private String afterTracerPrefix;
    private boolean dynamicMessagePropertyEnabled = false;
    private boolean customMappingEnabled = false;
    private boolean isPolled = false;
    private Mode mode = Mode.SingleNode;
    private String syncId;
    private boolean sendToOther = false;
    private StreamDefinition streamDefinition;
    private boolean isContinue = false;
    private BlockingEventQueue eventQueue;
    private int inputStreamSize = 0;

    public EventPublisher(EventPublisherConfiguration eventPublisherConfiguration) throws EventPublisherConfigurationException {
        this.eventPublisherConfiguration = eventPublisherConfiguration;
        this.customMappingEnabled = eventPublisherConfiguration.getOutputMapping().isCustomMappingEnabled();
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String metricId = "WSO2_CEP.EventPublishers[+]." + eventPublisherConfiguration.getEventPublisherName() + "." + "PublishedEvents";
        String inputStreamName = eventPublisherConfiguration.getFromStreamName();
        String inputStreamVersion = eventPublisherConfiguration.getFromStreamVersion();
        StreamDefinition inputStreamDefinition = null;
        try {
            inputStreamDefinition = EventPublisherServiceValueHolder.getEventStreamService().getStreamDefinition(inputStreamName, inputStreamVersion);
        }
        catch (EventStreamConfigurationException e) {
            throw new EventPublisherConfigurationException("Cannot retrieve the stream definition from stream store : " + e.getMessage());
        }
        if (inputStreamDefinition == null) {
            throw new EventPublisherConfigurationException("No event stream exists for the corresponding stream name and version : " + inputStreamName + "-" + inputStreamVersion);
        }
        this.streamId = inputStreamDefinition.getStreamId();
        int metaSize = inputStreamDefinition.getMetaData() == null ? 0 : inputStreamDefinition.getMetaData().size();
        int correlationSize = inputStreamDefinition.getCorrelationData() == null ? 0 : inputStreamDefinition.getCorrelationData().size();
        int payloadSize = inputStreamDefinition.getPayloadData() == null ? 0 : inputStreamDefinition.getPayloadData().size();
        this.inputStreamSize = metaSize + correlationSize + payloadSize;
        this.createPropertyPositionMap(inputStreamDefinition);
        this.outputMapper = EventPublisherServiceValueHolder.getMappingFactoryMap().get(eventPublisherConfiguration.getOutputMapping().getMappingType()).constructOutputMapper(eventPublisherConfiguration, this.propertyPositionMap, this.tenantId, inputStreamDefinition);
        Map<String, String> dynamicOutputAdapterProperties = eventPublisherConfiguration.getToAdapterDynamicProperties();
        for (Map.Entry<String, String> entry : dynamicOutputAdapterProperties.entrySet()) {
            Map.Entry<String, String> pairs = entry;
            this.getDynamicOutputMessageProperties(pairs.getValue() != null ? pairs.getValue().toString() : "");
        }
        if (this.dynamicMessagePropertyList.size() > 0) {
            this.dynamicMessagePropertyEnabled = true;
        }
        try {
            EventPublisherServiceValueHolder.getEventStreamService().subscribe((WSO2EventConsumer)this);
        }
        catch (EventStreamConfigurationException e) {
            throw new EventPublisherStreamValidationException("Stream " + this.streamId + " does not exist", this.streamId);
        }
        this.traceEnabled = eventPublisherConfiguration.isTracingEnabled();
        this.statisticsEnabled = eventPublisherConfiguration.isStatisticsEnabled() && EventPublisherServiceValueHolder.isGlobalStatisticsEnabled();
        this.processingEnabled = eventPublisherConfiguration.isProcessingEnabled();
        if (this.statisticsEnabled) {
            // empty if block
        }
        if (this.traceEnabled) {
            this.beforeTracerPrefix = "TenantId : " + this.tenantId + ", " + "Event Publisher" + " : " + eventPublisherConfiguration.getEventPublisherName() + ", " + "Event Stream" + " : " + EventPublisherUtil.getImportedStreamIdFrom(eventPublisherConfiguration) + ", before processing " + System.getProperty("line.separator");
            this.afterTracerPrefix = "TenantId : " + this.tenantId + ", " + "Event Publisher" + " : " + eventPublisherConfiguration.getEventPublisherName() + ", after processing " + System.getProperty("line.separator");
        }
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        try {
            eventAdapterService.create(eventPublisherConfiguration.getToAdapterConfiguration());
        }
        catch (OutputEventAdapterException e) {
            throw new EventPublisherConfigurationException("Error in creating the output Adapter for Event Publisher :" + eventPublisherConfiguration.getEventPublisherName() + ", " + e.getMessage(), e);
        }
        try {
            this.isPolled = eventAdapterService.isPolled(eventPublisherConfiguration.getToAdapterConfiguration().getName());
        }
        catch (OutputEventAdapterException e) {
            throw new EventPublisherConfigurationException("Error in creating Event Publisher :" + eventPublisherConfiguration.getEventPublisherName() + ", " + e.getMessage(), e);
        }
        ManagementModeInfo managementModeInfo = EventPublisherServiceValueHolder.getEventManagementService().getManagementModeInfo();
        this.mode = managementModeInfo.getMode();
        if (this.mode == Mode.Distributed || this.mode == Mode.HA) {
            this.syncId = EventManagementUtil.constructEventSyncId((int)this.tenantId, (String)eventPublisherConfiguration.getToAdapterConfiguration().getName(), (Manager.ManagerType)Manager.ManagerType.Publisher);
            this.streamDefinition = EventManagementUtil.constructDatabridgeStreamDefinition((String)this.syncId, (StreamDefinition)inputStreamDefinition);
            if (this.mode == Mode.Distributed && managementModeInfo.getDistributedConfiguration().isWorkerNode()) {
                this.sendToOther = true;
            } else if (this.mode == Mode.HA && managementModeInfo.getHaConfiguration().isWorkerNode()) {
                this.sendToOther = true;
                HAConfiguration haConfiguration = managementModeInfo.getHaConfiguration();
                this.eventQueue = new BlockingEventQueue(haConfiguration.getEventSyncPublisherMaxQueueSizeInMb(), haConfiguration.getEventSyncPublisherQueueSize());
            }
            EventPublisherServiceValueHolder.getEventManagementService().registerEventSync((EventSync)this, Manager.ManagerType.Publisher);
        }
    }

    public EventPublisherConfiguration getEventPublisherConfiguration() {
        return this.eventPublisherConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        if (this.isPolled) {
            if (this.sendToOther) {
                EventPublisherServiceValueHolder.getEventManagementService().syncEvent(this.syncId, Manager.ManagerType.Publisher, event);
            }
            this.process(event);
        } else if (!EventPublisherServiceValueHolder.getCarbonEventPublisherManagementService().isDrop()) {
            if (this.mode == Mode.HA) {
                long currentTime = EventPublisherServiceValueHolder.getEventManagementService().getClusterTimeInMillis();
                if (!this.eventQueue.isEmpty()) {
                    long lastProcessedTime = EventPublisherServiceValueHolder.getEventManagementService().getLatestEventSentTime(this.eventPublisherConfiguration.getEventPublisherName(), this.tenantId);
                    while (!this.eventQueue.isEmpty()) {
                        EventWrapper eventWrapper = this.eventQueue.poll();
                        if (eventWrapper.getTimestampInMillis() <= lastProcessedTime) continue;
                        this.process(eventWrapper.getEvent());
                    }
                }
                EventPublisherServiceValueHolder.getEventManagementService().updateLatestEventSentTime(this.eventPublisherConfiguration.getEventPublisherName(), this.tenantId, currentTime);
            }
            this.process(event);
        } else if (this.mode == Mode.HA) {
            long currentTime = EventPublisherServiceValueHolder.getEventManagementService().getClusterTimeInMillis();
            EventWrapper eventWrapper = new EventWrapper(event, currentTime);
            while (!this.eventQueue.offer(eventWrapper)) {
                EventWrapper wrapper = this.eventQueue.poll();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Dropping event arrived at " + wrapper.getTimestampInMillis() + " due to insufficient capacity at Event Publisher Queue, dropped event: " + wrapper.getEvent()));
            }
            long lastProcessedTime = EventPublisherServiceValueHolder.getEventManagementService().getLatestEventSentTime(this.eventPublisherConfiguration.getEventPublisherName(), this.tenantId);
            EventPublisher eventPublisher = this;
            synchronized (eventPublisher) {
                while (!this.eventQueue.isEmpty() && this.eventQueue.peek().getTimestampInMillis() <= lastProcessedTime) {
                    this.eventQueue.remove();
                }
            }
        }
    }

    private void createPropertyPositionMap(StreamDefinition streamDefinition) {
        List metaAttributeList = streamDefinition.getMetaData();
        List correlationAttributeList = streamDefinition.getCorrelationData();
        List payloadAttributeList = streamDefinition.getPayloadData();
        int propertyCount = 0;
        if (metaAttributeList != null) {
            for (Attribute attribute : metaAttributeList) {
                this.propertyPositionMap.put("meta_" + attribute.getName(), propertyCount);
                ++propertyCount;
            }
        }
        if (correlationAttributeList != null) {
            for (Attribute attribute : correlationAttributeList) {
                this.propertyPositionMap.put("correlation_" + attribute.getName(), propertyCount);
                ++propertyCount;
            }
        }
        if (payloadAttributeList != null) {
            for (Attribute attribute : payloadAttributeList) {
                this.propertyPositionMap.put(attribute.getName(), propertyCount);
                ++propertyCount;
            }
        }
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void onEvent(Event event) {
        this.sendEvent(event);
    }

    public void onAddDefinition(StreamDefinition definition) {
    }

    public void onRemoveDefinition(StreamDefinition definition) {
    }

    private List<String> getDynamicOutputMessageProperties(String messagePropertyValue) {
        String text = messagePropertyValue;
        while (text.contains("{{") && text.indexOf("}}") > 0) {
            this.dynamicMessagePropertyList.add(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")));
            text = text.substring(text.indexOf("}}") + 2);
        }
        return this.dynamicMessagePropertyList;
    }

    private void changeDynamicEventAdapterMessageProperties(Object[] eventData, Map<String, String> dynamicProperties, Map<String, Object> arbitraryDataMap) {
        for (String dynamicMessageProperty : this.dynamicMessagePropertyList) {
            if (eventData.length == 0 && arbitraryDataMap.isEmpty() || dynamicMessageProperty == null) continue;
            Integer position = this.propertyPositionMap.get(dynamicMessageProperty);
            this.changePropertyValue(position, dynamicMessageProperty, eventData, dynamicProperties, arbitraryDataMap);
        }
    }

    private void changePropertyValue(Integer position, String messageProperty, Object[] eventData, Map<String, String> dynamicProperties, Map<String, Object> arbitraryDataMap) {
        for (Map.Entry<String, String> entry : dynamicProperties.entrySet()) {
            String mapValue = "{{" + messageProperty + "}}";
            String regexValue = "\\{\\{" + messageProperty + "\\}\\}";
            String entryValue = entry.getValue();
            if (entryValue == null || !entryValue.contains(mapValue)) continue;
            if (position == null) {
                if (arbitraryDataMap == null || !arbitraryDataMap.containsKey(messageProperty)) {
                    throw new EventPublisherStreamValidationException("Property " + messageProperty + " is neither in the input stream attributes nor in runtime arbitrary data map.");
                }
                entry.setValue(entryValue.replaceAll(regexValue, Matcher.quoteReplacement(arbitraryDataMap.get(messageProperty).toString())));
                continue;
            }
            if (eventData[position] != null) {
                entry.setValue(entryValue.replaceAll(regexValue, Matcher.quoteReplacement(eventData[position].toString())));
                continue;
            }
            entry.setValue(entryValue.replaceAll(regexValue, ""));
        }
    }

    public void destroy() {
        if (this.mode == Mode.Distributed || this.mode == Mode.HA) {
            EventPublisherServiceValueHolder.getEventManagementService().unregisterEventSync(this.syncId, Manager.ManagerType.Publisher);
        }
        EventPublisherServiceValueHolder.getOutputEventAdapterService().destroy(this.eventPublisherConfiguration.getEventPublisherName());
    }

    public void process(Event event) {
        Object outObject;
        HashMap<String, String> dynamicProperties = new HashMap<String, String>(this.eventPublisherConfiguration.getToAdapterDynamicProperties());
        if (this.traceEnabled) {
            this.trace.info((Object)(this.beforeTracerPrefix + event));
        }
        if (this.statisticsEnabled) {
            // empty if block
        }
        if (!this.processingEnabled) {
            return;
        }
        org.wso2.siddhi.core.event.Event siddhiEvent = EventPublisherUtil.convertToSiddhiEvent(event, this.inputStreamSize);
        try {
            outObject = this.customMappingEnabled ? this.outputMapper.convertToMappedInputEvent(siddhiEvent) : this.outputMapper.convertToTypedInputEvent(siddhiEvent);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)("Cannot send " + event + " from " + this.eventPublisherConfiguration.getEventPublisherName()), (Throwable)e);
            return;
        }
        if (this.traceEnabled) {
            this.trace.info((Object)(this.afterTracerPrefix + outObject));
        }
        if (this.dynamicMessagePropertyEnabled) {
            this.changeDynamicEventAdapterMessageProperties(siddhiEvent.getData(), dynamicProperties, siddhiEvent.getArbitraryDataMap());
        }
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        eventAdapterService.publish(this.eventPublisherConfiguration.getEventPublisherName(), dynamicProperties, outObject);
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public boolean isContinueProcess() {
        return this.isContinue;
    }

    public void setContinueProcess(boolean isContinue) {
        this.isContinue = isContinue;
    }

    public String getOriginalEventStreamId() {
        return this.streamDefinition.getStreamId();
    }

    public void prepareDestroy() {
        if (EventPublisherServiceValueHolder.getEventManagementService().getManagementModeInfo().getMode() == Mode.HA && EventPublisherServiceValueHolder.getEventManagementService().getManagementModeInfo().getHaConfiguration().isWorkerNode()) {
            EventPublisherServiceValueHolder.getEventManagementService().updateLatestEventSentTime(this.eventPublisherConfiguration.getEventPublisherName(), this.tenantId, EventPublisherServiceValueHolder.getEventManagementService().getClusterTimeInMillis());
        }
    }

    public class EventWrapper {
        private Event event;
        private long timestampInMillis;
        private int size;

        public EventWrapper(Event event, long timestamp) {
            this.event = event;
            this.timestampInMillis = timestamp;
        }

        public Event getEvent() {
            return this.event;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public long getTimestampInMillis() {
            return this.timestampInMillis;
        }
    }
}

