/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.dataretrieval.DataRetrievalUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterSchema;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.publisher.core.EventPublisherDeployer;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfigurationFile;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.EventPublisher;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherConfigurationBuilder;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;
import org.wso2.carbon.event.publisher.core.internal.util.helper.EventPublisherConfigurationFilesystemInvoker;
import org.wso2.carbon.event.publisher.core.internal.util.helper.EventPublisherConfigurationHelper;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.WSO2EventConsumer;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.xml.sax.InputSource;

public class CarbonEventPublisherService
implements EventPublisherService {
    private static final Log log = LogFactory.getLog(CarbonEventPublisherService.class);
    private Map<Integer, Map<String, EventPublisher>> tenantSpecificEventPublisherConfigurationMap = new ConcurrentHashMap<Integer, Map<String, EventPublisher>>();
    private Map<Integer, List<EventPublisherConfigurationFile>> tenantSpecificEventPublisherConfigurationFileMap = new ConcurrentHashMap<Integer, List<EventPublisherConfigurationFile>>();
    private Map<Integer, EventPublisherDeployer> tenantSpecificDeployerMap = new ConcurrentHashMap<Integer, EventPublisherDeployer>();

    @Override
    public void deployEventPublisherConfiguration(EventPublisherConfiguration eventPublisherConfiguration) throws EventPublisherConfigurationException {
        String eventPublisherName = eventPublisherConfiguration.getEventPublisherName();
        OMElement omElement = EventPublisherConfigurationBuilder.eventPublisherConfigurationToOM(eventPublisherConfiguration);
        EventPublisherConfigurationHelper.validateEventPublisherConfiguration(omElement);
        if (EventPublisherConfigurationHelper.getOutputMappingType(omElement) == null) {
            throw new EventPublisherConfigurationException("Mapping type of the Event Publisher " + eventPublisherName + " cannot be null");
        }
        String repoPath = EventPublisherUtil.getAxisConfiguration().getRepository().getPath();
        EventPublisherUtil.generateFilePath(eventPublisherName, repoPath);
        this.validateToRemoveInactiveEventPublisherConfiguration(eventPublisherName);
        EventPublisherConfigurationFilesystemInvoker.encryptAndSave(omElement, eventPublisherName + ".xml");
    }

    @Override
    public EventPublisherConfiguration getEventPublisherConfiguration(InputStream eventPublisherConfiguration) throws EventPublisherConfigurationException {
        EventPublisherConfiguration eventPublisherConfigurationObject;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            OMElement omElement = DataRetrievalUtil.convertToOMElement((InputStream)eventPublisherConfiguration);
            omElement.build();
            EventPublisherConfigurationHelper.validateEventPublisherConfiguration(omElement);
            String mappingType = EventPublisherConfigurationHelper.getOutputMappingType(omElement);
            if (mappingType == null) {
                throw new EventPublisherConfigurationException("Mapping type of the Event Publisher cannot be null");
            }
            eventPublisherConfigurationObject = EventPublisherConfigurationBuilder.getEventPublisherConfiguration(omElement, mappingType, true, tenantId);
        }
        catch (XMLStreamException e) {
            throw new EventPublisherConfigurationException("Error while building XML configuration :" + e.getMessage(), e);
        }
        return eventPublisherConfigurationObject;
    }

    @Override
    public void deployEventPublisherConfiguration(String eventPublisherConfigXml) throws EventPublisherConfigurationException {
        OMElement omElement = null;
        try {
            omElement = AXIOMUtil.stringToOM((String)eventPublisherConfigXml);
        }
        catch (XMLStreamException e) {
            throw new EventPublisherConfigurationException("Error in parsing XML configuration of event publisher.");
        }
        EventPublisherConfigurationHelper.validateEventPublisherConfiguration(omElement);
        String eventPublisherName = EventPublisherConfigurationHelper.getEventPublisherName(omElement);
        if (EventPublisherConfigurationHelper.getOutputMappingType(omElement) == null) {
            throw new EventPublisherConfigurationException("Mapping type of the Event Publisher " + eventPublisherName + " cannot be null");
        }
        String repoPath = EventPublisherUtil.getAxisConfiguration().getRepository().getPath();
        EventPublisherUtil.generateFilePath(eventPublisherName, repoPath);
        this.validateToRemoveInactiveEventPublisherConfiguration(eventPublisherName);
        EventPublisherConfigurationFilesystemInvoker.encryptAndSave(omElement, eventPublisherName + ".xml");
    }

    @Override
    public String getEventPublisherName(String eventPublisherConfigXml) throws EventPublisherConfigurationException {
        OMElement omElement;
        try {
            omElement = AXIOMUtil.stringToOM((String)eventPublisherConfigXml);
        }
        catch (XMLStreamException e) {
            throw new EventPublisherConfigurationException("Error parsing XML configuration of event publisher.", e);
        }
        EventPublisherConfigurationHelper.validateEventPublisherConfiguration(omElement);
        return EventPublisherConfigurationHelper.getEventPublisherName(omElement);
    }

    @Override
    public void undeployActiveEventPublisherConfiguration(String eventPublisherName) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(tenantId, eventPublisherName);
        if (fileName == null) {
            throw new EventPublisherConfigurationException("Couldn't undeploy the Event Publisher configuration : " + eventPublisherName);
        }
        EventPublisherConfigurationFilesystemInvoker.delete(fileName);
    }

    @Override
    public void undeployInactiveEventPublisherConfiguration(String filename) throws EventPublisherConfigurationException {
        EventPublisherConfigurationFilesystemInvoker.delete(filename);
    }

    @Override
    public void editInactiveEventPublisherConfiguration(String eventPublisherConfiguration, String filename) throws EventPublisherConfigurationException {
        this.editEventPublisherConfiguration(filename, eventPublisherConfiguration, null);
    }

    @Override
    public void editActiveEventPublisherConfiguration(String eventPublisherConfiguration, String eventPublisherName) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(tenantId, eventPublisherName);
        if (fileName == null) {
            fileName = eventPublisherName + ".xml";
        }
        this.editEventPublisherConfiguration(fileName, eventPublisherConfiguration, eventPublisherName);
    }

    @Override
    public EventPublisherConfiguration getActiveEventPublisherConfiguration(String eventPublisherName) throws EventPublisherConfigurationException {
        EventPublisher eventPublisher;
        EventPublisherConfiguration eventPublisherConfiguration = null;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventPublisher> tenantSpecificEventPublisherMap = this.tenantSpecificEventPublisherConfigurationMap.get(tenantId);
        if (tenantSpecificEventPublisherMap != null && tenantSpecificEventPublisherMap.size() > 0 && (eventPublisher = tenantSpecificEventPublisherMap.get(eventPublisherName)) != null) {
            eventPublisherConfiguration = eventPublisher.getEventPublisherConfiguration();
        }
        return eventPublisherConfiguration;
    }

    @Override
    public List<EventPublisherConfiguration> getAllActiveEventPublisherConfigurations() {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ArrayList<EventPublisherConfiguration> eventPublisherConfigurations = new ArrayList<EventPublisherConfiguration>();
        Map<String, EventPublisher> tenantSpecificEventPublisherMap = this.tenantSpecificEventPublisherConfigurationMap.get(tenantId);
        if (tenantSpecificEventPublisherMap != null) {
            for (EventPublisher eventPublisher : tenantSpecificEventPublisherMap.values()) {
                eventPublisherConfigurations.add(eventPublisher.getEventPublisherConfiguration());
            }
        }
        return eventPublisherConfigurations;
    }

    @Override
    public List<EventPublisherConfiguration> getAllActiveEventPublisherConfigurations(String streamId) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ArrayList<EventPublisherConfiguration> eventPublisherConfigurations = new ArrayList<EventPublisherConfiguration>();
        if (this.tenantSpecificEventPublisherConfigurationMap.get(tenantId) != null) {
            for (EventPublisher eventPublisher : this.tenantSpecificEventPublisherConfigurationMap.get(tenantId).values()) {
                if (!eventPublisher.getStreamId().equals(streamId)) continue;
                eventPublisherConfigurations.add(eventPublisher.getEventPublisherConfiguration());
            }
        }
        return eventPublisherConfigurations;
    }

    @Override
    public List<EventPublisherConfigurationFile> getAllInactiveEventPublisherConfigurations() {
        ArrayList<EventPublisherConfigurationFile> undeployedEventPublisherFileList = new ArrayList<EventPublisherConfigurationFile>();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFiles = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId);
        if (eventPublisherConfigurationFiles != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFiles) {
                if (eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.DEPLOYED)) continue;
                undeployedEventPublisherFileList.add(eventPublisherConfigurationFile);
            }
        }
        return undeployedEventPublisherFileList;
    }

    @Override
    public String getInactiveEventPublisherConfigurationContent(String filename) throws EventPublisherConfigurationException {
        return EventPublisherConfigurationFilesystemInvoker.readEventPublisherConfigurationFile(filename);
    }

    @Override
    public String getActiveEventPublisherConfigurationContent(String eventPublisherName) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(tenantId, eventPublisherName);
        return EventPublisherConfigurationFilesystemInvoker.readEventPublisherConfigurationFile(fileName);
    }

    @Override
    public StreamDefinition getStreamDefinition(String streamNameWithVersion) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventStreamService eventStreamService = EventPublisherServiceValueHolder.getEventStreamService();
        try {
            return eventStreamService.getStreamDefinition(streamNameWithVersion);
        }
        catch (EventStreamConfigurationException e) {
            throw new EventPublisherConfigurationException("Error while getting stream definition from store : " + e.getMessage(), e);
        }
    }

    @Override
    public String getRegistryResourceContent(String resourcePath) throws EventPublisherConfigurationException {
        String registryData;
        RegistryService registryService = EventPublisherServiceValueHolder.getRegistryService();
        Resource registryResource = null;
        try {
            Object registryContent;
            String pathPrefix = resourcePath.substring(0, resourcePath.indexOf(58) + 2);
            if (pathPrefix.equalsIgnoreCase("conf:/")) {
                resourcePath = resourcePath.replace(pathPrefix, "");
                registryResource = registryService.getConfigSystemRegistry().get(resourcePath);
            } else if (pathPrefix.equalsIgnoreCase("gov:/")) {
                resourcePath = resourcePath.replace(pathPrefix, "");
                registryResource = registryService.getGovernanceSystemRegistry().get(resourcePath);
            }
            if (registryResource != null) {
                registryContent = registryResource.getContent();
                if (registryContent == null) {
                    throw new EventPublisherConfigurationException("There is no registry resource content available at " + resourcePath);
                }
            } else {
                throw new EventPublisherConfigurationException("Resource couldn't found from registry at " + resourcePath);
            }
            registryData = RegistryUtils.decodeBytes((byte[])((byte[])registryContent));
        }
        catch (RegistryException e) {
            throw new EventPublisherConfigurationException("Error while retrieving the resource from registry at " + resourcePath, e);
        }
        catch (ClassCastException e) {
            throw new EventPublisherConfigurationException("Invalid mapping content found in " + resourcePath, e);
        }
        return registryData;
    }

    @Override
    public void setStatisticsEnabled(String eventPublisherName, boolean statisticsEnabled) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventPublisherConfiguration eventPublisherConfiguration = this.getActiveEventPublisherConfiguration(eventPublisherName);
        eventPublisherConfiguration.setStatisticsEnabled(statisticsEnabled);
        this.editTracingStatisticsProcessing(eventPublisherConfiguration, eventPublisherName, tenantId);
    }

    @Override
    public void setTraceEnabled(String eventPublisherName, boolean traceEnabled) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventPublisherConfiguration eventPublisherConfiguration = this.getActiveEventPublisherConfiguration(eventPublisherName);
        eventPublisherConfiguration.setTraceEnabled(traceEnabled);
        this.editTracingStatisticsProcessing(eventPublisherConfiguration, eventPublisherName, tenantId);
    }

    @Override
    public void setProcessEnabled(String eventPublisherName, boolean processEnabled) throws EventPublisherConfigurationException {
        if (!processEnabled) {
            log.info((Object)("EventPublisher disabled : " + eventPublisherName));
        } else {
            log.info((Object)("EventPublisher enabled : " + eventPublisherName));
        }
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventPublisherConfiguration eventPublisherConfiguration = this.getActiveEventPublisherConfiguration(eventPublisherName);
        eventPublisherConfiguration.setProcessEnabled(processEnabled);
        this.editTracingStatisticsProcessing(eventPublisherConfiguration, eventPublisherName, tenantId);
    }

    @Override
    public void addEventPublisherConfigurationFile(EventPublisherConfigurationFile eventPublisherConfigurationFile, int tenantId) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFileList = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId);
        if (eventPublisherConfigurationFileList == null) {
            eventPublisherConfigurationFileList = new CopyOnWriteArrayList<EventPublisherConfigurationFile>();
        } else {
            for (EventPublisherConfigurationFile anEventPublisherConfigurationFileList : eventPublisherConfigurationFileList) {
                if (!anEventPublisherConfigurationFileList.getFileName().equals(eventPublisherConfigurationFile.getFileName())) continue;
                return;
            }
        }
        eventPublisherConfigurationFileList.add(eventPublisherConfigurationFile);
        this.tenantSpecificEventPublisherConfigurationFileMap.put(tenantId, eventPublisherConfigurationFileList);
    }

    @Override
    public void addEventPublisherConfiguration(EventPublisherConfiguration eventPublisherConfiguration) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventPublisher> eventPublisherConfigurationMap = this.tenantSpecificEventPublisherConfigurationMap.get(tenantId);
        if (eventPublisherConfigurationMap == null) {
            eventPublisherConfigurationMap = new ConcurrentHashMap<String, EventPublisher>();
        }
        EventPublisher eventPublisher = new EventPublisher(eventPublisherConfiguration);
        eventPublisherConfigurationMap.put(eventPublisherConfiguration.getEventPublisherName(), eventPublisher);
        this.tenantSpecificEventPublisherConfigurationMap.put(tenantId, eventPublisherConfigurationMap);
    }

    @Override
    public void removeEventPublisherConfigurationFile(String fileName, int tenantId) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFileList = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId);
        if (eventPublisherConfigurationFileList != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFileList) {
                if (!eventPublisherConfigurationFile.getFileName().equals(fileName)) continue;
                if (eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.DEPLOYED)) {
                    String eventPublisherName = eventPublisherConfigurationFile.getEventPublisherName();
                    EventPublisher eventPublisher = this.tenantSpecificEventPublisherConfigurationMap.get(tenantId).remove(eventPublisherName);
                    if (eventPublisher != null) {
                        eventPublisher.prepareDestroy();
                        EventPublisherServiceValueHolder.getEventStreamService().unsubscribe((WSO2EventConsumer)eventPublisher);
                        eventPublisher.destroy();
                    }
                }
                eventPublisherConfigurationFileList.remove(eventPublisherConfigurationFile);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateInactiveEventPublisherConfigurationsForAdapter(String eventAdapterType) throws EventPublisherConfigurationException {
        ArrayList<EventPublisherConfigurationFile> fileList = new ArrayList<EventPublisherConfigurationFile>();
        if (this.tenantSpecificEventPublisherConfigurationFileMap != null && this.tenantSpecificEventPublisherConfigurationFileMap.size() > 0) {
            for (List list : this.tenantSpecificEventPublisherConfigurationFileMap.values()) {
                if (list == null) continue;
                for (EventPublisherConfigurationFile eventPublisherConfigurationFile : list) {
                    if (!eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.WAITING_FOR_DEPENDENCY) || !eventPublisherConfigurationFile.getDependency().equalsIgnoreCase(eventAdapterType)) continue;
                    fileList.add(eventPublisherConfigurationFile);
                }
            }
        }
        for (EventPublisherConfigurationFile eventPublisherConfigurationFile : fileList) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(eventPublisherConfigurationFile.getTenantId());
                carbonContext.getTenantDomain(true);
                EventPublisherConfigurationFilesystemInvoker.reload(eventPublisherConfigurationFile.getFilePath(), this.tenantSpecificDeployerMap);
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred while trying to deploy the Event publisher configuration file : " + eventPublisherConfigurationFile.getFileName()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateInactiveEventPublisherConfigurationsForStream(String streamId, int tenantId) throws EventPublisherConfigurationException {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFileList;
        ArrayList<EventPublisherConfigurationFile> fileList = new ArrayList<EventPublisherConfigurationFile>();
        if (this.tenantSpecificEventPublisherConfigurationFileMap != null && this.tenantSpecificEventPublisherConfigurationFileMap.size() > 0 && (eventPublisherConfigurationFileList = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId)) != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFileList) {
                if (!EventPublisherConfigurationFile.Status.WAITING_FOR_STREAM_DEPENDENCY.equals((Object)eventPublisherConfigurationFile.getStatus()) || !streamId.equalsIgnoreCase(eventPublisherConfigurationFile.getDependency())) continue;
                fileList.add(eventPublisherConfigurationFile);
            }
        }
        for (EventPublisherConfigurationFile eventPublisherConfigurationFile : fileList) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(eventPublisherConfigurationFile.getTenantId());
                carbonContext.getTenantDomain(true);
                EventPublisherConfigurationFilesystemInvoker.reload(eventPublisherConfigurationFile.getFilePath(), this.tenantSpecificDeployerMap);
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred while trying to deploy the Event publisher configuration file : " + new File(eventPublisherConfigurationFile.getFileName()).getName()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public void deactivateActiveEventPublisherConfigurationsForAdapter(String dependency) throws EventPublisherConfigurationException {
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        ArrayList<EventPublisherConfigurationFile> fileList = new ArrayList<EventPublisherConfigurationFile>();
        if (this.tenantSpecificEventPublisherConfigurationMap != null && this.tenantSpecificEventPublisherConfigurationMap.size() > 0) {
            for (Map.Entry entry : this.tenantSpecificEventPublisherConfigurationMap.entrySet()) {
                if (entry.getValue() == null) continue;
                int tenantId = (Integer)entry.getKey();
                for (EventPublisher eventPublisher : ((Map)entry.getValue()).values()) {
                    EventPublisherConfigurationFile eventPublisherConfigurationFile;
                    String eventAdapterType = eventPublisher.getEventPublisherConfiguration().getToAdapterConfiguration().getType();
                    if (!eventAdapterType.equals(dependency) || (eventPublisherConfigurationFile = this.getEventPublisherConfigurationFile(eventPublisher.getEventPublisherConfiguration().getEventPublisherName(), tenantId)) == null) continue;
                    fileList.add(eventPublisherConfigurationFile);
                    eventAdapterService.destroy(eventPublisher.getEventPublisherConfiguration().getToAdapterConfiguration().getName());
                }
            }
        }
        for (EventPublisherConfigurationFile eventPublisherConfigurationFile : fileList) {
            EventPublisherConfigurationFilesystemInvoker.reload(eventPublisherConfigurationFile.getFilePath(), this.tenantSpecificDeployerMap);
            log.info((Object)("Event publisher : " + eventPublisherConfigurationFile.getEventPublisherName() + "  is in inactive state because dependency could not be found : " + dependency));
        }
    }

    public void deactivateActiveEventPublisherConfigurationsForStream(String streamId, int tenantId) throws EventPublisherConfigurationException {
        Map<String, EventPublisher> eventPublisherMap;
        OutputEventAdapterService eventAdapterService = EventPublisherServiceValueHolder.getOutputEventAdapterService();
        ArrayList<EventPublisherConfigurationFile> fileList = new ArrayList<EventPublisherConfigurationFile>();
        if (this.tenantSpecificEventPublisherConfigurationMap != null && this.tenantSpecificEventPublisherConfigurationMap.size() > 0 && (eventPublisherMap = this.tenantSpecificEventPublisherConfigurationMap.get(tenantId)) != null) {
            for (EventPublisher eventPublisher : eventPublisherMap.values()) {
                EventPublisherConfigurationFile eventPublisherConfigurationFile;
                EventPublisherConfiguration eventPublisherConfiguration = eventPublisher.getEventPublisherConfiguration();
                String stream = EventPublisherUtil.getImportedStreamIdFrom(eventPublisherConfiguration);
                if (!streamId.equals(stream) || (eventPublisherConfigurationFile = this.getEventPublisherConfigurationFile(eventPublisherConfiguration.getEventPublisherName(), tenantId)) == null) continue;
                fileList.add(eventPublisherConfigurationFile);
                eventAdapterService.destroy(eventPublisherConfiguration.getToAdapterConfiguration().getName());
            }
        }
        for (EventPublisherConfigurationFile eventPublisherConfigurationFile : fileList) {
            EventPublisherConfigurationFilesystemInvoker.reload(eventPublisherConfigurationFile.getFilePath(), this.tenantSpecificDeployerMap);
            log.info((Object)("Event publisher : " + eventPublisherConfigurationFile.getEventPublisherName() + "  is in inactive state because stream dependency could not be found : " + streamId));
        }
    }

    public boolean isEventPublisherAlreadyExists(int tenantId, String eventPublisherName) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFiles;
        if (this.tenantSpecificEventPublisherConfigurationFileMap.size() > 0 && (eventPublisherConfigurationFiles = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId)) != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFiles) {
                if (!eventPublisherConfigurationFile.getEventPublisherName().equals(eventPublisherName) || !eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.DEPLOYED)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEventPublisherFileAlreadyExist(String eventPublisherFileName, int tenantId) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFiles;
        if (this.tenantSpecificEventPublisherConfigurationFileMap.size() > 0 && (eventPublisherConfigurationFiles = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId)) != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFiles) {
                if (!eventPublisherConfigurationFile.getFileName().equals(eventPublisherFileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void editTracingStatisticsProcessing(EventPublisherConfiguration eventPublisherConfiguration, String eventPublisherName, int tenantId) throws EventPublisherConfigurationException {
        String fileName = this.getFileName(tenantId, eventPublisherName);
        this.undeployActiveEventPublisherConfiguration(eventPublisherName);
        OMElement omElement = EventPublisherConfigurationBuilder.eventPublisherConfigurationToOM(eventPublisherConfiguration);
        EventPublisherConfigurationFilesystemInvoker.delete(fileName);
        EventPublisherConfigurationFilesystemInvoker.encryptAndSave(omElement, fileName);
    }

    private String getFileName(int tenantId, String eventPublisherName) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFileList;
        if (this.tenantSpecificEventPublisherConfigurationFileMap.size() > 0 && (eventPublisherConfigurationFileList = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId)) != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFileList) {
                if (!eventPublisherConfigurationFile.getEventPublisherName().equals(eventPublisherName) || !eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.DEPLOYED)) continue;
                return eventPublisherConfigurationFile.getFileName();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void editEventPublisherConfiguration(String filename, String eventPublisherConfigurationXml, String originalEventPublisherName) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            DocumentBuilderFactory dbf = EventPublisherUtil.getSecuredDocumentBuilder();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(eventPublisherConfigurationXml)));
            OMElement omElement = XMLUtils.toOM((Element)document.getDocumentElement());
            omElement.build();
            EventPublisherConfigurationHelper.validateEventPublisherConfiguration(omElement);
            String mappingType = EventPublisherConfigurationHelper.getOutputMappingType(omElement);
            if (mappingType == null) throw new EventPublisherConfigurationException("Mapping type of the Event Publisher " + originalEventPublisherName + " cannot be null");
            EventPublisherConfiguration eventPublisherConfigurationObject = EventPublisherConfigurationBuilder.getEventPublisherConfiguration(omElement, mappingType, true, tenantId);
            if (!eventPublisherConfigurationObject.getEventPublisherName().equals(originalEventPublisherName)) {
                if (this.isEventPublisherAlreadyExists(tenantId, eventPublisherConfigurationObject.getEventPublisherName())) throw new EventPublisherConfigurationException("There is already a Event Publisher " + eventPublisherConfigurationObject.getEventPublisherName() + " with the same name");
                EventPublisherConfigurationFilesystemInvoker.delete(filename);
                EventPublisherConfigurationFilesystemInvoker.encryptAndSave(omElement, filename);
                return;
            } else {
                EventPublisherConfigurationFilesystemInvoker.delete(filename);
                EventPublisherConfigurationFilesystemInvoker.encryptAndSave(omElement, filename);
            }
            return;
        }
        catch (Exception e) {
            throw new EventPublisherConfigurationException("Error while building XML configuration :" + e.getMessage(), e);
        }
    }

    private EventPublisherConfigurationFile getEventPublisherConfigurationFile(String eventPublisherName, int tenantId) {
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFileList = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId);
        if (eventPublisherConfigurationFileList != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFileList) {
                if (!eventPublisherConfigurationFile.getEventPublisherName().equals(eventPublisherName)) continue;
                return eventPublisherConfigurationFile;
            }
        }
        return null;
    }

    private void validateToRemoveInactiveEventPublisherConfiguration(String eventPublisherName) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = eventPublisherName + ".xml";
        List<EventPublisherConfigurationFile> eventPublisherConfigurationFiles = this.tenantSpecificEventPublisherConfigurationFileMap.get(tenantId);
        if (eventPublisherConfigurationFiles != null) {
            for (EventPublisherConfigurationFile eventPublisherConfigurationFile : eventPublisherConfigurationFiles) {
                if (!eventPublisherConfigurationFile.getFileName().equals(fileName) || eventPublisherConfigurationFile.getStatus().equals((Object)EventPublisherConfigurationFile.Status.DEPLOYED)) continue;
                EventPublisherConfigurationFilesystemInvoker.delete(fileName);
                break;
            }
        }
    }

    public List<String> getEncryptedProperties(String eventAdaptorType) {
        ArrayList<String> encryptedProperties = new ArrayList<String>(1);
        OutputEventAdapterSchema outputEventAdapterSchema = EventPublisherServiceValueHolder.getOutputEventAdapterService().getOutputEventAdapterSchema(eventAdaptorType);
        if (outputEventAdapterSchema != null) {
            List properties = outputEventAdapterSchema.getStaticPropertyList();
            if (properties != null) {
                for (Property prop : properties) {
                    if (!prop.isEncrypted()) continue;
                    encryptedProperties.add(prop.getPropertyName());
                }
            }
            if ((properties = outputEventAdapterSchema.getDynamicPropertyList()) != null) {
                for (Property prop : properties) {
                    if (!prop.isEncrypted()) continue;
                    encryptedProperties.add(prop.getPropertyName());
                }
            }
        }
        return encryptedProperties;
    }

    public Map<Integer, EventPublisherDeployer> getTenantSpecificDeployerMap() {
        return this.tenantSpecificDeployerMap;
    }
}

