/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core.internal;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.publisher.core.internal.EventPublisher;
import org.wso2.carbon.event.publisher.core.internal.util.EventPublisherUtil;

public class BlockingEventQueue
extends LinkedBlockingQueue<EventPublisher.EventWrapper> {
    private static final Log log = LogFactory.getLog(BlockingEventQueue.class);
    private int maxSizeInBytes;
    private Semaphore semaphore;
    private AtomicInteger currentSize;
    private final Object lock;
    private int currentEventSize;

    public BlockingEventQueue(int maxSizeInMb, int maxNumOfEvents) {
        super(maxNumOfEvents);
        this.maxSizeInBytes = maxSizeInMb * 1000000;
        this.semaphore = new Semaphore(1);
        this.currentSize = new AtomicInteger(0);
        this.lock = new Object();
        this.currentEventSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(EventPublisher.EventWrapper event) throws InterruptedException {
        block11: {
            this.currentEventSize = EventPublisherUtil.getSize(event.getEvent()) + 4 + 8;
            event.setSize(this.currentEventSize);
            if (this.currentSize.get() >= this.maxSizeInBytes) {
                try {
                    this.semaphore.acquire();
                    if (this.semaphore.availablePermits() != 0) break block11;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.semaphore.availablePermits() == 0) {
                            this.semaphore.release();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        super.put(event);
        if (this.currentSize.addAndGet(this.currentEventSize) >= this.maxSizeInBytes) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("current queue size in bytes : " + this.currentSize + ", remaining capacity : " + this.remainingCapacity()));
        }
    }

    @Override
    public EventPublisher.EventWrapper take() throws InterruptedException {
        EventPublisher.EventWrapper wrappedEvent = (EventPublisher.EventWrapper)super.take();
        this.releaseEvent(wrappedEvent);
        return wrappedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEvent(EventPublisher.EventWrapper wrappedEvent) {
        this.currentSize.addAndGet(-wrappedEvent.getSize());
        if (this.semaphore.availablePermits() == 0 && (this.currentEventSize + this.currentSize.get() < this.maxSizeInBytes || this.size() == 0)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.semaphore.availablePermits() == 0 && (this.currentEventSize + this.currentSize.get() < this.maxSizeInBytes || this.size() == 0)) {
                    this.semaphore.release();
                }
            }
        }
    }

    @Override
    public EventPublisher.EventWrapper poll() {
        EventPublisher.EventWrapper wrappedEvent = (EventPublisher.EventWrapper)super.poll();
        if (wrappedEvent != null) {
            this.releaseEvent(wrappedEvent);
            return wrappedEvent;
        }
        return null;
    }

    @Override
    public EventPublisher.EventWrapper peek() {
        EventPublisher.EventWrapper wrappedEvent = (EventPublisher.EventWrapper)super.peek();
        if (wrappedEvent != null) {
            return wrappedEvent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(EventPublisher.EventWrapper event) {
        int size = EventPublisherUtil.getSize(event.getEvent()) + 4 + 8;
        event.setSize(size);
        boolean acquired = true;
        boolean offered = false;
        if (this.currentSize.get() >= this.maxSizeInBytes && (acquired = this.semaphore.tryAcquire()) && this.semaphore.availablePermits() == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.semaphore.availablePermits() == 0) {
                    this.semaphore.release();
                }
            }
        }
        if (acquired) {
            offered = super.offer(event);
        }
        if (this.currentSize.addAndGet(size) >= this.maxSizeInBytes) {
            this.semaphore.tryAcquire();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("current queue size in bytes : " + this.currentSize.get() + ", remaining capacity : " + this.remainingCapacity()));
        }
        return offered;
    }

    @Override
    public EventPublisher.EventWrapper remove() {
        EventPublisher.EventWrapper eventWrapper = (EventPublisher.EventWrapper)super.remove();
        if (eventWrapper != null) {
            this.releaseEvent(eventWrapper);
        }
        return eventWrapper;
    }
}

