/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.publisher.core.internal.CarbonEventPublisherService;
import org.wso2.carbon.event.publisher.core.internal.ds.EventPublisherServiceValueHolder;
import org.wso2.carbon.event.stream.core.EventStreamListener;

public class EventStreamListenerImpl
implements EventStreamListener {
    private static final Log log = LogFactory.getLog(EventStreamListenerImpl.class);

    public void removedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventPublisherService carbonEventPublisherService = EventPublisherServiceValueHolder.getCarbonEventPublisherService();
        String streamNameWithVersion = streamName + ":" + streamVersion;
        try {
            carbonEventPublisherService.deactivateActiveEventPublisherConfigurationsForStream(streamNameWithVersion, tenantId);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)"Exception occurred while un-deploying the Event publisher configuration files");
        }
    }

    public void addedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventPublisherService carbonEventPublisherService = EventPublisherServiceValueHolder.getCarbonEventPublisherService();
        String streamNameWithVersion = streamName + ":" + streamVersion;
        try {
            carbonEventPublisherService.activateInactiveEventPublisherConfigurationsForStream(streamNameWithVersion, tenantId);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)"Exception occurred while un-deploying the Event publisher configuration files");
        }
    }
}

