/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.synapse.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.synapse.SynapseAppDeployer;
import org.wso2.carbon.application.deployer.synapse.internal.DataHolder;
import org.wso2.carbon.application.deployer.synapse.service.SynapseAppDeployerService;
import org.wso2.carbon.application.deployer.synapse.service.SynapseAppDeployerServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;

@Component(name="application.deployer.synapse", immediate=true)
public class SynapseAppDeployerDSComponent
implements ServiceListener {
    private static Log log = LogFactory.getLog(SynapseAppDeployerDSComponent.class);
    private static Map<String, List<Feature>> requiredFeatures;
    private static ServiceRegistration appHandlerRegistration;
    private static BundleContext bndCtx;
    private List<String> requiredServices = new ArrayList<String>();
    private Timer pendingServicesObservationTimer = new Timer();

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            SynapseAppDeployer synapseDeployer = new SynapseAppDeployer();
            bndCtx = ctxt.getBundleContext();
            appHandlerRegistration = bndCtx.registerService(AppDeploymentHandler.class.getName(), (Object)synapseDeployer, null);
            URL reqFeaturesResource = ctxt.getBundleContext().getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs((OMElement)new StAXOMBuilder(xmlStream).getDocumentElement());
            }
            this.populateRequiredServices();
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization();
            } else {
                StringBuffer ldapFilter = new StringBuffer("(|");
                for (String service : this.requiredServices) {
                    ldapFilter.append("(").append("objectClass").append("=").append(service).append(")");
                }
                ldapFilter.append(")");
                bndCtx.addServiceListener((ServiceListener)this, ldapFilter.toString());
                ServiceReference[] serviceReferences = bndCtx.getServiceReferences((String)null, ldapFilter.toString());
                if (serviceReferences != null) {
                    for (ServiceReference reference : serviceReferences) {
                        String service = ((String[])reference.getProperty("objectClass"))[0];
                        this.requiredServices.remove(service);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Removed pending service " + service));
                    }
                }
                if (this.requiredServices.isEmpty()) {
                    this.completeInitialization();
                } else {
                    this.schedulePendingServicesObservationTimer();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Synapse Application Deployer", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (appHandlerRegistration != null) {
            appHandlerRegistration.unregister();
        }
    }

    @Reference(name="synapse.env.service", service=SynapseEnvironmentService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseEnvironmentService")
    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        DataHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        DataHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 1) {
            String service = ((String[])serviceEvent.getServiceReference().getProperty("objectClass"))[0];
            this.requiredServices.remove(service);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed pending service " + service));
            }
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization();
            }
        }
    }

    private void populateRequiredServices() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = bndCtx.getBundles()) {
            String[] values;
            String requiredServiceList = (String)bundle.getHeaders().get("SYNAPSE_DEPLOYER-RequiredServices");
            if (requiredServiceList == null) continue;
            for (String value : values = requiredServiceList.split(",")) {
                this.requiredServices.add(value);
            }
        }
    }

    private void schedulePendingServicesObservationTimer() {
        this.pendingServicesObservationTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!SynapseAppDeployerDSComponent.this.requiredServices.isEmpty()) {
                    StringBuffer services = new StringBuffer();
                    for (String service : SynapseAppDeployerDSComponent.this.requiredServices) {
                        services.append(service).append(",");
                    }
                    log.warn((Object)("Waiting for required OSGi services: " + services.toString()));
                }
            }
        }, 60000L, 60000L);
    }

    private void completeInitialization() {
        bndCtx.registerService(SynapseAppDeployerService.class.getName(), (Object)new SynapseAppDeployerServiceImpl(), null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Synapse Application deployer activated");
        }
    }
}

