/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class SquareRootFunctionExtension
extends FunctionExecutor {
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to math:sqrt() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.INT && attributeType != Attribute.Type.FLOAT && attributeType != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of math:sqrt() function, required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data != null) {
            if (data instanceof Integer) {
                int inputInt = (Integer)data;
                return Math.sqrt(inputInt);
            }
            if (data instanceof Long) {
                long inputLong = (Long)data;
                return Math.sqrt(inputLong);
            }
            if (data instanceof Float) {
                float inputFloat = ((Float)data).floatValue();
                return Math.sqrt(inputFloat);
            }
            if (data instanceof Double) {
                double inputValue = (Double)data;
                return Math.sqrt(inputValue);
            }
        } else {
            throw new ExecutionPlanRuntimeException("Input to the math:sqrt() function cannot be null");
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

