/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.tcpmon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.tcpmon.TCPMon;

class Sender
extends JPanel {
    public JTextField endpointField = null;
    public JTextField actionField = null;
    public JCheckBox xmlFormatBox = null;
    public JButton sendButton = null;
    public JButton switchButton = null;
    public JSplitPane outPane = null;
    public JPanel leftPanel = null;
    public JPanel rightPanel = null;
    public JTabbedPane notebook = null;
    private JTextArea inputText = null;
    private JTextArea outputText = null;

    public Sender(JTabbedPane _notebook) {
        this.notebook = _notebook;
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        top.add(new JLabel("Connection Endpoint", 4));
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.endpointField = new JTextField("http://localhost:8080/axis2/services/XYZ", 50);
        top.add(this.endpointField);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        top.add(new JLabel("SOAP Action  ", 4));
        this.actionField = new JTextField("", 4);
        top.add(this.actionField);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.endpointField.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        this.actionField.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.add((Component)top, "North");
        this.inputText = new JTextArea(null, null, 20, 80);
        JScrollPane inputScroll = new JScrollPane(this.inputText);
        this.outputText = new JTextArea(null, null, 20, 80);
        JScrollPane outputScroll = new JScrollPane(this.outputText);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BorderLayout());
        this.leftPanel = new JPanel();
        this.leftPanel.setAlignmentX(0.0f);
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.leftPanel.add(inputScroll);
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.rightPanel.add(outputScroll);
        this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
        this.outPane.setDividerSize(4);
        pane2.add((Component)this.outPane, "Center");
        JPanel bottomButtons = new JPanel();
        bottomButtons.setLayout(new BoxLayout(bottomButtons, 0));
        bottomButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.xmlFormatBox = new JCheckBox(TCPMon.getMessage("xmlFormat00", "XML Format"));
        bottomButtons.add(this.xmlFormatBox);
        bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        this.sendButton = new JButton("Send");
        bottomButtons.add(this.sendButton);
        bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
        final String switchStr = TCPMon.getMessage("switch00", "Switch Layout");
        this.switchButton = new JButton(switchStr);
        bottomButtons.add(this.switchButton);
        bottomButtons.add(Box.createHorizontalGlue());
        String close = TCPMon.getMessage("close00", "Close");
        pane2.add((Component)bottomButtons, "South");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if ("Send".equals(event.getActionCommand())) {
                    Sender.this.send();
                }
            }
        });
        this.switchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (switchStr.equals(event.getActionCommand())) {
                    int v = Sender.this.outPane.getOrientation();
                    if (v == 0) {
                        Sender.this.outPane.setOrientation(1);
                    } else {
                        Sender.this.outPane.setOrientation(0);
                    }
                    Sender.this.outPane.setDividerLocation(0.5);
                }
            }
        });
        this.add((Component)pane2, "Center");
        this.outPane.setDividerLocation(250);
        this.notebook.addTab("Sender", this);
    }

    public void setLeft(Component left) {
        this.leftPanel.removeAll();
        this.leftPanel.add(left);
    }

    public void setRight(Component right) {
        this.rightPanel.removeAll();
        this.rightPanel.add(right);
    }

    public void close() {
        this.notebook.remove(this);
    }

    public void send() {
        try {
            String line;
            URL u = new URL(this.endpointField.getText());
            URLConnection uc = u.openConnection();
            HttpURLConnection connection = (HttpURLConnection)uc;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            String action = "\"" + (this.actionField.getText() == null ? "" : this.actionField.getText()) + "\"";
            connection.setRequestProperty("SOAPAction", action);
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setRequestProperty("User-Agent", "Axis/2.0");
            OutputStream out = connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(this.inputText.getText());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            InputStream inputStream = null;
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            this.outputText.setText("");
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = rd.readLine()) != null) {
                this.outputText.append(line);
            }
            if (this.xmlFormatBox.isSelected()) {
                this.outputText.setText(this.prettyXML(this.outputText.getText()));
            }
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            this.outputText.setText(w.toString());
        }
    }

    public String prettyXML(String input) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(2));
        }
        catch (Exception e) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (Exception e) {
            // empty catch block
        }
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(writer));
        return writer.toString();
    }
}

