/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.claim.mgt.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.claim.mgt.stub.ClaimManagementServiceStub;
import org.wso2.carbon.claim.mgt.stub.dto.ClaimDTO;
import org.wso2.carbon.claim.mgt.stub.dto.ClaimDialectDTO;
import org.wso2.carbon.claim.mgt.stub.dto.ClaimMappingDTO;

public class ClaimAdminClient {
    private static final Log log = LogFactory.getLog(ClaimAdminClient.class);
    private ClaimManagementServiceStub stub;

    public ClaimAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "ClaimManagementService";
        this.stub = new ClaimManagementServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ClaimDialectDTO[] getAllClaimMappings() throws AxisFault {
        try {
            return this.stub.getClaimMappings();
        }
        catch (Exception e) {
            this.handleException("Error while reading claim mappings", e);
            return new ClaimDialectDTO[0];
        }
    }

    public ClaimDialectDTO getAllClaimMappingsByDialect(String dialect) throws AxisFault {
        try {
            return this.stub.getClaimMappingByDialect(dialect);
        }
        catch (Exception e) {
            this.handleException("Error while reading claim mappings by dialect", e);
            return null;
        }
    }

    public ClaimDialectDTO getAllClaimMappingsByDialectWithRole(String dialect) throws AxisFault {
        try {
            ClaimDialectDTO claims = this.stub.getClaimMappingByDialect(dialect);
            ClaimMappingDTO[] oldClaims = claims.getClaimMappings();
            ClaimMappingDTO[] newClaims = new ClaimMappingDTO[claims.getClaimMappings().length + 1];
            for (int i = 0; i < oldClaims.length; ++i) {
                newClaims[i] = oldClaims[i];
            }
            ClaimMappingDTO mapping = new ClaimMappingDTO();
            ClaimDTO role = new ClaimDTO();
            role.setClaimUri("http://wso2.org/claims/role");
            mapping.setClaim(role);
            newClaims[i] = mapping;
            claims.setClaimMappings(newClaims);
            return claims;
        }
        catch (Exception e) {
            this.handleException("Error while reading claim mappings by dialect", e);
            return null;
        }
    }

    public void addNewClaimDialect(ClaimDialectDTO dialect) throws AxisFault {
        try {
            this.stub.addNewClaimDialect(dialect);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addNewClaimMappping(ClaimMappingDTO claimMapping) throws AxisFault {
        try {
            this.stub.addNewClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateClaimMapping(ClaimMappingDTO claimMapping) throws AxisFault {
        try {
            this.stub.upateClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException("Error while updating claim mapping", e);
        }
    }

    public void removeClaimMapping(String dialectUri, String claimUri) throws AxisFault {
        try {
            this.stub.removeClaimMapping(dialectUri, claimUri);
        }
        catch (Exception e) {
            this.handleException("Error while removing claim mapping", e);
        }
    }

    public void removeClaimDialect(String dialectUri) throws AxisFault {
        try {
            this.stub.removeClaimDialect(dialectUri);
        }
        catch (Exception e) {
            this.handleException("Error while removing claim dialect", e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

