/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault.xpath;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.wso2.carbon.mediation.security.vault.SecretSrcData;
import org.wso2.carbon.mediation.security.vault.SecureVaultLookupHandlerImpl;
import org.wso2.carbon.mediation.security.vault.VaultType;

public class VaultLookupFunction
implements Function {
    private static final Log log = LogFactory.getLog(VaultLookupFunction.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    public static final String NULL_STRING = "";
    private final MessageContext synCtx;

    public VaultLookupFunction(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        boolean traceOrDebugOn;
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (args == null || args.size() == 0) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "vault value for lookup is not specified");
            }
            return NULL_STRING;
        }
        String argOne = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
        try {
            SecureVaultLookupHandlerImpl mediationSecurity = SecureVaultLookupHandlerImpl.getDefaultSecurityService();
            return mediationSecurity.evaluate(argOne, this.getSecretSourceInfo(args), this.synCtx);
        }
        catch (Exception msg) {
            throw new FunctionCallException((Throwable)msg);
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private SecretSrcData getSecretSourceInfo(List args) {
        if (args.size() == 3) {
            String secretType = args.get(1).toString();
            boolean isEncrypted = Boolean.parseBoolean(args.get(2).toString());
            if (VaultType.DOCKER.toString().equalsIgnoreCase(secretType)) {
                return new SecretSrcData(VaultType.DOCKER, isEncrypted);
            }
            if (VaultType.FILE.toString().equalsIgnoreCase(secretType)) {
                return new SecretSrcData(VaultType.FILE, isEncrypted);
            }
        }
        return new SecretSrcData();
    }
}

